; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,VEX,AVX1
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,VEX,AVX2
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX,AVX512,AVX512DQ
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VLDQ
;
; 32-bit tests to make sure we're not doing anything stupid.
; RUN: llc < %s -disable-peephole -mtriple=i686-unknown-unknown
; RUN: llc < %s -disable-peephole -mtriple=i686-unknown-unknown -mattr=+sse
; RUN: llc < %s -disable-peephole -mtriple=i686-unknown-unknown -mattr=+sse2
; RUN: llc < %s -disable-peephole -mtriple=i686-unknown-unknown -mattr=+sse4.1

;
; Signed Integer to Double
;

define <2 x float> @sitofp_2i32_to_2f32(<2 x i32> %a) {
; SSE-LABEL: sitofp_2i32_to_2f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_2i32_to_2f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = sitofp <2 x i32> %a to <2 x float>
  ret <2 x float> %cvt
}

define <2 x float> @uitofp_2i32_to_2f32(<2 x i32> %a) {
; SSE2-LABEL: uitofp_2i32_to_2f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm1, %xmm0
; SSE2-NEXT:    subpd %xmm1, %xmm0
; SSE2-NEXT:    cvtpd2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_2i32_to_2f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    subpd %xmm1, %xmm0
; SSE41-NEXT:    cvtpd2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_2i32_to_2f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vcvtpd2ps %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_2i32_to_2f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vcvtpd2ps %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_2i32_to_2f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_2i32_to_2f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_2i32_to_2f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_2i32_to_2f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <2 x i32> %a to <2 x float>
  ret <2 x float> %cvt
}

define <2 x double> @sitofp_2i64_to_2f64(<2 x i64> %a) {
; SSE2-LABEL: sitofp_2i64_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    cvtsi2sd %rax, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2sd %rax, %xmm0
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_2i64_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    cvtsi2sd %rax, %xmm1
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2sd %rax, %xmm0
; SSE41-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_2i64_to_2f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpextrq $1, %xmm0, %rax
; VEX-NEXT:    vcvtsi2sd %rax, %xmm1, %xmm1
; VEX-NEXT:    vmovq %xmm0, %rax
; VEX-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm0
; VEX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_2i64_to_2f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2sd %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_2i64_to_2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2sd %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_2i64_to_2f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_2i64_to_2f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = sitofp <2 x i64> %a to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_2i32_to_2f64(<4 x i32> %a) {
; SSE-LABEL: sitofp_2i32_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_2i32_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %cvt = sitofp <2 x i32> %shuf to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_4i32_to_2f64(<4 x i32> %a) {
; SSE-LABEL: sitofp_4i32_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_4i32_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = sitofp <4 x i32> %a to <4 x double>
  %shuf = shufflevector <4 x double> %cvt, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %shuf
}

define <2 x double> @sitofp_2i16_to_2f64(<8 x i16> %a) {
; SSE2-LABEL: sitofp_2i16_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_2i16_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_2i16_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <8 x i16> %a, <8 x i16> undef, <2 x i32> <i32 0, i32 1>
  %cvt = sitofp <2 x i16> %shuf to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_8i16_to_2f64(<8 x i16> %a) {
; SSE2-LABEL: sitofp_8i16_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_8i16_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_8i16_to_2f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovsxwd %xmm0, %xmm0
; VEX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: sitofp_8i16_to_2f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = sitofp <8 x i16> %a to <8 x double>
  %shuf = shufflevector <8 x double> %cvt, <8 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %shuf
}

define <2 x double> @sitofp_2i8_to_2f64(<16 x i8> %a) {
; SSE2-LABEL: sitofp_2i8_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_2i8_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_2i8_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <2 x i32> <i32 0, i32 1>
  %cvt = sitofp <2 x i8> %shuf to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_16i8_to_2f64(<16 x i8> %a) {
; SSE2-LABEL: sitofp_16i8_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_16i8_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_16i8_to_2f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovsxbd %xmm0, %xmm0
; VEX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: sitofp_16i8_to_2f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = sitofp <16 x i8> %a to <16 x double>
  %shuf = shufflevector <16 x double> %cvt, <16 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %shuf
}

define <4 x double> @sitofp_4i64_to_4f64(<4 x i64> %a) {
; SSE2-LABEL: sitofp_4i64_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    cvtsi2sd %rax, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2sd %rax, %xmm0
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    cvtsi2sd %rax, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2sd %rax, %xmm0
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE2-NEXT:    movapd %xmm2, %xmm0
; SSE2-NEXT:    movapd %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_4i64_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    cvtsi2sd %rax, %xmm2
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2sd %rax, %xmm0
; SSE41-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE41-NEXT:    pextrq $1, %xmm1, %rax
; SSE41-NEXT:    xorps %xmm2, %xmm2
; SSE41-NEXT:    cvtsi2sd %rax, %xmm2
; SSE41-NEXT:    movq %xmm1, %rax
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2sd %rax, %xmm1
; SSE41-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_4i64_to_4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpextrq $1, %xmm1, %rax
; AVX1-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm2
; AVX1-NEXT:    vmovq %xmm1, %rax
; AVX1-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm1
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm2
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_4i64_to_4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm2
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm2
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sitofp_4i64_to_4f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512F-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm2
; AVX512F-NEXT:    vmovq %xmm1, %rax
; AVX512F-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm1
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm2
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_4i64_to_4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512VL-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm2
; AVX512VL-NEXT:    vmovq %xmm1, %rax
; AVX512VL-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm1
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm2
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; AVX512VL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_4i64_to_4f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvtqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_4i64_to_4f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2pd %ymm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %cvt = sitofp <4 x i64> %a to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @sitofp_4i32_to_4f64(<4 x i32> %a) {
; SSE-LABEL: sitofp_4i32_to_4f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE-NEXT:    cvtdq2pd %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_4i32_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %cvt = sitofp <4 x i32> %a to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @sitofp_4i16_to_4f64(<8 x i16> %a) {
; SSE2-LABEL: sitofp_4i16_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_4i16_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_4i16_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %shuf = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = sitofp <4 x i16> %shuf to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @sitofp_8i16_to_4f64(<8 x i16> %a) {
; SSE2-LABEL: sitofp_8i16_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_8i16_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_8i16_to_4f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovsxwd %xmm0, %xmm0
; VEX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: sitofp_8i16_to_4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
  %cvt = sitofp <8 x i16> %a to <8 x double>
  %shuf = shufflevector <8 x double> %cvt, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %shuf
}

define <4 x double> @sitofp_4i8_to_4f64(<16 x i8> %a) {
; SSE2-LABEL: sitofp_4i8_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_4i8_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_4i8_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = sitofp <4 x i8> %shuf to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @sitofp_16i8_to_4f64(<16 x i8> %a) {
; SSE2-LABEL: sitofp_16i8_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_16i8_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_16i8_to_4f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovsxbd %xmm0, %xmm0
; VEX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: sitofp_16i8_to_4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
  %cvt = sitofp <16 x i8> %a to <16 x double>
  %shuf = shufflevector <16 x double> %cvt, <16 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %shuf
}

;
; Unsigned Integer to Double
;

define <2 x double> @uitofp_2i64_to_2f64(<2 x i64> %a) {
; SSE2-LABEL: uitofp_2i64_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [4294967295,4294967295]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    subpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    addpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_2i64_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; SSE41-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    subpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    addpd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_2i64_to_2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; AVX1-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_2i64_to_2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_2i64_to_2f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512F-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_2i64_to_2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm1, %xmm1
; AVX512VL-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; AVX512VL-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; AVX512VL-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_2i64_to_2f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_2i64_to_2f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <2 x i64> %a to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @uitofp_2i32_to_2f64(<4 x i32> %a) {
; SSE2-LABEL: uitofp_2i32_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm1, %xmm0
; SSE2-NEXT:    subpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_2i32_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    subpd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_2i32_to_2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_2i32_to_2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_2i32_to_2f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_2i32_to_2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_2i32_to_2f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_2i32_to_2f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %shuf = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %cvt = uitofp <2 x i32> %shuf to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @uitofp_4i32_to_2f64(<4 x i32> %a) {
; SSE2-LABEL: uitofp_4i32_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm1, %xmm0
; SSE2-NEXT:    subpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i32_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    subpd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_4i32_to_2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_4i32_to_2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_4i32_to_2f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_4i32_to_2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_4i32_to_2f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_4i32_to_2f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <4 x i32> %a to <4 x double>
  %shuf = shufflevector <4 x double> %cvt, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %shuf
}

define <2 x double> @uitofp_2i16_to_2f64(<8 x i16> %a) {
; SSE2-LABEL: uitofp_2i16_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_2i16_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_2i16_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <8 x i16> %a, <8 x i16> undef, <2 x i32> <i32 0, i32 1>
  %cvt = uitofp <2 x i16> %shuf to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @uitofp_8i16_to_2f64(<8 x i16> %a) {
; SSE2-LABEL: uitofp_8i16_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_8i16_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: uitofp_8i16_to_2f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; VEX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: uitofp_8i16_to_2f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = uitofp <8 x i16> %a to <8 x double>
  %shuf = shufflevector <8 x double> %cvt, <8 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %shuf
}

define <2 x double> @uitofp_2i8_to_2f64(<16 x i8> %a) {
; SSE2-LABEL: uitofp_2i8_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_2i8_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_2i8_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <2 x i32> <i32 0, i32 1>
  %cvt = uitofp <2 x i8> %shuf to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @uitofp_16i8_to_2f64(<16 x i8> %a) {
; SSE2-LABEL: uitofp_16i8_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_16i8_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: uitofp_16i8_to_2f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; VEX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: uitofp_16i8_to_2f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = uitofp <16 x i8> %a to <16 x double>
  %shuf = shufflevector <16 x double> %cvt, <16 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %shuf
}

define <4 x double> @uitofp_4i64_to_4f64(<4 x i64> %a) {
; SSE2-LABEL: uitofp_4i64_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [4294967295,4294967295]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movapd {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; SSE2-NEXT:    subpd %xmm6, %xmm0
; SSE2-NEXT:    addpd %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    psrlq $32, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    subpd %xmm6, %xmm1
; SSE2-NEXT:    addpd %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i64_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    movapd {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; SSE41-NEXT:    subpd %xmm6, %xmm0
; SSE41-NEXT:    addpd %xmm3, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; SSE41-NEXT:    por %xmm4, %xmm2
; SSE41-NEXT:    psrlq $32, %xmm1
; SSE41-NEXT:    por %xmm5, %xmm1
; SSE41-NEXT:    subpd %xmm6, %xmm1
; SSE41-NEXT:    addpd %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_4i64_to_4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX1-NEXT:    vorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2,1,3,4,6,5,7]
; AVX1-NEXT:    vorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vaddpd %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_4i64_to_4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200]
; AVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072]
; AVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25]
; AVX2-NEXT:    vsubpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_4i64_to_4f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200]
; AVX512F-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072]
; AVX512F-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25]
; AVX512F-NEXT:    vsubpd %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vaddpd %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_4i64_to_4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; AVX512VL-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; AVX512VL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_4i64_to_4f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_4i64_to_4f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2pd %ymm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <4 x i64> %a to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @uitofp_4i32_to_4f64(<4 x i32> %a) {
; SSE2-LABEL: uitofp_4i32_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd %xmm0, %xmm1
; SSE2-NEXT:    xorpd %xmm2, %xmm2
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm3 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm3, %xmm0
; SSE2-NEXT:    subpd %xmm3, %xmm0
; SSE2-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    orpd %xmm3, %xmm1
; SSE2-NEXT:    subpd %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i32_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    subpd %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm3
; SSE41-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE41-NEXT:    por %xmm2, %xmm1
; SSE41-NEXT:    subpd %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_4i32_to_4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    vorpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vsubpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_4i32_to_4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vsubpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_4i32_to_4f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_4i32_to_4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2pd %xmm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_4i32_to_4f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_4i32_to_4f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2pd %xmm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <4 x i32> %a to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @uitofp_4i16_to_4f64(<8 x i16> %a) {
; SSE2-LABEL: uitofp_4i16_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i16_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_4i16_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %shuf = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = uitofp <4 x i16> %shuf to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @uitofp_8i16_to_4f64(<8 x i16> %a) {
; SSE2-LABEL: uitofp_8i16_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_8i16_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; VEX-LABEL: uitofp_8i16_to_4f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; VEX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: uitofp_8i16_to_4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
  %cvt = uitofp <8 x i16> %a to <8 x double>
  %shuf = shufflevector <8 x double> %cvt, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %shuf
}

define <4 x double> @uitofp_4i8_to_4f64(<16 x i8> %a) {
; SSE2-LABEL: uitofp_4i8_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i8_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_4i8_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = uitofp <4 x i8> %shuf to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @uitofp_16i8_to_4f64(<16 x i8> %a) {
; SSE2-LABEL: uitofp_16i8_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_16i8_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; VEX-LABEL: uitofp_16i8_to_4f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; VEX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; VEX-NEXT:    retq
;
; AVX512-LABEL: uitofp_16i8_to_4f64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vcvtdq2pd %ymm0, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
  %cvt = uitofp <16 x i8> %a to <16 x double>
  %shuf = shufflevector <16 x double> %cvt, <16 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %shuf
}

;
; Signed Integer to Float
;

define <4 x float> @sitofp_2i64_to_4f32(<2 x i64> %a) {
; SSE2-LABEL: sitofp_2i64_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_2i64_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    cvtsi2ss %rax, %xmm1
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[2,3]
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_2i64_to_4f32:
; VEX:       # %bb.0:
; VEX-NEXT:    vpextrq $1, %xmm0, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; VEX-NEXT:    vmovq %xmm0, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_2i64_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_2i64_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_2i64_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_2i64_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = sitofp <2 x i64> %a to <2 x float>
  %ext = shufflevector <2 x float> %cvt, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  ret <4 x float> %ext
}

define <4 x float> @sitofp_2i64_to_4f32_zero(<2 x i64> %a) {
; SSE2-LABEL: sitofp_2i64_to_4f32_zero:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movq {{.*#+}} xmm0 = xmm0[0],zero
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_2i64_to_4f32_zero:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    cvtsi2ss %rax, %xmm1
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],xmm0[0],zero,zero
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_2i64_to_4f32_zero:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovq %xmm0, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; VEX-NEXT:    vpextrq $1, %xmm0, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],zero,zero
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_2i64_to_4f32_zero:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],zero,zero
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_2i64_to_4f32_zero:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],zero,zero
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_2i64_to_4f32_zero:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_2i64_to_4f32_zero:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = sitofp <2 x i64> %a to <2 x float>
  %ext = shufflevector <2 x float> %cvt, <2 x float> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %ext
}

define <4 x float> @sitofp_4i64_to_4f32_undef(<2 x i64> %a) {
; SSE2-LABEL: sitofp_4i64_to_4f32_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movq {{.*#+}} xmm0 = xmm1[0],zero
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_4i64_to_4f32_undef:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    cvtsi2ss %rax, %xmm1
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_4i64_to_4f32_undef:
; VEX:       # %bb.0:
; VEX-NEXT:    vpextrq $1, %xmm0, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; VEX-NEXT:    vmovq %xmm0, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_4i64_to_4f32_undef:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_4i64_to_4f32_undef:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_4i64_to_4f32_undef:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_4i64_to_4f32_undef:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VLDQ-NEXT:    vcvtqq2ps %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %ext = shufflevector <2 x i64> %a, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %cvt = sitofp <4 x i64> %ext to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @sitofp_4i32_to_4f32(<4 x i32> %a) {
; SSE-LABEL: sitofp_4i32_to_4f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_4i32_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = sitofp <4 x i32> %a to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @sitofp_4i16_to_4f32(<8 x i16> %a) {
; SSE2-LABEL: sitofp_4i16_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_4i16_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_4i16_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = sitofp <4 x i16> %shuf to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @sitofp_8i16_to_4f32(<8 x i16> %a) {
; SSE2-LABEL: sitofp_8i16_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_8i16_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_8i16_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_8i16_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sitofp_8i16_to_4f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = sitofp <8 x i16> %a to <8 x float>
  %shuf = shufflevector <8 x float> %cvt, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %shuf
}

define <4 x float> @sitofp_4i8_to_4f32(<16 x i8> %a) {
; SSE2-LABEL: sitofp_4i8_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_4i8_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_4i8_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = sitofp <4 x i8> %shuf to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @sitofp_16i8_to_4f32(<16 x i8> %a) {
; SSE2-LABEL: sitofp_16i8_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_16i8_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_16i8_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_16i8_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbd %xmm0, %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sitofp_16i8_to_4f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vcvtdq2ps %zmm0, %zmm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = sitofp <16 x i8> %a to <16 x float>
  %shuf = shufflevector <16 x float> %cvt, <16 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %shuf
}

define <4 x float> @sitofp_4i64_to_4f32(<4 x i64> %a) {
; SSE2-LABEL: sitofp_4i64_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_4i64_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    cvtsi2ss %rax, %xmm2
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[2,3]
; SSE41-NEXT:    movq %xmm1, %rax
; SSE41-NEXT:    xorps %xmm2, %xmm2
; SSE41-NEXT:    cvtsi2ss %rax, %xmm2
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],xmm2[0],xmm0[3]
; SSE41-NEXT:    pextrq $1, %xmm1, %rax
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ss %rax, %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_4i64_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm2
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_4i64_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm2
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sitofp_4i64_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_4i64_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_4i64_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvtqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_4i64_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2ps %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %cvt = sitofp <4 x i64> %a to <4 x float>
  ret <4 x float> %cvt
}

define <8 x float> @sitofp_8i32_to_8f32(<8 x i32> %a) {
; SSE-LABEL: sitofp_8i32_to_8f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_8i32_to_8f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX-NEXT:    retq
  %cvt = sitofp <8 x i32> %a to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @sitofp_8i16_to_8f32(<8 x i16> %a) {
; SSE2-LABEL: sitofp_8i16_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_8i16_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_8i16_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_8i16_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sitofp_8i16_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cvt = sitofp <8 x i16> %a to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @sitofp_8i8_to_8f32(<16 x i8> %a) {
; SSE2-LABEL: sitofp_8i8_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_8i8_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_8i8_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_8i8_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbd %xmm0, %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sitofp_8i8_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %ymm0
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cvt = sitofp <8 x i8> %shuf to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @sitofp_16i8_to_8f32(<16 x i8> %a) {
; SSE2-LABEL: sitofp_16i8_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_16i8_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_16i8_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_16i8_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbd %xmm0, %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sitofp_16i8_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vcvtdq2ps %zmm0, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
  %cvt = sitofp <16 x i8> %a to <16 x float>
  %shuf = shufflevector <16 x float> %cvt, <16 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %shuf
}

;
; Unsigned Integer to Float
;

define <4 x float> @uitofp_2i64_to_4f32(<2 x i64> %a) {
; SSE2-LABEL: uitofp_2i64_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB41_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    jmp .LBB41_3
; SSE2-NEXT:  .LBB41_1:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    addss %xmm0, %xmm0
; SSE2-NEXT:  .LBB41_3:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB41_4
; SSE2-NEXT:  # %bb.5:
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB41_4:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    addss %xmm1, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_2i64_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1,1]
; SSE41-NEXT:    pand %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    psrlq $1, %xmm2
; SSE41-NEXT:    por %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,2,3]
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm0
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    cvtsi2ss %rax, %xmm3
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    xorps %xmm2, %xmm2
; SSE41-NEXT:    cvtsi2ss %rax, %xmm2
; SSE41-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],zero,zero
; SSE41-NEXT:    movaps %xmm2, %xmm3
; SSE41-NEXT:    addps %xmm2, %xmm3
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm3, %xmm2
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: uitofp_2i64_to_4f32:
; VEX:       # %bb.0:
; VEX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; VEX-NEXT:    vpsrlq $1, %xmm0, %xmm2
; VEX-NEXT:    vpor %xmm1, %xmm2, %xmm1
; VEX-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm1
; VEX-NEXT:    vpextrq $1, %xmm1, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; VEX-NEXT:    vmovq %xmm1, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm2[0],zero,zero
; VEX-NEXT:    vaddps %xmm1, %xmm1, %xmm2
; VEX-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; VEX-NEXT:    vpcmpgtq %xmm0, %xmm3, %xmm0
; VEX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; VEX-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: uitofp_2i64_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_2i64_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_2i64_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_2i64_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <2 x i64> %a to <2 x float>
  %ext = shufflevector <2 x float> %cvt, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  ret <4 x float> %ext
}

define <4 x float> @uitofp_2i64_to_2f32(<2 x i64> %a) {
; SSE2-LABEL: uitofp_2i64_to_2f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB42_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    jmp .LBB42_3
; SSE2-NEXT:  .LBB42_1:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    addss %xmm1, %xmm1
; SSE2-NEXT:  .LBB42_3:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB42_4
; SSE2-NEXT:  # %bb.5:
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    jmp .LBB42_6
; SSE2-NEXT:  .LBB42_4:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    addss %xmm0, %xmm0
; SSE2-NEXT:  .LBB42_6:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movq {{.*#+}} xmm0 = xmm0[0],zero
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_2i64_to_2f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1,1]
; SSE41-NEXT:    pand %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    psrlq $1, %xmm2
; SSE41-NEXT:    por %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,3,2,3]
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm0
; SSE41-NEXT:    pextrq $1, %xmm0, %rax
; SSE41-NEXT:    xorps %xmm2, %xmm2
; SSE41-NEXT:    cvtsi2ss %rax, %xmm2
; SSE41-NEXT:    movq %xmm0, %rax
; SSE41-NEXT:    cvtsi2ss %rax, %xmm3
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],xmm2[0],zero,zero
; SSE41-NEXT:    movaps %xmm3, %xmm2
; SSE41-NEXT:    addps %xmm3, %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm3
; SSE41-NEXT:    movq {{.*#+}} xmm0 = xmm3[0],zero
; SSE41-NEXT:    retq
;
; VEX-LABEL: uitofp_2i64_to_2f32:
; VEX:       # %bb.0:
; VEX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; VEX-NEXT:    vpsrlq $1, %xmm0, %xmm2
; VEX-NEXT:    vpor %xmm1, %xmm2, %xmm1
; VEX-NEXT:    vblendvpd %xmm0, %xmm1, %xmm0, %xmm1
; VEX-NEXT:    vpextrq $1, %xmm1, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; VEX-NEXT:    vmovq %xmm1, %rax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm2[0],zero,zero
; VEX-NEXT:    vaddps %xmm1, %xmm1, %xmm2
; VEX-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; VEX-NEXT:    vpcmpgtq %xmm0, %xmm3, %xmm0
; VEX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; VEX-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; VEX-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; VEX-NEXT:    retq
;
; AVX512F-LABEL: uitofp_2i64_to_2f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],zero,zero
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_2i64_to_2f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],zero,zero
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_2i64_to_2f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_2i64_to_2f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <2 x i64> %a to <2 x float>
  %ext = shufflevector <2 x float> %cvt, <2 x float> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %ext
}

define <4 x float> @uitofp_4i64_to_4f32_undef(<2 x i64> %a) {
; SSE2-LABEL: uitofp_4i64_to_4f32_undef:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB43_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    jmp .LBB43_3
; SSE2-NEXT:  .LBB43_1:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    addss %xmm1, %xmm1
; SSE2-NEXT:  .LBB43_3:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB43_4
; SSE2-NEXT:  # %bb.5:
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    jmp .LBB43_6
; SSE2-NEXT:  .LBB43_4:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    addss %xmm0, %xmm0
; SSE2-NEXT:  .LBB43_6:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movq {{.*#+}} xmm0 = xmm1[0],zero
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i64_to_4f32_undef:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1,1]
; SSE41-NEXT:    pand %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    psrlq $1, %xmm2
; SSE41-NEXT:    por %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    pextrq $1, %xmm1, %rax
; SSE41-NEXT:    xorps %xmm2, %xmm2
; SSE41-NEXT:    cvtsi2ss %rax, %xmm2
; SSE41-NEXT:    movq %xmm1, %rax
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ss %rax, %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],xmm2[0],zero,zero
; SSE41-NEXT:    movaps %xmm1, %xmm2
; SSE41-NEXT:    addps %xmm1, %xmm2
; SSE41-NEXT:    xorps %xmm3, %xmm3
; SSE41-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm3[2,3]
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_4i64_to_4f32_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; AVX1-NEXT:    vpsrlq $1, %xmm0, %xmm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vmovaps %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm1
; AVX1-NEXT:    vpextrq $1, %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX1-NEXT:    vmovq %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[2,3]
; AVX1-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; AVX1-NEXT:    vaddps %xmm1, %xmm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpackssdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_4i64_to_4f32_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm0, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0],xmm2[3]
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[0]
; AVX2-NEXT:    vaddps %xmm1, %xmm1, %xmm2
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_4i64_to_4f32_undef:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_4i64_to_4f32_undef:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_4i64_to_4f32_undef:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_4i64_to_4f32_undef:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VLDQ-NEXT:    vcvtuqq2ps %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %ext = shufflevector <2 x i64> %a, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %cvt = uitofp <4 x i64> %ext to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @uitofp_4i32_to_4f32(<4 x i32> %a) {
; SSE2-LABEL: uitofp_4i32_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    psrld $16, %xmm0
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    addps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i32_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1258291200,1258291200,1258291200,1258291200]
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7]
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],mem[1],xmm0[2],mem[3],xmm0[4],mem[5],xmm0[6],mem[7]
; SSE41-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    addps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_4i32_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0],mem[1],xmm0[2],mem[3],xmm0[4],mem[5],xmm0[6],mem[7]
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],mem[1],xmm0[2],mem[3],xmm0[4],mem[5],xmm0[6],mem[7]
; AVX1-NEXT:    vsubps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_4i32_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [1258291200,1258291200,1258291200,1258291200]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7]
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm2 = [1392508928,1392508928,1392508928,1392508928]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5],xmm0[6],xmm2[7]
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm2 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; AVX2-NEXT:    vsubps %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_4i32_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_4i32_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_4i32_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_4i32_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <4 x i32> %a to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @uitofp_4i16_to_4f32(<8 x i16> %a) {
; SSE2-LABEL: uitofp_4i16_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i16_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_4i16_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = uitofp <4 x i16> %shuf to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @uitofp_8i16_to_4f32(<8 x i16> %a) {
; SSE2-LABEL: uitofp_8i16_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_8i16_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_8i16_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_8i16_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: uitofp_8i16_to_4f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = uitofp <8 x i16> %a to <8 x float>
  %shuf = shufflevector <8 x float> %cvt, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %shuf
}

define <4 x float> @uitofp_4i8_to_4f32(<16 x i8> %a) {
; SSE2-LABEL: uitofp_4i8_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i8_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_4i8_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %cvt = uitofp <4 x i8> %shuf to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @uitofp_16i8_to_4f32(<16 x i8> %a) {
; SSE2-LABEL: uitofp_16i8_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_16i8_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_16i8_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_16i8_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: uitofp_16i8_to_4f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vcvtdq2ps %zmm0, %zmm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cvt = uitofp <16 x i8> %a to <16 x float>
  %shuf = shufflevector <16 x float> %cvt, <16 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %shuf
}

define <4 x float> @uitofp_4i64_to_4f32(<4 x i64> %a) {
; SSE2-LABEL: uitofp_4i64_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB49_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    jmp .LBB49_3
; SSE2-NEXT:  .LBB49_1:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    addss %xmm2, %xmm2
; SSE2-NEXT:  .LBB49_3:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB49_4
; SSE2-NEXT:  # %bb.5:
; SSE2-NEXT:    cvtsi2ss %rax, %xmm3
; SSE2-NEXT:    jmp .LBB49_6
; SSE2-NEXT:  .LBB49_4:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm3
; SSE2-NEXT:    addss %xmm3, %xmm3
; SSE2-NEXT:  .LBB49_6:
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB49_7
; SSE2-NEXT:  # %bb.8:
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    jmp .LBB49_9
; SSE2-NEXT:  .LBB49_7:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    addss %xmm1, %xmm1
; SSE2-NEXT:  .LBB49_9:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB49_10
; SSE2-NEXT:  # %bb.11:
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    jmp .LBB49_12
; SSE2-NEXT:  .LBB49_10:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    addss %xmm0, %xmm0
; SSE2-NEXT:  .LBB49_12:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_4i64_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [1,1]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    psrlq $1, %xmm3
; SSE41-NEXT:    por %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm1, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm5
; SSE41-NEXT:    pextrq $1, %xmm5, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    movq %xmm5, %rax
; SSE41-NEXT:    xorps %xmm3, %xmm3
; SSE41-NEXT:    cvtsi2ss %rax, %xmm3
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[2,3]
; SSE41-NEXT:    pand %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm2, %xmm5
; SSE41-NEXT:    psrlq $1, %xmm5
; SSE41-NEXT:    por %xmm4, %xmm5
; SSE41-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,3],xmm2[1,3]
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    movq %xmm2, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],xmm0[0],xmm3[3]
; SSE41-NEXT:    pextrq $1, %xmm2, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1,2],xmm0[0]
; SSE41-NEXT:    movaps %xmm3, %xmm2
; SSE41-NEXT:    addps %xmm3, %xmm2
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm3
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_4i64_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrlq $1, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; AVX1-NEXT:    vorpd %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm1
; AVX1-NEXT:    vpextrq $1, %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm3
; AVX1-NEXT:    vmovq %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[2,3]
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vmovq %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0],xmm3[3]
; AVX1-NEXT:    vpextrq $1, %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[0]
; AVX1-NEXT:    vaddps %xmm1, %xmm1, %xmm3
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vblendvps %xmm0, %xmm3, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_4i64_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm0, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0],xmm2[3]
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[0]
; AVX2-NEXT:    vaddps %xmm1, %xmm1, %xmm2
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vpackssdw %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_4i64_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_4i64_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512VL-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_4i64_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_4i64_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2ps %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <4 x i64> %a to <4 x float>
  ret <4 x float> %cvt
}

define <8 x float> @uitofp_8i32_to_8f32(<8 x i32> %a) {
; SSE2-LABEL: uitofp_8i32_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [1258291200,1258291200,1258291200,1258291200]
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    psrld $16, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1392508928,1392508928,1392508928,1392508928]
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movaps {{.*#+}} xmm6 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; SSE2-NEXT:    subps %xmm6, %xmm0
; SSE2-NEXT:    addps %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    psrld $16, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    subps %xmm6, %xmm1
; SSE2-NEXT:    addps %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_8i32_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [1258291200,1258291200,1258291200,1258291200]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0],xmm2[1],xmm3[2],xmm2[3],xmm3[4],xmm2[5],xmm3[6],xmm2[7]
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [1392508928,1392508928,1392508928,1392508928]
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm4[1],xmm0[2],xmm4[3],xmm0[4],xmm4[5],xmm0[6],xmm4[7]
; SSE41-NEXT:    movaps {{.*#+}} xmm5 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; SSE41-NEXT:    subps %xmm5, %xmm0
; SSE41-NEXT:    addps %xmm3, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm1[0],xmm2[1],xmm1[2],xmm2[3],xmm1[4],xmm2[5],xmm1[6],xmm2[7]
; SSE41-NEXT:    psrld $16, %xmm1
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2],xmm4[3],xmm1[4],xmm4[5],xmm1[6],xmm4[7]
; SSE41-NEXT:    subps %xmm5, %xmm1
; SSE41-NEXT:    addps %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_8i32_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vcvtdq2ps %ymm1, %ymm1
; AVX1-NEXT:    vmulps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vaddps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_8i32_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [1258291200,1258291200,1258291200,1258291200,1258291200,1258291200,1258291200,1258291200]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7],ymm0[8],ymm1[9],ymm0[10],ymm1[11],ymm0[12],ymm1[13],ymm0[14],ymm1[15]
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [1392508928,1392508928,1392508928,1392508928,1392508928,1392508928,1392508928,1392508928]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2],ymm2[3],ymm0[4],ymm2[5],ymm0[6],ymm2[7],ymm0[8],ymm2[9],ymm0[10],ymm2[11],ymm0[12],ymm2[13],ymm0[14],ymm2[15]
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm2 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; AVX2-NEXT:    vsubps %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vaddps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_8i32_to_8f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_8i32_to_8f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2ps %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_8i32_to_8f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_8i32_to_8f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2ps %ymm0, %ymm0
; AVX512VLDQ-NEXT:    retq
  %cvt = uitofp <8 x i32> %a to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @uitofp_8i16_to_8f32(<8 x i16> %a) {
; SSE2-LABEL: uitofp_8i16_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm2, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_8i16_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE41-NEXT:    cvtdq2ps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_8i16_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_8i16_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: uitofp_8i16_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %cvt = uitofp <8 x i16> %a to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @uitofp_8i8_to_8f32(<16 x i8> %a) {
; SSE2-LABEL: uitofp_8i8_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm2, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_8i8_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_8i8_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_8i8_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: uitofp_8i8_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %shuf = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cvt = uitofp <8 x i8> %shuf to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @uitofp_16i8_to_8f32(<16 x i8> %a) {
; SSE2-LABEL: uitofp_16i8_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm2, %xmm2
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_16i8_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_16i8_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_16i8_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: uitofp_16i8_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vcvtdq2ps %zmm0, %zmm0
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512-NEXT:    retq
  %cvt = uitofp <16 x i8> %a to <16 x float>
  %shuf = shufflevector <16 x float> %cvt, <16 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %shuf
}

;
; Load Signed Integer to Double
;

define <2 x double> @sitofp_load_2i64_to_2f64(ptr%a) {
; SSE2-LABEL: sitofp_load_2i64_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    cvtsi2sdq (%rdi), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2sd %rax, %xmm1
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_2i64_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    cvtsi2sdq 8(%rdi), %xmm1
; SSE41-NEXT:    cvtsi2sdq (%rdi), %xmm0
; SSE41-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_load_2i64_to_2f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvtsi2sdq 8(%rdi), %xmm0, %xmm0
; VEX-NEXT:    vcvtsi2sdq (%rdi), %xmm1, %xmm1
; VEX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_load_2i64_to_2f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvtsi2sdq 8(%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    vcvtsi2sdq (%rdi), %xmm1, %xmm1
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_load_2i64_to_2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtsi2sdq 8(%rdi), %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtsi2sdq (%rdi), %xmm1, %xmm1
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_load_2i64_to_2f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vcvtqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_load_2i64_to_2f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2pd (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <2 x i64>, ptr%a
  %cvt = sitofp <2 x i64> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_load_2i32_to_2f64(ptr%a) {
; SSE-LABEL: sitofp_load_2i32_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_load_2i32_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd (%rdi), %xmm0
; AVX-NEXT:    retq
  %ld = load <2 x i32>, ptr%a
  %cvt = sitofp <2 x i32> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_volatile_load_4i32_to_2f64(ptr%a) {
; SSE-LABEL: sitofp_volatile_load_4i32_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_volatile_load_4i32_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load volatile <4 x i32>, ptr%a
  %b = shufflevector <4 x i32> %ld, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %cvt = sitofp <2 x i32> %b to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_load_4i32_to_2f64_2(ptr %x) {
; SSE-LABEL: sitofp_load_4i32_to_2f64_2:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_load_4i32_to_2f64_2:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd (%rdi), %xmm0
; AVX-NEXT:    retq
  %a = load <4 x i32>, ptr %x
  %b = sitofp <4 x i32> %a to <4 x double>
  %c = shufflevector <4 x double> %b, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %c
}

define <2 x double> @sitofp_volatile_load_4i32_to_2f64_2(ptr %x) {
; SSE-LABEL: sitofp_volatile_load_4i32_to_2f64_2:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_volatile_load_4i32_to_2f64_2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %a = load volatile <4 x i32>, ptr %x
  %b = sitofp <4 x i32> %a to <4 x double>
  %c = shufflevector <4 x double> %b, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %c
}

define <2 x double> @sitofp_load_2i16_to_2f64(ptr%a) {
; SSE2-LABEL: sitofp_load_2i16_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_2i16_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE41-NEXT:    pmovsxwd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_load_2i16_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vpmovsxwd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <2 x i16>, ptr%a
  %cvt = sitofp <2 x i16> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @sitofp_load_2i8_to_2f64(ptr%a) {
; SSE2-LABEL: sitofp_load_2i8_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,0,2,1,4,5,6,7]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_2i8_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pmovsxbd %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_load_2i8_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    vmovd %eax, %xmm0
; AVX-NEXT:    vpmovsxbd %xmm0, %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <2 x i8>, ptr%a
  %cvt = sitofp <2 x i8> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <4 x double> @sitofp_load_4i64_to_4f64(ptr%a) {
; SSE2-LABEL: sitofp_load_4i64_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    movdqa 16(%rdi), %xmm2
; SSE2-NEXT:    cvtsi2sdq (%rdi), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2sd %rax, %xmm1
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2sdq 16(%rdi), %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    cvtsi2sd %rax, %xmm2
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_4i64_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    cvtsi2sdq 8(%rdi), %xmm1
; SSE41-NEXT:    cvtsi2sdq (%rdi), %xmm0
; SSE41-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE41-NEXT:    cvtsi2sdq 24(%rdi), %xmm2
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2sdq 16(%rdi), %xmm1
; SSE41-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_load_4i64_to_4f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvtsi2sdq 24(%rdi), %xmm0, %xmm0
; VEX-NEXT:    vcvtsi2sdq 16(%rdi), %xmm1, %xmm1
; VEX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; VEX-NEXT:    vcvtsi2sdq 8(%rdi), %xmm2, %xmm1
; VEX-NEXT:    vcvtsi2sdq (%rdi), %xmm2, %xmm2
; VEX-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; VEX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_load_4i64_to_4f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvtsi2sdq 24(%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    vcvtsi2sdq 16(%rdi), %xmm1, %xmm1
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vcvtsi2sdq 8(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vcvtsi2sdq (%rdi), %xmm2, %xmm2
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_load_4i64_to_4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtsi2sdq 24(%rdi), %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtsi2sdq 16(%rdi), %xmm1, %xmm1
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vcvtsi2sdq 8(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vcvtsi2sdq (%rdi), %xmm2, %xmm2
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_load_4i64_to_4f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-NEXT:    vcvtqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_load_4i64_to_4f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2pd (%rdi), %ymm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <4 x i64>, ptr%a
  %cvt = sitofp <4 x i64> %ld to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @sitofp_load_4i32_to_4f64(ptr%a) {
; SSE-LABEL: sitofp_load_4i32_to_4f64:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_load_4i32_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd (%rdi), %ymm0
; AVX-NEXT:    retq
  %ld = load <4 x i32>, ptr%a
  %cvt = sitofp <4 x i32> %ld to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @sitofp_load_4i16_to_4f64(ptr%a) {
; SSE2-LABEL: sitofp_load_4i16_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_4i16_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd (%rdi), %xmm1
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_load_4i16_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxwd (%rdi), %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %ld = load <4 x i16>, ptr%a
  %cvt = sitofp <4 x i16> %ld to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @sitofp_load_4i8_to_4f64(ptr%a) {
; SSE2-LABEL: sitofp_load_4i8_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_4i8_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd (%rdi), %xmm1
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_load_4i8_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbd (%rdi), %xmm0
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %ld = load <4 x i8>, ptr%a
  %cvt = sitofp <4 x i8> %ld to <4 x double>
  ret <4 x double> %cvt
}

;
; Load Unsigned Integer to Double
;

define <2 x double> @uitofp_load_2i64_to_2f64(ptr%a) {
; SSE2-LABEL: uitofp_load_2i64_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [4294967295,4294967295]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    subpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    addpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_2i64_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; SSE41-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    subpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    addpd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_2i64_to_2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; AVX1-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_2i64_to_2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_2i64_to_2f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX512F-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_2i64_to_2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm1, %xmm1
; AVX512VL-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; AVX512VL-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; AVX512VL-NEXT:    vaddpd %xmm0, %xmm1, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_2i64_to_2f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_2i64_to_2f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2pd (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <2 x i64>, ptr%a
  %cvt = uitofp <2 x i64> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @uitofp_load_2i32_to_2f64(ptr%a) {
; SSE2-LABEL: uitofp_load_2i32_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm1, %xmm0
; SSE2-NEXT:    subpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_2i32_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    subpd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_2i32_to_2f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_2i32_to_2f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_2i32_to_2f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_2i32_to_2f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2pd (%rdi), %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_2i32_to_2f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_2i32_to_2f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2pd (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <2 x i32>, ptr%a
  %cvt = uitofp <2 x i32> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @uitofp_load_4i32_to_2f64_2(ptr %x) {
; SSE2-LABEL: uitofp_load_4i32_to_2f64_2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd (%rdi), %xmm0
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm1, %xmm0
; SSE2-NEXT:    subpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i32_to_2f64_2:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    subpd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_4i32_to_2f64_2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_4i32_to_2f64_2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_4i32_to_2f64_2:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %xmm0
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_4i32_to_2f64_2:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2pd (%rdi), %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_4i32_to_2f64_2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_4i32_to_2f64_2:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2pd (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %a = load <4 x i32>, ptr %x
  %b = uitofp <4 x i32> %a to <4 x double>
  %c = shufflevector <4 x double> %b, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %c
}

define <2 x double> @uitofp_volatile_load_4i32_to_2f64_2(ptr %x) {
; SSE2-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd (%rdi), %xmm0
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm1, %xmm0
; SSE2-NEXT:    subpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    subpd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = mem[0],zero,mem[1],zero
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    # xmm1 = mem[0,0]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vsubpd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %xmm0
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovaps (%rdi), %xmm0
; AVX512VL-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_volatile_load_4i32_to_2f64_2:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512VLDQ-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %a = load volatile <4 x i32>, ptr %x
  %b = uitofp <4 x i32> %a to <4 x double>
  %c = shufflevector <4 x double> %b, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %c
}

define <2 x double> @uitofp_load_2i16_to_2f64(ptr%a) {
; SSE2-LABEL: uitofp_load_2i16_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_2i16_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_load_2i16_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <2 x i16>, ptr%a
  %cvt = uitofp <2 x i16> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <2 x double> @uitofp_load_2i8_to_2f64(ptr%a) {
; SSE2-LABEL: uitofp_load_2i8_to_2f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_2i8_to_2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2pd %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_load_2i8_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    vmovd %eax, %xmm0
; AVX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <2 x i8>, ptr%a
  %cvt = uitofp <2 x i8> %ld to <2 x double>
  ret <2 x double> %cvt
}

define <4 x double> @uitofp_load_4i64_to_4f64(ptr%a) {
; SSE2-LABEL: uitofp_load_4i64_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    movdqa 16(%rdi), %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [4294967295,4294967295]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movapd {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; SSE2-NEXT:    subpd %xmm6, %xmm0
; SSE2-NEXT:    addpd %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    psrlq $32, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    subpd %xmm6, %xmm1
; SSE2-NEXT:    addpd %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i64_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    movdqa 16(%rdi), %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    movapd {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; SSE41-NEXT:    subpd %xmm6, %xmm0
; SSE41-NEXT:    addpd %xmm3, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; SSE41-NEXT:    por %xmm4, %xmm2
; SSE41-NEXT:    psrlq $32, %xmm1
; SSE41-NEXT:    por %xmm5, %xmm1
; SSE41-NEXT:    subpd %xmm6, %xmm1
; SSE41-NEXT:    addpd %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_4i64_to_4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX1-NEXT:    vorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,3],ymm0[1,3],ymm1[5,7],ymm0[5,7]
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,0,3,1,6,4,7,5]
; AVX1-NEXT:    vorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vaddpd %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_4i64_to_4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200]
; AVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072]
; AVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25]
; AVX2-NEXT:    vsubpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vaddpd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_4i64_to_4f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200]
; AVX512F-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072]
; AVX512F-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25]
; AVX512F-NEXT:    vsubpd %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vaddpd %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_4i64_to_4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7]
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $32, %ymm0, %ymm0
; AVX512VL-NEXT:    vporq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; AVX512VL-NEXT:    vsubpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; AVX512VL-NEXT:    vaddpd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_4i64_to_4f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_4i64_to_4f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2pd (%rdi), %ymm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <4 x i64>, ptr%a
  %cvt = uitofp <4 x i64> %ld to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @uitofp_load_4i32_to_4f64(ptr%a) {
; SSE2-LABEL: uitofp_load_4i32_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movapd (%rdi), %xmm1
; SSE2-NEXT:    xorpd %xmm2, %xmm2
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    movapd {{.*#+}} xmm3 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE2-NEXT:    orpd %xmm3, %xmm0
; SSE2-NEXT:    subpd %xmm3, %xmm0
; SSE2-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE2-NEXT:    orpd %xmm3, %xmm1
; SSE2-NEXT:    subpd %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i32_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm1
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm1[0],zero,xmm1[1],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [4.503599627370496E+15,4.503599627370496E+15]
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    subpd %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm3
; SSE41-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE41-NEXT:    por %xmm2, %xmm1
; SSE41-NEXT:    subpd %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_4i32_to_4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15]
; AVX1-NEXT:    vorpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vsubpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_4i32_to_4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxdq {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15,4.503599627370496E+15]
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vsubpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_4i32_to_4f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %xmm0
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_4i32_to_4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2pd (%rdi), %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_4i32_to_4f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_4i32_to_4f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2pd (%rdi), %ymm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <4 x i32>, ptr%a
  %cvt = uitofp <4 x i32> %ld to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @uitofp_load_4i16_to_4f64(ptr%a) {
; SSE2-LABEL: uitofp_load_4i16_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i16_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_load_4i16_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %ld = load <4 x i16>, ptr%a
  %cvt = uitofp <4 x i16> %ld to <4 x double>
  ret <4 x double> %cvt
}

define <4 x double> @uitofp_load_4i8_to_4f64(ptr%a) {
; SSE2-LABEL: uitofp_load_4i8_to_4f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i8_to_4f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE41-NEXT:    cvtdq2pd %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_load_4i8_to_4f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; AVX-NEXT:    vcvtdq2pd %xmm0, %ymm0
; AVX-NEXT:    retq
  %ld = load <4 x i8>, ptr%a
  %cvt = uitofp <4 x i8> %ld to <4 x double>
  ret <4 x double> %cvt
}

;
; Load Signed Integer to Float
;

define <4 x float> @sitofp_load_4i64_to_4f32(ptr%a) {
; SSE2-LABEL: sitofp_load_4i64_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-NEXT:    cvtsi2ssq 16(%rdi), %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ssq (%rdi), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_4i64_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    cvtsi2ssq 8(%rdi), %xmm1
; SSE41-NEXT:    cvtsi2ssq (%rdi), %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[2,3]
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ssq 16(%rdi), %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ssq 24(%rdi), %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_load_4i64_to_4f32:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvtsi2ssq 8(%rdi), %xmm0, %xmm0
; VEX-NEXT:    vcvtsi2ssq (%rdi), %xmm1, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; VEX-NEXT:    vcvtsi2ssq 16(%rdi), %xmm2, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; VEX-NEXT:    vcvtsi2ssq 24(%rdi), %xmm2, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_load_4i64_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvtsi2ssq 8(%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    vcvtsi2ssq (%rdi), %xmm1, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512F-NEXT:    vcvtsi2ssq 16(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512F-NEXT:    vcvtsi2ssq 24(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_load_4i64_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtsi2ssq 8(%rdi), %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtsi2ssq (%rdi), %xmm1, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512VL-NEXT:    vcvtsi2ssq 16(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512VL-NEXT:    vcvtsi2ssq 24(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_load_4i64_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-NEXT:    vcvtqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_load_4i64_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2psy (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <4 x i64>, ptr%a
  %cvt = sitofp <4 x i64> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @sitofp_load_4i32_to_4f32(ptr%a) {
; SSE-LABEL: sitofp_load_4i32_to_4f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_load_4i32_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps (%rdi), %xmm0
; AVX-NEXT:    retq
  %ld = load <4 x i32>, ptr%a
  %cvt = sitofp <4 x i32> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @sitofp_load_4i16_to_4f32(ptr%a) {
; SSE2-LABEL: sitofp_load_4i16_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_4i16_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd (%rdi), %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_load_4i16_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxwd (%rdi), %xmm0
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <4 x i16>, ptr%a
  %cvt = sitofp <4 x i16> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @sitofp_load_4i8_to_4f32(ptr%a) {
; SSE2-LABEL: sitofp_load_4i8_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_4i8_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd (%rdi), %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: sitofp_load_4i8_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovsxbd (%rdi), %xmm0
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <4 x i8>, ptr%a
  %cvt = sitofp <4 x i8> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <8 x float> @sitofp_load_8i64_to_8f32(ptr%a) {
; SSE2-LABEL: sitofp_load_8i64_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-NEXT:    movdqa 32(%rdi), %xmm2
; SSE2-NEXT:    movdqa 48(%rdi), %xmm3
; SSE2-NEXT:    cvtsi2ssq 16(%rdi), %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1]
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ssq (%rdi), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; SSE2-NEXT:    xorps %xmm4, %xmm4
; SSE2-NEXT:    cvtsi2ssq 48(%rdi), %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ssq 32(%rdi), %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_8i64_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    cvtsi2ssq 8(%rdi), %xmm1
; SSE41-NEXT:    cvtsi2ssq (%rdi), %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[2,3]
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ssq 16(%rdi), %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ssq 24(%rdi), %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; SSE41-NEXT:    cvtsi2ssq 40(%rdi), %xmm2
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ssq 32(%rdi), %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[2,3]
; SSE41-NEXT:    xorps %xmm2, %xmm2
; SSE41-NEXT:    cvtsi2ssq 48(%rdi), %xmm2
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; SSE41-NEXT:    xorps %xmm2, %xmm2
; SSE41-NEXT:    cvtsi2ssq 56(%rdi), %xmm2
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; SSE41-NEXT:    retq
;
; VEX-LABEL: sitofp_load_8i64_to_8f32:
; VEX:       # %bb.0:
; VEX-NEXT:    vcvtsi2ssq 40(%rdi), %xmm0, %xmm0
; VEX-NEXT:    vcvtsi2ssq 32(%rdi), %xmm1, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; VEX-NEXT:    vcvtsi2ssq 48(%rdi), %xmm2, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; VEX-NEXT:    vcvtsi2ssq 56(%rdi), %xmm2, %xmm1
; VEX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; VEX-NEXT:    vcvtsi2ssq 8(%rdi), %xmm2, %xmm1
; VEX-NEXT:    vcvtsi2ssq (%rdi), %xmm2, %xmm2
; VEX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; VEX-NEXT:    vcvtsi2ssq 16(%rdi), %xmm3, %xmm2
; VEX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; VEX-NEXT:    vcvtsi2ssq 24(%rdi), %xmm3, %xmm2
; VEX-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; VEX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: sitofp_load_8i64_to_8f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvtsi2ssq 40(%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    vcvtsi2ssq 32(%rdi), %xmm1, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512F-NEXT:    vcvtsi2ssq 48(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512F-NEXT:    vcvtsi2ssq 56(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512F-NEXT:    vcvtsi2ssq 8(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vcvtsi2ssq (%rdi), %xmm2, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512F-NEXT:    vcvtsi2ssq 16(%rdi), %xmm3, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512F-NEXT:    vcvtsi2ssq 24(%rdi), %xmm3, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sitofp_load_8i64_to_8f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtsi2ssq 40(%rdi), %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtsi2ssq 32(%rdi), %xmm1, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512VL-NEXT:    vcvtsi2ssq 48(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512VL-NEXT:    vcvtsi2ssq 56(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512VL-NEXT:    vcvtsi2ssq 8(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vcvtsi2ssq (%rdi), %xmm2, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512VL-NEXT:    vcvtsi2ssq 16(%rdi), %xmm3, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512VL-NEXT:    vcvtsi2ssq 24(%rdi), %xmm3, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; AVX512VL-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: sitofp_load_8i64_to_8f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvtqq2ps (%rdi), %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: sitofp_load_8i64_to_8f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtqq2ps (%rdi), %ymm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <8 x i64>, ptr%a
  %cvt = sitofp <8 x i64> %ld to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @sitofp_load_8i32_to_8f32(ptr%a) {
; SSE-LABEL: sitofp_load_8i32_to_8f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps (%rdi), %xmm0
; SSE-NEXT:    cvtdq2ps 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_load_8i32_to_8f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps (%rdi), %ymm0
; AVX-NEXT:    retq
  %ld = load <8 x i32>, ptr%a
  %cvt = sitofp <8 x i32> %ld to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @sitofp_load_8i16_to_8f32(ptr%a) {
; SSE2-LABEL: sitofp_load_8i16_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_8i16_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxwd 8(%rdi), %xmm1
; SSE41-NEXT:    pmovsxwd (%rdi), %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_load_8i16_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxwd 8(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxwd (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_load_8i16_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxwd (%rdi), %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sitofp_load_8i16_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxwd (%rdi), %ymm0
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %ld = load <8 x i16>, ptr%a
  %cvt = sitofp <8 x i16> %ld to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @sitofp_load_8i8_to_8f32(ptr%a) {
; SSE2-LABEL: sitofp_load_8i8_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    psrad $24, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $24, %xmm1
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: sitofp_load_8i8_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbd 4(%rdi), %xmm1
; SSE41-NEXT:    pmovsxbd (%rdi), %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: sitofp_load_8i8_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovsxbd 4(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxbd (%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: sitofp_load_8i8_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbd (%rdi), %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sitofp_load_8i8_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd (%rdi), %ymm0
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %ld = load <8 x i8>, ptr%a
  %cvt = sitofp <8 x i8> %ld to <8 x float>
  ret <8 x float> %cvt
}

;
; Load Unsigned Integer to Float
;

define <4 x float> @uitofp_load_4i64_to_4f32(ptr%a) {
; SSE2-LABEL: uitofp_load_4i64_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-NEXT:    movq 16(%rdi), %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB83_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    jmp .LBB83_3
; SSE2-NEXT:  .LBB83_1:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    addss %xmm1, %xmm1
; SSE2-NEXT:  .LBB83_3:
; SSE2-NEXT:    movq (%rdi), %rax
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rcx
; SSE2-NEXT:    testq %rcx, %rcx
; SSE2-NEXT:    js .LBB83_4
; SSE2-NEXT:  # %bb.5:
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm2
; SSE2-NEXT:    jmp .LBB83_6
; SSE2-NEXT:  .LBB83_4:
; SSE2-NEXT:    movq %rcx, %rdx
; SSE2-NEXT:    shrq %rdx
; SSE2-NEXT:    andl $1, %ecx
; SSE2-NEXT:    orq %rdx, %rcx
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm2
; SSE2-NEXT:    addss %xmm2, %xmm2
; SSE2-NEXT:  .LBB83_6:
; SSE2-NEXT:    movdqa (%rdi), %xmm3
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB83_7
; SSE2-NEXT:  # %bb.8:
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    jmp .LBB83_9
; SSE2-NEXT:  .LBB83_7:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    addss %xmm0, %xmm0
; SSE2-NEXT:  .LBB83_9:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[2,3,2,3]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB83_10
; SSE2-NEXT:  # %bb.11:
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    jmp .LBB83_12
; SSE2-NEXT:  .LBB83_10:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    addss %xmm2, %xmm2
; SSE2-NEXT:  .LBB83_12:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i64_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm1
; SSE41-NEXT:    movdqa 16(%rdi), %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [1,1]
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    psrlq $1, %xmm3
; SSE41-NEXT:    por %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm1, %xmm5
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm5
; SSE41-NEXT:    pextrq $1, %xmm5, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    movq %xmm5, %rax
; SSE41-NEXT:    xorps %xmm3, %xmm3
; SSE41-NEXT:    cvtsi2ss %rax, %xmm3
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[2,3]
; SSE41-NEXT:    pand %xmm2, %xmm4
; SSE41-NEXT:    movdqa %xmm2, %xmm5
; SSE41-NEXT:    psrlq $1, %xmm5
; SSE41-NEXT:    por %xmm4, %xmm5
; SSE41-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,3],xmm2[1,3]
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    movq %xmm2, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],xmm0[0],xmm3[3]
; SSE41-NEXT:    pextrq $1, %xmm2, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1,2],xmm0[0]
; SSE41-NEXT:    movaps %xmm3, %xmm2
; SSE41-NEXT:    addps %xmm3, %xmm2
; SSE41-NEXT:    movaps %xmm1, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm3
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_4i64_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %ymm0
; AVX1-NEXT:    vpsrlq $1, %xmm0, %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm3
; AVX1-NEXT:    vorpd %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm1
; AVX1-NEXT:    vpextrq $1, %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm3
; AVX1-NEXT:    vmovq %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[2,3]
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vmovq %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0],xmm3[3]
; AVX1-NEXT:    vpextrq $1, %xmm1, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[0]
; AVX1-NEXT:    vaddps %xmm1, %xmm1, %xmm3
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vblendvps %xmm0, %xmm3, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_4i64_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm0, %ymm2
; AVX2-NEXT:    vpor %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0],xmm2[3]
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[0]
; AVX2-NEXT:    vaddps %xmm1, %xmm1, %xmm2
; AVX2-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_4i64_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvtusi2ssq 8(%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    vcvtusi2ssq (%rdi), %xmm1, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512F-NEXT:    vcvtusi2ssq 16(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512F-NEXT:    vcvtusi2ssq 24(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_4i64_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtusi2ssq 8(%rdi), %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtusi2ssq (%rdi), %xmm1, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512VL-NEXT:    vcvtusi2ssq 16(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512VL-NEXT:    vcvtusi2ssq 24(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_4i64_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_4i64_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2psy (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <4 x i64>, ptr%a
  %cvt = uitofp <4 x i64> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @uitofp_load_4i32_to_4f32(ptr%a) {
; SSE2-LABEL: uitofp_load_4i32_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE2-NEXT:    psrld $16, %xmm0
; SSE2-NEXT:    por {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    addps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i32_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [1258291200,1258291200,1258291200,1258291200]
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7]
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],mem[1],xmm0[2],mem[3],xmm0[4],mem[5],xmm0[6],mem[7]
; SSE41-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    addps %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_4i32_to_4f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0],mem[1],xmm0[2],mem[3],xmm0[4],mem[5],xmm0[6],mem[7]
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],mem[1],xmm0[2],mem[3],xmm0[4],mem[5],xmm0[6],mem[7]
; AVX1-NEXT:    vsubps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_4i32_to_4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [1258291200,1258291200,1258291200,1258291200]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm1 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4],xmm1[5],xmm0[6],xmm1[7]
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm2 = [1392508928,1392508928,1392508928,1392508928]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5],xmm0[6],xmm2[7]
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm2 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; AVX2-NEXT:    vsubps %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_4i32_to_4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %xmm0
; AVX512F-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_4i32_to_4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2ps (%rdi), %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_4i32_to_4f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_4i32_to_4f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2ps (%rdi), %xmm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <4 x i32>, ptr%a
  %cvt = uitofp <4 x i32> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @uitofp_load_4i16_to_4f32(ptr%a) {
; SSE2-LABEL: uitofp_load_4i16_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i16_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_load_4i16_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <4 x i16>, ptr%a
  %cvt = uitofp <4 x i16> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <4 x float> @uitofp_load_4i8_to_4f32(ptr%a) {
; SSE2-LABEL: uitofp_load_4i8_to_4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_4i8_to_4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: uitofp_load_4i8_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %ld = load <4 x i8>, ptr%a
  %cvt = uitofp <4 x i8> %ld to <4 x float>
  ret <4 x float> %cvt
}

define <8 x float> @uitofp_load_8i64_to_8f32(ptr%a) {
; SSE2-LABEL: uitofp_load_8i64_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa 16(%rdi), %xmm0
; SSE2-NEXT:    movq 16(%rdi), %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB87_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    jmp .LBB87_3
; SSE2-NEXT:  .LBB87_1:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    addss %xmm2, %xmm2
; SSE2-NEXT:  .LBB87_3:
; SSE2-NEXT:    movq (%rdi), %rax
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    movq %xmm0, %rcx
; SSE2-NEXT:    testq %rcx, %rcx
; SSE2-NEXT:    js .LBB87_4
; SSE2-NEXT:  # %bb.5:
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm1
; SSE2-NEXT:    jmp .LBB87_6
; SSE2-NEXT:  .LBB87_4:
; SSE2-NEXT:    movq %rcx, %rdx
; SSE2-NEXT:    shrq %rdx
; SSE2-NEXT:    andl $1, %ecx
; SSE2-NEXT:    orq %rdx, %rcx
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm1
; SSE2-NEXT:    addss %xmm1, %xmm1
; SSE2-NEXT:  .LBB87_6:
; SSE2-NEXT:    movdqa (%rdi), %xmm3
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB87_7
; SSE2-NEXT:  # %bb.8:
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    jmp .LBB87_9
; SSE2-NEXT:  .LBB87_7:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    addss %xmm0, %xmm0
; SSE2-NEXT:  .LBB87_9:
; SSE2-NEXT:    movq 48(%rdi), %rax
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,2,3]
; SSE2-NEXT:    movq %xmm3, %rcx
; SSE2-NEXT:    testq %rcx, %rcx
; SSE2-NEXT:    js .LBB87_10
; SSE2-NEXT:  # %bb.11:
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm4
; SSE2-NEXT:    jmp .LBB87_12
; SSE2-NEXT:  .LBB87_10:
; SSE2-NEXT:    movq %rcx, %rdx
; SSE2-NEXT:    shrq %rdx
; SSE2-NEXT:    andl $1, %ecx
; SSE2-NEXT:    orq %rdx, %rcx
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm4
; SSE2-NEXT:    addss %xmm4, %xmm4
; SSE2-NEXT:  .LBB87_12:
; SSE2-NEXT:    movdqa 48(%rdi), %xmm5
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB87_13
; SSE2-NEXT:  # %bb.14:
; SSE2-NEXT:    xorps %xmm3, %xmm3
; SSE2-NEXT:    cvtsi2ss %rax, %xmm3
; SSE2-NEXT:    jmp .LBB87_15
; SSE2-NEXT:  .LBB87_13:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm3, %xmm3
; SSE2-NEXT:    cvtsi2ss %rax, %xmm3
; SSE2-NEXT:    addss %xmm3, %xmm3
; SSE2-NEXT:  .LBB87_15:
; SSE2-NEXT:    movq 32(%rdi), %rax
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,3,2,3]
; SSE2-NEXT:    movq %xmm5, %rcx
; SSE2-NEXT:    testq %rcx, %rcx
; SSE2-NEXT:    js .LBB87_16
; SSE2-NEXT:  # %bb.17:
; SSE2-NEXT:    xorps %xmm5, %xmm5
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm5
; SSE2-NEXT:    jmp .LBB87_18
; SSE2-NEXT:  .LBB87_16:
; SSE2-NEXT:    movq %rcx, %rdx
; SSE2-NEXT:    shrq %rdx
; SSE2-NEXT:    andl $1, %ecx
; SSE2-NEXT:    orq %rdx, %rcx
; SSE2-NEXT:    xorps %xmm5, %xmm5
; SSE2-NEXT:    cvtsi2ss %rcx, %xmm5
; SSE2-NEXT:    addss %xmm5, %xmm5
; SSE2-NEXT:  .LBB87_18:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE2-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE2-NEXT:    movdqa 32(%rdi), %xmm4
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB87_19
; SSE2-NEXT:  # %bb.20:
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    jmp .LBB87_21
; SSE2-NEXT:  .LBB87_19:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    cvtsi2ss %rax, %xmm1
; SSE2-NEXT:    addss %xmm1, %xmm1
; SSE2-NEXT:  .LBB87_21:
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE2-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[2,3,2,3]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    testq %rax, %rax
; SSE2-NEXT:    js .LBB87_22
; SSE2-NEXT:  # %bb.23:
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    jmp .LBB87_24
; SSE2-NEXT:  .LBB87_22:
; SSE2-NEXT:    movq %rax, %rcx
; SSE2-NEXT:    shrq %rcx
; SSE2-NEXT:    andl $1, %eax
; SSE2-NEXT:    orq %rcx, %rax
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    cvtsi2ss %rax, %xmm2
; SSE2-NEXT:    addss %xmm2, %xmm2
; SSE2-NEXT:  .LBB87_24:
; SSE2-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_8i64_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm4
; SSE41-NEXT:    movdqa 16(%rdi), %xmm5
; SSE41-NEXT:    movdqa 32(%rdi), %xmm6
; SSE41-NEXT:    movdqa 48(%rdi), %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm7 = [1,1]
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    movdqa %xmm4, %xmm1
; SSE41-NEXT:    psrlq $1, %xmm1
; SSE41-NEXT:    por %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    pextrq $1, %xmm3, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    movq %xmm3, %rax
; SSE41-NEXT:    xorps %xmm3, %xmm3
; SSE41-NEXT:    cvtsi2ss %rax, %xmm3
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[2,3]
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    movdqa %xmm5, %xmm1
; SSE41-NEXT:    psrlq $1, %xmm1
; SSE41-NEXT:    por %xmm0, %xmm1
; SSE41-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,3],xmm5[1,3]
; SSE41-NEXT:    movaps %xmm5, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm5
; SSE41-NEXT:    movq %xmm5, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],xmm0[0],xmm3[3]
; SSE41-NEXT:    pextrq $1, %xmm5, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1,2],xmm0[0]
; SSE41-NEXT:    movaps %xmm3, %xmm1
; SSE41-NEXT:    addps %xmm3, %xmm1
; SSE41-NEXT:    movaps %xmm4, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm6, %xmm0
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    movdqa %xmm6, %xmm1
; SSE41-NEXT:    psrlq $1, %xmm1
; SSE41-NEXT:    por %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm6, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm4
; SSE41-NEXT:    pextrq $1, %xmm4, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    movq %xmm4, %rax
; SSE41-NEXT:    xorps %xmm1, %xmm1
; SSE41-NEXT:    cvtsi2ss %rax, %xmm1
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[2,3]
; SSE41-NEXT:    pand %xmm2, %xmm7
; SSE41-NEXT:    movdqa %xmm2, %xmm4
; SSE41-NEXT:    psrlq $1, %xmm4
; SSE41-NEXT:    por %xmm7, %xmm4
; SSE41-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,3],xmm2[1,3]
; SSE41-NEXT:    movaps %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; SSE41-NEXT:    movq %xmm2, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0],xmm1[3]
; SSE41-NEXT:    pextrq $1, %xmm2, %rax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm0[0]
; SSE41-NEXT:    movaps %xmm1, %xmm2
; SSE41-NEXT:    addps %xmm1, %xmm2
; SSE41-NEXT:    movaps %xmm6, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_8i64_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [1,1,1,1]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm3
; AVX1-NEXT:    vpsrlq $1, %xmm1, %xmm4
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm5
; AVX1-NEXT:    vpsrlq $1, %xmm5, %xmm6
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX1-NEXT:    vorps %ymm3, %ymm4, %ymm3
; AVX1-NEXT:    vblendvpd %ymm1, %ymm3, %ymm1, %ymm3
; AVX1-NEXT:    vpextrq $1, %xmm3, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm4
; AVX1-NEXT:    vmovq %xmm3, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm6
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm6[0],xmm4[0],xmm6[2,3]
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vmovq %xmm3, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm6
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1],xmm6[0],xmm4[3]
; AVX1-NEXT:    vpextrq $1, %xmm3, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm3
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0,1,2],xmm3[0]
; AVX1-NEXT:    vaddps %xmm3, %xmm3, %xmm4
; AVX1-NEXT:    vpackssdw %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vblendvps %xmm1, %xmm4, %xmm3, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm2
; AVX1-NEXT:    vpsrlq $1, %xmm0, %xmm3
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX1-NEXT:    vpsrlq $1, %xmm4, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-NEXT:    vorps %ymm2, %ymm3, %ymm2
; AVX1-NEXT:    vblendvpd %ymm0, %ymm2, %ymm0, %ymm2
; AVX1-NEXT:    vpextrq $1, %xmm2, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm3
; AVX1-NEXT:    vmovq %xmm2, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[2,3]
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vmovq %xmm2, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm5[0],xmm3[3]
; AVX1-NEXT:    vpextrq $1, %xmm2, %rax
; AVX1-NEXT:    vcvtsi2ss %rax, %xmm7, %xmm2
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0,1,2],xmm2[0]
; AVX1-NEXT:    vaddps %xmm2, %xmm2, %xmm3
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_8i64_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [1,1,1,1]
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm4
; AVX2-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vblendvpd %ymm1, %ymm3, %ymm1, %ymm3
; AVX2-NEXT:    vpextrq $1, %xmm3, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; AVX2-NEXT:    vmovq %xmm3, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm5
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[2,3]
; AVX2-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-NEXT:    vmovq %xmm3, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm6, %xmm5
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1],xmm5[0],xmm4[3]
; AVX2-NEXT:    vpextrq $1, %xmm3, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm6, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0,1,2],xmm3[0]
; AVX2-NEXT:    vaddps %xmm3, %xmm3, %xmm4
; AVX2-NEXT:    vpackssdw 48(%rdi), %xmm1, %xmm1
; AVX2-NEXT:    vblendvps %xmm1, %xmm4, %xmm3, %xmm1
; AVX2-NEXT:    vandps %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlq $1, %ymm0, %ymm3
; AVX2-NEXT:    vpor %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vblendvpd %ymm0, %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrq $1, %xmm2, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm6, %xmm3
; AVX2-NEXT:    vmovq %xmm2, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm6, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[2,3]
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vmovq %xmm2, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm6, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0],xmm3[3]
; AVX2-NEXT:    vpextrq $1, %xmm2, %rax
; AVX2-NEXT:    vcvtsi2ss %rax, %xmm6, %xmm2
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0,1,2],xmm2[0]
; AVX2-NEXT:    vaddps %xmm2, %xmm2, %xmm3
; AVX2-NEXT:    vpackssdw 16(%rdi), %xmm0, %xmm0
; AVX2-NEXT:    vblendvps %xmm0, %xmm3, %xmm2, %xmm0
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_8i64_to_8f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvtusi2ssq 40(%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    vcvtusi2ssq 32(%rdi), %xmm1, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512F-NEXT:    vcvtusi2ssq 48(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512F-NEXT:    vcvtusi2ssq 56(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512F-NEXT:    vcvtusi2ssq 8(%rdi), %xmm2, %xmm1
; AVX512F-NEXT:    vcvtusi2ssq (%rdi), %xmm2, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512F-NEXT:    vcvtusi2ssq 16(%rdi), %xmm3, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512F-NEXT:    vcvtusi2ssq 24(%rdi), %xmm3, %xmm2
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_8i64_to_8f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtusi2ssq 40(%rdi), %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtusi2ssq 32(%rdi), %xmm1, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[2,3]
; AVX512VL-NEXT:    vcvtusi2ssq 48(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0],xmm0[3]
; AVX512VL-NEXT:    vcvtusi2ssq 56(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; AVX512VL-NEXT:    vcvtusi2ssq 8(%rdi), %xmm2, %xmm1
; AVX512VL-NEXT:    vcvtusi2ssq (%rdi), %xmm2, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512VL-NEXT:    vcvtusi2ssq 16(%rdi), %xmm3, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; AVX512VL-NEXT:    vcvtusi2ssq 24(%rdi), %xmm3, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; AVX512VL-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_8i64_to_8f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvtuqq2ps (%rdi), %ymm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_8i64_to_8f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtuqq2ps (%rdi), %ymm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <8 x i64>, ptr%a
  %cvt = uitofp <8 x i64> %ld to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @uitofp_load_8i32_to_8f32(ptr%a) {
; SSE2-LABEL: uitofp_load_8i32_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    movdqa 16(%rdi), %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,65535,65535]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [1258291200,1258291200,1258291200,1258291200]
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    psrld $16, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1392508928,1392508928,1392508928,1392508928]
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movaps {{.*#+}} xmm6 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; SSE2-NEXT:    subps %xmm6, %xmm0
; SSE2-NEXT:    addps %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    psrld $16, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    subps %xmm6, %xmm1
; SSE2-NEXT:    addps %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_8i32_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    movdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [1258291200,1258291200,1258291200,1258291200]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0],xmm2[1],xmm3[2],xmm2[3],xmm3[4],xmm2[5],xmm3[6],xmm2[7]
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [1392508928,1392508928,1392508928,1392508928]
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm4[1],xmm0[2],xmm4[3],xmm0[4],xmm4[5],xmm0[6],xmm4[7]
; SSE41-NEXT:    movaps {{.*#+}} xmm5 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; SSE41-NEXT:    subps %xmm5, %xmm0
; SSE41-NEXT:    addps %xmm3, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm1[0],xmm2[1],xmm1[2],xmm2[3],xmm1[4],xmm2[5],xmm1[6],xmm2[7]
; SSE41-NEXT:    psrld $16, %xmm1
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2],xmm4[3],xmm1[4],xmm4[5],xmm1[6],xmm4[7]
; SSE41-NEXT:    subps %xmm5, %xmm1
; SSE41-NEXT:    addps %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_8i32_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %ymm0
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vcvtdq2ps %ymm1, %ymm1
; AVX1-NEXT:    vmulps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vaddps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_8i32_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [1258291200,1258291200,1258291200,1258291200,1258291200,1258291200,1258291200,1258291200]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm0[0],ymm1[1],ymm0[2],ymm1[3],ymm0[4],ymm1[5],ymm0[6],ymm1[7],ymm0[8],ymm1[9],ymm0[10],ymm1[11],ymm0[12],ymm1[13],ymm0[14],ymm1[15]
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [1392508928,1392508928,1392508928,1392508928,1392508928,1392508928,1392508928,1392508928]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2],ymm2[3],ymm0[4],ymm2[5],ymm0[6],ymm2[7],ymm0[8],ymm2[9],ymm0[10],ymm2[11],ymm0[12],ymm2[13],ymm0[14],ymm2[15]
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm2 = [5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11,5.49764202E+11]
; AVX2-NEXT:    vsubps %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vaddps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: uitofp_load_8i32_to_8f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps (%rdi), %ymm0
; AVX512F-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: uitofp_load_8i32_to_8f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2ps (%rdi), %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: uitofp_load_8i32_to_8f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: uitofp_load_8i32_to_8f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2ps (%rdi), %ymm0
; AVX512VLDQ-NEXT:    retq
  %ld = load <8 x i32>, ptr%a
  %cvt = uitofp <8 x i32> %ld to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @uitofp_load_8i16_to_8f32(ptr%a) {
; SSE2-LABEL: uitofp_load_8i16_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_8i16_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_8i16_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_8i16_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: uitofp_load_8i16_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %ld = load <8 x i16>, ptr%a
  %cvt = uitofp <8 x i16> %ld to <8 x float>
  ret <8 x float> %cvt
}

define <8 x float> @uitofp_load_8i8_to_8f32(ptr%a) {
; SSE2-LABEL: uitofp_load_8i8_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: uitofp_load_8i8_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: uitofp_load_8i8_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm1 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: uitofp_load_8i8_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: uitofp_load_8i8_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} ymm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    retq
  %ld = load <8 x i8>, ptr%a
  %cvt = uitofp <8 x i8> %ld to <8 x float>
  ret <8 x float> %cvt
}

;
; Aggregates
;

%Arguments = type <{ <8 x i8>, <8 x i16>, ptr }>
define void @aggregate_sitofp_8i16_to_8f32(ptr nocapture readonly %a0) {
; SSE2-LABEL: aggregate_sitofp_8i16_to_8f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movq 24(%rdi), %rax
; SSE2-NEXT:    movdqu 8(%rdi), %xmm0
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE2-NEXT:    movaps %xmm0, 16(%rax)
; SSE2-NEXT:    movaps %xmm1, (%rax)
; SSE2-NEXT:    retq
;
; SSE41-LABEL: aggregate_sitofp_8i16_to_8f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq 24(%rdi), %rax
; SSE41-NEXT:    pmovsxwd 16(%rdi), %xmm0
; SSE41-NEXT:    pmovsxwd 8(%rdi), %xmm1
; SSE41-NEXT:    cvtdq2ps %xmm1, %xmm1
; SSE41-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE41-NEXT:    movaps %xmm0, 16(%rax)
; SSE41-NEXT:    movaps %xmm1, (%rax)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: aggregate_sitofp_8i16_to_8f32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq 24(%rdi), %rax
; AVX1-NEXT:    vpmovsxwd 16(%rdi), %xmm0
; AVX1-NEXT:    vpmovsxwd 8(%rdi), %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX1-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: aggregate_sitofp_8i16_to_8f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq 24(%rdi), %rax
; AVX2-NEXT:    vpmovsxwd 8(%rdi), %ymm0
; AVX2-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: aggregate_sitofp_8i16_to_8f32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq 24(%rdi), %rax
; AVX512-NEXT:    vpmovsxwd 8(%rdi), %ymm0
; AVX512-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512-NEXT:    vmovaps %ymm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
 %1 = load %Arguments, ptr %a0, align 1
 %2 = extractvalue %Arguments %1, 1
 %3 = extractvalue %Arguments %1, 2
 %4 = sitofp <8 x i16> %2 to <8 x float>
 store <8 x float> %4, ptr %3, align 32
 ret void
}

define <2 x double> @sitofp_i32_to_2f64(<2 x double> %a0, i32 %a1) nounwind {
; SSE-LABEL: sitofp_i32_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtsi2sd %edi, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_i32_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtsi2sd %edi, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = sitofp i32 %a1 to double
  %res = insertelement <2 x double> %a0, double %cvt, i32 0
  ret <2 x double> %res
}

define <4 x float> @sitofp_i32_to_4f32(<4 x float> %a0, i32 %a1) nounwind {
; SSE-LABEL: sitofp_i32_to_4f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtsi2ss %edi, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_i32_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtsi2ss %edi, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = sitofp i32 %a1 to float
  %res = insertelement <4 x float> %a0, float %cvt, i32 0
  ret <4 x float> %res
}

define <2 x double> @sitofp_i64_to_2f64(<2 x double> %a0, i64 %a1) nounwind {
; SSE-LABEL: sitofp_i64_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtsi2sd %rdi, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_i64_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtsi2sd %rdi, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = sitofp i64 %a1 to double
  %res = insertelement <2 x double> %a0, double %cvt, i32 0
  ret <2 x double> %res
}

define <4 x float> @sitofp_i64_to_4f32(<4 x float> %a0, i64 %a1) nounwind {
; SSE-LABEL: sitofp_i64_to_4f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtsi2ss %rdi, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_i64_to_4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtsi2ss %rdi, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cvt = sitofp i64 %a1 to float
  %res = insertelement <4 x float> %a0, float %cvt, i32 0
  ret <4 x float> %res
}

; Extract from int vector and convert to FP.

define float @extract0_sitofp_v4i32_f32(<4 x i32> %x) nounwind {
; SSE-LABEL: extract0_sitofp_v4i32_f32:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: extract0_sitofp_v4i32_f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 0
  %r = sitofp i32 %e to float
  ret float %r
}

define float @extract0_sitofp_v4i32_f32i_multiuse1(<4 x i32> %x) nounwind {
; SSE-LABEL: extract0_sitofp_v4i32_f32i_multiuse1:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE-NEXT:    incl %eax
; SSE-NEXT:    cvtsi2ss %eax, %xmm1
; SSE-NEXT:    divss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: extract0_sitofp_v4i32_f32i_multiuse1:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd %xmm0, %eax
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    incl %eax
; AVX-NEXT:    vcvtsi2ss %eax, %xmm1, %xmm1
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 0
  %f = sitofp i32 %e to float
  %e1 = add i32 %e, 1
  %f1 = sitofp i32 %e1 to float
  %r = fdiv float %f, %f1
  ret float %r
}

define float @extract0_sitofp_v4i32_f32_multiuse2(<4 x i32> %x, ptr %p) nounwind {
; SSE-LABEL: extract0_sitofp_v4i32_f32_multiuse2:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm1
; SSE-NEXT:    movss %xmm0, (%rdi)
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: extract0_sitofp_v4i32_f32_multiuse2:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm1
; AVX-NEXT:    vmovss %xmm0, (%rdi)
; AVX-NEXT:    vmovaps %xmm1, %xmm0
; AVX-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 0
  %r = sitofp i32 %e to float
  store i32 %e, ptr %p
  ret float %r
}

define double @extract0_sitofp_v4i32_f64(<4 x i32> %x) nounwind {
; SSE-LABEL: extract0_sitofp_v4i32_f64:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    cvtsi2sd %eax, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: extract0_sitofp_v4i32_f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 0
  %r = sitofp i32 %e to double
  ret double %r
}

define float @extract0_uitofp_v4i32_f32(<4 x i32> %x) nounwind {
; SSE-LABEL: extract0_uitofp_v4i32_f32:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    cvtsi2ss %rax, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: extract0_uitofp_v4i32_f32:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovd %xmm0, %eax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: extract0_uitofp_v4i32_f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: extract0_uitofp_v4i32_f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: extract0_uitofp_v4i32_f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: extract0_uitofp_v4i32_f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 0
  %r = uitofp i32 %e to float
  ret float %r
}

define double @extract0_uitofp_v4i32_f64(<4 x i32> %x) nounwind {
; SSE-LABEL: extract0_uitofp_v4i32_f64:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    xorps %xmm0, %xmm0
; SSE-NEXT:    cvtsi2sd %rax, %xmm0
; SSE-NEXT:    retq
;
; VEX-LABEL: extract0_uitofp_v4i32_f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vmovd %xmm0, %eax
; VEX-NEXT:    vcvtsi2sd %rax, %xmm1, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: extract0_uitofp_v4i32_f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: extract0_uitofp_v4i32_f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: extract0_uitofp_v4i32_f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: extract0_uitofp_v4i32_f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 0
  %r = uitofp i32 %e to double
  ret double %r
}

; Extract non-zero element from int vector and convert to FP.

define float @extract3_sitofp_v4i32_f32(<4 x i32> %x) nounwind {
; SSE-LABEL: extract3_sitofp_v4i32_f32:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    cvtdq2ps %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: extract3_sitofp_v4i32_f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 3
  %r = sitofp i32 %e to float
  ret float %r
}

define double @extract3_sitofp_v4i32_f64(<4 x i32> %x) nounwind {
; SSE2-LABEL: extract3_sitofp_v4i32_f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2sd %eax, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: extract3_sitofp_v4i32_f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    extractps $3, %xmm0, %eax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2sd %eax, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: extract3_sitofp_v4i32_f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX-NEXT:    vcvtdq2pd %xmm0, %xmm0
; AVX-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 3
  %r = sitofp i32 %e to double
  ret double %r
}

define float @extract3_uitofp_v4i32_f32(<4 x i32> %x) nounwind {
; SSE2-LABEL: extract3_uitofp_v4i32_f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2ss %rax, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: extract3_uitofp_v4i32_f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    extractps $3, %xmm0, %eax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2ss %rax, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: extract3_uitofp_v4i32_f32:
; VEX:       # %bb.0:
; VEX-NEXT:    vextractps $3, %xmm0, %eax
; VEX-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: extract3_uitofp_v4i32_f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512F-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: extract3_uitofp_v4i32_f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512VL-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: extract3_uitofp_v4i32_f32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512DQ-NEXT:    vcvtudq2ps %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: extract3_uitofp_v4i32_f32:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512VLDQ-NEXT:    vcvtudq2ps %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 3
  %r = uitofp i32 %e to float
  ret float %r
}

define double @extract3_uitofp_v4i32_f64(<4 x i32> %x) nounwind {
; SSE2-LABEL: extract3_uitofp_v4i32_f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    cvtsi2sd %rax, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: extract3_uitofp_v4i32_f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    extractps $3, %xmm0, %eax
; SSE41-NEXT:    xorps %xmm0, %xmm0
; SSE41-NEXT:    cvtsi2sd %rax, %xmm0
; SSE41-NEXT:    retq
;
; VEX-LABEL: extract3_uitofp_v4i32_f64:
; VEX:       # %bb.0:
; VEX-NEXT:    vextractps $3, %xmm0, %eax
; VEX-NEXT:    vcvtsi2sd %rax, %xmm1, %xmm0
; VEX-NEXT:    retq
;
; AVX512F-LABEL: extract3_uitofp_v4i32_f64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512F-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: extract3_uitofp_v4i32_f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512VL-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: extract3_uitofp_v4i32_f64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512DQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: extract3_uitofp_v4i32_f64:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX512VLDQ-NEXT:    vcvtudq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    retq
  %e = extractelement <4 x i32> %x, i32 3
  %r = uitofp i32 %e to double
  ret double %r
}

define void @PR43609(ptr nocapture %x, <2 x i64> %y) #0 {
; SSE2-LABEL: PR43609:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [2,2]
; SSE2-NEXT:    paddq %xmm0, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [4294967295,4294967295]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; SSE2-NEXT:    por %xmm4, %xmm3
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movapd {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; SSE2-NEXT:    subpd %xmm6, %xmm0
; SSE2-NEXT:    addpd %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    psrlq $32, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    subpd %xmm6, %xmm1
; SSE2-NEXT:    addpd %xmm2, %xmm1
; SSE2-NEXT:    movapd {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; SSE2-NEXT:    addpd %xmm2, %xmm0
; SSE2-NEXT:    addpd %xmm2, %xmm1
; SSE2-NEXT:    movupd %xmm0, (%rdi)
; SSE2-NEXT:    movupd %xmm1, 16(%rdi)
; SSE2-NEXT:    retq
;
; SSE41-LABEL: PR43609:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [2,2]
; SSE41-NEXT:    paddq %xmm0, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    movapd {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; SSE41-NEXT:    subpd %xmm6, %xmm0
; SSE41-NEXT:    addpd %xmm3, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; SSE41-NEXT:    por %xmm4, %xmm2
; SSE41-NEXT:    psrlq $32, %xmm1
; SSE41-NEXT:    por %xmm5, %xmm1
; SSE41-NEXT:    subpd %xmm6, %xmm1
; SSE41-NEXT:    addpd %xmm2, %xmm1
; SSE41-NEXT:    movapd {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; SSE41-NEXT:    addpd %xmm2, %xmm0
; SSE41-NEXT:    addpd %xmm2, %xmm1
; SSE41-NEXT:    movupd %xmm0, (%rdi)
; SSE41-NEXT:    movupd %xmm1, 16(%rdi)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: PR43609:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; AVX1-NEXT:    # xmm5 = mem[0,0]
; AVX1-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; AVX1-NEXT:    # xmm6 = mem[0,0]
; AVX1-NEXT:    vsubpd %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vaddpd %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; AVX1-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vsubpd %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vaddpd %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vmovddup {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; AVX1-NEXT:    # xmm2 = mem[0,0]
; AVX1-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vaddpd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovupd %xmm0, (%rdi)
; AVX1-NEXT:    vmovupd %xmm1, 16(%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR43609:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; AVX2-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; AVX2-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; AVX2-NEXT:    # xmm6 = mem[0,0]
; AVX2-NEXT:    vsubpd %xmm6, %xmm0, %xmm0
; AVX2-NEXT:    vaddpd %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX2-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX2-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX2-NEXT:    vpor %xmm5, %xmm1, %xmm1
; AVX2-NEXT:    vsubpd %xmm6, %xmm1, %xmm1
; AVX2-NEXT:    vaddpd %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; AVX2-NEXT:    # xmm2 = mem[0,0]
; AVX2-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vaddpd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vmovupd %xmm0, (%rdi)
; AVX2-NEXT:    vmovupd %xmm1, 16(%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: PR43609:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; AVX512F-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX512F-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; AVX512F-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512F-NEXT:    vmovddup {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; AVX512F-NEXT:    # xmm6 = mem[0,0]
; AVX512F-NEXT:    vsubpd %xmm6, %xmm0, %xmm0
; AVX512F-NEXT:    vaddpd %xmm0, %xmm3, %xmm0
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX512F-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512F-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX512F-NEXT:    vpor %xmm5, %xmm1, %xmm1
; AVX512F-NEXT:    vsubpd %xmm6, %xmm1, %xmm1
; AVX512F-NEXT:    vaddpd %xmm1, %xmm2, %xmm1
; AVX512F-NEXT:    vmovddup {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; AVX512F-NEXT:    # xmm2 = mem[0,0]
; AVX512F-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vaddpd %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vmovupd %xmm0, (%rdi)
; AVX512F-NEXT:    vmovupd %xmm1, 16(%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: PR43609:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm1
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [4841369599423283200,4841369599423283200]
; AVX512VL-NEXT:    vpor %xmm4, %xmm3, %xmm3
; AVX512VL-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm5 = [4985484787499139072,4985484787499139072]
; AVX512VL-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovddup {{.*#+}} xmm6 = [1.9342813118337666E+25,1.9342813118337666E+25]
; AVX512VL-NEXT:    # xmm6 = mem[0,0]
; AVX512VL-NEXT:    vsubpd %xmm6, %xmm0, %xmm0
; AVX512VL-NEXT:    vaddpd %xmm0, %xmm3, %xmm0
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm2 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX512VL-NEXT:    vpor %xmm4, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX512VL-NEXT:    vpor %xmm5, %xmm1, %xmm1
; AVX512VL-NEXT:    vsubpd %xmm6, %xmm1, %xmm1
; AVX512VL-NEXT:    vaddpd %xmm1, %xmm2, %xmm1
; AVX512VL-NEXT:    vmovddup {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; AVX512VL-NEXT:    # xmm2 = mem[0,0]
; AVX512VL-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; AVX512VL-NEXT:    vaddpd %xmm2, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovupd %xmm0, (%rdi)
; AVX512VL-NEXT:    vmovupd %xmm1, 16(%rdi)
; AVX512VL-NEXT:    retq
;
; AVX512DQ-LABEL: PR43609:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512DQ-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512DQ-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; AVX512DQ-NEXT:    vcvtuqq2pd %zmm1, %zmm1
; AVX512DQ-NEXT:    vmovddup {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; AVX512DQ-NEXT:    # xmm2 = mem[0,0]
; AVX512DQ-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; AVX512DQ-NEXT:    vaddpd %xmm2, %xmm1, %xmm1
; AVX512DQ-NEXT:    vmovupd %xmm0, (%rdi)
; AVX512DQ-NEXT:    vmovupd %xmm1, 16(%rdi)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512VLDQ-LABEL: PR43609:
; AVX512VLDQ:       # %bb.0:
; AVX512VLDQ-NEXT:    vpaddq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm1
; AVX512VLDQ-NEXT:    vcvtuqq2pd %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vcvtuqq2pd %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vmovddup {{.*#+}} xmm2 = [5.0E-1,5.0E-1]
; AVX512VLDQ-NEXT:    # xmm2 = mem[0,0]
; AVX512VLDQ-NEXT:    vaddpd %xmm2, %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vaddpd %xmm2, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vmovupd %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    vmovupd %xmm1, 16(%rdi)
; AVX512VLDQ-NEXT:    retq
  %step.add.epil = add <2 x i64> %y, <i64 2, i64 2>
  %t20 = uitofp <2 x i64> %y to <2 x double>
  %t21 = uitofp <2 x i64> %step.add.epil to <2 x double>
  %t22 = fadd fast <2 x double> %t20, <double 5.0e-01, double 5.0e-01>
  %t23 = fadd fast <2 x double> %t21, <double 5.0e-01, double 5.0e-01>
  store <2 x double> %t22, ptr %x, align 8
  %t26 = getelementptr inbounds double, ptr %x, i64 2
  store <2 x double> %t23, ptr %t26, align 8
  ret void
}

attributes #0 = { "unsafe-fp-math"="true" }

