; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=x86-64-v3| FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=x86-64-v4 | FileCheck %s --check-prefixes=AVX,AVX512

; i32 saturate

define <2 x i32> @stest_f64i32(<2 x double> %x) nounwind {
; SSE-LABEL: stest_f64i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4294967295,4294967295]
; SSE-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,2,2]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f64i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rcx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f64i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2qq %xmm0, %xmm0
; AVX512-NEXT:    vpmovsqd %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 2147483647, i64 2147483647>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>
  %1 = icmp sgt <2 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32(<2 x double> %x) nounwind {
; SSE-LABEL: utest_f64i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; SSE-NEXT:    movapd %xmm0, %xmm2
; SSE-NEXT:    subsd %xmm1, %xmm2
; SSE-NEXT:    cvttsd2si %xmm2, %rax
; SSE-NEXT:    cvttsd2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    subsd %xmm1, %xmm0
; SSE-NEXT:    cvttsd2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,2]
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f64i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vmovsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vcvttsd2si %xmm2, %rax
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttsd2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX2-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f64i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2uqq %xmm0, %xmm0
; AVX512-NEXT:    vpmovusqd %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %0 = icmp ult <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32(<2 x double> %x) nounwind {
; SSE-LABEL: ustest_f64i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [2147483647,2147483647]
; SSE-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f64i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4294967295,4294967295]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f64i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2qq %xmm0, %xmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovusqd %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %1 = icmp sgt <2 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> zeroinitializer
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32(<4 x float> %x) nounwind {
; SSE-LABEL: stest_f32i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    cvttss2si %xmm2, %rax
; SSE-NEXT:    movq %rax, %xmm2
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [2147483647,2147483647]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [4294967295,4294967295]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pcmpgtd %xmm1, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,0,2,2]
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[1,1,3,3]
; SSE-NEXT:    por %xmm9, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [18446744071562067968,18446744071562067968]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [18446744069414584320,18446744069414584320]
; SSE-NEXT:    pcmpgtd %xmm7, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f32i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f32i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512-NEXT:    vpmovsqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32(<4 x float> %x) nounwind {
; SSE-LABEL: utest_f32i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movss {{.*#+}} xmm2 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    subss %xmm2, %xmm1
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm2, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm2, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss %xmm2, %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,0,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [2147483647,2147483647,2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,0,2,2]
; SSE-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm0, %xmm4
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f32i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX2-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm2
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm4, %rax
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372041149743102,9223372041149743102,9223372041149743102,9223372041149743102]
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f32i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2uqq %xmm0, %ymm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32(<4 x float> %x) nounwind {
; SSE-LABEL: ustest_f32i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    cvttss2si %xmm2, %rax
; SSE-NEXT:    movq %rax, %xmm2
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4294967295,4294967295]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pcmpgtd %xmm1, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,0,2,2]
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[1,1,3,3]
; SSE-NEXT:    por %xmm9, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f32i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f32i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32(<4 x half> %x) nounwind {
; SSE-LABEL: stest_f16i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa (%rsp), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [2147483647,2147483647]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [4294967295,4294967295]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm6
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[0,0,2,2]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [18446744071562067968,18446744071562067968]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE-NEXT:    pcmpeqd %xmm6, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [18446744069414584320,18446744069414584320]
; SSE-NEXT:    pcmpgtd %xmm7, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[0,0,2,2]
; SSE-NEXT:    pand %xmm5, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE-NEXT:    pcmpgtd %xmm7, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f16i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX2-NEXT:    vpextrw $0, %xmm1, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpextrw $0, %xmm2, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm1
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f16i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512-NEXT:    vpmovsqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32(<4 x half> %x) nounwind {
; SSE-LABEL: utesth_f16i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq (%rsp), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147483647,2147483647,2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: utesth_f16i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX2-NEXT:    vpextrw $0, %xmm1, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm2
; AVX2-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpextrw $0, %xmm2, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm2
; AVX2-NEXT:    vpextrw $0, %xmm0, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm3
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    vsubss %xmm1, %xmm3, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm4, %rax
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm3, %rcx
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm4[0],xmm2[0]
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372041149743102,9223372041149743102,9223372041149743102,9223372041149743102]
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utesth_f16i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32(<4 x half> %x) nounwind {
; SSE-LABEL: ustest_f16i32:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa (%rsp), %xmm3 # 16-byte Reload
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [4294967295,4294967295]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm6
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[0,0,2,2]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f16i32:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX2-NEXT:    vpextrw $0, %xmm1, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpextrw $0, %xmm2, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f16i32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16(<2 x double> %x) nounwind {
; SSE-LABEL: stest_f64i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: stest_f64i16:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 32767, i32 32767>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>
  %1 = icmp sgt <2 x i32> %spec.store.select, <i32 -32768, i32 -32768>
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16(<2 x double> %x) nounwind {
; SSE-LABEL: utest_f64i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    addpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    andpd %xmm2, %xmm0
; SSE-NEXT:    orpd %xmm1, %xmm0
; SSE-NEXT:    movapd {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    xorpd %xmm0, %xmm1
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f64i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvttpd2dq %xmm0, %xmm1
; AVX2-NEXT:    vaddpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX2-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX2-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vorpd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f64i16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2udq %xmm0, %xmm0
; AVX512-NEXT:    vpminud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vpmovdw %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %0 = icmp ult <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16(<2 x double> %x) nounwind {
; SSE-LABEL: ustest_f64i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,u,u]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f64i16:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %1 = icmp sgt <2 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> zeroinitializer
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16(<4 x float> %x) nounwind {
; SSE-LABEL: stest_f32i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: stest_f32i16:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <4 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16(<4 x float> %x) nounwind {
; SSE-LABEL: utest_f32i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f32i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm1, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f32i16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2udq %xmm0, %xmm0
; AVX512-NEXT:    vpmovusdw %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %0 = icmp ult <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16(<4 x float> %x) nounwind {
; SSE-LABEL: ustest_f32i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f32i16:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <4 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> zeroinitializer
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16(<8 x half> %x) nounwind {
; SSE-LABEL: stest_f16i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    cvttps2dq %xmm1, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    packssdw {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f16i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f16i16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512-NEXT:    vpmovsdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <8 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16(<8 x half> %x) nounwind {
; SSE-LABEL: utesth_f16i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    cvttps2dq %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrad $31, %xmm1
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSE-NEXT:    cvttps2dq %xmm2, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[0],mem[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147549183,2147549183,2147549183,2147549183]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pcmpgtd %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pxor %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pslld $16, %xmm4
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm4, %xmm0
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: utesth_f16i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vcvttps2dq %ymm1, %ymm1
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utesth_f16i16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2udq %ymm0, %ymm0
; AVX512-NEXT:    vpmovusdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %0 = icmp ult <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16(<8 x half> %x) nounwind {
; SSE-LABEL: ustest_f16i16:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    cvttps2dq %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pslld $16, %xmm3
; SSE-NEXT:    psrad $16, %xmm3
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm3, %xmm0
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f16i16:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f16i16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovusdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <8 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> zeroinitializer
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i8 saturate

define <2 x i8> @stest_f64i8(<2 x double> %x) nounwind {
; SSE-LABEL: stest_f64i8:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: stest_f64i8:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 127, i32 127>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 127, i32 127>
  %1 = icmp sgt <2 x i32> %spec.store.select, <i32 -128, i32 -128>
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> <i32 -128, i32 -128>
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i8>
  ret <2 x i8> %conv6
}

define <2 x i8> @utest_f64i8(<2 x double> %x) nounwind {
; SSE-LABEL: utest_f64i8:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    addpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm3
; SSE-NEXT:    andpd %xmm2, %xmm3
; SSE-NEXT:    orpd %xmm1, %xmm3
; SSE-NEXT:    movapd {{.*#+}} xmm0 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    xorpd %xmm3, %xmm0
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    psrld $24, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f64i8:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvttpd2dq %xmm0, %xmm1
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX2-NEXT:    vaddpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX2-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vorpd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [255,255,255,255]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,0,4,8,12,0,4,8,12,0,4,8,12]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f64i8:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2udq %xmm0, %xmm0
; AVX512-NEXT:    vpminud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %0 = icmp ult <2 x i32> %conv, <i32 255, i32 255>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 255, i32 255>
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i8>
  ret <2 x i8> %conv6
}

define <2 x i8> @ustest_f64i8(<2 x double> %x) nounwind {
; SSE-LABEL: ustest_f64i8:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f64i8:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 255, i32 255>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 255, i32 255>
  %1 = icmp sgt <2 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> zeroinitializer
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i8>
  ret <2 x i8> %conv6
}

define <4 x i8> @stest_f32i8(<4 x float> %x) nounwind {
; SSE-LABEL: stest_f32i8:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: stest_f32i8:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 127, i32 127, i32 127, i32 127>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 127, i32 127, i32 127, i32 127>
  %1 = icmp sgt <4 x i32> %spec.store.select, <i32 -128, i32 -128, i32 -128, i32 -128>
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> <i32 -128, i32 -128, i32 -128, i32 -128>
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i8>
  ret <4 x i8> %conv6
}

define <4 x i8> @utest_f32i8(<4 x float> %x) nounwind {
; SSE-LABEL: utest_f32i8:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    psrld $24, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f32i8:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm1, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [255,255,255,255]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,0,4,8,12,0,4,8,12,0,4,8,12]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f32i8:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2udq %xmm0, %xmm0
; AVX512-NEXT:    vpmovusdb %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %0 = icmp ult <4 x i32> %conv, <i32 255, i32 255, i32 255, i32 255>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 255, i32 255, i32 255, i32 255>
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i8>
  ret <4 x i8> %conv6
}

define <4 x i8> @ustest_f32i8(<4 x float> %x) nounwind {
; SSE-LABEL: ustest_f32i8:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f32i8:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 255, i32 255, i32 255, i32 255>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 255, i32 255, i32 255, i32 255>
  %1 = icmp sgt <4 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> zeroinitializer
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i8>
  ret <4 x i8> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64(<2 x double> %x) nounwind {
; SSE-LABEL: stest_f64i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    cmpq %rsi, %rax
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rdx
; SSE-NEXT:    cmovgeq %rsi, %rax
; SSE-NEXT:    cmpq %rsi, %rbx
; SSE-NEXT:    movq %r14, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovlq %r14, %rcx
; SSE-NEXT:    cmovlq %rbx, %rsi
; SSE-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; SSE-NEXT:    cmpq %rsi, %rdi
; SSE-NEXT:    movq $-1, %r8
; SSE-NEXT:    movq $-1, %r9
; SSE-NEXT:    sbbq %rcx, %r9
; SSE-NEXT:    cmovgeq %rdi, %rsi
; SSE-NEXT:    cmpq %rax, %rdi
; SSE-NEXT:    sbbq %rdx, %r8
; SSE-NEXT:    cmovgeq %rdi, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rsi, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f64i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    callq __fixdfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __fixdfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX2-NEXT:    cmpq %rsi, %rax
; AVX2-NEXT:    movq %rdx, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovgeq %rcx, %rdx
; AVX2-NEXT:    cmovgeq %rsi, %rax
; AVX2-NEXT:    cmpq %rsi, %rbx
; AVX2-NEXT:    movq %r14, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovlq %r14, %rcx
; AVX2-NEXT:    cmovlq %rbx, %rsi
; AVX2-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX2-NEXT:    cmpq %rsi, %rdi
; AVX2-NEXT:    movq $-1, %r8
; AVX2-NEXT:    sbbq %rcx, %r8
; AVX2-NEXT:    movq $-1, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rsi
; AVX2-NEXT:    cmpq %rax, %rdi
; AVX2-NEXT:    sbbq %rdx, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rsi, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f64i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512-NEXT:    callq __fixdfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512-NEXT:    callq __fixdfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX512-NEXT:    cmpq %rsi, %rax
; AVX512-NEXT:    movq %rdx, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovgeq %rcx, %rdx
; AVX512-NEXT:    cmovgeq %rsi, %rax
; AVX512-NEXT:    cmpq %rsi, %rbx
; AVX512-NEXT:    movq %r14, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovlq %r14, %rcx
; AVX512-NEXT:    cmovlq %rbx, %rsi
; AVX512-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX512-NEXT:    cmpq %rsi, %rdi
; AVX512-NEXT:    movq $-1, %r8
; AVX512-NEXT:    movq $-1, %r9
; AVX512-NEXT:    sbbq %rcx, %r9
; AVX512-NEXT:    cmovgeq %rdi, %rsi
; AVX512-NEXT:    cmpq %rax, %rdi
; AVX512-NEXT:    sbbq %rdx, %r8
; AVX512-NEXT:    cmovgeq %rdi, %rax
; AVX512-NEXT:    vmovq %rax, %xmm0
; AVX512-NEXT:    vmovq %rsi, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64(<2 x double> %x) nounwind {
; SSE-LABEL: utest_f64i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    callq __fixunsdfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __fixunsdfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovneq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovneq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %xmm0
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: utest_f64i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    callq __fixunsdfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vpermilpd $1, (%rsp), %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = mem[1,0]
; AVX-NEXT:    callq __fixunsdfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovneq %rcx, %rax
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovneq %rcx, %rbx
; AVX-NEXT:    vmovq %rbx, %xmm0
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64(<2 x double> %x) nounwind {
; SSE-LABEL: ustest_f64i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    movl $1, %esi
; SSE-NEXT:    cmovgq %rsi, %rdx
; SSE-NEXT:    cmovgq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovleq %r14, %rsi
; SSE-NEXT:    cmovgq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %rdi
; SSE-NEXT:    negq %rdi
; SSE-NEXT:    movl $0, %edi
; SSE-NEXT:    sbbq %rsi, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rbx
; SSE-NEXT:    movq %rax, %rsi
; SSE-NEXT:    negq %rsi
; SSE-NEXT:    movl $0, %esi
; SSE-NEXT:    sbbq %rdx, %rsi
; SSE-NEXT:    cmovgeq %rcx, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rbx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f64i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX-NEXT:    callq __fixdfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    callq __fixdfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    movl $1, %esi
; AVX-NEXT:    cmovgq %rsi, %rdx
; AVX-NEXT:    cmovgq %rcx, %rax
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovleq %r14, %rsi
; AVX-NEXT:    cmovgq %rcx, %rbx
; AVX-NEXT:    movq %rbx, %rdi
; AVX-NEXT:    negq %rdi
; AVX-NEXT:    movl $0, %edi
; AVX-NEXT:    sbbq %rsi, %rdi
; AVX-NEXT:    cmovgeq %rcx, %rbx
; AVX-NEXT:    movq %rax, %rsi
; AVX-NEXT:    negq %rsi
; AVX-NEXT:    movl $0, %esi
; AVX-NEXT:    sbbq %rdx, %rsi
; AVX-NEXT:    cmovgeq %rcx, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vmovq %rbx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64(<2 x float> %x) nounwind {
; SSE-LABEL: stest_f32i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    cmpq %rsi, %rax
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rdx
; SSE-NEXT:    cmovgeq %rsi, %rax
; SSE-NEXT:    cmpq %rsi, %rbx
; SSE-NEXT:    movq %r14, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovlq %r14, %rcx
; SSE-NEXT:    cmovlq %rbx, %rsi
; SSE-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; SSE-NEXT:    cmpq %rsi, %rdi
; SSE-NEXT:    movq $-1, %r8
; SSE-NEXT:    movq $-1, %r9
; SSE-NEXT:    sbbq %rcx, %r9
; SSE-NEXT:    cmovgeq %rdi, %rsi
; SSE-NEXT:    cmpq %rax, %rdi
; SSE-NEXT:    sbbq %rdx, %r8
; SSE-NEXT:    cmovgeq %rdi, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rsi, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f32i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    callq __fixsfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __fixsfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX2-NEXT:    cmpq %rsi, %rax
; AVX2-NEXT:    movq %rdx, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovgeq %rcx, %rdx
; AVX2-NEXT:    cmovgeq %rsi, %rax
; AVX2-NEXT:    cmpq %rsi, %rbx
; AVX2-NEXT:    movq %r14, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovlq %r14, %rcx
; AVX2-NEXT:    cmovlq %rbx, %rsi
; AVX2-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX2-NEXT:    cmpq %rsi, %rdi
; AVX2-NEXT:    movq $-1, %r8
; AVX2-NEXT:    sbbq %rcx, %r8
; AVX2-NEXT:    movq $-1, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rsi
; AVX2-NEXT:    cmpq %rax, %rdi
; AVX2-NEXT:    sbbq %rdx, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rsi, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f32i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512-NEXT:    callq __fixsfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512-NEXT:    callq __fixsfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX512-NEXT:    cmpq %rsi, %rax
; AVX512-NEXT:    movq %rdx, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovgeq %rcx, %rdx
; AVX512-NEXT:    cmovgeq %rsi, %rax
; AVX512-NEXT:    cmpq %rsi, %rbx
; AVX512-NEXT:    movq %r14, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovlq %r14, %rcx
; AVX512-NEXT:    cmovlq %rbx, %rsi
; AVX512-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX512-NEXT:    cmpq %rsi, %rdi
; AVX512-NEXT:    movq $-1, %r8
; AVX512-NEXT:    movq $-1, %r9
; AVX512-NEXT:    sbbq %rcx, %r9
; AVX512-NEXT:    cmovgeq %rdi, %rsi
; AVX512-NEXT:    cmpq %rax, %rdi
; AVX512-NEXT:    sbbq %rdx, %r8
; AVX512-NEXT:    cmovgeq %rdi, %rax
; AVX512-NEXT:    vmovq %rax, %xmm0
; AVX512-NEXT:    vmovq %rsi, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64(<2 x float> %x) nounwind {
; SSE-LABEL: utest_f32i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    callq __fixunssfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __fixunssfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovneq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovneq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %xmm0
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: utest_f32i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    callq __fixunssfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovshdup (%rsp), %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = mem[1,1,3,3]
; AVX-NEXT:    callq __fixunssfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovneq %rcx, %rax
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovneq %rcx, %rbx
; AVX-NEXT:    vmovq %rbx, %xmm0
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64(<2 x float> %x) nounwind {
; SSE-LABEL: ustest_f32i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    movl $1, %esi
; SSE-NEXT:    cmovgq %rsi, %rdx
; SSE-NEXT:    cmovgq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovleq %r14, %rsi
; SSE-NEXT:    cmovgq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %rdi
; SSE-NEXT:    negq %rdi
; SSE-NEXT:    movl $0, %edi
; SSE-NEXT:    sbbq %rsi, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rbx
; SSE-NEXT:    movq %rax, %rsi
; SSE-NEXT:    negq %rsi
; SSE-NEXT:    movl $0, %esi
; SSE-NEXT:    sbbq %rdx, %rsi
; SSE-NEXT:    cmovgeq %rcx, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rbx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f32i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX-NEXT:    callq __fixsfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    callq __fixsfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    movl $1, %esi
; AVX-NEXT:    cmovgq %rsi, %rdx
; AVX-NEXT:    cmovgq %rcx, %rax
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovleq %r14, %rsi
; AVX-NEXT:    cmovgq %rcx, %rbx
; AVX-NEXT:    movq %rbx, %rdi
; AVX-NEXT:    negq %rdi
; AVX-NEXT:    movl $0, %edi
; AVX-NEXT:    sbbq %rsi, %rdi
; AVX-NEXT:    cmovgeq %rcx, %rbx
; AVX-NEXT:    movq %rax, %rsi
; AVX-NEXT:    negq %rsi
; AVX-NEXT:    movl $0, %esi
; AVX-NEXT:    sbbq %rdx, %rsi
; AVX-NEXT:    cmovgeq %rcx, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vmovq %rbx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64(<2 x half> %x) nounwind {
; SSE-LABEL: stest_f16i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    cmpq %rsi, %rax
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rdx
; SSE-NEXT:    cmovgeq %rsi, %rax
; SSE-NEXT:    cmpq %rsi, %rbx
; SSE-NEXT:    movq %r14, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovlq %r14, %rcx
; SSE-NEXT:    cmovlq %rbx, %rsi
; SSE-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; SSE-NEXT:    cmpq %rsi, %rdi
; SSE-NEXT:    movq $-1, %r8
; SSE-NEXT:    movq $-1, %r9
; SSE-NEXT:    sbbq %rcx, %r9
; SSE-NEXT:    cmovgeq %rdi, %rsi
; SSE-NEXT:    cmpq %rax, %rdi
; SSE-NEXT:    sbbq %rdx, %r8
; SSE-NEXT:    cmovgeq %rdi, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rsi, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f16i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    callq __fixhfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __fixhfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX2-NEXT:    cmpq %rsi, %rax
; AVX2-NEXT:    movq %rdx, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovgeq %rcx, %rdx
; AVX2-NEXT:    cmovgeq %rsi, %rax
; AVX2-NEXT:    cmpq %rsi, %rbx
; AVX2-NEXT:    movq %r14, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovlq %r14, %rcx
; AVX2-NEXT:    cmovlq %rbx, %rsi
; AVX2-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX2-NEXT:    cmpq %rsi, %rdi
; AVX2-NEXT:    movq $-1, %r8
; AVX2-NEXT:    sbbq %rcx, %r8
; AVX2-NEXT:    movq $-1, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rsi
; AVX2-NEXT:    cmpq %rax, %rdi
; AVX2-NEXT:    sbbq %rdx, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rsi, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f16i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX512-NEXT:    callq __fixhfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512-NEXT:    callq __fixhfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX512-NEXT:    cmpq %rsi, %rax
; AVX512-NEXT:    movq %rdx, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovgeq %rcx, %rdx
; AVX512-NEXT:    cmovgeq %rsi, %rax
; AVX512-NEXT:    cmpq %rsi, %rbx
; AVX512-NEXT:    movq %r14, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovlq %r14, %rcx
; AVX512-NEXT:    cmovlq %rbx, %rsi
; AVX512-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX512-NEXT:    cmpq %rsi, %rdi
; AVX512-NEXT:    movq $-1, %r8
; AVX512-NEXT:    movq $-1, %r9
; AVX512-NEXT:    sbbq %rcx, %r9
; AVX512-NEXT:    cmovgeq %rdi, %rsi
; AVX512-NEXT:    cmpq %rax, %rdi
; AVX512-NEXT:    sbbq %rdx, %r8
; AVX512-NEXT:    cmovgeq %rdi, %rax
; AVX512-NEXT:    vmovq %rax, %xmm0
; AVX512-NEXT:    vmovq %rsi, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64(<2 x half> %x) nounwind {
; SSE-LABEL: utesth_f16i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    callq __fixunshfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixunshfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovneq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovneq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %xmm0
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: utesth_f16i64:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    callq __fixunshfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovdqa (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    callq __fixunshfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    testq %rdx, %rdx
; AVX2-NEXT:    cmovneq %rcx, %rax
; AVX2-NEXT:    testq %r14, %r14
; AVX2-NEXT:    cmovneq %rcx, %rbx
; AVX2-NEXT:    vmovq %rbx, %xmm0
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utesth_f16i64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    callq __fixunshfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vpsrld $16, (%rsp), %xmm0 # 16-byte Folded Reload
; AVX512-NEXT:    callq __fixunshfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    testq %rdx, %rdx
; AVX512-NEXT:    cmovneq %rcx, %rax
; AVX512-NEXT:    testq %r14, %r14
; AVX512-NEXT:    cmovneq %rcx, %rbx
; AVX512-NEXT:    vmovq %rbx, %xmm0
; AVX512-NEXT:    vmovq %rax, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64(<2 x half> %x) nounwind {
; SSE-LABEL: ustest_f16i64:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    movl $1, %esi
; SSE-NEXT:    cmovgq %rsi, %rdx
; SSE-NEXT:    cmovgq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovleq %r14, %rsi
; SSE-NEXT:    cmovgq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %rdi
; SSE-NEXT:    negq %rdi
; SSE-NEXT:    movl $0, %edi
; SSE-NEXT:    sbbq %rsi, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rbx
; SSE-NEXT:    movq %rax, %rsi
; SSE-NEXT:    negq %rsi
; SSE-NEXT:    movl $0, %esi
; SSE-NEXT:    sbbq %rdx, %rsi
; SSE-NEXT:    cmovgeq %rcx, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rbx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f16i64:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    callq __fixhfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    callq __fixhfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    movl $1, %esi
; AVX-NEXT:    cmovgq %rsi, %rdx
; AVX-NEXT:    cmovgq %rcx, %rax
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovleq %r14, %rsi
; AVX-NEXT:    cmovgq %rcx, %rbx
; AVX-NEXT:    movq %rbx, %rdi
; AVX-NEXT:    negq %rdi
; AVX-NEXT:    movl $0, %edi
; AVX-NEXT:    sbbq %rsi, %rdi
; AVX-NEXT:    cmovgeq %rcx, %rbx
; AVX-NEXT:    movq %rax, %rsi
; AVX-NEXT:    negq %rsi
; AVX-NEXT:    movl $0, %esi
; AVX-NEXT:    sbbq %rdx, %rsi
; AVX-NEXT:    cmovgeq %rcx, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vmovq %rbx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}



; i32 saturate

define <2 x i32> @stest_f64i32_mm(<2 x double> %x) nounwind {
; SSE-LABEL: stest_f64i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4294967295,4294967295]
; SSE-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,2,2]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f64i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rcx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f64i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2qq %xmm0, %xmm0
; AVX512-NEXT:    vpmovsqd %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32_mm(<2 x double> %x) nounwind {
; SSE-LABEL: utest_f64i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; SSE-NEXT:    movapd %xmm0, %xmm2
; SSE-NEXT:    subsd %xmm1, %xmm2
; SSE-NEXT:    cvttsd2si %xmm2, %rax
; SSE-NEXT:    cvttsd2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    subsd %xmm1, %xmm0
; SSE-NEXT:    cvttsd2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,2]
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f64i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vmovsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vcvttsd2si %xmm2, %rax
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vsubsd %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttsd2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vcvttsd2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX2-NEXT:    vpcmpgtq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f64i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2uqq %xmm0, %xmm0
; AVX512-NEXT:    vpmovusqd %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.umin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32_mm(<2 x double> %x) nounwind {
; SSE-LABEL: ustest_f64i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttsd2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [2147483647,2147483647]
; SSE-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f64i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvttsd2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4294967295,4294967295]
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f64i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2qq %xmm0, %xmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovusqd %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> zeroinitializer)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32_mm(<4 x float> %x) nounwind {
; SSE-LABEL: stest_f32i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    cvttss2si %xmm2, %rax
; SSE-NEXT:    movq %rax, %xmm2
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm5, %xmm5
; SSE-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [4294967295,4294967295]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pcmpgtd %xmm1, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147483647,2147483647]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm5, %xmm7
; SSE-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,0,2,2]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [18446744069414584320,18446744069414584320]
; SSE-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[0,0,2,2]
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [18446744071562067968,18446744071562067968]
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,0,2,2]
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f32i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f32i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512-NEXT:    vpmovsqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32_mm(<4 x float> %x) nounwind {
; SSE-LABEL: utest_f32i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movss {{.*#+}} xmm2 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    subss %xmm2, %xmm1
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rcx, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rax, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    movq %rdx, %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm2, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm3, %rax
; SSE-NEXT:    subss %xmm2, %xmm3
; SSE-NEXT:    cvttss2si %xmm3, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm3
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss %xmm2, %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,0,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [2147483647,2147483647,2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,0,2,2]
; SSE-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm0, %xmm4
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f32i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX2-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm2
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm3
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm4, %rax
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372041149743102,9223372041149743102,9223372041149743102,9223372041149743102]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f32i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2uqq %xmm0, %ymm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32_mm(<4 x float> %x) nounwind {
; SSE-LABEL: ustest_f32i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm0[3,3]
; SSE-NEXT:    cvttss2si %xmm1, %rax
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    cvttss2si %xmm2, %rax
; SSE-NEXT:    movq %rax, %xmm2
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm5, %xmm5
; SSE-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pcmpgtd %xmm1, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm8, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [4294967295,4294967295]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm3[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm5, %xmm7
; SSE-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,0,2,2]
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f32i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f32i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32_mm(<4 x half> %x) nounwind {
; SSE-LABEL: stest_f16i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm3, %xmm3
; SSE-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [4294967295,4294967295]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [2147483647,2147483647]
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    pxor %xmm0, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,0,2,2]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm5, %xmm5
; SSE-NEXT:    pcmpeqd %xmm5, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [18446744069414584320,18446744069414584320]
; SSE-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[0,0,2,2]
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [18446744071562067968,18446744071562067968]
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm5, %xmm4
; SSE-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f16i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX2-NEXT:    vpextrw $0, %xmm1, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpextrw $0, %xmm2, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm1
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [2147483647,2147483647,2147483647,2147483647]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [18446744071562067968,18446744071562067968,18446744071562067968,18446744071562067968]
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f16i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512-NEXT:    vpmovsqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32_mm(<4 x half> %x) nounwind {
; SSE-LABEL: utesth_f16i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttss2si %xmm0, %rcx
; SSE-NEXT:    movq %rax, %rdx
; SSE-NEXT:    sarq $63, %rdx
; SSE-NEXT:    andq %rcx, %rdx
; SSE-NEXT:    orq %rax, %rdx
; SSE-NEXT:    movq %rdx, %xmm0
; SSE-NEXT:    punpcklqdq (%rsp), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,2,2]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147483647,2147483647,2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm0, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: utesth_f16i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX2-NEXT:    vpextrw $0, %xmm1, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm2
; AVX2-NEXT:    vmovss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpextrw $0, %xmm2, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vsubss %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vcvttss2si %xmm3, %rax
; AVX2-NEXT:    vcvttss2si %xmm2, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm2
; AVX2-NEXT:    vpextrw $0, %xmm0, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm3
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    vsubss %xmm1, %xmm3, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm4, %rax
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm4
; AVX2-NEXT:    vcvttss2si %xmm3, %rcx
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm4[0],xmm2[0]
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vcvttss2si %xmm0, %rcx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    movq %rcx, %rdx
; AVX2-NEXT:    sarq $63, %rdx
; AVX2-NEXT:    andq %rax, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372041149743102,9223372041149743102,9223372041149743102,9223372041149743102]
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utesth_f16i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32_mm(<4 x half> %x) nounwind {
; SSE-LABEL: ustest_f16i32_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movdqa (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE-NEXT:    pxor %xmm3, %xmm3
; SSE-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147483647,2147483647]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [4294967295,4294967295]
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    pxor %xmm0, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[1,1,3,3]
; SSE-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,0,2,2]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm3[0,2]
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f16i32_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX2-NEXT:    vpextrw $0, %xmm1, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vcvttss2si %xmm1, %rax
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpextrw $0, %xmm2, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vcvttss2si %xmm2, %rax
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vcvttss2si %xmm0, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,2,4,6,0,2,4,6]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f16i32_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovusqd %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16_mm(<2 x double> %x) nounwind {
; SSE-LABEL: stest_f64i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: stest_f64i16_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16_mm(<2 x double> %x) nounwind {
; SSE-LABEL: utest_f64i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    addpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    andpd %xmm2, %xmm0
; SSE-NEXT:    orpd %xmm1, %xmm0
; SSE-NEXT:    movapd {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    xorpd %xmm0, %xmm1
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f64i16_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvttpd2dq %xmm0, %xmm1
; AVX2-NEXT:    vaddpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm1, %xmm2
; AVX2-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX2-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vorpd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f64i16_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttpd2udq %xmm0, %xmm0
; AVX512-NEXT:    vpminud {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vpmovdw %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.umin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16_mm(<2 x double> %x) nounwind {
; SSE-LABEL: ustest_f64i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttpd2dq %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,u,u]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f64i16_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> zeroinitializer)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16_mm(<4 x float> %x) nounwind {
; SSE-LABEL: stest_f32i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: stest_f32i16_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16_mm(<4 x float> %x) nounwind {
; SSE-LABEL: utest_f32i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    pxor %xmm0, %xmm1
; SSE-NEXT:    pcmpgtd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX2-LABEL: utest_f32i16_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm1, %xmm1
; AVX2-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm2
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utest_f32i16_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttps2udq %xmm0, %xmm0
; AVX512-NEXT:    vpmovusdw %xmm0, %xmm0
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.umin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16_mm(<4 x float> %x) nounwind {
; SSE-LABEL: ustest_f32i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f32i16_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> zeroinitializer)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16_mm(<8 x half> %x) nounwind {
; SSE-LABEL: stest_f16i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    cvttps2dq %xmm1, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    packssdw {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f16i16_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f16i16_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512-NEXT:    vpmovsdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16_mm(<8 x half> %x) nounwind {
; SSE-LABEL: utesth_f16i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    psrad $31, %xmm2
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    cvttps2dq %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrad $31, %xmm1
; SSE-NEXT:    subps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSE-NEXT:    cvttps2dq %xmm2, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[0],mem[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147549183,2147549183,2147549183,2147549183]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pcmpgtd %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pxor %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pslld $16, %xmm4
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm4, %xmm0
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: utesth_f16i16_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vcvttps2dq %ymm1, %ymm1
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utesth_f16i16_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2udq %ymm0, %ymm0
; AVX512-NEXT:    vpmovusdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.umin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16_mm(<8 x half> %x) nounwind {
; SSE-LABEL: ustest_f16i16_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    cvttps2dq %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __extendhfsf2@PLT
; SSE-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE-NEXT:    punpcklqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtd %xmm1, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pslld $16, %xmm3
; SSE-NEXT:    psrad $16, %xmm3
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm3, %xmm0
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX2-LABEL: ustest_f16i16_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX2-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ustest_f16i16_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvtph2ps %xmm0, %ymm0
; AVX512-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovusdw %ymm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> zeroinitializer)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64_mm(<2 x double> %x) nounwind {
; SSE-LABEL: stest_f64i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    cmpq %rsi, %rax
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rdx
; SSE-NEXT:    cmovgeq %rsi, %rax
; SSE-NEXT:    cmpq %rsi, %rbx
; SSE-NEXT:    movq %r14, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovlq %r14, %rcx
; SSE-NEXT:    cmovlq %rbx, %rsi
; SSE-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; SSE-NEXT:    cmpq %rsi, %rdi
; SSE-NEXT:    movq $-1, %r8
; SSE-NEXT:    movq $-1, %r9
; SSE-NEXT:    sbbq %rcx, %r9
; SSE-NEXT:    cmovgeq %rdi, %rsi
; SSE-NEXT:    cmpq %rax, %rdi
; SSE-NEXT:    sbbq %rdx, %r8
; SSE-NEXT:    cmovgeq %rdi, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rsi, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f64i64_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    callq __fixdfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __fixdfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX2-NEXT:    cmpq %rsi, %rax
; AVX2-NEXT:    movq %rdx, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovgeq %rcx, %rdx
; AVX2-NEXT:    cmovgeq %rsi, %rax
; AVX2-NEXT:    cmpq %rsi, %rbx
; AVX2-NEXT:    movq %r14, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovlq %r14, %rcx
; AVX2-NEXT:    cmovlq %rbx, %rsi
; AVX2-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX2-NEXT:    cmpq %rsi, %rdi
; AVX2-NEXT:    movq $-1, %r8
; AVX2-NEXT:    sbbq %rcx, %r8
; AVX2-NEXT:    movq $-1, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rsi
; AVX2-NEXT:    cmpq %rax, %rdi
; AVX2-NEXT:    sbbq %rdx, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rsi, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f64i64_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512-NEXT:    callq __fixdfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512-NEXT:    callq __fixdfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX512-NEXT:    cmpq %rsi, %rax
; AVX512-NEXT:    movq %rdx, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovgeq %rcx, %rdx
; AVX512-NEXT:    cmovgeq %rsi, %rax
; AVX512-NEXT:    cmpq %rsi, %rbx
; AVX512-NEXT:    movq %r14, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovlq %r14, %rcx
; AVX512-NEXT:    cmovlq %rbx, %rsi
; AVX512-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX512-NEXT:    cmpq %rsi, %rdi
; AVX512-NEXT:    movq $-1, %r8
; AVX512-NEXT:    movq $-1, %r9
; AVX512-NEXT:    sbbq %rcx, %r9
; AVX512-NEXT:    cmovgeq %rdi, %rsi
; AVX512-NEXT:    cmpq %rax, %rdi
; AVX512-NEXT:    sbbq %rdx, %r8
; AVX512-NEXT:    cmovgeq %rdi, %rax
; AVX512-NEXT:    vmovq %rax, %xmm0
; AVX512-NEXT:    vmovq %rsi, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64_mm(<2 x double> %x) nounwind {
; SSE-LABEL: utest_f64i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    callq __fixunsdfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __fixunsdfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovneq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovneq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %xmm0
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: utest_f64i64_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    callq __fixunsdfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vpermilpd $1, (%rsp), %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = mem[1,0]
; AVX-NEXT:    callq __fixunsdfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovneq %rcx, %rax
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovneq %rcx, %rbx
; AVX-NEXT:    vmovq %rbx, %xmm0
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64_mm(<2 x double> %x) nounwind {
; SSE-LABEL: ustest_f64i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixdfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovgq %rcx, %rax
; SSE-NEXT:    movl $1, %esi
; SSE-NEXT:    cmovgq %rsi, %rdx
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovgq %rcx, %rbx
; SSE-NEXT:    cmovleq %r14, %rsi
; SSE-NEXT:    testq %rsi, %rsi
; SSE-NEXT:    cmovsq %rcx, %rbx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovsq %rcx, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rbx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f64i64_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX-NEXT:    callq __fixdfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    callq __fixdfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovgq %rcx, %rax
; AVX-NEXT:    movl $1, %esi
; AVX-NEXT:    cmovgq %rsi, %rdx
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovgq %rcx, %rbx
; AVX-NEXT:    cmovleq %r14, %rsi
; AVX-NEXT:    testq %rsi, %rsi
; AVX-NEXT:    cmovsq %rcx, %rbx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovsq %rcx, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vmovq %rbx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64_mm(<2 x float> %x) nounwind {
; SSE-LABEL: stest_f32i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    cmpq %rsi, %rax
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rdx
; SSE-NEXT:    cmovgeq %rsi, %rax
; SSE-NEXT:    cmpq %rsi, %rbx
; SSE-NEXT:    movq %r14, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovlq %r14, %rcx
; SSE-NEXT:    cmovlq %rbx, %rsi
; SSE-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; SSE-NEXT:    cmpq %rsi, %rdi
; SSE-NEXT:    movq $-1, %r8
; SSE-NEXT:    movq $-1, %r9
; SSE-NEXT:    sbbq %rcx, %r9
; SSE-NEXT:    cmovgeq %rdi, %rsi
; SSE-NEXT:    cmpq %rax, %rdi
; SSE-NEXT:    sbbq %rdx, %r8
; SSE-NEXT:    cmovgeq %rdi, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rsi, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f32i64_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    callq __fixsfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __fixsfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX2-NEXT:    cmpq %rsi, %rax
; AVX2-NEXT:    movq %rdx, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovgeq %rcx, %rdx
; AVX2-NEXT:    cmovgeq %rsi, %rax
; AVX2-NEXT:    cmpq %rsi, %rbx
; AVX2-NEXT:    movq %r14, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovlq %r14, %rcx
; AVX2-NEXT:    cmovlq %rbx, %rsi
; AVX2-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX2-NEXT:    cmpq %rsi, %rdi
; AVX2-NEXT:    movq $-1, %r8
; AVX2-NEXT:    sbbq %rcx, %r8
; AVX2-NEXT:    movq $-1, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rsi
; AVX2-NEXT:    cmpq %rax, %rdi
; AVX2-NEXT:    sbbq %rdx, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rsi, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f32i64_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512-NEXT:    callq __fixsfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512-NEXT:    callq __fixsfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX512-NEXT:    cmpq %rsi, %rax
; AVX512-NEXT:    movq %rdx, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovgeq %rcx, %rdx
; AVX512-NEXT:    cmovgeq %rsi, %rax
; AVX512-NEXT:    cmpq %rsi, %rbx
; AVX512-NEXT:    movq %r14, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovlq %r14, %rcx
; AVX512-NEXT:    cmovlq %rbx, %rsi
; AVX512-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX512-NEXT:    cmpq %rsi, %rdi
; AVX512-NEXT:    movq $-1, %r8
; AVX512-NEXT:    movq $-1, %r9
; AVX512-NEXT:    sbbq %rcx, %r9
; AVX512-NEXT:    cmovgeq %rdi, %rsi
; AVX512-NEXT:    cmpq %rax, %rdi
; AVX512-NEXT:    sbbq %rdx, %r8
; AVX512-NEXT:    cmovgeq %rdi, %rax
; AVX512-NEXT:    vmovq %rax, %xmm0
; AVX512-NEXT:    vmovq %rsi, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64_mm(<2 x float> %x) nounwind {
; SSE-LABEL: utest_f32i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    callq __fixunssfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __fixunssfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovneq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovneq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %xmm0
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: utest_f32i64_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    callq __fixunssfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovshdup (%rsp), %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = mem[1,1,3,3]
; AVX-NEXT:    callq __fixunssfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovneq %rcx, %rax
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovneq %rcx, %rbx
; AVX-NEXT:    vmovq %rbx, %xmm0
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64_mm(<2 x float> %x) nounwind {
; SSE-LABEL: ustest_f32i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixsfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovgq %rcx, %rax
; SSE-NEXT:    movl $1, %esi
; SSE-NEXT:    cmovgq %rsi, %rdx
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovgq %rcx, %rbx
; SSE-NEXT:    cmovleq %r14, %rsi
; SSE-NEXT:    testq %rsi, %rsi
; SSE-NEXT:    cmovsq %rcx, %rbx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovsq %rcx, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rbx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f32i64_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX-NEXT:    callq __fixsfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    callq __fixsfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovgq %rcx, %rax
; AVX-NEXT:    movl $1, %esi
; AVX-NEXT:    cmovgq %rsi, %rdx
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovgq %rcx, %rbx
; AVX-NEXT:    cmovleq %r14, %rsi
; AVX-NEXT:    testq %rsi, %rsi
; AVX-NEXT:    cmovsq %rcx, %rbx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovsq %rcx, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vmovq %rbx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64_mm(<2 x half> %x) nounwind {
; SSE-LABEL: stest_f16i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    cmpq %rsi, %rax
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovgeq %rcx, %rdx
; SSE-NEXT:    cmovgeq %rsi, %rax
; SSE-NEXT:    cmpq %rsi, %rbx
; SSE-NEXT:    movq %r14, %rdi
; SSE-NEXT:    sbbq $0, %rdi
; SSE-NEXT:    cmovlq %r14, %rcx
; SSE-NEXT:    cmovlq %rbx, %rsi
; SSE-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; SSE-NEXT:    cmpq %rsi, %rdi
; SSE-NEXT:    movq $-1, %r8
; SSE-NEXT:    movq $-1, %r9
; SSE-NEXT:    sbbq %rcx, %r9
; SSE-NEXT:    cmovgeq %rdi, %rsi
; SSE-NEXT:    cmpq %rax, %rdi
; SSE-NEXT:    sbbq %rdx, %r8
; SSE-NEXT:    cmovgeq %rdi, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rsi, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: stest_f16i64_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    callq __fixhfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __fixhfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX2-NEXT:    cmpq %rsi, %rax
; AVX2-NEXT:    movq %rdx, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovgeq %rcx, %rdx
; AVX2-NEXT:    cmovgeq %rsi, %rax
; AVX2-NEXT:    cmpq %rsi, %rbx
; AVX2-NEXT:    movq %r14, %rdi
; AVX2-NEXT:    sbbq $0, %rdi
; AVX2-NEXT:    cmovlq %r14, %rcx
; AVX2-NEXT:    cmovlq %rbx, %rsi
; AVX2-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX2-NEXT:    cmpq %rsi, %rdi
; AVX2-NEXT:    movq $-1, %r8
; AVX2-NEXT:    sbbq %rcx, %r8
; AVX2-NEXT:    movq $-1, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rsi
; AVX2-NEXT:    cmpq %rax, %rdi
; AVX2-NEXT:    sbbq %rdx, %rcx
; AVX2-NEXT:    cmovgeq %rdi, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %rsi, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: stest_f16i64_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX512-NEXT:    callq __fixhfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512-NEXT:    callq __fixhfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; AVX512-NEXT:    cmpq %rsi, %rax
; AVX512-NEXT:    movq %rdx, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovgeq %rcx, %rdx
; AVX512-NEXT:    cmovgeq %rsi, %rax
; AVX512-NEXT:    cmpq %rsi, %rbx
; AVX512-NEXT:    movq %r14, %rdi
; AVX512-NEXT:    sbbq $0, %rdi
; AVX512-NEXT:    cmovlq %r14, %rcx
; AVX512-NEXT:    cmovlq %rbx, %rsi
; AVX512-NEXT:    movabsq $-9223372036854775808, %rdi # imm = 0x8000000000000000
; AVX512-NEXT:    cmpq %rsi, %rdi
; AVX512-NEXT:    movq $-1, %r8
; AVX512-NEXT:    movq $-1, %r9
; AVX512-NEXT:    sbbq %rcx, %r9
; AVX512-NEXT:    cmovgeq %rdi, %rsi
; AVX512-NEXT:    cmpq %rax, %rdi
; AVX512-NEXT:    sbbq %rdx, %r8
; AVX512-NEXT:    cmovgeq %rdi, %rax
; AVX512-NEXT:    vmovq %rax, %xmm0
; AVX512-NEXT:    vmovq %rsi, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64_mm(<2 x half> %x) nounwind {
; SSE-LABEL: utesth_f16i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    callq __fixunshfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixunshfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovneq %rcx, %rax
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovneq %rcx, %rbx
; SSE-NEXT:    movq %rbx, %xmm0
; SSE-NEXT:    movq %rax, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX2-LABEL: utesth_f16i64_mm:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $24, %rsp
; AVX2-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    callq __fixunshfti@PLT
; AVX2-NEXT:    movq %rax, %rbx
; AVX2-NEXT:    movq %rdx, %r14
; AVX2-NEXT:    vmovdqa (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    callq __fixunshfti@PLT
; AVX2-NEXT:    xorl %ecx, %ecx
; AVX2-NEXT:    testq %rdx, %rdx
; AVX2-NEXT:    cmovneq %rcx, %rax
; AVX2-NEXT:    testq %r14, %r14
; AVX2-NEXT:    cmovneq %rcx, %rbx
; AVX2-NEXT:    vmovq %rbx, %xmm0
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    addq $24, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512-LABEL: utesth_f16i64_mm:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    subq $24, %rsp
; AVX512-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512-NEXT:    callq __fixunshfti@PLT
; AVX512-NEXT:    movq %rax, %rbx
; AVX512-NEXT:    movq %rdx, %r14
; AVX512-NEXT:    vpsrld $16, (%rsp), %xmm0 # 16-byte Folded Reload
; AVX512-NEXT:    callq __fixunshfti@PLT
; AVX512-NEXT:    xorl %ecx, %ecx
; AVX512-NEXT:    testq %rdx, %rdx
; AVX512-NEXT:    cmovneq %rcx, %rax
; AVX512-NEXT:    testq %r14, %r14
; AVX512-NEXT:    cmovneq %rcx, %rbx
; AVX512-NEXT:    vmovq %rbx, %xmm0
; AVX512-NEXT:    vmovq %rax, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    addq $24, %rsp
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    retq
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64_mm(<2 x half> %x) nounwind {
; SSE-LABEL: ustest_f16i64_mm:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    movq %rax, %rbx
; SSE-NEXT:    movq %rdx, %r14
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    callq __fixhfti@PLT
; SSE-NEXT:    xorl %ecx, %ecx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovgq %rcx, %rax
; SSE-NEXT:    movl $1, %esi
; SSE-NEXT:    cmovgq %rsi, %rdx
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    cmovgq %rcx, %rbx
; SSE-NEXT:    cmovleq %r14, %rsi
; SSE-NEXT:    testq %rsi, %rsi
; SSE-NEXT:    cmovsq %rcx, %rbx
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    cmovsq %rcx, %rax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    movq %rbx, %xmm1
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r14
; SSE-NEXT:    retq
;
; AVX-LABEL: ustest_f16i64_mm:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    callq __fixhfti@PLT
; AVX-NEXT:    movq %rax, %rbx
; AVX-NEXT:    movq %rdx, %r14
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    callq __fixhfti@PLT
; AVX-NEXT:    xorl %ecx, %ecx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovgq %rcx, %rax
; AVX-NEXT:    movl $1, %esi
; AVX-NEXT:    cmovgq %rsi, %rdx
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    cmovgq %rcx, %rbx
; AVX-NEXT:    cmovleq %r14, %rsi
; AVX-NEXT:    testq %rsi, %rsi
; AVX-NEXT:    cmovsq %rcx, %rbx
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    cmovsq %rcx, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vmovq %rbx, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r14
; AVX-NEXT:    retq
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

declare <2 x i32> @llvm.smin.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.smax.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.umin.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
declare <2 x i128> @llvm.smin.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.smax.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.umin.v2i128(<2 x i128>, <2 x i128>)
