; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=riscv32 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32d | FileCheck -check-prefix=RV32ID %s
; RUN: llc -mtriple=riscv64 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d | FileCheck -check-prefix=RV64ID %s

; A GPR<->FPR move (fmv.?.?) is unnecessary in all of the tests below, as in
; the value can be loaded/stored directly from/to the stack.

define float @spill_i32_to_float(i32 %a) nounwind {
; RV32ID-LABEL: spill_i32_to_float:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -160
; RV32ID-NEXT:    sw ra, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 120(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 116(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 112(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 108(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fmv.w.x fa5, a0
; RV32ID-NEXT:    fsw fa5, 4(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    flw fa0, 4(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw ra, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 120(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 116(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 112(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 108(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 160
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: spill_i32_to_float:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fmv.w.x fa5, a0
; RV64ID-NEXT:    fsw fa5, 4(sp) # 4-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    flw fa0, 4(sp) # 4-byte Folded Reload
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  %1 = bitcast i32 %a to float
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  ret float %1
}

define i32 @spill_float_to_i32(float %a) nounwind {
; RV32ID-LABEL: spill_float_to_i32:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -160
; RV32ID-NEXT:    sw ra, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 120(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 116(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 112(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 108(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fmv.x.w a0, fa0
; RV32ID-NEXT:    sw a0, 4(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw ra, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 120(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 116(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 112(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 108(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 160
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: spill_float_to_i32:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fmv.x.w a0, fa0
; RV64ID-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  %1 = bitcast float %a to i32
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  ret i32 %1
}

define double @spill_i64_to_double(i64 %a) nounwind {
; RV32ID-LABEL: spill_i64_to_double:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -176
; RV32ID-NEXT:    sw ra, 172(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 168(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 164(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 160(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 112(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 104(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    sw a1, 20(sp)
; RV32ID-NEXT:    sw a0, 16(sp)
; RV32ID-NEXT:    fld fa5, 16(sp)
; RV32ID-NEXT:    fsd fa5, 8(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    fld fa0, 8(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    lw ra, 172(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 168(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 164(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 160(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 112(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 104(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 176
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: spill_i64_to_double:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fmv.d.x fa5, a0
; RV64ID-NEXT:    fsd fa5, 0(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    fld fa0, 0(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  %1 = bitcast i64 %a to double
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  ret double %1
}

define i64 @spill_double_to_i64(double %a) nounwind {
; RV32ID-LABEL: spill_double_to_i64:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -176
; RV32ID-NEXT:    sw ra, 172(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 168(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 164(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 160(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 112(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 104(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fa0, 16(sp)
; RV32ID-NEXT:    lw a0, 16(sp)
; RV32ID-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    lw a0, 20(sp)
; RV32ID-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw a1, 8(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw ra, 172(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 168(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 164(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 160(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 112(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 104(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 176
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: spill_double_to_i64:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fmv.x.d a0, fa0
; RV64ID-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  %1 = bitcast double %a to i64
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  ret i64 %1
}

define float @fill_i32_to_float(i32 %a) nounwind {
; RV32ID-LABEL: fill_i32_to_float:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -160
; RV32ID-NEXT:    sw ra, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 120(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 116(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 112(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 108(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    sw a0, 4(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fmv.w.x fa0, a0
; RV32ID-NEXT:    lw ra, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 120(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 116(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 112(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 108(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 160
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: fill_i32_to_float:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fmv.w.x fa0, a0
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  %1 = bitcast i32 %a to float
  ret float %1
}

define i32 @fill_float_to_i32(float %a) nounwind {
; RV32ID-LABEL: fill_float_to_i32:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -160
; RV32ID-NEXT:    sw ra, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 120(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 116(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 112(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 108(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsw fa0, 4(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    flw fa5, 4(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fmv.x.w a0, fa5
; RV32ID-NEXT:    lw ra, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 120(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 116(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 112(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 108(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 160
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: fill_float_to_i32:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsw fa0, 4(sp) # 4-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    flw fa5, 4(sp) # 4-byte Folded Reload
; RV64ID-NEXT:    fmv.x.w a0, fa5
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  %1 = bitcast float %a to i32
  ret i32 %1
}

define double @fill_i64_to_double(i64 %a) nounwind {
; RV32ID-LABEL: fill_i64_to_double:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -176
; RV32ID-NEXT:    sw ra, 172(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 168(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 164(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 160(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 112(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 104(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    sw a1, 20(sp)
; RV32ID-NEXT:    sw a0, 16(sp)
; RV32ID-NEXT:    fld fa5, 16(sp)
; RV32ID-NEXT:    fsd fa5, 8(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    fld fa0, 8(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    lw ra, 172(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 168(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 164(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 160(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 112(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 104(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 176
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: fill_i64_to_double:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fmv.d.x fa0, a0
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  %1 = bitcast i64 %a to double
  ret double %1
}

define i64 @fill_double_to_i64(double %a) nounwind {
; RV32ID-LABEL: fill_double_to_i64:
; RV32ID:       # %bb.0:
; RV32ID-NEXT:    addi sp, sp, -176
; RV32ID-NEXT:    sw ra, 172(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s0, 168(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s1, 164(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s2, 160(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s3, 156(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s4, 152(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s5, 148(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s6, 144(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s7, 140(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s8, 136(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s9, 132(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s10, 128(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    sw s11, 124(sp) # 4-byte Folded Spill
; RV32ID-NEXT:    fsd fs0, 112(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs1, 104(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs2, 96(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs3, 88(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs4, 80(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs5, 72(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs6, 64(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs7, 56(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs8, 48(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs9, 40(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs10, 32(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fs11, 24(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    fsd fa0, 8(sp) # 8-byte Folded Spill
; RV32ID-NEXT:    #APP
; RV32ID-NEXT:    #NO_APP
; RV32ID-NEXT:    fld fa5, 8(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fsd fa5, 16(sp)
; RV32ID-NEXT:    lw a0, 16(sp)
; RV32ID-NEXT:    lw a1, 20(sp)
; RV32ID-NEXT:    lw ra, 172(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s0, 168(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s1, 164(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s2, 160(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s3, 156(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s4, 152(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s5, 148(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s6, 144(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s7, 140(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s8, 136(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s9, 132(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s10, 128(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    lw s11, 124(sp) # 4-byte Folded Reload
; RV32ID-NEXT:    fld fs0, 112(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs1, 104(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs2, 96(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs3, 88(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs4, 80(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs5, 72(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs6, 64(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs7, 56(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs8, 48(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs9, 40(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs10, 32(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    fld fs11, 24(sp) # 8-byte Folded Reload
; RV32ID-NEXT:    addi sp, sp, 176
; RV32ID-NEXT:    ret
;
; RV64ID-LABEL: fill_double_to_i64:
; RV64ID:       # %bb.0:
; RV64ID-NEXT:    addi sp, sp, -208
; RV64ID-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s0, 192(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s1, 184(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s2, 176(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s3, 168(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s4, 160(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s5, 152(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s6, 144(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s7, 136(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s8, 128(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s9, 120(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s10, 112(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    sd s11, 104(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs0, 96(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs1, 88(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs2, 80(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs3, 72(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs4, 64(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs5, 56(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs6, 48(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs7, 40(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs8, 32(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs9, 24(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs10, 16(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fs11, 8(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    fsd fa0, 0(sp) # 8-byte Folded Spill
; RV64ID-NEXT:    #APP
; RV64ID-NEXT:    #NO_APP
; RV64ID-NEXT:    fld fa5, 0(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fmv.x.d a0, fa5
; RV64ID-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s0, 192(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s1, 184(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s2, 176(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s3, 168(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s4, 160(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s5, 152(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s6, 144(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s7, 136(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s8, 128(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s9, 120(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s10, 112(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    ld s11, 104(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs0, 96(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs1, 88(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs2, 80(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs3, 72(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs4, 64(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs5, 56(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs6, 48(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs7, 40(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs8, 32(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs9, 24(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs10, 16(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    fld fs11, 8(sp) # 8-byte Folded Reload
; RV64ID-NEXT:    addi sp, sp, 208
; RV64ID-NEXT:    ret
  call void asm sideeffect "", "~{x0},~{x1},~{x2},~{x3},~{x4},~{x5},~{x6},~{x7},~{x8},~{x9},~{x10},~{x11},~{x12},~{x13},~{x14},~{x15},~{x16},~{x17},~{x18},~{x19},~{x20},~{x21},~{x22},~{x23},~{x24},~{x25},~{x26},~{x27},~{x28},~{x29},~{x30},~{x31},~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"() nounwind
  %1 = bitcast double %a to i64
  ret i64 %1
}
