; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; FMAXNM
;

define <4 x half> @fmaxnm_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fmaxnm_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.maxnum.v4f16(<4 x half> %op1, <4 x half> %op2)
  ret <4 x half> %res
}

define <8 x half> @fmaxnm_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fmaxnm_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.maxnum.v8f16(<8 x half> %op1, <8 x half> %op2)
  ret <8 x half> %res
}

define void @fmaxnm_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fmaxnm_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmaxnm z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = call <16 x half> @llvm.maxnum.v16f16(<16 x half> %op1, <16 x half> %op2)
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fmaxnm_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fmaxnm_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.maxnum.v2f32(<2 x float> %op1, <2 x float> %op2)
  ret <2 x float> %res
}

define <4 x float> @fmaxnm_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fmaxnm_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.maxnum.v4f32(<4 x float> %op1, <4 x float> %op2)
  ret <4 x float> %res
}

define void @fmaxnm_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fmaxnm_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmaxnm z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = call <8 x float> @llvm.maxnum.v8f32(<8 x float> %op1, <8 x float> %op2)
  store <8 x float> %res, ptr %a
  ret void
}

define <1 x double> @fmaxnm_v1f64(<1 x double> %op1, <1 x double> %op2) {
; CHECK-LABEL: fmaxnm_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmaxnm d0, d0, d1
; CHECK-NEXT:    ret
  %res = call <1 x double> @llvm.maxnum.v1f64(<1 x double> %op1, <1 x double> %op2)
  ret <1 x double> %res
}

define <2 x double> @fmaxnm_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fmaxnm_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.maxnum.v2f64(<2 x double> %op1, <2 x double> %op2)
  ret <2 x double> %res
}

define void @fmaxnm_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fmaxnm_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmaxnm z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = call <4 x double> @llvm.maxnum.v4f64(<4 x double> %op1, <4 x double> %op2)
  store <4 x double> %res, ptr %a
  ret void
}

;
; FMINNM
;

define <4 x half> @fminnm_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fminnm_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.minnum.v4f16(<4 x half> %op1, <4 x half> %op2)
  ret <4 x half> %res
}

define <8 x half> @fminnm_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fminnm_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.minnum.v8f16(<8 x half> %op1, <8 x half> %op2)
  ret <8 x half> %res
}

define void @fminnm_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fminnm_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fminnm z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = call <16 x half> @llvm.minnum.v16f16(<16 x half> %op1, <16 x half> %op2)
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fminnm_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fminnm_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.minnum.v2f32(<2 x float> %op1, <2 x float> %op2)
  ret <2 x float> %res
}

define <4 x float> @fminnm_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fminnm_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.minnum.v4f32(<4 x float> %op1, <4 x float> %op2)
  ret <4 x float> %res
}

define void @fminnm_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fminnm_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fminnm z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = call <8 x float> @llvm.minnum.v8f32(<8 x float> %op1, <8 x float> %op2)
  store <8 x float> %res, ptr %a
  ret void
}

define <1 x double> @fminnm_v1f64(<1 x double> %op1, <1 x double> %op2) {
; CHECK-LABEL: fminnm_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fminnm d0, d0, d1
; CHECK-NEXT:    ret
  %res = call <1 x double> @llvm.minnum.v1f64(<1 x double> %op1, <1 x double> %op2)
  ret <1 x double> %res
}

define <2 x double> @fminnm_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fminnm_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.minnum.v2f64(<2 x double> %op1, <2 x double> %op2)
  ret <2 x double> %res
}

define void @fminnm_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fminnm_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fminnm z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = call <4 x double> @llvm.minnum.v4f64(<4 x double> %op1, <4 x double> %op2)
  store <4 x double> %res, ptr %a
  ret void
}

;
; FMAX
;

define <4 x half> @fmax_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fmax_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.maximum.v4f16(<4 x half> %op1, <4 x half> %op2)
  ret <4 x half> %res
}

define <8 x half> @fmax_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fmax_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.maximum.v8f16(<8 x half> %op1, <8 x half> %op2)
  ret <8 x half> %res
}

define void @fmax_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fmax_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmax z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = call <16 x half> @llvm.maximum.v16f16(<16 x half> %op1, <16 x half> %op2)
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fmax_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fmax_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.maximum.v2f32(<2 x float> %op1, <2 x float> %op2)
  ret <2 x float> %res
}

define <4 x float> @fmax_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fmax_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.maximum.v4f32(<4 x float> %op1, <4 x float> %op2)
  ret <4 x float> %res
}

define void @fmax_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fmax_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmax z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = call <8 x float> @llvm.maximum.v8f32(<8 x float> %op1, <8 x float> %op2)
  store <8 x float> %res, ptr %a
  ret void
}

define <1 x double> @fmax_v1f64(<1 x double> %op1, <1 x double> %op2) {
; CHECK-LABEL: fmax_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmax d0, d0, d1
; CHECK-NEXT:    ret
  %res = call <1 x double> @llvm.maximum.v1f64(<1 x double> %op1, <1 x double> %op2)
  ret <1 x double> %res
}

define <2 x double> @fmax_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fmax_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.maximum.v2f64(<2 x double> %op1, <2 x double> %op2)
  ret <2 x double> %res
}

define void @fmax_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fmax_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmax z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = call <4 x double> @llvm.maximum.v4f64(<4 x double> %op1, <4 x double> %op2)
  store <4 x double> %res, ptr %a
  ret void
}

;
; FMIN
;

define <4 x half> @fmin_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fmin_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.minimum.v4f16(<4 x half> %op1, <4 x half> %op2)
  ret <4 x half> %res
}

define <8 x half> @fmin_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fmin_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.minimum.v8f16(<8 x half> %op1, <8 x half> %op2)
  ret <8 x half> %res
}

define void @fmin_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fmin_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmin z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = call <16 x half> @llvm.minimum.v16f16(<16 x half> %op1, <16 x half> %op2)
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fmin_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fmin_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.minimum.v2f32(<2 x float> %op1, <2 x float> %op2)
  ret <2 x float> %res
}

define <4 x float> @fmin_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fmin_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.minimum.v4f32(<4 x float> %op1, <4 x float> %op2)
  ret <4 x float> %res
}

define void @fmin_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fmin_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmin z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = call <8 x float> @llvm.minimum.v8f32(<8 x float> %op1, <8 x float> %op2)
  store <8 x float> %res, ptr %a
  ret void
}

define <1 x double> @fmin_v1f64(<1 x double> %op1, <1 x double> %op2) {
; CHECK-LABEL: fmin_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmin d0, d0, d1
; CHECK-NEXT:    ret
  %res = call <1 x double> @llvm.minimum.v1f64(<1 x double> %op1, <1 x double> %op2)
  ret <1 x double> %res
}

define <2 x double> @fmin_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fmin_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.minimum.v2f64(<2 x double> %op1, <2 x double> %op2)
  ret <2 x double> %res
}

define void @fmin_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fmin_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fmin z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = call <4 x double> @llvm.minimum.v4f64(<4 x double> %op1, <4 x double> %op2)
  store <4 x double> %res, ptr %a
  ret void
}

declare <4 x half> @llvm.minnum.v4f16(<4 x half>, <4 x half>)
declare <8 x half> @llvm.minnum.v8f16(<8 x half>, <8 x half>)
declare <16 x half> @llvm.minnum.v16f16(<16 x half>, <16 x half>)
declare <2 x float> @llvm.minnum.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.minnum.v4f32(<4 x float>, <4 x float>)
declare <8 x float> @llvm.minnum.v8f32(<8 x float>, <8 x float>)
declare <1 x double> @llvm.minnum.v1f64(<1 x double>, <1 x double>)
declare <2 x double> @llvm.minnum.v2f64(<2 x double>, <2 x double>)
declare <4 x double> @llvm.minnum.v4f64(<4 x double>, <4 x double>)

declare <4 x half> @llvm.maxnum.v4f16(<4 x half>, <4 x half>)
declare <8 x half> @llvm.maxnum.v8f16(<8 x half>, <8 x half>)
declare <16 x half> @llvm.maxnum.v16f16(<16 x half>, <16 x half>)
declare <2 x float> @llvm.maxnum.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>)
declare <8 x float> @llvm.maxnum.v8f32(<8 x float>, <8 x float>)
declare <1 x double> @llvm.maxnum.v1f64(<1 x double>, <1 x double>)
declare <2 x double> @llvm.maxnum.v2f64(<2 x double>, <2 x double>)
declare <4 x double> @llvm.maxnum.v4f64(<4 x double>, <4 x double>)

declare <4 x half> @llvm.minimum.v4f16(<4 x half>, <4 x half>)
declare <8 x half> @llvm.minimum.v8f16(<8 x half>, <8 x half>)
declare <16 x half> @llvm.minimum.v16f16(<16 x half>, <16 x half>)
declare <2 x float> @llvm.minimum.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.minimum.v4f32(<4 x float>, <4 x float>)
declare <8 x float> @llvm.minimum.v8f32(<8 x float>, <8 x float>)
declare <1 x double> @llvm.minimum.v1f64(<1 x double>, <1 x double>)
declare <2 x double> @llvm.minimum.v2f64(<2 x double>, <2 x double>)
declare <4 x double> @llvm.minimum.v4f64(<4 x double>, <4 x double>)

declare <4 x half> @llvm.maximum.v4f16(<4 x half>, <4 x half>)
declare <8 x half> @llvm.maximum.v8f16(<8 x half>, <8 x half>)
declare <16 x half> @llvm.maximum.v16f16(<16 x half>, <16 x half>)
declare <2 x float> @llvm.maximum.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.maximum.v4f32(<4 x float>, <4 x float>)
declare <8 x float> @llvm.maximum.v8f32(<8 x float>, <8 x float>)
declare <1 x double> @llvm.maximum.v1f64(<1 x double>, <1 x double>)
declare <2 x double> @llvm.maximum.v2f64(<2 x double>, <2 x double>)
declare <4 x double> @llvm.maximum.v4f64(<4 x double>, <4 x double>)
