/*
 * Copyright (C) 2022 magicxqq <xqq@xqq.im>. All rights reserved.
 *
 * This file is part of libaribcaption.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "decoder/b24_drcs_conv.hpp"

namespace aribcaption {

// MD5 => UCS4, for common DRCS patterns
extern const std::unordered_map<std::string, uint32_t> kDRCSReplacementMap = {
    {"022b6f43e2a414fd68f172da202bac9a", 0x269e},
    {"94fb7be756372db6b62e3e0a119083d5", 0x269e},
    {"12aecdea283e4d07f88b9f2b740e4f86", 0x269f},
    {"1a563501affbf7f5baec350a108d5505", 0x269f},
    {"556971570f40044fa4520df3289a1cf2", 0x269f},
    {"65b042886a563a771aa389b12af7bca7", 0x269f},
    {"bbda644d17efd3c020635ee3d90968a5", 0xff5f},
    {"5063561406195ca45f5992e3f7ad77d2", 0xff5f},
    {"9d15c0395a4738936af34308acf2d032", 0xff5f},
    {"2a063edc4770b3403f060b38166a0d4d", 0xff5f},
    {"54479aa90145b4713134b78d4fb98aa5", 0xff5f},
    {"12a2c7156da32fc972b5a451bb87b813", 0xff5f},
    {"c8d428ead557285b0b7088388b22519c", 0xff5f},
    {"7160f7419cba7acdacd23cbeb4834dbe", 0xff5f},
    {"3c49616fb9bf0b9052b30e118f8857ea", 0xff5f},
    {"71c94bb6d963e47443eac448a09d22ce", 0xff5f},
    {"7ec2179107ba4c58abb6ef92e7781365", 0xff5f},
    {"2eb49bd25d7eeada006afc0864350da4", 0xff5f},
    {"a341ee7fe8a368c9737a3341f016ac70", 0xff5f},
    {"f47048d669ac8d84eeb62477e8420f89", 0xff5f},
    {"38566b372f4c5a1aead4efa20decd079", 0xff60},
    {"d84fc83615b75802ed422eda4ba39465", 0xff60},
    {"5bb8b7731d9473ebd7c842334dfa24f2", 0xff60},
    {"9ffa7e00cfc7e807a161ada460b8060c", 0xff60},
    {"a58dc0e1271b03a5981b57a83271afa7", 0xff60},
    {"e67210b0da0161d36b79e8c9be6a9d0c", 0xff60},
    {"08de4be9569ebd6ac01709f552ae8a65", 0xff60},
    {"e214599903c94c532684bdf54b62df61", 0xff60},
    {"2a83209f8a7489081890c277397df425", 0xff60},
    {"0294d50cea5197c8c4646d2cace3e78d", 0xff60},
    {"0b808509e4d89a2b9d02252ca85f2e34", 0xff60},
    {"2a74d4ad7292c858dc2bb559de67f2d9", 0xff60},
    {"8c810b8cbe6159e837a88575bb4e6033", 0xff60},
    {"dc66317cd6fff4f4221069a20f321fce", 0xff60},
    {"563e1633d226c10ef4ec80638997e4a9", 0x300e},
    {"0993d5cdf910f481eeefa19e4f09d77c", 0x300e},
    {"7b80a8345c16e2d4f8ff2691e245c2b1", 0x300e},
    {"016669fa94786f9581342d47f317c02c", 0x300e},
    {"01d3eb52ab29f0eecc62ff74224fffd4", 0x300e},
    {"089aa1d87915ef8ad3c43982ac657c8c", 0x300e},
    {"30e8cb69cda3ad84e87943c4351c24b7", 0x300e},
    {"385927959c2621acf57f8d40140924f8", 0x300e},
    {"2c256506f406bac4c214318f196ad5db", 0x300e},
    {"2d3912e10113e5c7bef33df3249af4a7", 0x300e},
    {"8b6444be18f269ac615643b26f9e3041", 0x300e},
    {"9c8c1ff659b439f73c65cf4766ab2f14", 0x300e},
    {"e4caa1628ad6878f14be986761e06aaa", 0x300e},
    {"e702912587801d73d58cdb30e48debed", 0x300f},
    {"d70bb2b097f44c1ddefb93bf92bbb5cd", 0x300f},
    {"f2b927267947a75b891403f95db72005", 0x300f},
    {"4ec38a1d8d22e4df6c359f00f7ad8662", 0x300f},
    {"55c9ea9aa8eb630e5ecb793b2f85c927", 0x300f},
    {"70376e1ea05a3438a19c062ad49a7960", 0x300f},
    {"8fe7cb78ca24d1973419eecf99252a88", 0x300f},
    {"9ee59c7d2c202e0214836a0138f59e24", 0x300f},
    {"b56aaf7fc68c5e206ccbc2ee1442b3af", 0x300f},
    {"ba37f6b56d8fc8980c8236de9894fa61", 0x300f},
    {"cc9fde9238a2bf78fd1c13f65b098e77", 0x300f},
    {"f02e3e84dcd71c5d3bab2b7b4b99bd7e", 0x300f},
    {"f686e0b742abe806fccbd4d9b3fcc4cd", 0x300f},
    {"37f6ecf37a0a3ef8dff083ccc8754f81", 0x266c},
    {"3336f18e849144658f212bd9399bec5f", 0x266c},
    {"93efdc18683d8ecacb0a920d5f2fffb3", 0x266c},
    {"9b8325b71aa6a000d24f88c4d7ec730d", 0x266c},
    {"ab791ef796e6b5d66f13ed9aea3e8ab2", 0x266c},
    {"6eb29f1917caea1cadf94f5496a4c374", 0x21b1},
    {"583134b86e7d90960f64c5b863196978", 0x27a1},
    {"4ba716a88c003ca0a069392be3b63951", 0x27a1},
    {"4e0fbe47e3ba0fd5949bda53f11b16a5", 0x27a1},
    {"61ec226a927ee80fffa12db219a43233", 0x27a1},
    {"8e5b873ac8e1bf84246b281b3548c2ff", 0x21b4},
    {"a78d9b65f46654601ce0145622164b47", 0x21b4},
    {"5d01e6804b9aaec0c276f77306888c54", 0x21b4},
    {"6168af1e81b6497fccb6b8d3226a8016", 0x21b4},
    {"4360c0b7364802b680f5a65fa415bdd6", 0x2197},
    {"4dab788480bb9ac50d2454b58438e407", 0x2197},
    {"bfb2d58ab8c469d2b8b5c42d81e4e3b7", 0x2197},
    {"4c503a0873195bfe8d71c9d55669781b", 0x2192},
    {"caf36eff2cf3580cd66c5cd021ee4c09", 0x2192},
    {"f00be20caf0aaef3a6fbec90a0e71852", 0x2160},
    {"e660e1e23a6ddc9a5d2e0e1ef7ac5b86", 0x2161},
    {"a62583f621fb5405add08e8f0beb6db4", 0x2161},
    {"0e761ebb18b9870383725b3712f5c8d4", 0x2161},
    {"1f65debfbf9df96de52c6f80922b012b", 0x2161},
    {"5c13facf2da9f38922a9419061771ed0", 0x2161},
    {"75a65cc3171c4c7ca0141042846ab91a", 0x2161},
    {"eae94a6301787ff7bf77786ae4424601", 0x2161},
    {"f1add7809e18e064e4609783211c9815", 0x2162},
    {"a7ee6f7f63d348e2b8fb7ee9503f3c5c", 0x2661},
    {"9c8cfb5e9349b06f0939605638896f4e", 0x2665},
    {"45ce7d6d5c779136d32d3e60e13e10cd", 0x2155},
    {"51f5fe58aaf460263b766e990fdbe979", 0x2155},
    {"db40b0a65939e462396822d5ab3c6d9c", 0x2155},
    {"d9e3a48d5a7c6ba6f8db18f56cf91f92", 0x215b},
    {"86586bcdf8f14883f846849e93ca274c", 0x215c},
    {"9d81f46e134081d56bc92f69eebfabd9", 0x2152},
    {"18dddb04a4fe9b3f5c7b79e68fb8ab4b", 0x2152},
    {"eff8659a150859b7b69682a023b283c1", 0x2152},
    {"6e5ccf08b2bc815b0923df83cf9fafa1", 0x33a0},
    {"8a77e56517a074d3d2ba426b84a07bf4", 0x33a0},
    {"2c381a0eab014487d50f6f8bae8f0b71", 0x33a2},
    {"9d1a36a1bec1cd2b0b0765f93c1e4f3c", 0x33a2},
    {"e03eb00c54de790d8cc9997527fde905", 0x33a2},
    {"3bce2a06a6a8557082543a6c90a42fe0", 0x303d},
    {"4898c7d9fe3a8a6f9859b0e6f85a4327", 0x303d},
    {"98ab18764756c8ca7608e17f562b21ce", 0x303d},
    {"3037aad230d8cdae3df6e0ebedc0db79", 0x2049},
    {"66e3474e6cbd8e817ba0a1f8920bf4e7", 0x2049},
    {"4360dd96063ce1a9660cc8437e8238e3", 0x2048},
    {"6ce68b7e389c5169309ee956ed0c98a8", 0x2048},
    {"737a19289d25d963e255f3692ded6536", 0x2048},
    {"14b18199bbc3f4bf65b72e316bc41d3c", 0xff01},
    {"6bf58c146b692aeb403ed1f7618a060a", 0xff01},
    {"7f12b67caaf7c8c5075b444bb2a16c70", 0xff01},
    {"bfd55f4031ad80cb7401d65937b1d5d9", 0x301c},
    {"4a61f6f7da9e6c8e373f4112cbd453cf", 0x301c},
    {"882ded8f0bb4cdfa4ce28a0b64056d2a", 0x301c},
    {"7726ffbf3a6e953affe6353c24ffb085", 0x301c},
    {"0e290ec6542b5d52c972775e3d7cfeaf", 0xff0d},
    {"420f1d27972d7cc83929307fbbb6dd50", 0xff0d},
    {"4aa0e459273a2fe3012d7b3d2e14e07e", 0xff0d},
    {"030b487ae68da1f4da98046f4fed390f", 0x4e00},
    {"21699fa18fd14735a312512dfea2bff4", 0x4e00},
    {"559fc240f4efe5a1e64714ce09217a3e", 0x4e00},
    {"b7352c3f33a77bc9d3fbf693efbb8095", 0x4e00},
    {"fcdb30a244fb6aad5255ee2d32fdf7fc", 0x4e00},
    {"15a0a0fb33aacd4ce730a9503c46df5f", 0x3299},
    {"9dad4982bd65fbf21525261a7efdf669", 0x3299},
    {"c3e68e6d08d5429e28ffd6592acf4519", 0x3094},
    {"f022cfe594d6f6930d7a5b994e1a0b71", 0x51dc},
    {"407057c7b7b1a91d058d572d9a9d3aa5", 0x51dc},
    {"fc85b0622183795f89111219dfbc6281", 0x51dc},
    {"9707099e5828d97eb12ff2e6ba438558", 0x51dc},
    {"987c829b62eb31f467165827766c410d", 0x51dc},
    {"58371bb195aaa7a468c5c508351ac383", 0x51dc},
    {"32324012ed7274a15002b66ed1e464f8", 0x873b},
    {"0ffb731db8d4a6b711f97bbb08ed8819", 0x873b},
    {"d90aae9a752e9b61662a9cafa837961f", 0x7953},
    {"23d6c6f231ac5d51f4cdaaaa26701956", 0x7953},
    {"81cbedabd8f88d4494255b0631820dfd", 0x7953},
    {"4185f93a5571e49433ca9c13ae588f96", 0x9b4e},
    {"9ab74d6e8bda8723614017a7fce587fe", 0x9b4e},
    {"e96a39a050b694e5f8aadb111420b698", 0x20bb7},
    {"08c5eb5fac4f1d362b946689eb2e4edf", 0x20bb7},
    {"2cef7e443c22f5835658e67749ae52d1", 0x20bb7},
    {"4ab0dd1578c8c5fa25f45938ff0f8575", 0x20bb7},
    {"4c392bb90a1f62796f8fba2c19b4a7de", 0x20bb7},
    {"43856fd7c04a779e571fe24c47f02a6c", 0x9ad9},
    {"265efc2a174c73ea229f9ffefa703f32", 0x9ad9},
    {"5a7af09cce6b3005355e1c6c82df8858", 0x9ad9},
    {"808e9b858294184933f8bf45d6291572", 0x9ad9},
    {"27f0c69a76bf571d6dc25db389d20779", 0x9ad9},
    {"46fb250f60436fd5f33808343893ca12", 0x9ad9},
    {"8a8c4c67a6094d4dc6039e5fe931159c", 0x9ad9},
    {"9257f3792fcfcd21b85524d5f86f624e", 0x9ad9},
    {"d502a276d6f311449597ee9e576d9217", 0x9ad9},
    {"eaa49075e50fbe1fa4b7f593dfd95620", 0x9ad9},
    {"c01d2bafce469da1abbb612fdb16c1e3", 0x5143},
    {"e1ce03321fdb4eaca026a49a43e521a5", 0x5143},
    {"0cfa6c95283a90eff3733db1ac80f58a", 0x5143},
    {"52c1ad5b834821dc6b85ec27bdea1f76", 0x5143},
    {"ad088cffd260c1fccb655cae17b14803", 0x5143},
    {"a9ee52eaa5b4cc32d1891d540bfe93cc", 0xfa10},
    {"a00182f1de36aaee28cac80a3c89d067", 0xfa10},
    {"b03d44ca831a0c995116056ce23f82c5", 0xfa10},
    {"2d6b7d3b5ca6c02d94c5b48661045b7a", 0xfa11},
    {"f5c6e02e235abd23a87f48ed6a64cdcc", 0xfa11},
    {"e9a3b055bda7b9ae70bde4003a4c5885", 0xfa11},
    {"cb17df533b4ebd698a038defeddecf8a", 0xfa11},
    {"0ea39c05c35f96d5b5a48e9815974132", 0xfa11},
    {"3f642f3778827e651c8b82a4e9f06fd3", 0xfa11},
    {"447d8358f482a4e1d9495902ebe269b1", 0xfa11},
    {"ca59a20f1e0ee55b74db34697f961385", 0xfa11},
    {"d2eae5651260b39c4239bcf00c8a76c5", 0xfa11},
    {"f55eb365a9ded45d1e620f83d9f9de26", 0xfa11},
    {"2b385c2642704e44347f2f4db147c8fa", 0x845b},
    {"5c3a8c3a891386a771ff8f00a239b4ba", 0x845b},
    {"e8caa78518e2d690af54e2206c9538f8", 0x5f45},
    {"2e8659ae5e220240c5f8a97147d09df6", 0x5f45},
    {"7592e633260537c1dfa7e5af1000752a", 0x5f45},
    {"a57d3f7684c28d2a901fe6020145de32", 0x5f45},
    {"da3ab2d5da4d69c7d312c7d819e45856", 0x5f45},
    {"918e84ed41c2157aa5f5bbf9aa60514c", 0x5861},
    {"b1e889986beb3a6518d8c2ea53547b7c", 0x5861},
    {"d449ab392afa98c27eb817c40e2eb7ce", 0x5861},
    {"e7158075f2976c353e4cf9247aae3abc", 0x9041},
    {"f1a6fbb17f041cc15148163da34f541f", 0x9041},
    {"a1779a3aaf215916fd0d8fbbb5bf5925", 0x87ec},
    {"a3c09b57be535c0f5618d72f95884c50", 0x87ec},
    {"4b9401a9f9a58c7d0f9c86120aa2dd23", 0x93e2},
    {"fe00b640a48dd341573cafa94afeafa2", 0x93e2},
    {"f4e1d8b42e3c49ea7c896049186d74bd", 0x87dc},
    {"640130a634bd2a0f4347f933a8c5d6d6", 0x87dc},
    {"62985aeebaec69314f03ff9d3080ada2", 0x9dd7},
    {"1bd027207977c585c5889a1e24cae94e", 0x9dd7},
    {"5c8022286d3bc941c12e9bbc475255dd", 0x9dd7},
    {"e4a837fe20dfa091e03afe4857e2482e", 0x525d},
    {"bf2cccb40b985fe3af04281944beac1a", 0x525d},
    {"d5451a035c4e516e5ccb9372cd533d81", 0x525d},
    {"e13ae32f28d840df74a88432df9b122e", 0x525d},
    {"41637d181cd99088e2120a4ec6fc18aa", 0x5b34},
    {"de63abb1aaa44e6ab8a11470103377d5", 0x5b34},
    {"3d32b12254e01c701c195412cb8ef37c", 0x5b34},
    {"f67bc6318ccf43e7902df9a6f9622932", 0x5b34},
    {"d4ce6847d78fc2f8241088b5c0be795c", 0x5b34},
    {"c472e6ade04610e67904aca1b1fa1468", 0x9e83},
    {"db3d060943fbf888eb2fa7fd87340cba", 0x9e83},
    {"509cff0edcba46d5db30b2f2f45c49c9", 0x7623},
    {"4862270872e35184aab420c4d38169ad", 0x7623},
    {"def4d364d00d0f78577987eaebd42aef", 0x9f55},
    {"3cc113a87b49ce231a7b2ffbca4c1e18", 0x9f55},
    {"03dddff25be65f7c284ef8addb8a0a8b", 0x9a41},
    {"52aa815a5a57aff03085d31acd5afbc4", 0x9a41},
    {"4f0431c4c63a6a362646758e62521df8", 0x7156},
    {"dbf1ab17c746c48d474b3730064ba6f2", 0x7156},
    {"790c6b4da6a88f7f4fdb6fdab77fe045", 0x7156},
    {"4d7ae77f2bbf9c8af03d49d466f74058", 0x7156},
    {"0335ba124be8a9e0c501f4051ac5fcf5", 0x9f90},
    {"01d7892b430fd4362c8917ad921199b2", 0x9f90},
    {"e866fd7e605c8b7c8bf718c45a5438cf", 0x9f90},
    {"5df7d88e1e15018b3bce73e765ef72d6", 0x69cc},
    {"48478e1f69ea50c6f7709d47f15b4007", 0x69cc},
    {"4d7d276f23c92f94056b292e295ebd78", 0xfa19},
    {"87d2b97034cf680cd86bc7fe7c500d93", 0xfa19},
    {"f6300abbfcd6bd0db3abd41041499aaa", 0x9082},
    {"26c476496eb73e15285527ab7c635f0b", 0x9082},
    {"be33b9008a58bab485e17de9b2ab2626", 0x9005},
    {"3a9b8b576fe8efca2dedc957732afa37", 0x9005},
    {"b798637262a0c1a29c8de602d4b688c6", 0x9005},
    {"a3785fd94f13646623554b180d08ac77", 0x5fb7},
    {"1f81885b0996be70410e5aa3e4aab3c6", 0x5fb7},
    {"88425dfcbd96fcb6d77ebb76f834d986", 0x5fb7},
    {"9f993f913cd0614a3a965d74e0f4c8d1", 0x5fb7},
    {"a8bb5f2f83d975edfc951a1e461befdc", 0x5fb7},
    {"cd2eadbb87d0aadf1d1cd71fed0ab02f", 0x5fb7},
    {"d22feeb00ace0a632e1a780682f937e8", 0x5fb7},
    {"c9f2fda15b722253c625aebe73f4b1d9", 0x8fbb},
    {"04556b37bff1ccc2f3b395232e104934", 0x8fbb},
    {"117bacaeb67e3508d23a650b98f3c143", 0x8fbb},
    {"211d70374c1787c4bc62df15794a4692", 0x8fbb},
    {"7ba50856c59d1de19cc9c88caaced915", 0x8fbb},
    {"0d627ebf7693b13645336a88813fb7e3", 0x7940},
    {"2c3c032660b20a485575c2d8c7d47956", 0x7940},
    {"1aaec04e53f2978bdf0a127c01b34e9a", 0xf9c3},
    {"e2c3bf09b755b0d59a8a25cba6dda273", 0xf9c3},
    {"fb13879ba2f93a8b0a28b2cd5358d1ee", 0xf9c3},
    {"20eff1fff8d986496b949efa604ec402", 0x8abe},
    {"8742940fcbdbd65aeff1566c1889ece7", 0x8abe},
    {"23e6ef0ecc7bbe8e9465b0b40e901c0d", 0x5393},
    {"5a69785acb47d746fd1ae98bd511db81", 0x5393},
    {"392b8afa18046fc06398b32a42641889", 0x4f60},
    {"7ff2c821d31ef0ca7e9c430f3e659d46", 0x4f60},
    {"44d8b7aacbfc1fc4c32d6526ab8012ee", 0x7960},
    {"c9486b883ab870fc02e7a1f189454f49", 0x7960},
    {"62e7447a02f797cf287a7a758d66563b", 0x64f2},
    {"7d767d2518431dd61e631941dea6bb5e", 0x64f2},
    {"914fa35485d5016adc8b799b0cb5e978", 0x53e3},
    {"d50802fc331261feed1a140f3b70c4b3", 0x53e3},
    {"eeff4833bdfc34b1cbfe6a9d98f38cb5", 0x53e3},
    {"a6d6aaeaf5505676111390a52fa6be51", 0x66b2},
    {"bc534a1accc68d8876e9d47ad8d4b489", 0x66b2},
    {"b5e8cb114ccad281bcb4d86768d509df", 0x9288},
    {"d2c0ab0242ae4ad8a08bffa71613a1a7", 0x9288},
    {"f09031463933b2892be7ebbc501269d0", 0x8559},
    {"f1378529fe66a7f655031d7f5b8c4eb5", 0x8559},
    {"6b696a5ae7634c454aaa7dd833fdfaf9", 0x7737},
    {"5012d099f110e5e7c0df78528686ae07", 0x69ae},
    {"bf27e95238dd789b05e38d56dc41cbf7", 0x5d53},
    {"1d2eafa6be36dc6152cb1917cd2ac486", 0x6c0f},
    {"8b1bd5636f709dfd6a95da9f463729c3", 0x67c0},
    {"0b49a77f459cf3783c5bac37a80518c5", 0x4efd},
    {"8d1ba0e24b619cb4d377ddb7adb3e6fa", 0x55bc},
    {"dab4c329f3c540192f758a2e0008d275", 0x939a},
    {"5b6c90ad3012bfbbc2450b5ab930484d", 0x7fdf},
    {"7eb78d5654f8335d0b1cf4cf78872097", 0x912d},
    {"c3852ea003683f2866abd56140fb5d84", 0x9306},
    {"a78b8a79d8a32c925776c82955d168cc", 0x90ed},
    {"b6e773b060fdd575bc965369d509f4e0", 0x7149},
    {"6d981a3b846347e2b3c9ca4d13794834", 0x6852},
    {"d0ed8ffbc229f84dd796cdd6de36d2e4", 0x40ef},
    {"d9aff359058ab474d552ce52e5a71ec8", 0x537f},
    {"5417381484172c1607d7ca60765b62d2", 0x8755},
    {"b309cd2c649ce3ef6ea0ad2f5fc655cc", 0x9019},
    {"2a349ac3d6b94a8a64d904083fdd5c02", 0x8fbf},
    {"0632283bfd909ef205b1f950e2b00f16", 0x9751},
    {"d91c5a40619510b21610f523f9434269", 0x6df8},
    {"8dc47c6e65beb788da7ed9efd59f0934", 0x8cb7},
    {"e28d4c57d97fbe4a0d67aec2cc92e7c8", 0x6365},
    {"9374173a2e4b7f1dcac75eccd5ee7e7f", 0x698a},
    {"ec7b2c805a5ba3d52c281ee2296b94d7", 0x8523},
};

}  // namespace aribcaption
