#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Walk Visitor base class

template <class StructType>
class CallReplacerOnExpressionsVisitor : public BaseVisitor<StructType>
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    bool call_replacer_on_value=true;
    bool visit_expr_after_replacement=true;
    ASR::expr_t** current_expr=nullptr;
    SymbolTable* current_scope=nullptr;

    void call_replacer() {}
    void transform_stmts(ASR::stmt_t **&m_body, size_t &n_body) {
        for (size_t i = 0; i < n_body; i++) {
            self().visit_stmt(*m_body[i]);
        }
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        current_scope = current_scope_copy;
    }
    void visit_Program(const Program_t &x) {
        Program_t& xx = const_cast<Program_t&>(x);
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().transform_stmts(xx.m_body, xx.n_body);
        current_scope = current_scope_copy;
    }
    void visit_Module(const Module_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        current_scope = current_scope_copy;
    }
    void visit_Function(const Function_t &x) {
        Function_t& xx = const_cast<Function_t&>(x);
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().visit_ttype(*x.m_function_signature);
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_0 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_0;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        self().transform_stmts(xx.m_body, xx.n_body);
        if (x.m_return_var) {
            ASR::expr_t** current_expr_copy_1 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_return_var));
            self().call_replacer();
            current_expr = current_expr_copy_1;
            if( x.m_return_var && visit_expr_after_replacement )
            self().visit_expr(*x.m_return_var);
        }
        current_scope = current_scope_copy;
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_parent_symtab;
        for (size_t i=0; i<x.n_procs; i++) {
        }
        current_scope = current_scope_copy;
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_parent_symtab;
        for (size_t i=0; i<x.n_procs; i++) {
        }
        current_scope = current_scope_copy;
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_parent_symtab;
        if ((bool&)x) { } // Suppress unused warning
        current_scope = current_scope_copy;
    }
    void visit_Struct(const Struct_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
        if (x.m_alignment) {
            ASR::expr_t** current_expr_copy_2 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_alignment));
            self().call_replacer();
            current_expr = current_expr_copy_2;
            if( x.m_alignment && visit_expr_after_replacement )
            self().visit_expr(*x.m_alignment);
        }
        current_scope = current_scope_copy;
    }
    void visit_Enum(const Enum_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().visit_ttype(*x.m_type);
        current_scope = current_scope_copy;
    }
    void visit_Union(const Union_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
        current_scope = current_scope_copy;
    }
    void visit_Variable(const Variable_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_parent_symtab;
        if (x.m_symbolic_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_3 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_symbolic_value));
                self().call_replacer();
                current_expr = current_expr_copy_3;
            }
            if( x.m_symbolic_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_symbolic_value);
        }
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_4 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_4;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
        self().visit_ttype(*x.m_type);
        current_scope = current_scope_copy;
    }
    void visit_Class(const Class_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        current_scope = current_scope_copy;
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_parent_symtab;
        if ((bool&)x) { } // Suppress unused warning
        current_scope = current_scope_copy;
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        AssociateBlock_t& xx = const_cast<AssociateBlock_t&>(x);
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().transform_stmts(xx.m_body, xx.n_body);
        current_scope = current_scope_copy;
    }
    void visit_Block(const Block_t &x) {
        Block_t& xx = const_cast<Block_t&>(x);
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().transform_stmts(xx.m_body, xx.n_body);
        current_scope = current_scope_copy;
    }
    void visit_Requirement(const Requirement_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
        current_scope = current_scope_copy;
    }
    void visit_Template(const Template_t &x) {
        SymbolTable* current_scope_copy = current_scope;
        current_scope = x.m_symtab;
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
        current_scope = current_scope_copy;
    }
    void visit_Allocate(const Allocate_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
        if (x.m_stat) {
            ASR::expr_t** current_expr_copy_5 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_stat));
            self().call_replacer();
            current_expr = current_expr_copy_5;
            if( x.m_stat && visit_expr_after_replacement )
            self().visit_expr(*x.m_stat);
        }
        if (x.m_errmsg) {
            ASR::expr_t** current_expr_copy_6 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_errmsg));
            self().call_replacer();
            current_expr = current_expr_copy_6;
            if( x.m_errmsg && visit_expr_after_replacement )
            self().visit_expr(*x.m_errmsg);
        }
        if (x.m_source) {
            ASR::expr_t** current_expr_copy_7 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_source));
            self().call_replacer();
            current_expr = current_expr_copy_7;
            if( x.m_source && visit_expr_after_replacement )
            self().visit_expr(*x.m_source);
        }
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
    }
    void visit_Assign(const Assign_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        ASR::expr_t** current_expr_copy_8 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_target));
        self().call_replacer();
        current_expr = current_expr_copy_8;
        if( x.m_target && visit_expr_after_replacement )
        self().visit_expr(*x.m_target);
        ASR::expr_t** current_expr_copy_9 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
        self().call_replacer();
        current_expr = current_expr_copy_9;
        if( x.m_value && visit_expr_after_replacement )
        self().visit_expr(*x.m_value);
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        }
    }
    void visit_Associate(const Associate_t &x) {
        ASR::expr_t** current_expr_copy_10 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_target));
        self().call_replacer();
        current_expr = current_expr_copy_10;
        if( x.m_target && visit_expr_after_replacement )
        self().visit_expr(*x.m_target);
        ASR::expr_t** current_expr_copy_11 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
        self().call_replacer();
        current_expr = current_expr_copy_11;
        if( x.m_value && visit_expr_after_replacement )
        self().visit_expr(*x.m_value);
    }
    void visit_Cycle(const Cycle_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            ASR::expr_t** current_expr_copy_12 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_vars[i]));
            self().call_replacer();
            current_expr = current_expr_copy_12;
            if( x.m_vars[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            ASR::expr_t** current_expr_copy_13 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_vars[i]));
            self().call_replacer();
            current_expr = current_expr_copy_13;
            if( x.m_vars[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        DoConcurrentLoop_t& xx = const_cast<DoConcurrentLoop_t&>(x);
        for (size_t i=0; i<x.n_head; i++) {
            self().visit_do_loop_head(x.m_head[i]);
        }
        for (size_t i=0; i<x.n_shared; i++) {
            ASR::expr_t** current_expr_copy_14 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_shared[i]));
            self().call_replacer();
            current_expr = current_expr_copy_14;
            if( x.m_shared[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_shared[i]);
        }
        for (size_t i=0; i<x.n_local; i++) {
            ASR::expr_t** current_expr_copy_15 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_local[i]));
            self().call_replacer();
            current_expr = current_expr_copy_15;
            if( x.m_local[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_local[i]);
        }
        for (size_t i=0; i<x.n_reduction; i++) {
            self().visit_reduction_expr(x.m_reduction[i]);
        }
        self().transform_stmts(xx.m_body, xx.n_body);
    }
    void visit_DoLoop(const DoLoop_t &x) {
        DoLoop_t& xx = const_cast<DoLoop_t&>(x);
        self().visit_do_loop_head(x.m_head);
        self().transform_stmts(xx.m_body, xx.n_body);
        self().transform_stmts(xx.m_orelse, xx.n_orelse);
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        if (x.m_code) {
            ASR::expr_t** current_expr_copy_16 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_code));
            self().call_replacer();
            current_expr = current_expr_copy_16;
            if( x.m_code && visit_expr_after_replacement )
            self().visit_expr(*x.m_code);
        }
    }
    void visit_Exit(const Exit_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        self().visit_do_loop_head(x.m_head);
        self().visit_stmt(*x.m_assign_stmt);
    }
    void visit_ForEach(const ForEach_t &x) {
        ForEach_t& xx = const_cast<ForEach_t&>(x);
        ASR::expr_t** current_expr_copy_17 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_var));
        self().call_replacer();
        current_expr = current_expr_copy_17;
        if( x.m_var && visit_expr_after_replacement )
        self().visit_expr(*x.m_var);
        ASR::expr_t** current_expr_copy_18 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_container));
        self().call_replacer();
        current_expr = current_expr_copy_18;
        if( x.m_container && visit_expr_after_replacement )
        self().visit_expr(*x.m_container);
        self().transform_stmts(xx.m_body, xx.n_body);
    }
    void visit_GoTo(const GoTo_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        If_t& xx = const_cast<If_t&>(x);
        ASR::expr_t** current_expr_copy_19 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_test));
        self().call_replacer();
        current_expr = current_expr_copy_19;
        if( x.m_test && visit_expr_after_replacement )
        self().visit_expr(*x.m_test);
        self().transform_stmts(xx.m_body, xx.n_body);
        self().transform_stmts(xx.m_orelse, xx.n_orelse);
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        ASR::expr_t** current_expr_copy_20 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_test));
        self().call_replacer();
        current_expr = current_expr_copy_20;
        if( x.m_test && visit_expr_after_replacement )
        self().visit_expr(*x.m_test);
    }
    void visit_Print(const Print_t &x) {
        ASR::expr_t** current_expr_copy_21 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_text));
        self().call_replacer();
        current_expr = current_expr_copy_21;
        if( x.m_text && visit_expr_after_replacement )
        self().visit_expr(*x.m_text);
    }
    void visit_FileOpen(const FileOpen_t &x) {
        if (x.m_newunit) {
            ASR::expr_t** current_expr_copy_22 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_newunit));
            self().call_replacer();
            current_expr = current_expr_copy_22;
            if( x.m_newunit && visit_expr_after_replacement )
            self().visit_expr(*x.m_newunit);
        }
        if (x.m_filename) {
            ASR::expr_t** current_expr_copy_23 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_filename));
            self().call_replacer();
            current_expr = current_expr_copy_23;
            if( x.m_filename && visit_expr_after_replacement )
            self().visit_expr(*x.m_filename);
        }
        if (x.m_status) {
            ASR::expr_t** current_expr_copy_24 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_status));
            self().call_replacer();
            current_expr = current_expr_copy_24;
            if( x.m_status && visit_expr_after_replacement )
            self().visit_expr(*x.m_status);
        }
        if (x.m_form) {
            ASR::expr_t** current_expr_copy_25 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_form));
            self().call_replacer();
            current_expr = current_expr_copy_25;
            if( x.m_form && visit_expr_after_replacement )
            self().visit_expr(*x.m_form);
        }
        if (x.m_access) {
            ASR::expr_t** current_expr_copy_26 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_access));
            self().call_replacer();
            current_expr = current_expr_copy_26;
            if( x.m_access && visit_expr_after_replacement )
            self().visit_expr(*x.m_access);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_27 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_27;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
        if (x.m_iomsg) {
            ASR::expr_t** current_expr_copy_28 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iomsg));
            self().call_replacer();
            current_expr = current_expr_copy_28;
            if( x.m_iomsg && visit_expr_after_replacement )
            self().visit_expr(*x.m_iomsg);
        }
    }
    void visit_FileClose(const FileClose_t &x) {
        if (x.m_unit) {
            ASR::expr_t** current_expr_copy_29 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_unit));
            self().call_replacer();
            current_expr = current_expr_copy_29;
            if( x.m_unit && visit_expr_after_replacement )
            self().visit_expr(*x.m_unit);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_30 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_30;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
        if (x.m_iomsg) {
            ASR::expr_t** current_expr_copy_31 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iomsg));
            self().call_replacer();
            current_expr = current_expr_copy_31;
            if( x.m_iomsg && visit_expr_after_replacement )
            self().visit_expr(*x.m_iomsg);
        }
        if (x.m_err) {
            ASR::expr_t** current_expr_copy_32 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_err));
            self().call_replacer();
            current_expr = current_expr_copy_32;
            if( x.m_err && visit_expr_after_replacement )
            self().visit_expr(*x.m_err);
        }
        if (x.m_status) {
            ASR::expr_t** current_expr_copy_33 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_status));
            self().call_replacer();
            current_expr = current_expr_copy_33;
            if( x.m_status && visit_expr_after_replacement )
            self().visit_expr(*x.m_status);
        }
    }
    void visit_FileRead(const FileRead_t &x) {
        if (x.m_unit) {
            ASR::expr_t** current_expr_copy_34 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_unit));
            self().call_replacer();
            current_expr = current_expr_copy_34;
            if( x.m_unit && visit_expr_after_replacement )
            self().visit_expr(*x.m_unit);
        }
        if (x.m_fmt) {
            ASR::expr_t** current_expr_copy_35 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_fmt));
            self().call_replacer();
            current_expr = current_expr_copy_35;
            if( x.m_fmt && visit_expr_after_replacement )
            self().visit_expr(*x.m_fmt);
        }
        if (x.m_iomsg) {
            ASR::expr_t** current_expr_copy_36 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iomsg));
            self().call_replacer();
            current_expr = current_expr_copy_36;
            if( x.m_iomsg && visit_expr_after_replacement )
            self().visit_expr(*x.m_iomsg);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_37 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_37;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
        if (x.m_advance) {
            ASR::expr_t** current_expr_copy_38 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_advance));
            self().call_replacer();
            current_expr = current_expr_copy_38;
            if( x.m_advance && visit_expr_after_replacement )
            self().visit_expr(*x.m_advance);
        }
        if (x.m_size) {
            ASR::expr_t** current_expr_copy_39 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_size));
            self().call_replacer();
            current_expr = current_expr_copy_39;
            if( x.m_size && visit_expr_after_replacement )
            self().visit_expr(*x.m_size);
        }
        if (x.m_id) {
            ASR::expr_t** current_expr_copy_40 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_id));
            self().call_replacer();
            current_expr = current_expr_copy_40;
            if( x.m_id && visit_expr_after_replacement )
            self().visit_expr(*x.m_id);
        }
        for (size_t i=0; i<x.n_values; i++) {
            ASR::expr_t** current_expr_copy_41 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_values[i]));
            self().call_replacer();
            current_expr = current_expr_copy_41;
            if( x.m_values[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        }
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        if (x.m_unit) {
            ASR::expr_t** current_expr_copy_42 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_unit));
            self().call_replacer();
            current_expr = current_expr_copy_42;
            if( x.m_unit && visit_expr_after_replacement )
            self().visit_expr(*x.m_unit);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_43 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_43;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
        if (x.m_err) {
            ASR::expr_t** current_expr_copy_44 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_err));
            self().call_replacer();
            current_expr = current_expr_copy_44;
            if( x.m_err && visit_expr_after_replacement )
            self().visit_expr(*x.m_err);
        }
    }
    void visit_FileRewind(const FileRewind_t &x) {
        if (x.m_unit) {
            ASR::expr_t** current_expr_copy_45 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_unit));
            self().call_replacer();
            current_expr = current_expr_copy_45;
            if( x.m_unit && visit_expr_after_replacement )
            self().visit_expr(*x.m_unit);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_46 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_46;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
        if (x.m_err) {
            ASR::expr_t** current_expr_copy_47 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_err));
            self().call_replacer();
            current_expr = current_expr_copy_47;
            if( x.m_err && visit_expr_after_replacement )
            self().visit_expr(*x.m_err);
        }
    }
    void visit_FileInquire(const FileInquire_t &x) {
        if (x.m_unit) {
            ASR::expr_t** current_expr_copy_48 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_unit));
            self().call_replacer();
            current_expr = current_expr_copy_48;
            if( x.m_unit && visit_expr_after_replacement )
            self().visit_expr(*x.m_unit);
        }
        if (x.m_file) {
            ASR::expr_t** current_expr_copy_49 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_file));
            self().call_replacer();
            current_expr = current_expr_copy_49;
            if( x.m_file && visit_expr_after_replacement )
            self().visit_expr(*x.m_file);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_50 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_50;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
        if (x.m_err) {
            ASR::expr_t** current_expr_copy_51 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_err));
            self().call_replacer();
            current_expr = current_expr_copy_51;
            if( x.m_err && visit_expr_after_replacement )
            self().visit_expr(*x.m_err);
        }
        if (x.m_exist) {
            ASR::expr_t** current_expr_copy_52 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_exist));
            self().call_replacer();
            current_expr = current_expr_copy_52;
            if( x.m_exist && visit_expr_after_replacement )
            self().visit_expr(*x.m_exist);
        }
        if (x.m_opened) {
            ASR::expr_t** current_expr_copy_53 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_opened));
            self().call_replacer();
            current_expr = current_expr_copy_53;
            if( x.m_opened && visit_expr_after_replacement )
            self().visit_expr(*x.m_opened);
        }
        if (x.m_number) {
            ASR::expr_t** current_expr_copy_54 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_number));
            self().call_replacer();
            current_expr = current_expr_copy_54;
            if( x.m_number && visit_expr_after_replacement )
            self().visit_expr(*x.m_number);
        }
        if (x.m_named) {
            ASR::expr_t** current_expr_copy_55 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_named));
            self().call_replacer();
            current_expr = current_expr_copy_55;
            if( x.m_named && visit_expr_after_replacement )
            self().visit_expr(*x.m_named);
        }
        if (x.m_name) {
            ASR::expr_t** current_expr_copy_56 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_name));
            self().call_replacer();
            current_expr = current_expr_copy_56;
            if( x.m_name && visit_expr_after_replacement )
            self().visit_expr(*x.m_name);
        }
        if (x.m_access) {
            ASR::expr_t** current_expr_copy_57 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_access));
            self().call_replacer();
            current_expr = current_expr_copy_57;
            if( x.m_access && visit_expr_after_replacement )
            self().visit_expr(*x.m_access);
        }
        if (x.m_sequential) {
            ASR::expr_t** current_expr_copy_58 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_sequential));
            self().call_replacer();
            current_expr = current_expr_copy_58;
            if( x.m_sequential && visit_expr_after_replacement )
            self().visit_expr(*x.m_sequential);
        }
        if (x.m_direct) {
            ASR::expr_t** current_expr_copy_59 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_direct));
            self().call_replacer();
            current_expr = current_expr_copy_59;
            if( x.m_direct && visit_expr_after_replacement )
            self().visit_expr(*x.m_direct);
        }
        if (x.m_form) {
            ASR::expr_t** current_expr_copy_60 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_form));
            self().call_replacer();
            current_expr = current_expr_copy_60;
            if( x.m_form && visit_expr_after_replacement )
            self().visit_expr(*x.m_form);
        }
        if (x.m_formatted) {
            ASR::expr_t** current_expr_copy_61 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_formatted));
            self().call_replacer();
            current_expr = current_expr_copy_61;
            if( x.m_formatted && visit_expr_after_replacement )
            self().visit_expr(*x.m_formatted);
        }
        if (x.m_unformatted) {
            ASR::expr_t** current_expr_copy_62 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_unformatted));
            self().call_replacer();
            current_expr = current_expr_copy_62;
            if( x.m_unformatted && visit_expr_after_replacement )
            self().visit_expr(*x.m_unformatted);
        }
        if (x.m_recl) {
            ASR::expr_t** current_expr_copy_63 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_recl));
            self().call_replacer();
            current_expr = current_expr_copy_63;
            if( x.m_recl && visit_expr_after_replacement )
            self().visit_expr(*x.m_recl);
        }
        if (x.m_nextrec) {
            ASR::expr_t** current_expr_copy_64 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_nextrec));
            self().call_replacer();
            current_expr = current_expr_copy_64;
            if( x.m_nextrec && visit_expr_after_replacement )
            self().visit_expr(*x.m_nextrec);
        }
        if (x.m_blank) {
            ASR::expr_t** current_expr_copy_65 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_blank));
            self().call_replacer();
            current_expr = current_expr_copy_65;
            if( x.m_blank && visit_expr_after_replacement )
            self().visit_expr(*x.m_blank);
        }
        if (x.m_position) {
            ASR::expr_t** current_expr_copy_66 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_position));
            self().call_replacer();
            current_expr = current_expr_copy_66;
            if( x.m_position && visit_expr_after_replacement )
            self().visit_expr(*x.m_position);
        }
        if (x.m_action) {
            ASR::expr_t** current_expr_copy_67 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_action));
            self().call_replacer();
            current_expr = current_expr_copy_67;
            if( x.m_action && visit_expr_after_replacement )
            self().visit_expr(*x.m_action);
        }
        if (x.m_read) {
            ASR::expr_t** current_expr_copy_68 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_read));
            self().call_replacer();
            current_expr = current_expr_copy_68;
            if( x.m_read && visit_expr_after_replacement )
            self().visit_expr(*x.m_read);
        }
        if (x.m_write) {
            ASR::expr_t** current_expr_copy_69 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_write));
            self().call_replacer();
            current_expr = current_expr_copy_69;
            if( x.m_write && visit_expr_after_replacement )
            self().visit_expr(*x.m_write);
        }
        if (x.m_readwrite) {
            ASR::expr_t** current_expr_copy_70 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_readwrite));
            self().call_replacer();
            current_expr = current_expr_copy_70;
            if( x.m_readwrite && visit_expr_after_replacement )
            self().visit_expr(*x.m_readwrite);
        }
        if (x.m_delim) {
            ASR::expr_t** current_expr_copy_71 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_delim));
            self().call_replacer();
            current_expr = current_expr_copy_71;
            if( x.m_delim && visit_expr_after_replacement )
            self().visit_expr(*x.m_delim);
        }
        if (x.m_pad) {
            ASR::expr_t** current_expr_copy_72 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_pad));
            self().call_replacer();
            current_expr = current_expr_copy_72;
            if( x.m_pad && visit_expr_after_replacement )
            self().visit_expr(*x.m_pad);
        }
        if (x.m_flen) {
            ASR::expr_t** current_expr_copy_73 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_flen));
            self().call_replacer();
            current_expr = current_expr_copy_73;
            if( x.m_flen && visit_expr_after_replacement )
            self().visit_expr(*x.m_flen);
        }
        if (x.m_blocksize) {
            ASR::expr_t** current_expr_copy_74 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_blocksize));
            self().call_replacer();
            current_expr = current_expr_copy_74;
            if( x.m_blocksize && visit_expr_after_replacement )
            self().visit_expr(*x.m_blocksize);
        }
        if (x.m_convert) {
            ASR::expr_t** current_expr_copy_75 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_convert));
            self().call_replacer();
            current_expr = current_expr_copy_75;
            if( x.m_convert && visit_expr_after_replacement )
            self().visit_expr(*x.m_convert);
        }
        if (x.m_carriagecontrol) {
            ASR::expr_t** current_expr_copy_76 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_carriagecontrol));
            self().call_replacer();
            current_expr = current_expr_copy_76;
            if( x.m_carriagecontrol && visit_expr_after_replacement )
            self().visit_expr(*x.m_carriagecontrol);
        }
        if (x.m_size) {
            ASR::expr_t** current_expr_copy_77 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_size));
            self().call_replacer();
            current_expr = current_expr_copy_77;
            if( x.m_size && visit_expr_after_replacement )
            self().visit_expr(*x.m_size);
        }
        if (x.m_pos) {
            ASR::expr_t** current_expr_copy_78 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_pos));
            self().call_replacer();
            current_expr = current_expr_copy_78;
            if( x.m_pos && visit_expr_after_replacement )
            self().visit_expr(*x.m_pos);
        }
        if (x.m_iolength) {
            ASR::expr_t** current_expr_copy_79 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iolength));
            self().call_replacer();
            current_expr = current_expr_copy_79;
            if( x.m_iolength && visit_expr_after_replacement )
            self().visit_expr(*x.m_iolength);
        }
    }
    void visit_FileWrite(const FileWrite_t &x) {
        if (x.m_unit) {
            ASR::expr_t** current_expr_copy_80 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_unit));
            self().call_replacer();
            current_expr = current_expr_copy_80;
            if( x.m_unit && visit_expr_after_replacement )
            self().visit_expr(*x.m_unit);
        }
        if (x.m_iomsg) {
            ASR::expr_t** current_expr_copy_81 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iomsg));
            self().call_replacer();
            current_expr = current_expr_copy_81;
            if( x.m_iomsg && visit_expr_after_replacement )
            self().visit_expr(*x.m_iomsg);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_82 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_82;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
        if (x.m_id) {
            ASR::expr_t** current_expr_copy_83 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_id));
            self().call_replacer();
            current_expr = current_expr_copy_83;
            if( x.m_id && visit_expr_after_replacement )
            self().visit_expr(*x.m_id);
        }
        for (size_t i=0; i<x.n_values; i++) {
            ASR::expr_t** current_expr_copy_84 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_values[i]));
            self().call_replacer();
            current_expr = current_expr_copy_84;
            if( x.m_values[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_separator) {
            ASR::expr_t** current_expr_copy_85 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_separator));
            self().call_replacer();
            current_expr = current_expr_copy_85;
            if( x.m_separator && visit_expr_after_replacement )
            self().visit_expr(*x.m_separator);
        }
        if (x.m_end) {
            ASR::expr_t** current_expr_copy_86 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_end));
            self().call_replacer();
            current_expr = current_expr_copy_86;
            if( x.m_end && visit_expr_after_replacement )
            self().visit_expr(*x.m_end);
        }
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        }
    }
    void visit_Return(const Return_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        Select_t& xx = const_cast<Select_t&>(x);
        ASR::expr_t** current_expr_copy_87 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_test));
        self().call_replacer();
        current_expr = current_expr_copy_87;
        if( x.m_test && visit_expr_after_replacement )
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
        }
        self().transform_stmts(xx.m_default, xx.n_default);
    }
    void visit_Stop(const Stop_t &x) {
        if (x.m_code) {
            ASR::expr_t** current_expr_copy_88 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_code));
            self().call_replacer();
            current_expr = current_expr_copy_88;
            if( x.m_code && visit_expr_after_replacement )
            self().visit_expr(*x.m_code);
        }
    }
    void visit_Assert(const Assert_t &x) {
        ASR::expr_t** current_expr_copy_89 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_test));
        self().call_replacer();
        current_expr = current_expr_copy_89;
        if( x.m_test && visit_expr_after_replacement )
        self().visit_expr(*x.m_test);
        if (x.m_msg) {
            ASR::expr_t** current_expr_copy_90 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_msg));
            self().call_replacer();
            current_expr = current_expr_copy_90;
            if( x.m_msg && visit_expr_after_replacement )
            self().visit_expr(*x.m_msg);
        }
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        if (x.m_dt) {
            ASR::expr_t** current_expr_copy_91 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_dt));
            self().call_replacer();
            current_expr = current_expr_copy_91;
            if( x.m_dt && visit_expr_after_replacement )
            self().visit_expr(*x.m_dt);
        }
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_92 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_92;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
    }
    void visit_Where(const Where_t &x) {
        Where_t& xx = const_cast<Where_t&>(x);
        ASR::expr_t** current_expr_copy_93 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_test));
        self().call_replacer();
        current_expr = current_expr_copy_93;
        if( x.m_test && visit_expr_after_replacement )
        self().visit_expr(*x.m_test);
        self().transform_stmts(xx.m_body, xx.n_body);
        self().transform_stmts(xx.m_orelse, xx.n_orelse);
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        WhileLoop_t& xx = const_cast<WhileLoop_t&>(x);
        ASR::expr_t** current_expr_copy_94 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_test));
        self().call_replacer();
        current_expr = current_expr_copy_94;
        if( x.m_test && visit_expr_after_replacement )
        self().visit_expr(*x.m_test);
        self().transform_stmts(xx.m_body, xx.n_body);
        self().transform_stmts(xx.m_orelse, xx.n_orelse);
    }
    void visit_Nullify(const Nullify_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            ASR::expr_t** current_expr_copy_95 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_vars[i]));
            self().call_replacer();
            current_expr = current_expr_copy_95;
            if( x.m_vars[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_Flush(const Flush_t &x) {
        ASR::expr_t** current_expr_copy_96 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_unit));
        self().call_replacer();
        current_expr = current_expr_copy_96;
        if( x.m_unit && visit_expr_after_replacement )
        self().visit_expr(*x.m_unit);
        if (x.m_err) {
            ASR::expr_t** current_expr_copy_97 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_err));
            self().call_replacer();
            current_expr = current_expr_copy_97;
            if( x.m_err && visit_expr_after_replacement )
            self().visit_expr(*x.m_err);
        }
        if (x.m_iomsg) {
            ASR::expr_t** current_expr_copy_98 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iomsg));
            self().call_replacer();
            current_expr = current_expr_copy_98;
            if( x.m_iomsg && visit_expr_after_replacement )
            self().visit_expr(*x.m_iomsg);
        }
        if (x.m_iostat) {
            ASR::expr_t** current_expr_copy_99 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_iostat));
            self().call_replacer();
            current_expr = current_expr_copy_99;
            if( x.m_iostat && visit_expr_after_replacement )
            self().visit_expr(*x.m_iostat);
        }
    }
    void visit_ListAppend(const ListAppend_t &x) {
        ASR::expr_t** current_expr_copy_100 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_100;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_101 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ele));
        self().call_replacer();
        current_expr = current_expr_copy_101;
        if( x.m_ele && visit_expr_after_replacement )
        self().visit_expr(*x.m_ele);
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SelectType(const SelectType_t &x) {
        SelectType_t& xx = const_cast<SelectType_t&>(x);
        ASR::expr_t** current_expr_copy_102 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_selector));
        self().call_replacer();
        current_expr = current_expr_copy_102;
        if( x.m_selector && visit_expr_after_replacement )
        self().visit_expr(*x.m_selector);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
        }
        self().transform_stmts(xx.m_default, xx.n_default);
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        ASR::expr_t** current_expr_copy_103 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_cptr));
        self().call_replacer();
        current_expr = current_expr_copy_103;
        if( x.m_cptr && visit_expr_after_replacement )
        self().visit_expr(*x.m_cptr);
        ASR::expr_t** current_expr_copy_104 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ptr));
        self().call_replacer();
        current_expr = current_expr_copy_104;
        if( x.m_ptr && visit_expr_after_replacement )
        self().visit_expr(*x.m_ptr);
        if (x.m_shape) {
            ASR::expr_t** current_expr_copy_105 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_shape));
            self().call_replacer();
            current_expr = current_expr_copy_105;
            if( x.m_shape && visit_expr_after_replacement )
            self().visit_expr(*x.m_shape);
        }
        if (x.m_lower_bounds) {
            ASR::expr_t** current_expr_copy_106 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_lower_bounds));
            self().call_replacer();
            current_expr = current_expr_copy_106;
            if( x.m_lower_bounds && visit_expr_after_replacement )
            self().visit_expr(*x.m_lower_bounds);
        }
    }
    void visit_BlockCall(const BlockCall_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetInsert(const SetInsert_t &x) {
        ASR::expr_t** current_expr_copy_107 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_107;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_108 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ele));
        self().call_replacer();
        current_expr = current_expr_copy_108;
        if( x.m_ele && visit_expr_after_replacement )
        self().visit_expr(*x.m_ele);
    }
    void visit_SetRemove(const SetRemove_t &x) {
        ASR::expr_t** current_expr_copy_109 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_109;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_110 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ele));
        self().call_replacer();
        current_expr = current_expr_copy_110;
        if( x.m_ele && visit_expr_after_replacement )
        self().visit_expr(*x.m_ele);
    }
    void visit_ListInsert(const ListInsert_t &x) {
        ASR::expr_t** current_expr_copy_111 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_111;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_112 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_pos));
        self().call_replacer();
        current_expr = current_expr_copy_112;
        if( x.m_pos && visit_expr_after_replacement )
        self().visit_expr(*x.m_pos);
        ASR::expr_t** current_expr_copy_113 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ele));
        self().call_replacer();
        current_expr = current_expr_copy_113;
        if( x.m_ele && visit_expr_after_replacement )
        self().visit_expr(*x.m_ele);
    }
    void visit_ListRemove(const ListRemove_t &x) {
        ASR::expr_t** current_expr_copy_114 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_114;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_115 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ele));
        self().call_replacer();
        current_expr = current_expr_copy_115;
        if( x.m_ele && visit_expr_after_replacement )
        self().visit_expr(*x.m_ele);
    }
    void visit_ListClear(const ListClear_t &x) {
        ASR::expr_t** current_expr_copy_116 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_116;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
    }
    void visit_DictInsert(const DictInsert_t &x) {
        ASR::expr_t** current_expr_copy_117 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_117;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_118 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_key));
        self().call_replacer();
        current_expr = current_expr_copy_118;
        if( x.m_key && visit_expr_after_replacement )
        self().visit_expr(*x.m_key);
        ASR::expr_t** current_expr_copy_119 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
        self().call_replacer();
        current_expr = current_expr_copy_119;
        if( x.m_value && visit_expr_after_replacement )
        self().visit_expr(*x.m_value);
    }
    void visit_DictClear(const DictClear_t &x) {
        ASR::expr_t** current_expr_copy_120 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_120;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
    }
    void visit_SetClear(const SetClear_t &x) {
        ASR::expr_t** current_expr_copy_121 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_121;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
    }
    void visit_Expr(const Expr_t &x) {
        ASR::expr_t** current_expr_copy_122 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_expression));
        self().call_replacer();
        current_expr = current_expr_copy_122;
        if( x.m_expression && visit_expr_after_replacement )
        self().visit_expr(*x.m_expression);
    }
    void visit_IfExp(const IfExp_t &x) {
        ASR::expr_t** current_expr_copy_123 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_test));
        self().call_replacer();
        current_expr = current_expr_copy_123;
        if( x.m_test && visit_expr_after_replacement )
        self().visit_expr(*x.m_test);
        ASR::expr_t** current_expr_copy_124 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_body));
        self().call_replacer();
        current_expr = current_expr_copy_124;
        if( x.m_body && visit_expr_after_replacement )
        self().visit_expr(*x.m_body);
        ASR::expr_t** current_expr_copy_125 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_orelse));
        self().call_replacer();
        current_expr = current_expr_copy_125;
        if( x.m_orelse && visit_expr_after_replacement )
        self().visit_expr(*x.m_orelse);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_126 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_126;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        ASR::expr_t** current_expr_copy_127 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_re));
        self().call_replacer();
        current_expr = current_expr_copy_127;
        if( x.m_re && visit_expr_after_replacement )
        self().visit_expr(*x.m_re);
        ASR::expr_t** current_expr_copy_128 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_im));
        self().call_replacer();
        current_expr = current_expr_copy_128;
        if( x.m_im && visit_expr_after_replacement )
        self().visit_expr(*x.m_im);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_129 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_129;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        ASR::expr_t** current_expr_copy_130 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_target));
        self().call_replacer();
        current_expr = current_expr_copy_130;
        if( x.m_target && visit_expr_after_replacement )
        self().visit_expr(*x.m_target);
        ASR::expr_t** current_expr_copy_131 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
        self().call_replacer();
        current_expr = current_expr_copy_131;
        if( x.m_value && visit_expr_after_replacement )
        self().visit_expr(*x.m_value);
        self().visit_ttype(*x.m_type);
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_132 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_132;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
        if (x.m_dt) {
            ASR::expr_t** current_expr_copy_133 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_dt));
            self().call_replacer();
            current_expr = current_expr_copy_133;
            if( x.m_dt && visit_expr_after_replacement )
            self().visit_expr(*x.m_dt);
        }
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_134 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_134;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        }
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_135 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_135;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_136 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_136;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        }
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_137 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_137;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_138 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_138;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        }
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_139 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_139;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        self().visit_ttype(*x.m_arg_type);
        if (x.m_arg) {
            ASR::expr_t** current_expr_copy_140 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
            self().call_replacer();
            current_expr = current_expr_copy_140;
            if( x.m_arg && visit_expr_after_replacement )
            self().visit_expr(*x.m_arg);
        }
        self().visit_ttype(*x.m_type);
        ASR::expr_t** current_expr_copy_141 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
        self().call_replacer();
        current_expr = current_expr_copy_141;
        if( x.m_value && visit_expr_after_replacement )
        self().visit_expr(*x.m_value);
    }
    void visit_StructConstructor(const StructConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_142 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_142;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StructConstant(const StructConstant_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_EnumConstructor(const EnumConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_143 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_143;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_144 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_144;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_UnionConstructor(const UnionConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_145 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_145;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_146 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_146;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        for (size_t i=0; i<x.n_values; i++) {
            ASR::expr_t** current_expr_copy_147 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_values[i]));
            self().call_replacer();
            current_expr = current_expr_copy_147;
            if( x.m_values[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_values[i]);
        }
        ASR::expr_t** current_expr_copy_148 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_var));
        self().call_replacer();
        current_expr = current_expr_copy_148;
        if( x.m_var && visit_expr_after_replacement )
        self().visit_expr(*x.m_var);
        ASR::expr_t** current_expr_copy_149 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_start));
        self().call_replacer();
        current_expr = current_expr_copy_149;
        if( x.m_start && visit_expr_after_replacement )
        self().visit_expr(*x.m_start);
        ASR::expr_t** current_expr_copy_150 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_end));
        self().call_replacer();
        current_expr = current_expr_copy_150;
        if( x.m_end && visit_expr_after_replacement )
        self().visit_expr(*x.m_end);
        if (x.m_increment) {
            ASR::expr_t** current_expr_copy_151 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_increment));
            self().call_replacer();
            current_expr = current_expr_copy_151;
            if( x.m_increment && visit_expr_after_replacement )
            self().visit_expr(*x.m_increment);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_152 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_152;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        ASR::expr_t** current_expr_copy_153 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_153;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_154 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_154;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        ASR::expr_t** current_expr_copy_155 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_155;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_156 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_156;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        ASR::expr_t** current_expr_copy_157 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_157;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_158 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_158;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_159 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_159;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        ASR::expr_t** current_expr_copy_160 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_160;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_161 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_161;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_162 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_162;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        ASR::expr_t** current_expr_copy_163 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_163;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_164 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_164;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        ASR::expr_t** current_expr_copy_165 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_165;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_166 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_166;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        ASR::expr_t** current_expr_copy_167 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_167;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_168 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_168;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_169 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_169;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        ASR::expr_t** current_expr_copy_170 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_170;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_171 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_171;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_172 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_172;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_RealConstant(const RealConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        ASR::expr_t** current_expr_copy_173 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_173;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_174 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_174;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_RealCompare(const RealCompare_t &x) {
        ASR::expr_t** current_expr_copy_175 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_175;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_176 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_176;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_177 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_177;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        ASR::expr_t** current_expr_copy_178 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_178;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_179 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_179;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_180 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_180;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        ASR::expr_t** current_expr_copy_181 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_target));
        self().call_replacer();
        current_expr = current_expr_copy_181;
        if( x.m_target && visit_expr_after_replacement )
        self().visit_expr(*x.m_target);
        ASR::expr_t** current_expr_copy_182 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_source));
        self().call_replacer();
        current_expr = current_expr_copy_182;
        if( x.m_source && visit_expr_after_replacement )
        self().visit_expr(*x.m_source);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_183 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_183;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        ASR::expr_t** current_expr_copy_184 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_184;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_185 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_185;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        ASR::expr_t** current_expr_copy_186 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_186;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_187 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_187;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_188 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_188;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        ASR::expr_t** current_expr_copy_189 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_189;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_190 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_190;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_191 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_191;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        ASR::expr_t** current_expr_copy_192 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_192;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_193 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_193;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        ASR::expr_t** current_expr_copy_194 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_194;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_195 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_195;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_196 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_196;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        ASR::expr_t** current_expr_copy_197 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_197;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_198 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_198;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_199 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_199;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListConstant(const ListConstant_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_200 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_200;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_ListLen(const ListLen_t &x) {
        ASR::expr_t** current_expr_copy_201 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_201;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_202 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_202;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListConcat(const ListConcat_t &x) {
        ASR::expr_t** current_expr_copy_203 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_203;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_204 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_204;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_205 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_205;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListCompare(const ListCompare_t &x) {
        ASR::expr_t** current_expr_copy_206 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_206;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_207 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_207;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_208 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_208;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListCount(const ListCount_t &x) {
        ASR::expr_t** current_expr_copy_209 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_209;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        ASR::expr_t** current_expr_copy_210 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ele));
        self().call_replacer();
        current_expr = current_expr_copy_210;
        if( x.m_ele && visit_expr_after_replacement )
        self().visit_expr(*x.m_ele);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_211 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_211;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListContains(const ListContains_t &x) {
        ASR::expr_t** current_expr_copy_212 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_212;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_213 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_213;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_214 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_214;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_SetConstant(const SetConstant_t &x) {
        for (size_t i=0; i<x.n_elements; i++) {
            ASR::expr_t** current_expr_copy_215 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_elements[i]));
            self().call_replacer();
            current_expr = current_expr_copy_215;
            if( x.m_elements[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_SetLen(const SetLen_t &x) {
        ASR::expr_t** current_expr_copy_216 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_216;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_217 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_217;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        for (size_t i=0; i<x.n_elements; i++) {
            ASR::expr_t** current_expr_copy_218 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_elements[i]));
            self().call_replacer();
            current_expr = current_expr_copy_218;
            if( x.m_elements[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_TupleLen(const TupleLen_t &x) {
        ASR::expr_t** current_expr_copy_219 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_219;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        ASR::expr_t** current_expr_copy_220 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
        self().call_replacer();
        current_expr = current_expr_copy_220;
        if( x.m_value && visit_expr_after_replacement )
        self().visit_expr(*x.m_value);
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        ASR::expr_t** current_expr_copy_221 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_221;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_222 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_222;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_223 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_223;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        ASR::expr_t** current_expr_copy_224 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_224;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_225 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_225;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_226 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_226;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_TupleContains(const TupleContains_t &x) {
        ASR::expr_t** current_expr_copy_227 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_227;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_228 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_228;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_229 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_229;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringConstant(const StringConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_StringConcat(const StringConcat_t &x) {
        ASR::expr_t** current_expr_copy_230 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_230;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_231 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_231;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_232 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_232;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        ASR::expr_t** current_expr_copy_233 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_233;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_234 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_234;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_235 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_235;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringLen(const StringLen_t &x) {
        ASR::expr_t** current_expr_copy_236 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_236;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_237 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_237;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringItem(const StringItem_t &x) {
        ASR::expr_t** current_expr_copy_238 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_238;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        ASR::expr_t** current_expr_copy_239 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_idx));
        self().call_replacer();
        current_expr = current_expr_copy_239;
        if( x.m_idx && visit_expr_after_replacement )
        self().visit_expr(*x.m_idx);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_240 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_240;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringSection(const StringSection_t &x) {
        ASR::expr_t** current_expr_copy_241 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_241;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        if (x.m_start) {
            ASR::expr_t** current_expr_copy_242 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_start));
            self().call_replacer();
            current_expr = current_expr_copy_242;
            if( x.m_start && visit_expr_after_replacement )
            self().visit_expr(*x.m_start);
        }
        if (x.m_end) {
            ASR::expr_t** current_expr_copy_243 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_end));
            self().call_replacer();
            current_expr = current_expr_copy_243;
            if( x.m_end && visit_expr_after_replacement )
            self().visit_expr(*x.m_end);
        }
        if (x.m_step) {
            ASR::expr_t** current_expr_copy_244 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_step));
            self().call_replacer();
            current_expr = current_expr_copy_244;
            if( x.m_step && visit_expr_after_replacement )
            self().visit_expr(*x.m_step);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_245 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_245;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringCompare(const StringCompare_t &x) {
        ASR::expr_t** current_expr_copy_246 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_246;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_247 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_247;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_248 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_248;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringContains(const StringContains_t &x) {
        ASR::expr_t** current_expr_copy_249 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_substr));
        self().call_replacer();
        current_expr = current_expr_copy_249;
        if( x.m_substr && visit_expr_after_replacement )
        self().visit_expr(*x.m_substr);
        ASR::expr_t** current_expr_copy_250 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_str));
        self().call_replacer();
        current_expr = current_expr_copy_250;
        if( x.m_str && visit_expr_after_replacement )
        self().visit_expr(*x.m_str);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_251 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_251;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringOrd(const StringOrd_t &x) {
        ASR::expr_t** current_expr_copy_252 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_252;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_253 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_253;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringChr(const StringChr_t &x) {
        ASR::expr_t** current_expr_copy_254 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_254;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_255 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_255;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringFormat(const StringFormat_t &x) {
        if (x.m_fmt) {
            ASR::expr_t** current_expr_copy_256 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_fmt));
            self().call_replacer();
            current_expr = current_expr_copy_256;
            if( x.m_fmt && visit_expr_after_replacement )
            self().visit_expr(*x.m_fmt);
        }
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_257 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_257;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_258 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_258;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StringPhysicalCast(const StringPhysicalCast_t &x) {
        ASR::expr_t** current_expr_copy_259 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_259;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_260 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_260;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        ASR::expr_t** current_expr_copy_261 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_261;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_262 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_262;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_263 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_263;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        ASR::expr_t** current_expr_copy_264 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_264;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_265 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_265;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_266 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_266;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_DictConstant(const DictConstant_t &x) {
        for (size_t i=0; i<x.n_keys; i++) {
            ASR::expr_t** current_expr_copy_267 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_keys[i]));
            self().call_replacer();
            current_expr = current_expr_copy_267;
            if( x.m_keys[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_keys[i]);
        }
        for (size_t i=0; i<x.n_values; i++) {
            ASR::expr_t** current_expr_copy_268 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_values[i]));
            self().call_replacer();
            current_expr = current_expr_copy_268;
            if( x.m_values[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_DictLen(const DictLen_t &x) {
        ASR::expr_t** current_expr_copy_269 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_269;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_270 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_270;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_Var(const Var_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_271 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_271;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            ASR::expr_t** current_expr_copy_272 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_args[i]));
            self().call_replacer();
            current_expr = current_expr_copy_272;
            if( x.m_args[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_273 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_273;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        ASR::expr_t** current_expr_copy_274 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_274;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_275 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_275;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArraySection(const ArraySection_t &x) {
        ASR::expr_t** current_expr_copy_276 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_276;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_277 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_277;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArraySize(const ArraySize_t &x) {
        ASR::expr_t** current_expr_copy_278 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_278;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        if (x.m_dim) {
            ASR::expr_t** current_expr_copy_279 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_dim));
            self().call_replacer();
            current_expr = current_expr_copy_279;
            if( x.m_dim && visit_expr_after_replacement )
            self().visit_expr(*x.m_dim);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_280 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_280;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        ASR::expr_t** current_expr_copy_281 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_281;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        if (x.m_dim) {
            ASR::expr_t** current_expr_copy_282 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_dim));
            self().call_replacer();
            current_expr = current_expr_copy_282;
            if( x.m_dim && visit_expr_after_replacement )
            self().visit_expr(*x.m_dim);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_283 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_283;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        ASR::expr_t** current_expr_copy_284 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_matrix));
        self().call_replacer();
        current_expr = current_expr_copy_284;
        if( x.m_matrix && visit_expr_after_replacement )
        self().visit_expr(*x.m_matrix);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_285 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_285;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        ASR::expr_t** current_expr_copy_286 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_array));
        self().call_replacer();
        current_expr = current_expr_copy_286;
        if( x.m_array && visit_expr_after_replacement )
        self().visit_expr(*x.m_array);
        ASR::expr_t** current_expr_copy_287 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_mask));
        self().call_replacer();
        current_expr = current_expr_copy_287;
        if( x.m_mask && visit_expr_after_replacement )
        self().visit_expr(*x.m_mask);
        if (x.m_vector) {
            ASR::expr_t** current_expr_copy_288 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_vector));
            self().call_replacer();
            current_expr = current_expr_copy_288;
            if( x.m_vector && visit_expr_after_replacement )
            self().visit_expr(*x.m_vector);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_289 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_289;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        ASR::expr_t** current_expr_copy_290 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_array));
        self().call_replacer();
        current_expr = current_expr_copy_290;
        if( x.m_array && visit_expr_after_replacement )
        self().visit_expr(*x.m_array);
        ASR::expr_t** current_expr_copy_291 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_shape));
        self().call_replacer();
        current_expr = current_expr_copy_291;
        if( x.m_shape && visit_expr_after_replacement )
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_292 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_292;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        ASR::expr_t** current_expr_copy_293 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_array));
        self().call_replacer();
        current_expr = current_expr_copy_293;
        if( x.m_array && visit_expr_after_replacement )
        self().visit_expr(*x.m_array);
        ASR::expr_t** current_expr_copy_294 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_shape));
        self().call_replacer();
        current_expr = current_expr_copy_294;
        if( x.m_shape && visit_expr_after_replacement )
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_295 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_295;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_BitCast(const BitCast_t &x) {
        ASR::expr_t** current_expr_copy_296 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_source));
        self().call_replacer();
        current_expr = current_expr_copy_296;
        if( x.m_source && visit_expr_after_replacement )
        self().visit_expr(*x.m_source);
        ASR::expr_t** current_expr_copy_297 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_mold));
        self().call_replacer();
        current_expr = current_expr_copy_297;
        if( x.m_mold && visit_expr_after_replacement )
        self().visit_expr(*x.m_mold);
        if (x.m_size) {
            ASR::expr_t** current_expr_copy_298 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_size));
            self().call_replacer();
            current_expr = current_expr_copy_298;
            if( x.m_size && visit_expr_after_replacement )
            self().visit_expr(*x.m_size);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_299 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_299;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        ASR::expr_t** current_expr_copy_300 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_300;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_301 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_301;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        ASR::expr_t** current_expr_copy_302 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_302;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_303 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_303;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        ASR::expr_t** current_expr_copy_304 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_304;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_305 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_305;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        ASR::expr_t** current_expr_copy_306 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_306;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_307 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_307;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_EnumName(const EnumName_t &x) {
        ASR::expr_t** current_expr_copy_308 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_308;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_309 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_309;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_EnumValue(const EnumValue_t &x) {
        ASR::expr_t** current_expr_copy_310 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
        self().call_replacer();
        current_expr = current_expr_copy_310;
        if( x.m_v && visit_expr_after_replacement )
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_311 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_311;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        ASR::expr_t** current_expr_copy_312 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_312;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_313 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_313;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_314 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_314;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
        ASR::expr_t** current_expr_copy_315 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_overloaded));
        self().call_replacer();
        current_expr = current_expr_copy_315;
        if( x.m_overloaded && visit_expr_after_replacement )
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        ASR::expr_t** current_expr_copy_316 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_316;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_317 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_317;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_318 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_318;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
        ASR::expr_t** current_expr_copy_319 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_overloaded));
        self().call_replacer();
        current_expr = current_expr_copy_319;
        if( x.m_overloaded && visit_expr_after_replacement )
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        ASR::expr_t** current_expr_copy_320 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_320;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_321 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_321;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
        ASR::expr_t** current_expr_copy_322 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_overloaded));
        self().call_replacer();
        current_expr = current_expr_copy_322;
        if( x.m_overloaded && visit_expr_after_replacement )
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        ASR::expr_t** current_expr_copy_323 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_323;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_324 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_324;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_325 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_325;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
        ASR::expr_t** current_expr_copy_326 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_overloaded));
        self().call_replacer();
        current_expr = current_expr_copy_326;
        if( x.m_overloaded && visit_expr_after_replacement )
        self().visit_expr(*x.m_overloaded);
    }
    void visit_Cast(const Cast_t &x) {
        ASR::expr_t** current_expr_copy_327 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_327;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_328 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_328;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        ASR::expr_t** current_expr_copy_329 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_329;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_330 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_330;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        ASR::expr_t** current_expr_copy_331 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_331;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_332 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_332;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        ASR::expr_t** current_expr_copy_333 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_333;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_334 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_334;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_DictItem(const DictItem_t &x) {
        ASR::expr_t** current_expr_copy_335 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_335;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_336 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_key));
        self().call_replacer();
        current_expr = current_expr_copy_336;
        if( x.m_key && visit_expr_after_replacement )
        self().visit_expr(*x.m_key);
        if (x.m_default) {
            ASR::expr_t** current_expr_copy_337 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_default));
            self().call_replacer();
            current_expr = current_expr_copy_337;
            if( x.m_default && visit_expr_after_replacement )
            self().visit_expr(*x.m_default);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_338 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_338;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_CLoc(const CLoc_t &x) {
        ASR::expr_t** current_expr_copy_339 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_339;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_340 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_340;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        ASR::expr_t** current_expr_copy_341 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_341;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_342 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_342;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_GetPointer(const GetPointer_t &x) {
        ASR::expr_t** current_expr_copy_343 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_343;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_344 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_344;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListItem(const ListItem_t &x) {
        ASR::expr_t** current_expr_copy_345 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_345;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_346 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_pos));
        self().call_replacer();
        current_expr = current_expr_copy_346;
        if( x.m_pos && visit_expr_after_replacement )
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_347 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_347;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_TupleItem(const TupleItem_t &x) {
        ASR::expr_t** current_expr_copy_348 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_348;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_349 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_pos));
        self().call_replacer();
        current_expr = current_expr_copy_349;
        if( x.m_pos && visit_expr_after_replacement )
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_350 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_350;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListSection(const ListSection_t &x) {
        ASR::expr_t** current_expr_copy_351 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_351;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        self().visit_array_index(x.m_section);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_352 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_352;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        ASR::expr_t** current_expr_copy_353 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_353;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_354 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_354;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_355 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_355;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_DictPop(const DictPop_t &x) {
        ASR::expr_t** current_expr_copy_356 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_356;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        ASR::expr_t** current_expr_copy_357 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_key));
        self().call_replacer();
        current_expr = current_expr_copy_357;
        if( x.m_key && visit_expr_after_replacement )
        self().visit_expr(*x.m_key);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_358 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_358;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_SetPop(const SetPop_t &x) {
        ASR::expr_t** current_expr_copy_359 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_359;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_360 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_360;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_SetContains(const SetContains_t &x) {
        ASR::expr_t** current_expr_copy_361 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_361;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_362 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_362;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_363 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_363;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_DictContains(const DictContains_t &x) {
        ASR::expr_t** current_expr_copy_364 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
        self().call_replacer();
        current_expr = current_expr_copy_364;
        if( x.m_left && visit_expr_after_replacement )
        self().visit_expr(*x.m_left);
        ASR::expr_t** current_expr_copy_365 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
        self().call_replacer();
        current_expr = current_expr_copy_365;
        if( x.m_right && visit_expr_after_replacement )
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_366 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_366;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        ASR::expr_t** current_expr_copy_367 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_367;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_368 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_368;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_Ichar(const Ichar_t &x) {
        ASR::expr_t** current_expr_copy_369 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_369;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_370 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_370;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_Iachar(const Iachar_t &x) {
        ASR::expr_t** current_expr_copy_371 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_371;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_372 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_372;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        self().visit_ttype(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_373 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_373;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        ASR::expr_t** current_expr_copy_374 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_ptr));
        self().call_replacer();
        current_expr = current_expr_copy_374;
        if( x.m_ptr && visit_expr_after_replacement )
        self().visit_expr(*x.m_ptr);
        if (x.m_tgt) {
            ASR::expr_t** current_expr_copy_375 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_tgt));
            self().call_replacer();
            current_expr = current_expr_copy_375;
            if( x.m_tgt && visit_expr_after_replacement )
            self().visit_expr(*x.m_tgt);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_376 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_376;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        ASR::expr_t** current_expr_copy_377 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_377;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_378 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_378;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_ArrayIsContiguous(const ArrayIsContiguous_t &x) {
        ASR::expr_t** current_expr_copy_379 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_array));
        self().call_replacer();
        current_expr = current_expr_copy_379;
        if( x.m_array && visit_expr_after_replacement )
        self().visit_expr(*x.m_array);
        self().visit_ttype(*x.m_type);
        if (x.m_value) {
            if (call_replacer_on_value) {
                ASR::expr_t** current_expr_copy_380 = current_expr;
                current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
                self().call_replacer();
                current_expr = current_expr_copy_380;
            }
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_Integer(const Integer_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_String(const String_t &x) {
        if (x.m_len_expr) {
            ASR::expr_t** current_expr_copy_381 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_len_expr));
            self().call_replacer();
            current_expr = current_expr_copy_381;
            if( x.m_len_expr && visit_expr_after_replacement )
            self().visit_expr(*x.m_len_expr);
        }
    }
    void visit_Logical(const Logical_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_List(const List_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Tuple(const Tuple_t &x) {
        for (size_t i=0; i<x.n_type; i++) {
            self().visit_ttype(*x.m_type[i]);
        }
    }
    void visit_StructType(const StructType_t &x) {
        for (size_t i=0; i<x.n_data_member_types; i++) {
            self().visit_ttype(*x.m_data_member_types[i]);
        }
        for (size_t i=0; i<x.n_member_function_types; i++) {
            self().visit_ttype(*x.m_member_function_types[i]);
        }
    }
    void visit_EnumType(const EnumType_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionType(const UnionType_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassType(const ClassType_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Dict(const Dict_t &x) {
        self().visit_ttype(*x.m_key_type);
        self().visit_ttype(*x.m_value_type);
    }
    void visit_Pointer(const Pointer_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Allocatable(const Allocatable_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_CPtr(const CPtr_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        self().visit_ttype(*x.m_type);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_FunctionType(const FunctionType_t &x) {
        for (size_t i=0; i<x.n_arg_types; i++) {
            self().visit_ttype(*x.m_arg_types[i]);
        }
        if (x.m_return_var_type) {
            self().visit_ttype(*x.m_return_var_type);
        }
        for (size_t i=0; i<x.n_restrictions; i++) {
        }
    }
    void visit_dimension(const dimension_t &x) {
        if (x.m_start) {
            ASR::expr_t** current_expr_copy_382 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_start));
            self().call_replacer();
            current_expr = current_expr_copy_382;
            if( x.m_start && visit_expr_after_replacement )
            self().visit_expr(*x.m_start);
        }
        if (x.m_length) {
            ASR::expr_t** current_expr_copy_383 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_length));
            self().call_replacer();
            current_expr = current_expr_copy_383;
            if( x.m_length && visit_expr_after_replacement )
            self().visit_expr(*x.m_length);
        }
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        ASR::expr_t** current_expr_copy_384 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_a));
        self().call_replacer();
        current_expr = current_expr_copy_384;
        if( x.m_a && visit_expr_after_replacement )
        self().visit_expr(*x.m_a);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
        if (x.m_len_expr) {
            ASR::expr_t** current_expr_copy_385 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_len_expr));
            self().call_replacer();
            current_expr = current_expr_copy_385;
            if( x.m_len_expr && visit_expr_after_replacement )
            self().visit_expr(*x.m_len_expr);
        }
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        }
    }
    void visit_Attribute(const Attribute_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_attribute_arg(x.m_args[i]);
        }
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        if (x.m_value) {
            ASR::expr_t** current_expr_copy_386 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_value));
            self().call_replacer();
            current_expr = current_expr_copy_386;
            if( x.m_value && visit_expr_after_replacement )
            self().visit_expr(*x.m_value);
        }
    }
    void visit_reduction_expr(const reduction_expr_t &x) {
        ASR::expr_t** current_expr_copy_387 = current_expr;
        current_expr = const_cast<ASR::expr_t**>(&(x.m_arg));
        self().call_replacer();
        current_expr = current_expr_copy_387;
        if( x.m_arg && visit_expr_after_replacement )
        self().visit_expr(*x.m_arg);
    }
    void visit_Bind(const Bind_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        if (x.m_left) {
            ASR::expr_t** current_expr_copy_388 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_left));
            self().call_replacer();
            current_expr = current_expr_copy_388;
            if( x.m_left && visit_expr_after_replacement )
            self().visit_expr(*x.m_left);
        }
        if (x.m_right) {
            ASR::expr_t** current_expr_copy_389 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_right));
            self().call_replacer();
            current_expr = current_expr_copy_389;
            if( x.m_right && visit_expr_after_replacement )
            self().visit_expr(*x.m_right);
        }
        if (x.m_step) {
            ASR::expr_t** current_expr_copy_390 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_step));
            self().call_replacer();
            current_expr = current_expr_copy_390;
            if( x.m_step && visit_expr_after_replacement )
            self().visit_expr(*x.m_step);
        }
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        if (x.m_v) {
            ASR::expr_t** current_expr_copy_391 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_v));
            self().call_replacer();
            current_expr = current_expr_copy_391;
            if( x.m_v && visit_expr_after_replacement )
            self().visit_expr(*x.m_v);
        }
        if (x.m_start) {
            ASR::expr_t** current_expr_copy_392 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_start));
            self().call_replacer();
            current_expr = current_expr_copy_392;
            if( x.m_start && visit_expr_after_replacement )
            self().visit_expr(*x.m_start);
        }
        if (x.m_end) {
            ASR::expr_t** current_expr_copy_393 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_end));
            self().call_replacer();
            current_expr = current_expr_copy_393;
            if( x.m_end && visit_expr_after_replacement )
            self().visit_expr(*x.m_end);
        }
        if (x.m_increment) {
            ASR::expr_t** current_expr_copy_394 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_increment));
            self().call_replacer();
            current_expr = current_expr_copy_394;
            if( x.m_increment && visit_expr_after_replacement )
            self().visit_expr(*x.m_increment);
        }
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        CaseStmt_t& xx = const_cast<CaseStmt_t&>(x);
        for (size_t i=0; i<x.n_test; i++) {
            ASR::expr_t** current_expr_copy_395 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_test[i]));
            self().call_replacer();
            current_expr = current_expr_copy_395;
            if( x.m_test[i] && visit_expr_after_replacement )
            self().visit_expr(*x.m_test[i]);
        }
        self().transform_stmts(xx.m_body, xx.n_body);
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        CaseStmt_Range_t& xx = const_cast<CaseStmt_Range_t&>(x);
        if (x.m_start) {
            ASR::expr_t** current_expr_copy_396 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_start));
            self().call_replacer();
            current_expr = current_expr_copy_396;
            if( x.m_start && visit_expr_after_replacement )
            self().visit_expr(*x.m_start);
        }
        if (x.m_end) {
            ASR::expr_t** current_expr_copy_397 = current_expr;
            current_expr = const_cast<ASR::expr_t**>(&(x.m_end));
            self().call_replacer();
            current_expr = current_expr_copy_397;
            if( x.m_end && visit_expr_after_replacement )
            self().visit_expr(*x.m_end);
        }
        self().transform_stmts(xx.m_body, xx.n_body);
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        TypeStmtName_t& xx = const_cast<TypeStmtName_t&>(x);
        self().transform_stmts(xx.m_body, xx.n_body);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        ClassStmt_t& xx = const_cast<ClassStmt_t&>(x);
        self().transform_stmts(xx.m_body, xx.n_body);
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        TypeStmtType_t& xx = const_cast<TypeStmtType_t&>(x);
        self().visit_ttype(*x.m_type);
        self().transform_stmts(xx.m_body, xx.n_body);
    }
    void visit_Require(const Require_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
};


}
