#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Pickle Visitor base class

template <class StructType>
class PickleBaseVisitor : public BaseVisitor<StructType>
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    std::string s, indented = "";
    bool use_colors;
    bool indent;
    int indent_level = 0, indent_spaces = 4;
public:
    PickleBaseVisitor() : use_colors(false), indent(false) { s.reserve(100000); }
    void inc_indent() {
        indent_level++;
        indented = std::string(indent_level*indent_spaces, ' ');
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indented = std::string(indent_level*indent_spaces, ' ');
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TranslationUnit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_asr(*x.m_items[i]);
            if (i < x.n_items-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Program");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Module(const Module_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_loaded_from_mod) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_intrinsic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Function");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_function_signature);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_deterministic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_side_effect_free) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_module_file) {
            s.append("\"" + str_escape_c(x.m_module_file) + "\"");
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_procs; i++) {
            self().visit_symbol(*x.m_procs[i]);
            if (i < x.n_procs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CustomOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_procs; i++) {
            self().visit_symbol(*x.m_procs[i]);
            if (i < x.n_procs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExternalSymbol");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_external);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_module_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_scope_names; i++) {
            s.append(x.m_scope_names[i]);
            if (i < x.n_scope_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_original_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Struct(const Struct_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Struct");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_packed) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_abstract) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
            if (i < x.n_initializers-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_alignment) {
            self().visit_expr(*x.m_alignment);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Enum(const Enum_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Enum");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_enumtypeType(x.m_enum_value_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Union(const Union_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Union");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
            if (i < x.n_initializers-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Variable(const Variable_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Variable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_intentType(x.m_intent);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_symbolic_value) {
            self().visit_expr(*x.m_symbolic_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_storage_typeType(x.m_storage);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type_declaration) {
            self().visit_symbol(*x.m_type_declaration);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_presenceType(x.m_presence);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value_attr) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_target_attr) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Class(const Class_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Class");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_self_argument) {
            s.append(x.m_self_argument);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_proc_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_proc);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_deferred) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_nopass) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlock");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Block(const Block_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Block");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Requirement(const Requirement_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Requirement");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
            if (i < x.n_requires-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Template(const Template_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Template");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
            if (i < x.n_requires-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Allocate(const Allocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stat) {
            self().visit_expr(*x.m_stat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_errmsg) {
            self().visit_expr(*x.m_errmsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_source) {
            self().visit_expr(*x.m_source);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ReAlloc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Assign(const Assign_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_variable);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Associate(const Associate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Associate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoConcurrentLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_head; i++) {
            self().visit_do_loop_head(x.m_head[i]);
            if (i < x.n_head-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_shared; i++) {
            self().visit_expr(*x.m_shared[i]);
            if (i < x.n_shared-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_local; i++) {
            self().visit_expr(*x.m_local[i]);
            if (i < x.n_local-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_reduction; i++) {
            self().visit_reduction_expr(x.m_reduction[i]);
            if (i < x.n_reduction-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_do_loop_head(x.m_head);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ErrorStop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Exit(const Exit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAllSingle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_do_loop_head(x.m_head);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_stmt(*x.m_assign_stmt);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GoTo(const GoTo_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoTo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_target_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoToTarget");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("If");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfArithmetic");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_lt_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_eq_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_gt_label));
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Print(const Print_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_text);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileOpen(const FileOpen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileOpen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_newunit) {
            self().visit_expr(*x.m_newunit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_filename) {
            self().visit_expr(*x.m_filename);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileClose(const FileClose_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileClose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileRead(const FileRead_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileBackspace");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileRewind(const FileRewind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRewind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileInquire(const FileInquire_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileInquire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_file) {
            self().visit_expr(*x.m_file);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_exist) {
            self().visit_expr(*x.m_exist);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_opened) {
            self().visit_expr(*x.m_opened);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_number) {
            self().visit_expr(*x.m_number);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_named) {
            self().visit_expr(*x.m_named);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_name) {
            self().visit_expr(*x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_access) {
            self().visit_expr(*x.m_access);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_sequential) {
            self().visit_expr(*x.m_sequential);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_direct) {
            self().visit_expr(*x.m_direct);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_formatted) {
            self().visit_expr(*x.m_formatted);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unformatted) {
            self().visit_expr(*x.m_unformatted);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_recl) {
            self().visit_expr(*x.m_recl);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_nextrec) {
            self().visit_expr(*x.m_nextrec);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_blank) {
            self().visit_expr(*x.m_blank);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_position) {
            self().visit_expr(*x.m_position);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_action) {
            self().visit_expr(*x.m_action);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_read) {
            self().visit_expr(*x.m_read);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_write) {
            self().visit_expr(*x.m_write);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_readwrite) {
            self().visit_expr(*x.m_readwrite);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_delim) {
            self().visit_expr(*x.m_delim);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_pad) {
            self().visit_expr(*x.m_pad);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_flen) {
            self().visit_expr(*x.m_flen);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_blocksize) {
            self().visit_expr(*x.m_blocksize);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_convert) {
            self().visit_expr(*x.m_convert);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_carriagecontrol) {
            self().visit_expr(*x.m_carriagecontrol);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iolength) {
            self().visit_expr(*x.m_iolength);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileWrite(const FileWrite_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Return(const Return_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Return");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
            if (i < x.n_default-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_enable_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Stop(const Stop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Assert(const Assert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_msg) {
            self().visit_expr(*x.m_msg);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SubroutineCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureSubroutine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_sub_intrinsic_id(x.m_sub_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Where(const Where_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("WhileLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Nullify(const Nullify_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Nullify");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Flush(const Flush_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Flush");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_unit);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListAppend(const ListAppend_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListAppend");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_m);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SelectType(const SelectType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_selector);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
            if (i < x.n_default-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrToPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_cptr);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ptr);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_shape) {
            self().visit_expr(*x.m_shape);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_lower_bounds) {
            self().visit_expr(*x.m_lower_bounds);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BlockCall(const BlockCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetInsert(const SetInsert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetRemove(const SetRemove_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListInsert(const ListInsert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_pos);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListRemove(const ListRemove_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListClear(const ListClear_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListClear");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictInsert(const DictInsert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_key);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Expr(const Expr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Expr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_expression);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IfExp(const IfExp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfExp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_body);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_orelse);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_re);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_im);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("NamedExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicElementalFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_intrinsic_id(x.m_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicArrayFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_array_intrinsic_id(x.m_arr_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_impure_intrinsic_id(x.m_impure_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeInquiry");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_intrinsic_id(x.m_inquiry_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_arg_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_arg) {
            self().visit_expr(*x.m_arg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructConstructor(const StructConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_dt_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumConstructor(const EnumConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_dt_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnionConstructor(const UnionConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_dt_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImpliedDoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_var);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_start);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_end);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_n));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_integerbozType(x.m_intboz_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_n));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealConstant(const RealConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_r));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealCompare(const RealCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCopySign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_source);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_re));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_im));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_value) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_logicalbinopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListConstant(const ListConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListLen(const ListLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListConcat(const ListConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListCompare(const ListCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListCount(const ListCount_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCount");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetConstant(const SetConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
            if (i < x.n_elements-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetLen(const SetLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
            if (i < x.n_elements-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleLen(const TupleLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringConstant(const StringConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringConcat(const StringConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringLen(const StringLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringItem(const StringItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_idx);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringSection(const StringSection_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringCompare(const StringCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringContains(const StringContains_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringContains");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_substr);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_str);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringOrd(const StringOrd_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringOrd");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringChr(const StringChr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringChr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringFormat(const StringFormat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringFormat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_string_format_kindType(x.m_kind);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringPhysicalCast(const StringPhysicalCast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringPhysicalCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_string_physical_typeType(x.m_old);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_string_physical_typeType(x.m_new);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictConstant(const DictConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_keys; i++) {
            self().visit_expr(*x.m_keys[i]);
            if (i < x.n_keys-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictLen(const DictLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Var(const Var_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Var");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        self().visit_symbol(*x.m_v);
        s.append(")");
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionParam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_param_number));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arraystorageType(x.m_storage_format);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_n_data));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arraystorageType(x.m_storage_format);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arraystorageType(x.m_storage_format);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArraySection(const ArraySection_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArraySize(const ArraySize_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySize");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBound");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arrayboundType(x.m_bound);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayTranspose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_matrix);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPack");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_array);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_mask);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_vector) {
            self().visit_expr(*x.m_vector);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayReshape");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_array);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_shape);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBroadcast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_array);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_shape);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BitCast(const BitCast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BitCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_source);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_mold);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumName(const EnumName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_enum_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumValue(const EnumValue_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumValue");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_enum_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedStringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Cast(const Cast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cast_kindType(x.m_kind);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPhysicalCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_array_physical_typeType(x.m_old);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_array_physical_typeType(x.m_new);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexRe");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexIm");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictItem(const DictItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_key);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_default) {
            self().visit_expr(*x.m_default);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CLoc(const CLoc_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CLoc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerToCPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GetPointer(const GetPointer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GetPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListItem(const ListItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_pos);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleItem(const TupleItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_pos);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListSection(const ListSection_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_array_index(x.m_section);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictPop(const DictPop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_key);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetPop(const SetPop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Ichar(const Ichar_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Ichar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Iachar(const Iachar_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Iachar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SizeOfType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerNullConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerAssociated");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_ptr);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_tgt) {
            self().visit_expr(*x.m_tgt);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealSqrt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Integer(const Integer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Integer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedInteger");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_kind));
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Complex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_String(const String_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("String");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(" ");
        s.append(std::to_string(x.m_len));
        s.append(" ");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("()");
        }
        s.append(" ");
        visit_string_physical_typeType(x.m_physical_type);
        s.append(")");
    }
    void visit_Logical(const Logical_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Logical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Set");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_List(const List_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("List");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Tuple(const Tuple_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Tuple");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_type; i++) {
            self().visit_ttype(*x.m_type[i]);
            if (i < x.n_type-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructType(const StructType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_derived_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumType(const EnumType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_enum_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnionType(const UnionType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_union_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ClassType(const ClassType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_class_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Dict(const Dict_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Dict");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_key_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_value_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Pointer(const Pointer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Pointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Allocatable(const Allocatable_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocatable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CPtr(const CPtr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicExpression");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeParameter");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_param);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Array");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_array_physical_typeType(x.m_physical_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FunctionType(const FunctionType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_arg_types; i++) {
            self().visit_ttype(*x.m_arg_types[i]);
            if (i < x.n_arg_types-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_return_var_type) {
            self().visit_ttype(*x.m_return_var_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_deftypeType(x.m_deftype);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_bindc_name) {
            s.append("\"" + str_escape_c(x.m_bindc_name) + "\"");
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_elemental) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_pure) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_module) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_inline) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_static) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_restrictions; i++) {
            self().visit_symbol(*x.m_restrictions[i]);
            if (i < x.n_restrictions-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_restriction) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_cast_kindType(const cast_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cast_kindType::RealToInteger) : {
                s.append("RealToInteger");
             break; }
            case (cast_kindType::IntegerToReal) : {
                s.append("IntegerToReal");
             break; }
            case (cast_kindType::LogicalToReal) : {
                s.append("LogicalToReal");
             break; }
            case (cast_kindType::RealToReal) : {
                s.append("RealToReal");
             break; }
            case (cast_kindType::IntegerToInteger) : {
                s.append("IntegerToInteger");
             break; }
            case (cast_kindType::RealToComplex) : {
                s.append("RealToComplex");
             break; }
            case (cast_kindType::IntegerToComplex) : {
                s.append("IntegerToComplex");
             break; }
            case (cast_kindType::IntegerToLogical) : {
                s.append("IntegerToLogical");
             break; }
            case (cast_kindType::RealToLogical) : {
                s.append("RealToLogical");
             break; }
            case (cast_kindType::StringToLogical) : {
                s.append("StringToLogical");
             break; }
            case (cast_kindType::StringToInteger) : {
                s.append("StringToInteger");
             break; }
            case (cast_kindType::StringToList) : {
                s.append("StringToList");
             break; }
            case (cast_kindType::ComplexToLogical) : {
                s.append("ComplexToLogical");
             break; }
            case (cast_kindType::ComplexToComplex) : {
                s.append("ComplexToComplex");
             break; }
            case (cast_kindType::ComplexToReal) : {
                s.append("ComplexToReal");
             break; }
            case (cast_kindType::ComplexToInteger) : {
                s.append("ComplexToInteger");
             break; }
            case (cast_kindType::LogicalToInteger) : {
                s.append("LogicalToInteger");
             break; }
            case (cast_kindType::RealToString) : {
                s.append("RealToString");
             break; }
            case (cast_kindType::IntegerToString) : {
                s.append("IntegerToString");
             break; }
            case (cast_kindType::LogicalToString) : {
                s.append("LogicalToString");
             break; }
            case (cast_kindType::UnsignedIntegerToInteger) : {
                s.append("UnsignedIntegerToInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToUnsignedInteger) : {
                s.append("UnsignedIntegerToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToReal) : {
                s.append("UnsignedIntegerToReal");
             break; }
            case (cast_kindType::UnsignedIntegerToLogical) : {
                s.append("UnsignedIntegerToLogical");
             break; }
            case (cast_kindType::IntegerToUnsignedInteger) : {
                s.append("IntegerToUnsignedInteger");
             break; }
            case (cast_kindType::RealToUnsignedInteger) : {
                s.append("RealToUnsignedInteger");
             break; }
            case (cast_kindType::CPtrToUnsignedInteger) : {
                s.append("CPtrToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToCPtr) : {
                s.append("UnsignedIntegerToCPtr");
             break; }
            case (cast_kindType::IntegerToSymbolicExpression) : {
                s.append("IntegerToSymbolicExpression");
             break; }
            case (cast_kindType::ListToArray) : {
                s.append("ListToArray");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_storage_typeType(const storage_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (storage_typeType::Default) : {
                s.append("Default");
             break; }
            case (storage_typeType::Save) : {
                s.append("Save");
             break; }
            case (storage_typeType::Parameter) : {
                s.append("Parameter");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_accessType(const accessType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (accessType::Public) : {
                s.append("Public");
             break; }
            case (accessType::Private) : {
                s.append("Private");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_intentType(const intentType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (intentType::Local) : {
                s.append("Local");
             break; }
            case (intentType::In) : {
                s.append("In");
             break; }
            case (intentType::Out) : {
                s.append("Out");
             break; }
            case (intentType::InOut) : {
                s.append("InOut");
             break; }
            case (intentType::ReturnVar) : {
                s.append("ReturnVar");
             break; }
            case (intentType::Unspecified) : {
                s.append("Unspecified");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_deftypeType(const deftypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (deftypeType::Implementation) : {
                s.append("Implementation");
             break; }
            case (deftypeType::Interface) : {
                s.append("Interface");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_presenceType(const presenceType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (presenceType::Required) : {
                s.append("Required");
             break; }
            case (presenceType::Optional) : {
                s.append("Optional");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_abiType(const abiType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (abiType::Source) : {
                s.append("Source");
             break; }
            case (abiType::LFortranModule) : {
                s.append("LFortranModule");
             break; }
            case (abiType::GFortranModule) : {
                s.append("GFortranModule");
             break; }
            case (abiType::BindC) : {
                s.append("BindC");
             break; }
            case (abiType::BindPython) : {
                s.append("BindPython");
             break; }
            case (abiType::BindJS) : {
                s.append("BindJS");
             break; }
            case (abiType::Interactive) : {
                s.append("Interactive");
             break; }
            case (abiType::Intrinsic) : {
                s.append("Intrinsic");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_dimension(const dimension_t &x) {
        s.append("(");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        s.append("(");
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_Attribute(const Attribute_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Attribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_attribute_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        s.append("(");
        s.append(x.m_arg);
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        s.append("(");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_reduction_expr(const reduction_expr_t &x) {
        s.append("(");
        visit_reduction_opType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_arg);
        s.append(")");
    }
    void visit_Bind(const Bind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_lang) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_name) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        s.append("(");
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        s.append("(");
        if (x.m_v) {
            self().visit_expr(*x.m_v);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_test; i++) {
            self().visit_expr(*x.m_test[i]);
            if (i < x.n_test-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt_Range");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_enumtypeType(const enumtypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (enumtypeType::IntegerConsecutiveFromZero) : {
                s.append("IntegerConsecutiveFromZero");
             break; }
            case (enumtypeType::IntegerUnique) : {
                s.append("IntegerUnique");
             break; }
            case (enumtypeType::IntegerNotUnique) : {
                s.append("IntegerNotUnique");
             break; }
            case (enumtypeType::NonInteger) : {
                s.append("NonInteger");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_Require(const Require_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Require");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_physical_typeType(const array_physical_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (array_physical_typeType::DescriptorArray) : {
                s.append("DescriptorArray");
             break; }
            case (array_physical_typeType::PointerToDataArray) : {
                s.append("PointerToDataArray");
             break; }
            case (array_physical_typeType::UnboundedPointerToDataArray) : {
                s.append("UnboundedPointerToDataArray");
             break; }
            case (array_physical_typeType::FixedSizeArray) : {
                s.append("FixedSizeArray");
             break; }
            case (array_physical_typeType::StringArraySinglePointer) : {
                s.append("StringArraySinglePointer");
             break; }
            case (array_physical_typeType::NumPyArray) : {
                s.append("NumPyArray");
             break; }
            case (array_physical_typeType::ISODescriptorArray) : {
                s.append("ISODescriptorArray");
             break; }
            case (array_physical_typeType::SIMDArray) : {
                s.append("SIMDArray");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_string_physical_typeType(const string_physical_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (string_physical_typeType::PointerString) : {
                s.append("PointerString");
             break; }
            case (string_physical_typeType::DescriptorString) : {
                s.append("DescriptorString");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_binopType(const binopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (binopType::Add) : {
                s.append("Add");
             break; }
            case (binopType::Sub) : {
                s.append("Sub");
             break; }
            case (binopType::Mul) : {
                s.append("Mul");
             break; }
            case (binopType::Div) : {
                s.append("Div");
             break; }
            case (binopType::Pow) : {
                s.append("Pow");
             break; }
            case (binopType::BitAnd) : {
                s.append("BitAnd");
             break; }
            case (binopType::BitOr) : {
                s.append("BitOr");
             break; }
            case (binopType::BitXor) : {
                s.append("BitXor");
             break; }
            case (binopType::BitLShift) : {
                s.append("BitLShift");
             break; }
            case (binopType::BitRShift) : {
                s.append("BitRShift");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_reduction_opType(const reduction_opType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (reduction_opType::ReduceAdd) : {
                s.append("ReduceAdd");
             break; }
            case (reduction_opType::ReduceSub) : {
                s.append("ReduceSub");
             break; }
            case (reduction_opType::ReduceMul) : {
                s.append("ReduceMul");
             break; }
            case (reduction_opType::ReduceMIN) : {
                s.append("ReduceMIN");
             break; }
            case (reduction_opType::ReduceMAX) : {
                s.append("ReduceMAX");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_logicalbinopType(const logicalbinopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (logicalbinopType::And) : {
                s.append("And");
             break; }
            case (logicalbinopType::Or) : {
                s.append("Or");
             break; }
            case (logicalbinopType::Xor) : {
                s.append("Xor");
             break; }
            case (logicalbinopType::NEqv) : {
                s.append("NEqv");
             break; }
            case (logicalbinopType::Eqv) : {
                s.append("Eqv");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("Eq");
             break; }
            case (cmpopType::NotEq) : {
                s.append("NotEq");
             break; }
            case (cmpopType::Lt) : {
                s.append("Lt");
             break; }
            case (cmpopType::LtE) : {
                s.append("LtE");
             break; }
            case (cmpopType::Gt) : {
                s.append("Gt");
             break; }
            case (cmpopType::GtE) : {
                s.append("GtE");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_integerbozType(const integerbozType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (integerbozType::Binary) : {
                s.append("Binary");
             break; }
            case (integerbozType::Hex) : {
                s.append("Hex");
             break; }
            case (integerbozType::Octal) : {
                s.append("Octal");
             break; }
            case (integerbozType::Decimal) : {
                s.append("Decimal");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arrayboundType(const arrayboundType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arrayboundType::LBound) : {
                s.append("LBound");
             break; }
            case (arrayboundType::UBound) : {
                s.append("UBound");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arraystorageType(const arraystorageType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arraystorageType::RowMajor) : {
                s.append("RowMajor");
             break; }
            case (arraystorageType::ColMajor) : {
                s.append("ColMajor");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_string_format_kindType(const string_format_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (string_format_kindType::FormatFortran) : {
                s.append("FormatFortran");
             break; }
            case (string_format_kindType::FormatC) : {
                s.append("FormatC");
             break; }
            case (string_format_kindType::FormatPythonPercent) : {
                s.append("FormatPythonPercent");
             break; }
            case (string_format_kindType::FormatPythonFString) : {
                s.append("FormatPythonFString");
             break; }
            case (string_format_kindType::FormatPythonFormat) : {
                s.append("FormatPythonFormat");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
};


}
