#ifndef _DOCUMENT_H_INCLUDED_
#define _DOCUMENT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Document.h
// ------
// XML document class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Document
// 
// Description: XML document container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "Element.h"
#include "Attribute.h"

class Document {
 
 public:

    Document();
    Document(const Chain& docName);
    Document(Element* pRootElement);
    ~Document();

    const Chain& getName();

    void setRootElement(Element* pRootElement);
    Element* getRootElement();

    void setDocType(const Chain& docType);
    const Chain& getDocType() const;

    void setAttributeList(const ListT<Attribute>& attrList);
    void setAttribute(const Chain& attr, const Chain& value);
    Chain getAttributeValue(const Chain& attr) const;

    const ListT<Attribute>& getAttributeList() const;

    Document& operator =  ( const Document& d);
    bool operator == ( const Document& d) const;

    void clear();

private:
    
    ListT<Attribute> _attrList;
    Element* _pRootElement;
    Chain _docType;
    Chain _docName;
     
};
#endif
