#ifndef _ATTRIBUTE_H_INCLUDED_
#define _ATTRIBUTE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//
// Attribute.h
// -----------
// XML Attribute implementation
//               
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Attribute
// 
// Description: XML attribute container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>

class Attribute {
 
 public:
  
    Attribute();
    Attribute(const Chain& name);
    Attribute(const Chain& name, const Chain& value, bool treatXMLEscape = true);
     ~Attribute();
     
     const Chain& getName() const;

     Chain getXMLValue() const;
     
     void setValue(const Chain& value, bool treatXMLEscape = true);
     Chain getValue() const;

     Attribute& operator =  ( const Attribute& attr);
     bool operator == ( const Attribute& attr) const;
        
 private:
     
     Chain _name;
     Chain _value;
  
};
#endif
