///////////////////////////////////////////////////////////////////////////////
//                                                         
// Timer.cc
// -------
// Timer implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// IMPLEMENTATION MODULE
//
// Class: Timer
// 
// Description: Timer class for time measurement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <signal.h>
#include "Exception.h"
#include "Timer.h"

Timer::Timer(int s, int p)
{
    _scale = s;
    _precision = p;
    
    _sumSec = 0;
    _sumUSec = 0;

}

Timer::~Timer()
{
}

void Timer::start()
{

    struct timeval tval;
   
    if (gettimeofday(&tval, NULL) != 0)
    {
	throw Exception(EXLOC, "system error");
    }
    
    _sec = tval.tv_sec;
    _usec = tval.tv_usec;    
}

void Timer::stop()
{

    struct timeval tval;
   
    if (gettimeofday(&tval, NULL) != 0)
    {
	throw Exception(EXLOC, "system error");
    }
    
    if ( _usec > tval.tv_usec )
    {
	_sec = tval.tv_sec - _sec - 1;
	_usec = 1000000 + tval.tv_usec - _usec;
    }
    else
    {
	_sec = tval.tv_sec - _sec;
	_usec = tval.tv_usec - _usec;
    }

    _sumSec += _sec + ( (_sumUSec +_usec )  / 1000000 );
    _sumUSec = ( _sumUSec + _usec) % 1000000;
}

void Timer::reset()
{    
    _sumSec = 0;
    _sumUSec = 0;   
}

long Timer::getSumSec() const
{
    return _sumSec;
}

long Timer::getSumUSec() const
{
    return _sumUSec;
}

Chain Timer::getUsed() const
{
    Chain sec((unsigned long)_sec);
    Chain usec((unsigned long)(1000000 + _usec));
    return sec + Chain(".") + usec.subChain(2,1 + _precision);
}

ostream& operator << (ostream& s, const  Timer& t)
{
    s << t.getUsed();
    return s;
}
