#ifndef _SHAREDMEMORY_H_INCLUDED_
#define _SHAREDMEMORY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// SharedMemory.h
// --------------
// Shared memory class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: SharedMemory 
// 
// Description: Utility class for shared memory management
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

class SharedMemory {

public:

     SharedMemory(int key);
     ~SharedMemory();
     
     void create(unsigned long size, int shmflag = 0666);
     void destroy();

     void attach(int shmflag = 0666);
     void detach();
     
     int getId();
     void* getAddr();

     void printInfo();

private:     

     int _key;
     int _id;
     void* _addr;

};
#endif
