#ifndef _PAGER_H_INCLUDED_ 
#define _PAGER_H_INCLUDED_ 
/////////////////////////////////////////////////////////////////////////////// 
// 
// Pager.h 
// --------- 
// Curses based pager interface definition 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017 Bjoern Lemke 
// 
// INTERFACE MODULE 
// 
// Class: CegoAdmMon 
// 
// Description: Description: Cursor based monitor 
// 
// Status: CLEAN 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include <ctype.h> 
#include <string.h> 

#ifndef LFCNOCURSES 

#ifdef HAVE_MINGW 
#include <ncurses/ncurses.h> 
#else 
#include <ncurses.h> 
#endif 

#endif 

#include "Chain.h" 
#include "ListT.h" 
#include "Datetime.h" 
#include "SigHandler.h" 

#define MON_TIMEOUT 0 
#define MON_SELECT 1 
#define MON_LEAVE 2 

class Pager : public SigHandler { 

public: 

    Pager(); 
    ~Pager(); 

    void managePage(const Chain& title, const ListT< ListT<Chain> > & outData, const ListT<Chain>& schema); 

private: 

    void writeHeader(); 
    void writeFooter (int start, int end, int totalRow); 
    void getAttrSpec(const Chain& s, Chain& attr, int& len);
    void sigCatch(int sig);
    
    ListT<Chain> _schema;
    Chain _title;

    int _rows;
    int _cols;
    
}; 

#endif
