#ifndef _NET_H_INCLUDED_
#define _NET_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Net.h
// -----
// Base network driver
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// INTERFACE MODULE
//
// Class: Net
// 
// Description: All operations on network resources (IPv4)
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "Chain.h"
#include "ListT.h"
#include "NetHandler.h"

class NetHandler;

class Net {

public:
    
    Net(int initMsgBufLen, int sizeBufLen, int maxSendLen);
    ~Net();
    
    NetHandler* connect(const Chain& hostname, const Chain& service);
    NetHandler* connect(const Chain& hostname, const Chain& service, int timeout);
    void serve(int port);
    void serve(const Chain& hostname, const Chain& service);
    
    NetHandler* nextRequest(int timeout);
    void removeHandle(NetHandler *pN);
    
private:
	
    int _initMsgBufLen;
    int _sizeBufLen;
    int _maxSendLen;
   
    int _csock;
};

#endif
