# Welcome to ITK's documentation!

The Insight Toolkit (ITK) is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.
Our documentation is a resource for both new and seasoned ITK community members and includes tutorials, examples, and best practices to help you
unlock the full power of ITK's advanced algorithms.

We invite you to join the ITK community and explore our documentation to find out how you can use ITK to make your vision a reality.

[![GitHub release](https://img.shields.io/github/release/InsightSoftwareConsortium/ITK.svg)](https://github.com/InsightSoftwareConsortium/ITK/releases/latest)
[![Commit Activity](https://img.shields.io/github/commit-activity/y/InsightSoftwareConsortium/ITK)](https://github.com/InsightSoftwareConsortium/ITK)
[![PyPI](https://img.shields.io/pypi/v/itk.svg)](https://pypi.python.org/pypi/itk)

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://github.com/InsightSoftwareConsortium/ITK/blob/master/LICENSE)
[![DOI](https://zenodo.org/badge/800928.svg)](https://zenodo.org/badge/latestdoi/800928)
[![Powered by NumFOCUS](https://img.shields.io/badge/powered%20by-NumFOCUS-orange.svg?style=flat&colorA=E1523D&colorB=007D8A)](https://numfocus.org)


```{toctree}
:maxdepth: 1
:caption: 💾 Download

download
releases/index
licenses
```


```{toctree}
:maxdepth: 1
:caption: 📖 Learn

learn/python_quick_start.md
Examples <https://examples.itk.org>
Tutorial <https://github.com/InsightSoftwareConsortium/ScientificImageAnalysisVisualizationAndArtificialIntelligenceCourse>
Software Guide <https://itk.org/ItkSoftwareGuide.pdf>
learn/faq.md
learn/dicom.md
learn/courses.md
learn/third_party_applications.md
learn/fda_off_the_shelf_sw_guidelines.md
```


```{toctree}
:maxdepth: 1
:caption: 🔨 Develop

API <https://itk.org/Doxygen/html/index.html>
Discussion <https://discourse.itk.org>
Issue tracker <https://github.com/InsightSoftwareConsortium/ITK/issues>
supported_compilers
migration_guides/index
contributing/code_of_conduct
contributing/index
```


```{toctree}
:maxdepth: 1
:caption: 🌱 Scientific ecosystem

scientific_ecosystem/itk_ecosystem.md
```
