# Contributing to UNITS

:+1: First off, thank you for taking the time to contribute! :+1:

The following is a set of guidelines for contributing to UNITS. These are suggested guidelines. Use your best judgment.

## Licensing

The units library is distributed under the terms of the BSD-3 clause license. All new contributions must be made under this [license](https://github.com/LLNL/units/blob/main/LICENSE) in accordance with the github [terms of service](https://help.github.com/en/articles/github-terms-of-service#6-contributions-under-repository-license), which uses inbound=outbound policy. By submitting a pull request you are acknowledging that you have the right to license your code under these terms.

## [Code of Conduct](.github/CODE_OF_CONDUCT.md)

## How Can I Contribute

### Reporting Bugs

This section guides you through submitting a bug report for UNITS. Following these guidelines helps maintainers and the community understand your report, reproduce the behavior, and find related reports.

When you are creating a bug report, please include as many details as possible. Frequently, helpful information includes operating system, version, compiler used, API, interface, and some details about the function or operation being performed.

> **Note:** If you find a **Closed** issue that seems like it is the same thing that you're experiencing, open a new issue and include a link to the original issue in the body of your new one.

### Suggesting Enhancements

This section guides you through submitting a feature request, or enhancement for UNITS, including completely new features and minor improvements to existing functionality.

Please include as much detail as possible including the steps that you imagine you would take if the feature you're requesting existed, and the rational and reasoning of why this feature would be a good idea for a co-simulation framework.

A pull request including a bug fix or feature will always be welcome.

#### Before Submitting An Enhancement Suggestion

- check the issue list for any similar issues

### Your First Code Contribution

Unsure where to begin contributing to UNITS? You can start by looking for \[`help wanted`\]

### Submitting a pull request

Typically you would want to submit a pull request against the master branch. The pull requests are run through several automated checks in Travis and CircleCI and for the most part must pass these tests before merging. The goal is 100% coverage so if a new feature is added, then it should have tests to cover the new code. The Codacy check is evaluated but not required as the checks are sometimes a bit aggressive.

## Styleguides

Code formatting is controlled via clang-format and other repo cleanliness issues checked through pre-commit modules
