// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_11_16_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_11_16_H
#include <cstddef>
#include <cstdint>

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_11_16 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return table5_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit5(size_t i, size_t emit) {
    return table5_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp6(size_t i) {
    return table6_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit6(size_t i, size_t emit) {
    return table6_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp7(size_t i) {
    return table7_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit7(size_t i, size_t emit) {
    return table7_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_inner_[i >> 6][table1_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit1(size_t i, size_t emit) {
    return table1_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp8(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit8(size_t, size_t emit) {
    return emit ? 62 : 35;
  }
  static inline uint64_t GetOp9(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit9(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 36 : 0) : ((emit - 2) ? 91 : 64));
  }
  static inline uint64_t GetOp11(size_t i) {
    return (i < 2 ? (i ? 4 : 0) : ((i - 2) + 1));
  }
  static inline uint64_t GetEmit11(size_t, size_t emit) {
    return emit ? 126 : 93;
  }
  static inline uint64_t GetOp12(size_t i) {
    return table12_0_inner_[table12_0_outer_[i]];
  }
  static inline uint64_t GetEmit12(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 126 : 93) : ((emit - 2) ? 125 : 94));
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_0_inner_[table13_0_outer_[i]];
  }
  static inline uint64_t GetEmit13(size_t, size_t emit) {
    return table13_0_emit_[emit];
  }
  static inline uint64_t GetOp14(size_t i) { return table14_0_ops_[i]; }
  static inline uint64_t GetEmit14(size_t, size_t emit) {
    return table13_0_emit_[emit];
  }
  static inline uint64_t GetOp15(size_t i) { return table15_0_ops_[i]; }
  static inline uint64_t GetEmit15(size_t, size_t emit) {
    return table13_0_emit_[emit];
  }
  static inline uint64_t GetOp16(size_t i) { return table16_0_ops_[i]; }
  static inline uint64_t GetEmit16(size_t, size_t emit) {
    return table16_0_emit_[emit];
  }
  static inline uint64_t GetOp17(size_t i) {
    return table17_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit17(size_t i, size_t emit) {
    return table17_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp18(size_t i) {
    return table18_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit18(size_t i, size_t emit) {
    return table18_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp20(size_t i) {
    return table20_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit20(size_t i, size_t emit) {
    return table20_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp21(size_t i) {
    return table21_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit21(size_t i, size_t emit) {
    return table21_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp22(size_t i) {
    return table22_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit22(size_t i, size_t emit) {
    return table22_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp23(size_t i) {
    return table23_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit23(size_t i, size_t emit) {
    return table23_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp24(size_t i) {
    return table24_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit24(size_t i, size_t emit) {
    return table24_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp10(size_t i) {
    return table10_ops_[i >> 8][i & 0xff];
  }
  static inline uint64_t GetEmit10(size_t i, size_t emit) {
    return table10_emit_[i >> 8][emit];
  }
  static inline uint64_t GetOp25(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit25(size_t, size_t emit) { return emit + 2; }
  static inline uint64_t GetOp26(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit26(size_t, size_t emit) { return emit + 4; }
  static inline uint64_t GetOp27(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit27(size_t, size_t emit) { return emit + 6; }
  static inline uint64_t GetOp28(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit28(size_t, size_t emit) {
    return emit ? 11 : 8;
  }
  static inline uint64_t GetOp29(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit29(size_t, size_t emit) {
    return emit ? 14 : 12;
  }
  static inline uint64_t GetOp30(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit30(size_t, size_t emit) { return emit + 15; }
  static inline uint64_t GetOp31(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit31(size_t, size_t emit) { return emit + 17; }
  static inline uint64_t GetOp32(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit32(size_t, size_t emit) { return emit + 19; }
  static inline uint64_t GetOp33(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit33(size_t, size_t emit) {
    return emit ? 23 : 21;
  }
  static inline uint64_t GetOp34(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit34(size_t, size_t emit) { return emit + 24; }
  static inline uint64_t GetOp35(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit35(size_t, size_t emit) { return emit + 26; }
  static inline uint64_t GetOp36(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit36(size_t, size_t emit) { return emit + 28; }
  static inline uint64_t GetOp37(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit37(size_t, size_t emit) { return emit + 30; }
  static inline uint64_t GetOp38(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit38(size_t, size_t emit) {
    return emit ? 220 : 127;
  }
  static inline uint64_t GetOp40(size_t i) { return i; }
  static inline uint64_t GetEmit40(size_t, size_t emit) {
    return ((void)emit, 249);
  }
  static inline uint64_t GetOp41(size_t i) {
    return (i < 2 ? (i) : ((i - 2) ? 2 : 0));
  }
  static inline uint64_t GetEmit41(size_t, size_t emit) {
    return ((void)emit, 249);
  }
  static inline uint64_t GetOp39(size_t i) {
    return table39_0_inner_[(i < 3 ? (((void)i, 0)) : ((i - 3)))];
  }
  static inline uint64_t GetEmit39(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 10 : 249) : ((emit - 2) ? 22 : 13));
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table5_0_ops_[128];
  static const uint8_t table5_1_emit_[52];
  static const uint8_t table5_1_ops_[128];
  static const uint8_t* const table5_emit_[2];
  static const uint8_t* const table5_ops_[2];
  static const uint8_t table6_0_emit_[2];
  static const uint8_t table6_0_ops_[32];
  static const uint8_t table6_1_emit_[2];
  static const uint8_t table6_2_emit_[2];
  static const uint8_t table6_3_emit_[2];
  static const uint8_t table6_4_emit_[2];
  static const uint8_t table6_5_emit_[4];
  static const uint8_t table6_5_ops_[32];
  static const uint8_t table6_6_emit_[4];
  static const uint8_t table6_7_emit_[4];
  static const uint8_t table6_8_emit_[4];
  static const uint8_t table6_9_emit_[4];
  static const uint8_t table6_10_emit_[4];
  static const uint8_t table6_11_emit_[6];
  static const uint8_t table6_11_ops_[32];
  static const uint8_t table6_12_emit_[8];
  static const uint8_t table6_12_ops_[32];
  static const uint8_t table6_13_emit_[8];
  static const uint8_t table6_14_emit_[8];
  static const uint8_t table6_15_emit_[10];
  static const uint8_t table6_15_ops_[32];
  static const uint8_t* const table6_emit_[16];
  static const uint8_t* const table6_ops_[16];
  static const uint8_t table7_0_emit_[36];
  static const uint8_t table7_0_ops_[64];
  static const uint8_t table7_1_emit_[36];
  static const uint8_t table7_1_ops_[64];
  static const uint8_t table7_2_emit_[36];
  static const uint8_t table7_2_ops_[64];
  static const uint8_t table7_3_emit_[36];
  static const uint8_t table7_3_ops_[64];
  static const uint8_t table7_4_emit_[38];
  static const uint8_t table7_4_ops_[64];
  static const uint8_t table7_5_ops_[64];
  static const uint8_t table7_11_ops_[64];
  static const uint8_t table7_12_ops_[64];
  static const uint8_t table7_15_emit_[15];
  static const uint8_t table7_15_ops_[64];
  static const uint8_t* const table7_emit_[16];
  static const uint8_t* const table7_ops_[16];
  static const uint8_t table1_0_emit_[71];
  static const uint16_t table1_0_inner_[37];
  static const uint8_t table1_0_outer_[64];
  static const uint8_t table1_1_emit_[71];
  static const uint16_t table1_1_inner_[37];
  static const uint8_t table1_2_emit_[71];
  static const uint16_t table1_2_inner_[37];
  static const uint8_t table1_3_emit_[71];
  static const uint16_t table1_3_inner_[37];
  static const uint8_t table1_4_emit_[71];
  static const uint16_t table1_4_inner_[37];
  static const uint8_t table1_5_emit_[71];
  static const uint16_t table1_5_inner_[37];
  static const uint8_t table1_6_emit_[71];
  static const uint16_t table1_6_inner_[37];
  static const uint8_t table1_7_emit_[71];
  static const uint16_t table1_7_inner_[37];
  static const uint8_t table1_8_emit_[71];
  static const uint16_t table1_8_inner_[37];
  static const uint8_t table1_9_emit_[71];
  static const uint16_t table1_9_inner_[37];
  static const uint8_t table1_10_emit_[40];
  static const uint16_t table1_10_inner_[22];
  static const uint8_t table1_10_outer_[64];
  static const uint8_t table1_11_emit_[40];
  static const uint8_t table1_12_emit_[40];
  static const uint8_t table1_13_emit_[40];
  static const uint8_t table1_14_emit_[40];
  static const uint8_t table1_15_emit_[40];
  static const uint8_t table1_16_emit_[40];
  static const uint8_t table1_17_emit_[40];
  static const uint8_t table1_18_emit_[40];
  static const uint8_t table1_19_emit_[40];
  static const uint8_t table1_20_emit_[40];
  static const uint8_t table1_21_emit_[40];
  static const uint8_t table1_22_emit_[40];
  static const uint8_t table1_23_emit_[4];
  static const uint16_t table1_23_inner_[4];
  static const uint8_t table1_23_outer_[64];
  static const uint8_t table1_24_emit_[4];
  static const uint8_t table1_25_emit_[4];
  static const uint8_t table1_26_emit_[4];
  static const uint8_t table1_27_emit_[4];
  static const uint8_t table1_28_emit_[4];
  static const uint8_t table1_29_emit_[4];
  static const uint8_t table1_30_emit_[4];
  static const uint8_t table1_31_emit_[14];
  static const uint16_t table1_31_inner_[17];
  static const uint8_t table1_31_outer_[64];
  static const uint8_t* const table1_emit_[32];
  static const uint16_t* const table1_inner_[32];
  static const uint8_t* const table1_outer_[32];
  static const uint8_t table12_0_inner_[6];
  static const uint8_t table12_0_outer_[8];
  static const uint8_t table13_0_emit_[7];
  static const uint8_t table13_0_inner_[9];
  static const uint8_t table13_0_outer_[16];
  static const uint8_t table14_0_ops_[32];
  static const uint8_t table15_0_ops_[64];
  static const uint8_t table16_0_emit_[45];
  static const uint8_t table16_0_ops_[128];
  static const uint8_t table17_0_emit_[72];
  static const uint16_t table17_0_ops_[64];
  static const uint8_t table17_1_emit_[72];
  static const uint8_t table17_2_emit_[40];
  static const uint16_t table17_2_ops_[64];
  static const uint8_t table17_3_emit_[6];
  static const uint16_t table17_3_ops_[64];
  static const uint8_t* const table17_emit_[4];
  static const uint16_t* const table17_ops_[4];
  static const uint8_t table18_0_emit_[44];
  static const uint16_t table18_0_ops_[64];
  static const uint8_t table18_1_emit_[92];
  static const uint16_t table18_1_ops_[64];
  static const uint8_t table18_2_emit_[44];
  static const uint8_t table18_3_emit_[92];
  static const uint8_t table18_4_emit_[72];
  static const uint8_t table18_5_emit_[72];
  static const uint8_t table18_6_emit_[40];
  static const uint8_t table18_7_emit_[31];
  static const uint16_t table18_7_ops_[64];
  static const uint8_t* const table18_emit_[8];
  static const uint16_t* const table18_ops_[8];
  static const uint8_t table19_0_emit_[16];
  static const uint16_t table19_0_ops_[64];
  static const uint8_t table19_1_emit_[28];
  static const uint16_t table19_1_ops_[64];
  static const uint8_t table19_2_emit_[36];
  static const uint16_t table19_2_ops_[64];
  static const uint8_t table19_3_emit_[68];
  static const uint16_t table19_3_ops_[64];
  static const uint8_t table19_4_emit_[16];
  static const uint8_t table19_5_emit_[28];
  static const uint8_t table19_6_emit_[36];
  static const uint8_t table19_7_emit_[68];
  static const uint8_t table19_8_emit_[44];
  static const uint8_t table19_9_emit_[92];
  static const uint8_t table19_10_emit_[44];
  static const uint8_t table19_11_emit_[92];
  static const uint8_t table19_12_emit_[72];
  static const uint8_t table19_13_emit_[72];
  static const uint8_t table19_14_emit_[72];
  static const uint8_t table19_15_emit_[24];
  static const uint16_t table19_15_ops_[64];
  static const uint8_t* const table19_emit_[16];
  static const uint16_t* const table19_ops_[16];
  static const uint8_t table20_0_emit_[8];
  static const uint16_t table20_0_ops_[64];
  static const uint8_t table20_1_emit_[8];
  static const uint8_t table20_2_emit_[12];
  static const uint16_t table20_2_ops_[64];
  static const uint8_t table20_3_emit_[16];
  static const uint8_t table20_4_emit_[16];
  static const uint8_t table20_5_emit_[20];
  static const uint16_t table20_5_ops_[64];
  static const uint8_t table20_6_emit_[32];
  static const uint16_t table20_6_ops_[64];
  static const uint8_t table20_7_emit_[36];
  static const uint16_t table20_7_ops_[64];
  static const uint8_t table20_8_emit_[8];
  static const uint8_t table20_9_emit_[8];
  static const uint8_t table20_10_emit_[12];
  static const uint8_t table20_11_emit_[16];
  static const uint8_t table20_12_emit_[16];
  static const uint8_t table20_13_emit_[20];
  static const uint8_t table20_14_emit_[32];
  static const uint8_t table20_15_emit_[36];
  static const uint8_t table20_16_emit_[16];
  static const uint8_t table20_17_emit_[28];
  static const uint8_t table20_18_emit_[36];
  static const uint8_t table20_19_emit_[68];
  static const uint8_t table20_20_emit_[16];
  static const uint8_t table20_21_emit_[28];
  static const uint8_t table20_22_emit_[36];
  static const uint8_t table20_23_emit_[68];
  static const uint8_t table20_24_emit_[44];
  static const uint8_t table20_25_emit_[92];
  static const uint8_t table20_26_emit_[44];
  static const uint8_t table20_27_emit_[92];
  static const uint8_t table20_28_emit_[44];
  static const uint8_t table20_29_emit_[92];
  static const uint8_t table20_30_emit_[15];
  static const uint16_t table20_30_ops_[64];
  static const uint8_t table20_31_emit_[35];
  static const uint16_t table20_31_ops_[64];
  static const uint8_t* const table20_emit_[32];
  static const uint16_t* const table20_ops_[32];
  static const uint8_t table21_0_emit_[60];
  static const uint16_t table21_0_ops_[64];
  static const uint8_t table21_1_emit_[60];
  static const uint8_t table21_2_emit_[60];
  static const uint8_t table21_3_emit_[60];
  static const uint8_t table21_4_emit_[60];
  static const uint8_t table21_5_emit_[8];
  static const uint16_t table21_5_ops_[64];
  static const uint8_t table21_6_emit_[8];
  static const uint8_t table21_7_emit_[8];
  static const uint8_t table21_8_emit_[8];
  static const uint8_t table21_9_emit_[8];
  static const uint8_t table21_10_emit_[8];
  static const uint8_t table21_11_emit_[12];
  static const uint16_t table21_11_ops_[64];
  static const uint8_t table21_12_emit_[16];
  static const uint16_t table21_12_ops_[64];
  static const uint8_t table21_13_emit_[16];
  static const uint8_t table21_14_emit_[16];
  static const uint8_t table21_15_emit_[30];
  static const uint16_t table21_15_ops_[64];
  static const uint8_t table21_16_emit_[60];
  static const uint8_t table21_17_emit_[60];
  static const uint8_t table21_18_emit_[60];
  static const uint8_t table21_19_emit_[60];
  static const uint8_t table21_20_emit_[60];
  static const uint8_t table21_21_emit_[8];
  static const uint8_t table21_22_emit_[8];
  static const uint8_t table21_23_emit_[8];
  static const uint8_t table21_24_emit_[8];
  static const uint8_t table21_25_emit_[8];
  static const uint8_t table21_26_emit_[8];
  static const uint8_t table21_27_emit_[12];
  static const uint8_t table21_28_emit_[16];
  static const uint8_t table21_29_emit_[16];
  static const uint8_t table21_30_emit_[16];
  static const uint8_t table21_31_emit_[30];
  static const uint8_t table21_32_emit_[8];
  static const uint8_t table21_33_emit_[8];
  static const uint8_t table21_34_emit_[12];
  static const uint8_t table21_35_emit_[16];
  static const uint8_t table21_36_emit_[16];
  static const uint8_t table21_37_emit_[20];
  static const uint16_t table21_37_ops_[64];
  static const uint8_t table21_38_emit_[32];
  static const uint16_t table21_38_ops_[64];
  static const uint8_t table21_39_emit_[36];
  static const uint16_t table21_39_ops_[64];
  static const uint8_t table21_40_emit_[8];
  static const uint8_t table21_41_emit_[8];
  static const uint8_t table21_42_emit_[12];
  static const uint8_t table21_43_emit_[16];
  static const uint8_t table21_44_emit_[16];
  static const uint8_t table21_45_emit_[20];
  static const uint8_t table21_46_emit_[32];
  static const uint8_t table21_47_emit_[36];
  static const uint8_t table21_48_emit_[16];
  static const uint8_t table21_49_emit_[28];
  static const uint16_t table21_49_ops_[64];
  static const uint8_t table21_50_emit_[36];
  static const uint16_t table21_50_ops_[64];
  static const uint8_t table21_51_emit_[68];
  static const uint16_t table21_51_ops_[64];
  static const uint8_t table21_52_emit_[16];
  static const uint8_t table21_53_emit_[28];
  static const uint8_t table21_54_emit_[36];
  static const uint8_t table21_55_emit_[68];
  static const uint8_t table21_56_emit_[16];
  static const uint8_t table21_57_emit_[28];
  static const uint8_t table21_58_emit_[36];
  static const uint8_t table21_59_emit_[68];
  static const uint8_t table21_60_emit_[5];
  static const uint16_t table21_60_ops_[64];
  static const uint8_t table21_61_emit_[10];
  static const uint16_t table21_61_ops_[64];
  static const uint8_t table21_62_emit_[23];
  static const uint16_t table21_62_ops_[64];
  static const uint8_t table21_63_emit_[41];
  static const uint16_t table21_63_ops_[64];
  static const uint8_t* const table21_emit_[64];
  static const uint16_t* const table21_ops_[64];
  static const uint8_t table22_0_emit_[108];
  static const uint16_t table22_0_ops_[64];
  static const uint8_t table22_1_emit_[108];
  static const uint8_t table22_2_emit_[108];
  static const uint8_t table22_3_emit_[108];
  static const uint8_t table22_4_emit_[108];
  static const uint8_t table22_5_emit_[108];
  static const uint8_t table22_6_emit_[108];
  static const uint8_t table22_7_emit_[108];
  static const uint8_t table22_8_emit_[108];
  static const uint8_t table22_9_emit_[108];
  static const uint8_t table22_10_emit_[60];
  static const uint16_t table22_10_ops_[64];
  static const uint8_t table22_11_emit_[60];
  static const uint8_t table22_12_emit_[60];
  static const uint8_t table22_13_emit_[60];
  static const uint8_t table22_14_emit_[60];
  static const uint8_t table22_15_emit_[60];
  static const uint8_t table22_16_emit_[60];
  static const uint8_t table22_17_emit_[60];
  static const uint8_t table22_18_emit_[60];
  static const uint8_t table22_19_emit_[60];
  static const uint8_t table22_20_emit_[60];
  static const uint8_t table22_21_emit_[60];
  static const uint8_t table22_22_emit_[60];
  static const uint8_t table22_23_emit_[8];
  static const uint16_t table22_23_ops_[64];
  static const uint8_t table22_24_emit_[8];
  static const uint8_t table22_25_emit_[8];
  static const uint8_t table22_26_emit_[8];
  static const uint8_t table22_27_emit_[8];
  static const uint8_t table22_28_emit_[8];
  static const uint8_t table22_29_emit_[8];
  static const uint8_t table22_30_emit_[8];
  static const uint8_t table22_31_emit_[28];
  static const uint16_t table22_31_ops_[64];
  static const uint8_t table22_32_emit_[108];
  static const uint8_t table22_33_emit_[108];
  static const uint8_t table22_34_emit_[108];
  static const uint8_t table22_35_emit_[108];
  static const uint8_t table22_36_emit_[108];
  static const uint8_t table22_37_emit_[108];
  static const uint8_t table22_38_emit_[108];
  static const uint8_t table22_39_emit_[108];
  static const uint8_t table22_40_emit_[108];
  static const uint8_t table22_41_emit_[108];
  static const uint8_t table22_42_emit_[60];
  static const uint8_t table22_43_emit_[60];
  static const uint8_t table22_44_emit_[60];
  static const uint8_t table22_45_emit_[60];
  static const uint8_t table22_46_emit_[60];
  static const uint8_t table22_47_emit_[60];
  static const uint8_t table22_48_emit_[60];
  static const uint8_t table22_49_emit_[60];
  static const uint8_t table22_50_emit_[60];
  static const uint8_t table22_51_emit_[60];
  static const uint8_t table22_52_emit_[60];
  static const uint8_t table22_53_emit_[60];
  static const uint8_t table22_54_emit_[60];
  static const uint8_t table22_55_emit_[8];
  static const uint8_t table22_56_emit_[8];
  static const uint8_t table22_57_emit_[8];
  static const uint8_t table22_58_emit_[8];
  static const uint8_t table22_59_emit_[8];
  static const uint8_t table22_60_emit_[8];
  static const uint8_t table22_61_emit_[8];
  static const uint8_t table22_62_emit_[8];
  static const uint8_t table22_63_emit_[28];
  static const uint8_t table22_64_emit_[60];
  static const uint8_t table22_65_emit_[60];
  static const uint8_t table22_66_emit_[60];
  static const uint8_t table22_67_emit_[60];
  static const uint8_t table22_68_emit_[60];
  static const uint8_t table22_69_emit_[8];
  static const uint8_t table22_70_emit_[8];
  static const uint8_t table22_71_emit_[8];
  static const uint8_t table22_72_emit_[8];
  static const uint8_t table22_73_emit_[8];
  static const uint8_t table22_74_emit_[8];
  static const uint8_t table22_75_emit_[12];
  static const uint16_t table22_75_ops_[64];
  static const uint8_t table22_76_emit_[16];
  static const uint16_t table22_76_ops_[64];
  static const uint8_t table22_77_emit_[16];
  static const uint8_t table22_78_emit_[16];
  static const uint8_t table22_79_emit_[30];
  static const uint16_t table22_79_ops_[64];
  static const uint8_t table22_80_emit_[60];
  static const uint8_t table22_81_emit_[60];
  static const uint8_t table22_82_emit_[60];
  static const uint8_t table22_83_emit_[60];
  static const uint8_t table22_84_emit_[60];
  static const uint8_t table22_85_emit_[8];
  static const uint8_t table22_86_emit_[8];
  static const uint8_t table22_87_emit_[8];
  static const uint8_t table22_88_emit_[8];
  static const uint8_t table22_89_emit_[8];
  static const uint8_t table22_90_emit_[8];
  static const uint8_t table22_91_emit_[12];
  static const uint8_t table22_92_emit_[16];
  static const uint8_t table22_93_emit_[16];
  static const uint8_t table22_94_emit_[16];
  static const uint8_t table22_95_emit_[30];
  static const uint8_t table22_96_emit_[8];
  static const uint8_t table22_97_emit_[8];
  static const uint8_t table22_98_emit_[12];
  static const uint8_t table22_99_emit_[16];
  static const uint8_t table22_100_emit_[16];
  static const uint8_t table22_101_emit_[20];
  static const uint16_t table22_101_ops_[64];
  static const uint8_t table22_102_emit_[32];
  static const uint16_t table22_102_ops_[64];
  static const uint8_t table22_103_emit_[36];
  static const uint16_t table22_103_ops_[64];
  static const uint8_t table22_104_emit_[8];
  static const uint8_t table22_105_emit_[8];
  static const uint8_t table22_106_emit_[12];
  static const uint8_t table22_107_emit_[16];
  static const uint8_t table22_108_emit_[16];
  static const uint8_t table22_109_emit_[20];
  static const uint8_t table22_110_emit_[32];
  static const uint8_t table22_111_emit_[36];
  static const uint8_t table22_112_emit_[8];
  static const uint8_t table22_113_emit_[8];
  static const uint8_t table22_114_emit_[12];
  static const uint8_t table22_115_emit_[16];
  static const uint8_t table22_116_emit_[16];
  static const uint8_t table22_117_emit_[20];
  static const uint8_t table22_118_emit_[32];
  static const uint8_t table22_119_emit_[36];
  static const uint8_t table22_120_emit_[40];
  static const uint16_t table22_120_ops_[64];
  static const uint8_t table22_121_emit_[22];
  static const uint16_t table22_121_ops_[64];
  static const uint8_t table22_122_emit_[4];
  static const uint16_t table22_122_ops_[64];
  static const uint8_t table22_123_emit_[6];
  static const uint16_t table22_123_ops_[64];
  static const uint8_t table22_124_emit_[8];
  static const uint16_t table22_124_ops_[64];
  static const uint8_t table22_125_emit_[15];
  static const uint16_t table22_125_ops_[64];
  static const uint8_t table22_126_emit_[20];
  static const uint16_t table22_126_ops_[64];
  static const uint8_t table22_127_emit_[33];
  static const uint16_t table22_127_ops_[64];
  static const uint8_t* const table22_emit_[128];
  static const uint16_t* const table22_ops_[128];
  static const uint8_t table23_0_emit_[204];
  static const uint16_t table23_0_ops_[128];
  static const uint8_t table23_1_emit_[204];
  static const uint8_t table23_2_emit_[204];
  static const uint8_t table23_3_emit_[204];
  static const uint8_t table23_4_emit_[204];
  static const uint8_t table23_5_emit_[204];
  static const uint8_t table23_6_emit_[204];
  static const uint8_t table23_7_emit_[204];
  static const uint8_t table23_8_emit_[204];
  static const uint8_t table23_9_emit_[204];
  static const uint8_t table23_10_emit_[216];
  static const uint16_t table23_10_ops_[128];
  static const uint8_t table23_11_emit_[216];
  static const uint8_t table23_12_emit_[216];
  static const uint8_t table23_13_emit_[216];
  static const uint8_t table23_14_emit_[216];
  static const uint8_t table23_15_emit_[216];
  static const uint8_t table23_16_emit_[216];
  static const uint8_t table23_17_emit_[216];
  static const uint8_t table23_18_emit_[216];
  static const uint8_t table23_19_emit_[216];
  static const uint8_t table23_20_emit_[216];
  static const uint8_t table23_21_emit_[216];
  static const uint8_t table23_22_emit_[216];
  static const uint8_t table23_23_emit_[120];
  static const uint16_t table23_23_ops_[128];
  static const uint8_t table23_24_emit_[120];
  static const uint8_t table23_25_emit_[120];
  static const uint8_t table23_26_emit_[120];
  static const uint8_t table23_27_emit_[120];
  static const uint8_t table23_28_emit_[120];
  static const uint8_t table23_29_emit_[120];
  static const uint8_t table23_30_emit_[120];
  static const uint8_t table23_31_emit_[32];
  static const uint16_t table23_31_ops_[128];
  static const uint8_t table23_32_emit_[204];
  static const uint8_t table23_33_emit_[204];
  static const uint8_t table23_34_emit_[204];
  static const uint8_t table23_35_emit_[204];
  static const uint8_t table23_36_emit_[204];
  static const uint8_t table23_37_emit_[204];
  static const uint8_t table23_38_emit_[204];
  static const uint8_t table23_39_emit_[204];
  static const uint8_t table23_40_emit_[204];
  static const uint8_t table23_41_emit_[204];
  static const uint8_t table23_42_emit_[216];
  static const uint8_t table23_43_emit_[216];
  static const uint8_t table23_44_emit_[216];
  static const uint8_t table23_45_emit_[216];
  static const uint8_t table23_46_emit_[216];
  static const uint8_t table23_47_emit_[216];
  static const uint8_t table23_48_emit_[216];
  static const uint8_t table23_49_emit_[216];
  static const uint8_t table23_50_emit_[216];
  static const uint8_t table23_51_emit_[216];
  static const uint8_t table23_52_emit_[216];
  static const uint8_t table23_53_emit_[216];
  static const uint8_t table23_54_emit_[216];
  static const uint8_t table23_55_emit_[120];
  static const uint8_t table23_56_emit_[120];
  static const uint8_t table23_57_emit_[120];
  static const uint8_t table23_58_emit_[120];
  static const uint8_t table23_59_emit_[120];
  static const uint8_t table23_60_emit_[120];
  static const uint8_t table23_61_emit_[120];
  static const uint8_t table23_62_emit_[120];
  static const uint8_t table23_63_emit_[32];
  static const uint8_t table23_64_emit_[216];
  static const uint8_t table23_65_emit_[216];
  static const uint8_t table23_66_emit_[216];
  static const uint8_t table23_67_emit_[216];
  static const uint8_t table23_68_emit_[216];
  static const uint8_t table23_69_emit_[120];
  static const uint8_t table23_70_emit_[120];
  static const uint8_t table23_71_emit_[120];
  static const uint8_t table23_72_emit_[120];
  static const uint8_t table23_73_emit_[120];
  static const uint8_t table23_74_emit_[120];
  static const uint8_t table23_75_emit_[68];
  static const uint16_t table23_75_ops_[128];
  static const uint16_t table23_76_ops_[128];
  static const uint8_t table23_79_emit_[36];
  static const uint16_t table23_79_ops_[128];
  static const uint8_t table23_80_emit_[216];
  static const uint8_t table23_81_emit_[216];
  static const uint8_t table23_82_emit_[216];
  static const uint8_t table23_83_emit_[216];
  static const uint8_t table23_84_emit_[216];
  static const uint8_t table23_85_emit_[120];
  static const uint8_t table23_86_emit_[120];
  static const uint8_t table23_87_emit_[120];
  static const uint8_t table23_88_emit_[120];
  static const uint8_t table23_89_emit_[120];
  static const uint8_t table23_90_emit_[120];
  static const uint8_t table23_91_emit_[68];
  static const uint8_t table23_95_emit_[36];
  static const uint8_t table23_96_emit_[120];
  static const uint8_t table23_97_emit_[120];
  static const uint8_t table23_98_emit_[68];
  static const uint16_t table23_101_ops_[128];
  static const uint16_t table23_102_ops_[128];
  static const uint8_t table23_103_emit_[46];
  static const uint16_t table23_103_ops_[128];
  static const uint8_t table23_104_emit_[120];
  static const uint8_t table23_105_emit_[120];
  static const uint8_t table23_106_emit_[68];
  static const uint8_t table23_111_emit_[46];
  static const uint8_t table23_112_emit_[120];
  static const uint8_t table23_113_emit_[120];
  static const uint8_t table23_114_emit_[68];
  static const uint8_t table23_119_emit_[46];
  static const uint8_t table23_120_emit_[144];
  static const uint16_t table23_120_ops_[128];
  static const uint8_t table23_121_emit_[112];
  static const uint16_t table23_121_ops_[128];
  static const uint8_t table23_122_emit_[80];
  static const uint16_t table23_122_ops_[128];
  static const uint8_t table23_123_emit_[44];
  static const uint16_t table23_123_ops_[128];
  static const uint16_t table23_124_ops_[128];
  static const uint16_t table23_125_ops_[128];
  static const uint16_t table23_126_ops_[128];
  static const uint8_t table23_127_emit_[37];
  static const uint16_t table23_127_ops_[128];
  static const uint8_t* const table23_emit_[128];
  static const uint16_t* const table23_ops_[128];
  static const uint8_t table24_0_emit_[66];
  static const uint16_t table24_0_ops_[128];
  static const uint8_t table24_1_emit_[156];
  static const uint16_t table24_1_ops_[128];
  static const uint8_t table24_2_emit_[66];
  static const uint8_t table24_3_emit_[156];
  static const uint8_t table24_4_emit_[66];
  static const uint8_t table24_5_emit_[156];
  static const uint8_t table24_6_emit_[66];
  static const uint8_t table24_7_emit_[156];
  static const uint8_t table24_8_emit_[66];
  static const uint8_t table24_9_emit_[156];
  static const uint8_t table24_10_emit_[66];
  static const uint8_t table24_11_emit_[156];
  static const uint8_t table24_12_emit_[66];
  static const uint8_t table24_13_emit_[156];
  static const uint8_t table24_14_emit_[66];
  static const uint8_t table24_15_emit_[156];
  static const uint8_t table24_16_emit_[66];
  static const uint8_t table24_17_emit_[156];
  static const uint8_t table24_18_emit_[66];
  static const uint8_t table24_19_emit_[156];
  static const uint8_t table24_20_emit_[204];
  static const uint8_t table24_21_emit_[204];
  static const uint8_t table24_22_emit_[204];
  static const uint8_t table24_23_emit_[204];
  static const uint8_t table24_24_emit_[204];
  static const uint8_t table24_25_emit_[204];
  static const uint8_t table24_26_emit_[204];
  static const uint8_t table24_27_emit_[204];
  static const uint8_t table24_28_emit_[204];
  static const uint8_t table24_29_emit_[204];
  static const uint8_t table24_30_emit_[204];
  static const uint8_t table24_31_emit_[204];
  static const uint8_t table24_32_emit_[204];
  static const uint8_t table24_33_emit_[204];
  static const uint8_t table24_34_emit_[204];
  static const uint8_t table24_35_emit_[204];
  static const uint8_t table24_36_emit_[204];
  static const uint8_t table24_37_emit_[204];
  static const uint8_t table24_38_emit_[204];
  static const uint8_t table24_39_emit_[204];
  static const uint8_t table24_40_emit_[204];
  static const uint8_t table24_41_emit_[204];
  static const uint8_t table24_42_emit_[204];
  static const uint8_t table24_43_emit_[204];
  static const uint8_t table24_44_emit_[204];
  static const uint8_t table24_45_emit_[204];
  static const uint8_t table24_46_emit_[216];
  static const uint8_t table24_47_emit_[216];
  static const uint8_t table24_48_emit_[216];
  static const uint8_t table24_49_emit_[216];
  static const uint8_t table24_50_emit_[216];
  static const uint8_t table24_51_emit_[216];
  static const uint8_t table24_52_emit_[216];
  static const uint8_t table24_53_emit_[216];
  static const uint8_t table24_54_emit_[216];
  static const uint8_t table24_55_emit_[216];
  static const uint8_t table24_56_emit_[216];
  static const uint8_t table24_57_emit_[216];
  static const uint8_t table24_58_emit_[216];
  static const uint8_t table24_59_emit_[216];
  static const uint8_t table24_60_emit_[216];
  static const uint8_t table24_61_emit_[216];
  static const uint8_t table24_62_emit_[120];
  static const uint8_t table24_63_emit_[91];
  static const uint16_t table24_63_ops_[128];
  static const uint8_t table24_64_emit_[66];
  static const uint8_t table24_65_emit_[156];
  static const uint8_t table24_66_emit_[66];
  static const uint8_t table24_67_emit_[156];
  static const uint8_t table24_68_emit_[66];
  static const uint8_t table24_69_emit_[156];
  static const uint8_t table24_70_emit_[66];
  static const uint8_t table24_71_emit_[156];
  static const uint8_t table24_72_emit_[66];
  static const uint8_t table24_73_emit_[156];
  static const uint8_t table24_74_emit_[66];
  static const uint8_t table24_75_emit_[156];
  static const uint8_t table24_76_emit_[66];
  static const uint8_t table24_77_emit_[156];
  static const uint8_t table24_78_emit_[66];
  static const uint8_t table24_79_emit_[156];
  static const uint8_t table24_80_emit_[66];
  static const uint8_t table24_81_emit_[156];
  static const uint8_t table24_82_emit_[66];
  static const uint8_t table24_83_emit_[156];
  static const uint8_t table24_84_emit_[204];
  static const uint8_t table24_85_emit_[204];
  static const uint8_t table24_86_emit_[204];
  static const uint8_t table24_87_emit_[204];
  static const uint8_t table24_88_emit_[204];
  static const uint8_t table24_89_emit_[204];
  static const uint8_t table24_90_emit_[204];
  static const uint8_t table24_91_emit_[204];
  static const uint8_t table24_92_emit_[204];
  static const uint8_t table24_93_emit_[204];
  static const uint8_t table24_94_emit_[204];
  static const uint8_t table24_95_emit_[204];
  static const uint8_t table24_96_emit_[204];
  static const uint8_t table24_97_emit_[204];
  static const uint8_t table24_98_emit_[204];
  static const uint8_t table24_99_emit_[204];
  static const uint8_t table24_100_emit_[204];
  static const uint8_t table24_101_emit_[204];
  static const uint8_t table24_102_emit_[204];
  static const uint8_t table24_103_emit_[204];
  static const uint8_t table24_104_emit_[204];
  static const uint8_t table24_105_emit_[204];
  static const uint8_t table24_106_emit_[204];
  static const uint8_t table24_107_emit_[204];
  static const uint8_t table24_108_emit_[204];
  static const uint8_t table24_109_emit_[204];
  static const uint8_t table24_110_emit_[216];
  static const uint8_t table24_111_emit_[216];
  static const uint8_t table24_112_emit_[216];
  static const uint8_t table24_113_emit_[216];
  static const uint8_t table24_114_emit_[216];
  static const uint8_t table24_115_emit_[216];
  static const uint8_t table24_116_emit_[216];
  static const uint8_t table24_117_emit_[216];
  static const uint8_t table24_118_emit_[216];
  static const uint8_t table24_119_emit_[216];
  static const uint8_t table24_120_emit_[216];
  static const uint8_t table24_121_emit_[216];
  static const uint8_t table24_122_emit_[216];
  static const uint8_t table24_123_emit_[216];
  static const uint8_t table24_124_emit_[216];
  static const uint8_t table24_125_emit_[216];
  static const uint8_t table24_126_emit_[120];
  static const uint8_t table24_127_emit_[92];
  static const uint16_t table24_127_ops_[128];
  static const uint8_t table24_128_emit_[204];
  static const uint8_t table24_129_emit_[204];
  static const uint8_t table24_130_emit_[204];
  static const uint8_t table24_131_emit_[204];
  static const uint8_t table24_132_emit_[204];
  static const uint8_t table24_133_emit_[204];
  static const uint8_t table24_134_emit_[204];
  static const uint8_t table24_135_emit_[204];
  static const uint8_t table24_136_emit_[204];
  static const uint8_t table24_137_emit_[204];
  static const uint8_t table24_138_emit_[216];
  static const uint8_t table24_139_emit_[216];
  static const uint8_t table24_140_emit_[216];
  static const uint8_t table24_141_emit_[216];
  static const uint8_t table24_142_emit_[216];
  static const uint8_t table24_143_emit_[216];
  static const uint8_t table24_144_emit_[216];
  static const uint8_t table24_145_emit_[216];
  static const uint8_t table24_146_emit_[216];
  static const uint8_t table24_147_emit_[216];
  static const uint8_t table24_148_emit_[216];
  static const uint8_t table24_149_emit_[216];
  static const uint8_t table24_150_emit_[216];
  static const uint8_t table24_151_emit_[120];
  static const uint8_t table24_152_emit_[120];
  static const uint8_t table24_153_emit_[120];
  static const uint8_t table24_154_emit_[120];
  static const uint8_t table24_155_emit_[120];
  static const uint8_t table24_156_emit_[120];
  static const uint8_t table24_157_emit_[120];
  static const uint8_t table24_158_emit_[120];
  static const uint8_t table24_159_emit_[32];
  static const uint8_t table24_160_emit_[204];
  static const uint8_t table24_161_emit_[204];
  static const uint8_t table24_162_emit_[204];
  static const uint8_t table24_163_emit_[204];
  static const uint8_t table24_164_emit_[204];
  static const uint8_t table24_165_emit_[204];
  static const uint8_t table24_166_emit_[204];
  static const uint8_t table24_167_emit_[204];
  static const uint8_t table24_168_emit_[204];
  static const uint8_t table24_169_emit_[204];
  static const uint8_t table24_170_emit_[216];
  static const uint8_t table24_171_emit_[216];
  static const uint8_t table24_172_emit_[216];
  static const uint8_t table24_173_emit_[216];
  static const uint8_t table24_174_emit_[216];
  static const uint8_t table24_175_emit_[216];
  static const uint8_t table24_176_emit_[216];
  static const uint8_t table24_177_emit_[216];
  static const uint8_t table24_178_emit_[216];
  static const uint8_t table24_179_emit_[216];
  static const uint8_t table24_180_emit_[216];
  static const uint8_t table24_181_emit_[216];
  static const uint8_t table24_182_emit_[216];
  static const uint8_t table24_183_emit_[120];
  static const uint8_t table24_184_emit_[120];
  static const uint8_t table24_185_emit_[120];
  static const uint8_t table24_186_emit_[120];
  static const uint8_t table24_187_emit_[120];
  static const uint8_t table24_188_emit_[120];
  static const uint8_t table24_189_emit_[120];
  static const uint8_t table24_190_emit_[120];
  static const uint8_t table24_191_emit_[32];
  static const uint8_t table24_192_emit_[216];
  static const uint8_t table24_193_emit_[216];
  static const uint8_t table24_194_emit_[216];
  static const uint8_t table24_195_emit_[216];
  static const uint8_t table24_196_emit_[216];
  static const uint8_t table24_197_emit_[120];
  static const uint8_t table24_198_emit_[120];
  static const uint8_t table24_199_emit_[120];
  static const uint8_t table24_200_emit_[120];
  static const uint8_t table24_201_emit_[120];
  static const uint8_t table24_202_emit_[120];
  static const uint8_t table24_203_emit_[68];
  static const uint8_t table24_204_emit_[16];
  static const uint8_t table24_205_emit_[16];
  static const uint8_t table24_206_emit_[16];
  static const uint8_t table24_207_emit_[36];
  static const uint8_t table24_208_emit_[216];
  static const uint8_t table24_209_emit_[216];
  static const uint8_t table24_210_emit_[216];
  static const uint8_t table24_211_emit_[216];
  static const uint8_t table24_212_emit_[216];
  static const uint8_t table24_213_emit_[120];
  static const uint8_t table24_214_emit_[120];
  static const uint8_t table24_215_emit_[120];
  static const uint8_t table24_216_emit_[120];
  static const uint8_t table24_217_emit_[120];
  static const uint8_t table24_218_emit_[120];
  static const uint8_t table24_219_emit_[68];
  static const uint8_t table24_220_emit_[16];
  static const uint8_t table24_221_emit_[16];
  static const uint8_t table24_222_emit_[16];
  static const uint8_t table24_223_emit_[36];
  static const uint8_t table24_224_emit_[216];
  static const uint8_t table24_225_emit_[216];
  static const uint8_t table24_226_emit_[216];
  static const uint8_t table24_227_emit_[216];
  static const uint8_t table24_228_emit_[216];
  static const uint8_t table24_229_emit_[120];
  static const uint8_t table24_230_emit_[120];
  static const uint8_t table24_231_emit_[120];
  static const uint8_t table24_232_emit_[120];
  static const uint8_t table24_233_emit_[120];
  static const uint8_t table24_234_emit_[120];
  static const uint8_t table24_235_emit_[68];
  static const uint8_t table24_236_emit_[16];
  static const uint8_t table24_237_emit_[16];
  static const uint8_t table24_238_emit_[16];
  static const uint8_t table24_239_emit_[36];
  static const uint8_t table24_240_emit_[136];
  static const uint16_t table24_240_ops_[128];
  static const uint8_t table24_241_emit_[136];
  static const uint8_t table24_242_emit_[136];
  static const uint8_t table24_243_emit_[144];
  static const uint8_t table24_244_emit_[144];
  static const uint8_t table24_245_emit_[144];
  static const uint8_t table24_246_emit_[144];
  static const uint8_t table24_247_emit_[80];
  static const uint8_t table24_248_emit_[80];
  static const uint8_t table24_249_emit_[80];
  static const uint8_t table24_250_emit_[26];
  static const uint16_t table24_250_ops_[128];
  static const uint8_t table24_251_emit_[8];
  static const uint8_t table24_252_emit_[8];
  static const uint8_t table24_253_emit_[12];
  static const uint16_t table24_253_ops_[128];
  static const uint8_t table24_254_emit_[16];
  static const uint16_t table24_254_ops_[128];
  static const uint8_t table24_255_emit_[36];
  static const uint16_t table24_255_ops_[128];
  static const uint8_t* const table24_emit_[256];
  static const uint16_t* const table24_ops_[256];
  static const uint8_t table10_0_emit_[1];
  static const uint16_t table10_0_ops_[256];
  static const uint8_t table10_64_emit_[1];
  static const uint8_t table10_128_emit_[1];
  static const uint16_t table10_128_ops_[256];
  static const uint8_t table10_160_emit_[1];
  static const uint8_t table10_192_emit_[1];
  static const uint16_t table10_192_ops_[256];
  static const uint8_t table10_208_emit_[1];
  static const uint8_t table10_224_emit_[1];
  static const uint8_t table10_240_emit_[1];
  static const uint16_t table10_240_ops_[256];
  static const uint8_t table10_241_emit_[1];
  static const uint8_t table10_242_emit_[1];
  static const uint8_t table10_243_emit_[2];
  static const uint16_t table10_243_ops_[256];
  static const uint8_t table10_244_emit_[2];
  static const uint8_t table10_245_emit_[2];
  static const uint8_t table10_246_emit_[2];
  static const uint8_t table10_247_emit_[4];
  static const uint16_t table10_247_ops_[256];
  static const uint8_t table10_248_emit_[4];
  static const uint8_t table10_249_emit_[4];
  static const uint8_t table10_250_emit_[7];
  static const uint16_t table10_250_ops_[256];
  static const uint16_t table10_251_ops_[256];
  static const uint16_t table10_253_ops_[256];
  static const uint16_t table10_254_ops_[256];
  static const uint8_t table10_255_emit_[55];
  static const uint16_t table10_255_ops_[256];
  static const uint8_t* const table10_emit_[256];
  static const uint16_t* const table10_ops_[256];
  static const uint8_t table39_0_inner_[5];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo11()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 11)) & 0x7ff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 7;
      switch ((op >> 4) & 7) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          sink_(GetEmit1(index, emit_ofs + 1));
          break;
        }
        case 1: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 2: {
          DecodeStep0();
          break;
        }
        case 3: {
          DecodeStep1();
          break;
        }
        case 4: {
          DecodeStep2();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo11() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2: {
        return Read2to7Bytes();
      }
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp5(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit5(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp6(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit6(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp7(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            sink_(GetEmit7(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo1()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp8(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit8(index, emit_ofs + 0));
  }
  bool RefillTo1() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Done1() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep1() {
    if (!RefillTo2()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp9(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit9(index, emit_ofs + 0));
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done2() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep2() {
    if (!RefillTo16()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 16)) & 0xffff;
    const auto op = GetOp10(index);
    const int consumed = op & 31;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 9;
    switch ((op >> 5) & 15) {
      case 0: {
        sink_(GetEmit10(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep3();
        break;
      }
      case 2: {
        DecodeStep4();
        break;
      }
      case 3: {
        DecodeStep5();
        break;
      }
      case 4: {
        DecodeStep6();
        break;
      }
      case 5: {
        DecodeStep7();
        break;
      }
      case 6: {
        DecodeStep8();
        break;
      }
      case 7: {
        DecodeStep9();
        break;
      }
      case 8: {
        DecodeStep10();
        break;
      }
      case 9: {
        DecodeStep11();
        break;
      }
      case 10: {
        DecodeStep12();
        break;
      }
      case 11: {
        DecodeStep13();
        break;
      }
      case 12: {
        DecodeStep14();
        break;
      }
      case 13: {
        DecodeStep15();
        break;
      }
      case 14: {
        DecodeStep16();
        break;
      }
      case 15: {
        DecodeStep17();
        break;
      }
    }
  }
  bool RefillTo16() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7: {
        return Read2to7Bytes();
      }
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  void Done3() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp11(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit11(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp12(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit12(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            sink_(GetEmit16(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            sink_(GetEmit17(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp18(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            sink_(GetEmit18(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp19(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            sink_(GetEmit19(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp20(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            sink_(GetEmit20(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp21(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit21(index, (op >> 3) + 0));
            sink_(GetEmit21(index, (op >> 3) + 1));
            sink_(GetEmit21(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit21(index, (op >> 3) + 0));
            sink_(GetEmit21(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit21(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp22(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            sink_(GetEmit22(index, (op >> 3) + 1));
            sink_(GetEmit22(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            sink_(GetEmit22(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp23(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            sink_(GetEmit23(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 15: {
        const auto index = buffer_ & 32767;
        const auto op = GetOp24(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit24(index, (op >> 3) + 0));
            sink_(GetEmit24(index, (op >> 3) + 1));
            sink_(GetEmit24(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit24(index, (op >> 3) + 0));
            sink_(GetEmit24(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit24(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep3() {
    if (!RefillTo1()) {
      Done4();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp25(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit25(index, emit_ofs + 0));
  }
  void Done4() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep4() {
    if (!RefillTo1()) {
      Done5();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp26(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit26(index, emit_ofs + 0));
  }
  void Done5() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep5() {
    if (!RefillTo1()) {
      Done6();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp27(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit27(index, emit_ofs + 0));
  }
  void Done6() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep6() {
    if (!RefillTo1()) {
      Done7();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp28(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit28(index, emit_ofs + 0));
  }
  void Done7() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep7() {
    if (!RefillTo1()) {
      Done8();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp29(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit29(index, emit_ofs + 0));
  }
  void Done8() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep8() {
    if (!RefillTo1()) {
      Done9();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp30(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit30(index, emit_ofs + 0));
  }
  void Done9() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep9() {
    if (!RefillTo1()) {
      Done10();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp31(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit31(index, emit_ofs + 0));
  }
  void Done10() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep10() {
    if (!RefillTo1()) {
      Done11();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp32(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit32(index, emit_ofs + 0));
  }
  void Done11() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep11() {
    if (!RefillTo1()) {
      Done12();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp33(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit33(index, emit_ofs + 0));
  }
  void Done12() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep12() {
    if (!RefillTo1()) {
      Done13();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp34(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit34(index, emit_ofs + 0));
  }
  void Done13() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep13() {
    if (!RefillTo1()) {
      Done14();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp35(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit35(index, emit_ofs + 0));
  }
  void Done14() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep14() {
    if (!RefillTo1()) {
      Done15();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp36(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit36(index, emit_ofs + 0));
  }
  void Done15() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep15() {
    if (!RefillTo1()) {
      Done16();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp37(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit37(index, emit_ofs + 0));
  }
  void Done16() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep16() {
    if (!RefillTo1()) {
      Done17();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp38(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit38(index, emit_ofs + 0));
  }
  void Done17() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep17() {
    if (!RefillTo3()) {
      Done18();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 3)) & 0x7;
    const auto op = GetOp39(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 3;
    switch ((op >> 2) & 1) {
      case 0: {
        sink_(GetEmit39(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  bool RefillTo3() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done18() {
    done_ = true;
    switch (buffer_len_) {
      case 1: {
        const auto index = buffer_ & 1;
        const auto op = GetOp40(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit40(index, (op >> 1) + 0));
            break;
          }
        }
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp41(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit41(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_11_16
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_11_16_H
