---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab repo clone`

Clone a GitLab repository or project.

## Synopsis

Clone supports these shorthand references:

- repo
- namespace/repo
- org/group/repo
- project ID

```plaintext
glab repo clone <repo> [flags] [<dir>] [-- <gitflags>...]
glab repo clone -g <group> [flags] [<dir>] [-- <gitflags>...]
```

## Examples

```plaintext
$ glab repo clone profclems/glab

$ glab repo clone https://gitlab.com/profclems/glab

# Clones repository into 'mydirectory'
$ glab repo clone profclems/glab mydirectory

# Clones repository 'glab' for current user
$ glab repo clone glab

# Finds the project by the ID provided and clones it
$ glab repo clone 4356677

# Clones all repos in a group
$ glab repo clone -g everyonecancontribute --paginate

# Clones all non-archived repos in a group
$ glab repo clone -g everyonecancontribute --archived=false --paginate

# Clones from a GitLab Self-Managed or GitLab Dedicated instance
$ GITLAB_HOST=salsa.debian.org glab repo clone myrepo

```

## Options

```plaintext
  -g, --group string          Specify the group to clone repositories from.
  -p, --preserve-namespace    Clone the repository in a subdirectory based on namespace.
  -a, --archived              Limit by archived status. Use with '-a=false' to exclude archived repositories. Used with the --group flag.
  -G, --include-subgroups     Include projects in subgroups of this group. Default is true. Used with the --group flag. (default true)
  -m, --mine                  Limit by projects in the group owned by the current authenticated user. Used with the --group flag.
  -v, --visibility string     Limit by visibility: public, internal, private. Used with the --group flag.
  -I, --with-issues-enabled   Limit by projects with the issues feature enabled. Default is false. Used with the --group flag.
  -M, --with-mr-enabled       Limit by projects with the merge request feature enabled. Default is false. Used with the --group flag.
  -S, --with-shared           Include projects shared to this group. Default is true. Used with the --group flag. (default true)
      --paginate              Make additional HTTP requests to fetch all pages of projects before cloning. Respects --per-page.
      --page int              Page number. (default 1)
      --per-page int          Number of items to list per page. (default 30)
```

## Options inherited from parent commands

```plaintext
      --help   Show help for this command.
```
