/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { describe, it, expect, beforeEach } from 'vitest';
import { modelCommand } from './modelCommand.js';
import {} from './types.js';
import { createMockCommandContext } from '../../test-utils/mockCommandContext.js';
describe('modelCommand', () => {
    let mockContext;
    beforeEach(() => {
        mockContext = createMockCommandContext();
    });
    it('should return a dialog action to open the model dialog', async () => {
        if (!modelCommand.action) {
            throw new Error('The model command must have an action.');
        }
        const result = await modelCommand.action(mockContext, '');
        expect(result).toEqual({
            type: 'dialog',
            dialog: 'model',
        });
    });
    it('should have the correct name and description', () => {
        expect(modelCommand.name).toBe('model');
        expect(modelCommand.description).toBe('Opens a dialog to configure the model');
    });
});
//# sourceMappingURL=modelCommand.test.js.map