#ifndef _FIRSTHASH_H_INCLUDED_
#define _FIRSTHASH_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// FirstHash.h
// -----------
// Dragon fist hash interface defintion
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: FirstHash
// 
// Description: access to dragon termianal information 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

class FirstHash {
public:
    
    FirstHash();
    FirstHash(const Chain& prodName);
    FirstHash(const Chain& prodName, const SetT<Chain>& firstSet);
    ~FirstHash();
    
    
    SetT<Chain>& getFirstSet();
    
    FirstHash& operator = (const FirstHash& s);
    bool operator == (const FirstHash& s);
	
private:
    
    Chain _prodName;
    SetT<Chain> _firstSet;
    
};

#endif





