///////////////////////////////////////////////////////////////////////////////
//                                                         
// FSMTransition.cc
// ----------------
// Dragon final state machine transition implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: FSMTransition
// 
// Description: state transition description of the dragon FSM 
//
///////////////////////////////////////////////////////////////////////////////

#include "FSMTransition.h"

FSMTransition::FSMTransition()
{
    _source = 0;
    _target = 0;
    _sign = 0;
}

FSMTransition::FSMTransition(const FSMTransition& x)
{
    _source = x._source;
    _target = x._target;
    _sign = x._sign;
}

FSMTransition::FSMTransition(unsigned long source, char sign)
{
    _source = source;
    _sign = sign;
}

FSMTransition::FSMTransition(unsigned long source, unsigned long target, char sign)
{
    _source = source;
    _target = target;
    _sign = sign;
}

FSMTransition::~FSMTransition()
{  
}

void FSMTransition::setSource(unsigned long source)
{
    _source = source;
}

void FSMTransition::setTarget(unsigned long target)
{
    _target = target;
}

unsigned long FSMTransition::Source()
{
    return _source;
}

unsigned long FSMTransition::Target()
{
    return _target;
}

char FSMTransition::Sign()
{
    return _sign;
}

FSMTransition FSMTransition::operator = (const FSMTransition& x)
{
    _source = x._source;
    _target = x._target;
    _sign = x._sign;
    return (*this);
}
    
bool FSMTransition::operator < (FSMTransition x)
{
    if (_source < x._source)
    {	
	return true;
    }    
    else
    {	
	if (_source == x._source)
	{
	    if (_target < x._target)
	    {	
		return true;
	    }    
	    else
	    {	
		if (_target == x._target)
		{
		    if (_sign < x._sign)
		    {	
			return true;
		    }    
		    else
		    {	
			if (_sign == x._sign)
			{
			    return false;			    
			}
			else
			{
			    return false;
			}
		    }
		}   
		else
		{
		    return false;
		}
	    }	    
	}
	else
	{
	    return false;
	}
    }
}

    
bool FSMTransition::operator > (FSMTransition x)
{
    if (_source > x._source)
    {	
	return true;
    }    
    else
    {	
	if (_source == x._source)
	{
	    if (_target > x._target)
	    {	
		return true;
	    }    
	    else
	    {	
		if (_target == x._target)
		{
		    if (_sign > x._sign)
		    {	
			return true;
		    }    
		    else
		    {	
			if (_sign == x._sign)
			{
			    return false;			    
			}
			else
			{
			    return false;
			}
		    }
		}   
		else
		{
		    return false;
		}
	    }	    
	}
	else
	{
	    return false;
	}
    }
}


bool FSMTransition::operator == (FSMTransition x)
{
    if (_source == x._source && _target == x._target && _sign == x._sign)
	return true;
    return false;    
}
