# 0.82.1 release notes

**Release date:** 2025-04-04


## Summary

The main focus of this maintenance release is to fix a couple of regressions
introduced in 0.82.0 and older releases, mostly related to game compatibility.
The other big improvement is the CPU usage of the 3dfx Voodoo emulation has
been reduced by about 50%, so your computer won't go into hoover-mode anymore
when playing those Voodoo games :sunglasses: :cyclone:

This release was made possible by everyone who tried 0.82.0, submitted bugs
and pull requests, and tested the updates. Thank you!


### Game compatibility fixes

- Fix **DreamWeb** regression introduced in [0.81.2](0.81.2.md) where the
  grayscale text in the intro appeared "quantised" to pure black and white
  colours.

- Fix **Epic Pinball: Super Android (shareware v1.1)** regression where the
  music was playing too quickly with doubled notes on the Gravis UltraSound
  (the **Epic Pinball: The Complete Collection** CD version was not affected).

- Fix audio stuttering regression above ~100k cycles in **Nethack:
  Falcon's Eye**.

- Fix regression where an executable could not be started by its
  extensionless name if another file with the same name and no extension was
  present in the same directory (e.g., if you had `SKI.EXE` and `SKI` in the
  same directory, `SKI.EXE` would start the executable, but `SKI` resulted in
  an error). A non-exhaustive list of affected games:

    <div class="compact">
      <ul>
        <li>**Fahrenheit 451**</li>
        <li>**Overkill**</li>
        <li>**Ski or Die** </li>
        <li>**Treasure Island**</li>
        <li>**Wizard of Oz**</li>
      </ul>
    </div>

- Fix **Jane's Combat Simulations AH-64D Longbow** (original non-Gold
  version) regression where the in-game options menu could not be opened
  (v1.07), and fix the game crashing when launching any mission (v1.08).

- Fix emulator crash in **Chess Housers (1993)** which happened a few
  seconds after starting the game.

- Fix dual-mouse gaming support not working on Windows. This broke dual-mouse
  support in **The Settlers** and **The Settlers II: Veni, Vidi, Vici**.


### Other fixes and enhancements

- The CPU usage of the 3dfx Voodoo emulation has been reduced by about 50%.

- Fix regression where the audio was not muted when the mapper was open.

- Fix subtle Gravis UltraSound regression where the high-frequency content
  of the GUS's output was a little harsher than before in some games.

- The default audio volume (master channel volume) has been reduced to 50% (-6
  dB) in the mixer to avoid audible distortion in games with a loud output.

- Enabling crossfeed (e.g., by setting `crossfeed = on` in the config) now
  only applies the crossfeed effect to the **OPL** and **CMS** channels.

- Fix old regression introduced in [0.78.0](0.78.0.md) where the zoom-rotator
  effects in the demos **Show** and **Face** by **Majic 12** were offset
  horizontally by roughly half the screen.

- Fix regression where sometimes the real mode cycles value was incorrectly
  displayed in the DOSBox Staging window's title bar in protected mode
  programs.

- File sharing and locking emulation introduced in [0.82.0](0.82.0.md) can now
  be disabled with the new `file_locking` setting. A very small number of DOS
  programs might misbehave or crash with file locking enabled (e.g., the demo
  [Astral Blur by TBL](https://www.pouet.net/prod.php?which=1)).


### Other changes

- The minimum required macOS version has been increased from **macOS 10.15
  Catalina** to **macOS 11 Big Sur**.


## Installation

This is a drop-in upgrade for users already on [0.82.0](0.82.0.md)---no
configuration changes are necessary.

For those upgrading from an earlier DOSBox Staging version, please follow
these [upgrade instructions](0.82.0.md/#how-to-upgrade) and read the 
earlier release notes to learn about the changes and new features.

First-time users and people migrating from other DOSBox variants should start
by reading the [Getting started guide](../../getting-started/index.md).


## Graphics

### 3dfx Voodoo improvements

- The CPU usage of the Voodoo emulation has been reduced by about 50%.

- `voodoo_threads = auto` now sets threads equal to the number of logical
  (hyperthreaded) CPU cores rather than just physical cores. The maximum
  number of threads `auto` will set has been raised from 8 to 16.

- You can now manually set `voodoo_threads` to a maximum of 128 threads (up
  from 16). We don't know how well it will perform at high thread counts, but
  if you have an AMD Ryzen Threadripper, please let us know if it scales
  :sunglasses:

- Bilinear filtering is now enabled by default to emulate the characteristic
  Voodoo look more authentically.

- The descriptions of the Voodoo settings have been improved.


### Other changes

- Fix **DreamWeb** regression introduced in 0.81.2 where the grayscale text in
  the intro appeared "quantised" to pure black and white colours.

- Fix old regression introduced in 0.78.0 where the zoom-rotator effects in
  the demos **Show** and **Face** by **Majic 12** were offset horizontally by
  roughly half the screen.

- The 132x28, 132x30, and 132x34 DOSBox-special VESA text modes are now only
  available if `vesa_modes = all` is set (e.g., when trying to set them via
  the `MODE` command).


??? note "Full PR list of graphics-related changes"

    - Enable bilinear filtering for the 3dfx Voodoo by default (#4250)
    - Fix VGA draw address calculation (#4062)
    - Fix `INT10_SetVideoMode()` regression (#4182)
    - Use std::atomic's wait over busy wait in Voodoo (#4220)
    - VESA 2.0 mode list regression fix (#4245)


## Sound

### Lower the default master volume

The default audio volume (master channel volume) has been reduced to 50% (-6
dB) in the mixer to avoid audible distortion in games with a loud output. This
also helps with overly loud SoundFonts.

You can use the `mixer master 100` DOS command to restore the previous
behaviour, but it's advised to only do that for games that are too quiet on a
case-by-case basis. An even better solution is to only raise the volume of the
channels that need a bit of a boost (e.g., run `mixer sb 200` to make the
Sound Blaster digital output twice as loud).


### Gravis UltraSound changes

- Fixed **Epic Pinball: Super Android (shareware v1.1)** regression where the
  music was playing too quickly with doubled notes on the Gravis UltraSound
  (the **Epic Pinball: The Complete Collection** CD version was not affected).

- Fixed regression where the Gravis UltraSound would play back static noise
  after it was enabled, disabled, and then re-enabled via the `CONFIG` command.

- Fixed subtle Gravis UltraSound regression where the high-frequency content
  of the GUS's output was a little harsher than before. This was mostly only
  noticeable in music with lots of hi-hats and similar high-pitched sounds.

- Additionally, the sound of the Gravis UltraSound Classic and MAX models are
  emulated more faithfully now. This includes the emulation of the analog
  low-pass output filter which is enabled by default.


### Other fixes & improvements

- Fixed audio stuttering regression above ~100k cycles in **Nethack:
  Falcon's Eye**.

- Fixed regression where the audio was not muted when the mapper was open.

- Enabling crossfeed (e.g., by setting `crossfeed = on` in the config) now
  only applies the crossfeed effect to the **OPL** and **CMS** channels. These
  are the two devices that typically feature hard-panned sounds. Previously,
  crossfeed presets applied to all stereo channels, but this was rarely
  wanted.  You can apply crossfeed to other channels as well with the `MIXER`
  command if you want (e.g., `MIXER GUS x50`).

- Downgrade FluidSynth to v2.3.5 on Windows and use single-precision float
  mode. This fixes at least **Trevor0402's SC-55 SoundFont** on Windows
  (typically called `SC-55.SoundFont.v1.2b.sf2` or `SC-55 SoundFont.v1.2b
  [Trevor0402].sf2`) and ensures identical SoundFont playback on all
  supported platforms when using our official builds.


??? note "Full PR list of sound-related changes"

    - Add custom vcpkg overlay port for FluidSynth (#4267)
    - Delete the GUS tick handler in the destructor (#4183)
    - Fix GUS resampling regression & emulate the GUS' output more authentically (#4219)
    - Improve default crossfeed setting behaviour (#4223)
    - Lower default master volume (#4105)
    - Mute audio when the mapper is active (#4195)
    - Remove std::atomic from performance critical global variables (#4181)
    - Revert "Keep GUS running (and rendering) on IO port reads" (#4216)


## Input

- Fixed dual-mouse gaming support not working on Windows. This broke the
  dual-mouse support in **The Settlers** and **The Settlers II: Veni, Vidi,
  Vici**.

??? note "Full PR list of input-related changes"

    - Fix ManyMouse support in Windows builds (#4035)
    - Improve some mouse setting descriptions (#4206)


## DOS integration

### Make file locking configurable

We've added a new `file_locking` setting to allow disabling the [file sharing
and locking](0.82.0.md/#file-sharing-support) support introduced in
[0.82.0](0.82.0.md).

Previously, the feature was always enabled which did not cause problems for
the vast majority of DOS software, but it did cause a regression for the demo
[Astral Blur by TBL](https://www.pouet.net/prod.php?which=1).

Please refer to the setting's description to learn more (e.g., run `config -h
file_locking` from the DOS prompt).

### Other fixes

- Fixed a regression where an executable could not be started by its
  extensionless name if another file with the same name and no extension was
  present in the same directory. E.g., if you had `SKI.EXE` and `SKI` in the
  same directory, `SKI.EXE` would start the executable, but `SKI` would result
  in an "Invalid command" error. Here's a non-exhaustive list of affected
  games (probably a lot more games were affected):

    <div class="compact">
      <ul>
        <li>**Fahrenheit 451**</li>
        <li>**Overkill**</li>
        <li>**Ski or Die** </li>
        <li>**Treasure Island**</li>
        <li>**Wizard of Oz**</li>
      </ul>
    </div>

- Fixed an obscure issue where the game **Abuse** failed to launch on Windows
  7 and newer versions of Windows when using a network drive.


??? note "Full PR list of DOS integration-related changes"

    - Add a file_locking config option (#4024)
    - Fix command line parser bug where an extension-less file prevents execution (#4185 )
    - Rename files on Windows before delete (#4152)


## Localisation

- Update the Polish translation.

??? note "Full PR list of localisation-related changes"



## General

- Fixed emulator crash in **Chess Housers (1993)** which happened a few
  seconds after starting the game.

- Fixed a bug where setting the startup verbosity level could lead to a black
  screen after starting the emulator.

- Fixed a regression where configuration settings were handled in a
  case-sensitive manner across the board (they should be case-insensitive;
  `cpu_cycles`, `CPU_CYCLES` and `Cpu_CYCles` should refer to the same
  setting).

- Fixed an old regression where path names passed to the DOSBox Staging
  executable were not always handled properly. This caused problems when
  passing a directory name with spaces in it to mount it as the C drive (e.g.,
  `dosbox.exe "some directory name"`).

- Improved the formatting of newly written config files by separating setting
  descriptions with blank lines.

- DOSBox Staging will now queue changes for unchangeable settings such as
  `machine` and `memsize`, and use them when restarting with `CONFIG -r` or
  via the restart hotkey. For example, run the following commands to change
  the machine type to CGA and use 1 MB of RAM:

        Z:\> machine cga
        Z:\> memsize 1
        Z:\> config -r

- Fixed regression where sometimes the real mode cycles value was incorrectly
  displayed in the DOSBox Staging window's title bar in protected mode
  programs.


??? note "Full PR list of project maintenance-related changes"

    - Remove Coverity static analysis (#4171)


??? note "Full PR list of miscellaneous changes"

    - Display the correct real or protected mode cycles value in the title bar (#4221)
    - Do not hard exit when encountering unimplemented PIC functions (#4225) 
    - Eliminate the internal `InstantLaunch` verbosity level (#4054)
    - Fix configuration setting case sensitivity regression (#4057)
    - Fix support for space in the directory name argument (#4150)
    - Improve the formatting of the written config file (#4048)
    - Let unchangeable settings be queued and used on restart (#4055)


??? note "Full PR list of other changes"

    - Bump macOS runner to macOS-13 (#4038)
    - Set 'actions/cache' to 'v4' (#4153)


## 0.82.1 commit authors

<div class="compact" markdown>

  - interloper98
  - johnnovak
  - weirddan455
  - FeralChild64
  - Torinde

</div>


## Thank you

We are grateful for all the community contributions and the original DOSBox
project, on which DOSBox Staging is based.

