## Contributing

Thanks for your interest in C++/WinRT! You are welcome to contribute by filing issues for problems you encounter.
Project maintainers will consider changes that improve compatibility or fix bugs. 

The following process is required in order to have a pull request considered:

* File an issue for any change you would like to propose. This can start a discussion so we can agree on an approach
before you invest a large amount of time. Due to the large number of dependent projects, contributions that include
compatibility risk or added complexity will generally be rejected. 

* Contributors will need the help of a project maintainer to verify the change with the Windows operating system
build system. If a project maintainer is available to provide guidance and mentorship for the change, a pull request
may be opened to begin the formal review process. 

Most contributions require you to agree to a Contributor License Agreement (CLA) declaring that
you have the right to, and actually do, grant us the rights to use your contribution. For details,
visit https://cla.opensource.microsoft.com.

When you submit a pull request, a CLA bot will automatically determine whether you need to provide
a CLA and decorate the PR appropriately (e.g., status check, comment). Simply follow the instructions
provided by the bot. You will only need to do this once across all repos using our CLA.

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or
contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.
