      PROGRAM TEST
!
!     SAMPLE ADF TEST PROGRAM TO BUILD ADF FILES ILLUSTRATED
!     IN THE EXAMPLE DATABASE FIGURE
!
      PARAMETER (MAXCHR=32)
!
      CHARACTER*(MAXCHR) TSTLBL,DTYPE
      CHARACTER*(MAXCHR) FNAM,PATH
!
      REAL*8 RID,PID,CID,TMPID,RIDF2
      REAL A(4,3),B(4,3)
      INTEGER IC(6),ID(6)
      INTEGER IERR
      INTEGER IDIM(2),IDIMA(2),IDIMC,IDIMD
!
      DATA A /1.1,2.1,3.1,4.1, &
              1.2,2.2,3.2,4.2, &
              1.3,2.3,3.3,4.3/
      DATA IDIMA /4,3/
!
      DATA IC /1,2,3,4,5,6/
      DATA IDIMC /6/
!
!     SET ERROR FLAG TO ABORT ON ERROR
!
      CALL ADFSES(1,IERR)
!
! *** 1.) OPEN 1ST DATABASE (ADF_FILE_TWO.ADF)
!     2.) CREATE THREE NODES AT FIRST LEVEL
!     3.) PUT LABEL ON NODE F3
!     4.) PUT DATA IN F3
!     5.) CREATE TWO NODES BELOW F3
!     6.) CLOSE DATABASE
!
      CALL ADFDOPN('adf_file_two.adf','NEW',' ',RID,IERR)
      RIDF2 = RID
      CALL ADFCRE(RID,'F1',TMPID,IERR)
      CALL ADFCRE(RID,'F2',TMPID,IERR)
      CALL ADFCRE(RID,'F3',PID,IERR)
      CALL ADFSLB(PID,'LABEL ON NODE F3',IERR)
      CALL ADFPDIM(PID,'R4',2,IDIMA,IERR)
      CALL ADFWALL(PID,A,IERR)
!
      CALL ADFCRE(PID,'F4',CID,IERR)
!
      CALL ADFCRE(PID,'F5',CID,IERR)
!
      CALL ADFDCLO(RID,IERR)
!
! *** 1.) OPEN 2ND DATABASE
!     2.) CREATE NODES
!     3.) PUT DATA IN N13
!
      CALL ADFDOPN('adf_file_one.adf','NEW',' ',RID,IERR)
!
!     THREE NODES UNDER ROOT
!
      CALL ADFCRE(RID,'N1',TMPID,IERR)
      CALL ADFCRE(RID,'N2',TMPID,IERR)
      CALL ADFCRE(RID,'N3',TMPID,IERR)
!
!     THREE NODES UNDER N1 (TWO REGULAR AND ONE LINK)
!
      CALL ADFGNID(RID,'N1',PID,IERR)
      CALL ADFCRE(PID,'N4',TMPID,IERR)
      CALL ADFLINK(PID,'L3','adf_file_two.adf','/F3',TMPID,IERR)
      CALL ADFCRE(PID,'N5',TMPID,IERR)
!
!     TWO NODES UNDER N4
!
      CALL ADFGNID(PID,'N4',CID,IERR)
      CALL ADFCRE(CID,'N6',TMPID,IERR)
      CALL ADFCRE(CID,'N7',TMPID,IERR)
!
!     ONE NODE UNDER N6
!
      CALL ADFGNID(RID,'/N1/N4/N6',PID,IERR)
      CALL ADFCRE(PID,'N8',TMPID,IERR)
!
!     THREE NODES UNDER N3
!
      CALL ADFGNID(RID,'N3',PID,IERR)
      CALL ADFCRE(PID,'N9',TMPID,IERR)
      CALL ADFCRE(PID,'N10',TMPID,IERR)
      CALL ADFCRE(PID,'N11',TMPID,IERR)
!
!     TWO NODES UNDER N9
!
      CALL ADFGNID(PID,'N9',CID,IERR)
      CALL ADFCRE(CID,'N12',TMPID,IERR)
      CALL ADFCRE(CID,'N13',TMPID,IERR)
!
!     PUT LABEL AND DATA IN N13
!
      CALL ADFSLB(TMPID,'LABEL ON NODE N13',IERR)
      CALL ADFPDIM(TMPID,'I4',1,IDIMC,IERR)
      CALL ADFWALL(TMPID,IC,IERR)
!
!     TWO NODES UNDER N10
!
      CALL ADFGNID(RID,'/N3/N10',PID,IERR)
      CALL ADFLINK(PID,'L1',' ','/N3/N9/N13',TMPID,IERR)
      CALL ADFCRE(PID,'N14',TMPID,IERR)
!
!     TWO NODES UNDER N11
!
      CALL ADFGNID(RID,'/N3/N11',PID,IERR)
      CALL ADFLINK(PID,'L2',' ','/N3/N9/N13',TMPID,IERR)
      CALL ADFCRE(PID,'N15',TMPID,IERR)
!
! *** READ AND PRINT DATA FROM NODES
!     1.) NODE F5 THROUGH LINK L3
!
      CALL ADFGNID(RID,'/N1/L3',PID,IERR)
      CALL ADFGLB(PID,TSTLBL,IERR)
      CALL ADFGDT(PID,DTYPE,IERR)
      CALL ADFGND(PID,NUMDIM,IERR)
      CALL ADFGDV(PID,IDIM,IERR)
      CALL ADFRALL(PID,B,IERR)
      PRINT *,' NODE F3 THROUGH LINK L3:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA TYPE   = ',DTYPE
      PRINT *,'   NUM OF DIMS = ',NUMDIM
      PRINT *,'   DIM VALS    = ',IDIM
      PRINT *,'   DATA:'
      WRITE(*,100)((B(J,I),I=1,3),J=1,4)
  100 FORMAT(5X,3F10.2)
!
!     2.) N13
!
      CALL ADFGNID(RID,'N3/N9/N13',PID,IERR)
      CALL ADFGLB(PID,TSTLBL,IERR)
      CALL ADFGDT(PID,DTYPE,IERR)
      CALL ADFGND(PID,NUMDIM,IERR)
      CALL ADFGDV(PID,IDIMD,IERR)
      CALL ADFRALL(PID,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA TYPE   = ',DTYPE
      PRINT *,'   NUM OF DIMS = ',NUMDIM
      PRINT *,'   DIM VALS    = ',IDIMD
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
  200 FORMAT(5X,6I6)
!
!     3.) N13 THROUGH L1
!
      CALL ADFGNID(RID,'N3/N10/L1',TMPID,IERR)
      CALL ADFGLB(TMPID,TSTLBL,IERR)
      CALL ADFRALL(TMPID,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13 THROUGH LINK L1:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
!
!     4.) N13 THROUGH L2
!
      CALL ADFGNID(RID,'N3/N11/L2',CID,IERR)
      CALL ADFGLB(CID,TSTLBL,IERR)
      CALL ADFRALL(CID,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13 THROUGH LINK L2:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
!
!     PRINT LIST OF CHILDREN UNDER ROOT NODE
!
      CALL PRTCLD(RID)
!
!     PRINT LIST OF CHILDREN UNDER N3
!
      CALL ADFGNID(RID,'N3',PID,IERR)
      CALL PRTCLD(PID)
!
!     REOPEN ADF_FILE_TWO AND GET NEW ROOT ID
!
      CALL ADFDOPN('adf_file_two.adf','OLD',' ',RID,IERR)
      PRINT *,' '
      PRINT *,' COMPARISON OF ROOT ID: '
      PRINT *,' ADF_FILE_TWO.ADF ORIGINAL ROOT ID = ',RIDF2
      PRINT *,' ADF_FILE_TWO.ADF NEW ROOT ID      = ',RID
!
      STOP
      END
!
! ************* SUBROUTINES ****************
!
      SUBROUTINE PRTCLD(PID)
!
! *** PRINT TABLE OF CHILDREN GIVEN A PARENT NODE-ID
!
      PARAMETER (MAXCLD=10)
      PARAMETER (MAXCHR=32)
      REAL*8 PID
      CHARACTER*(MAXCHR) NODNAM,NDNMS(MAXCLD)
      CALL ADFGNAM(PID,NODNAM,IERR)
      CALL ADFNCLD(PID,NUMC,IERR)
      WRITE(*,120)NODNAM,NUMC
  120 FORMAT(/,' PARENT NODE NAME = ',A,/, &
             '     NUMBER OF CHILDREN = ',I2,/, &
             '     CHILDREN NAMES:')
      NLEFT = NUMC
      ISTART = 1
!     --- TOP OF DO-WHILE LOOP
  130 CONTINUE
!        CALL ADFCNAM(PID,ISTART,MAXCLD,LEN(NDNMS),
!---------------- g77 doesn't like this ^
         CALL ADFCNAM(PID,ISTART,MAXCLD,MAXCHR, &
                      NUMRET,NDNMS,IERR)
         WRITE(*,140)(NDNMS(K),K=1,NUMRET)
  140    FORMAT(8X,A)
         NLEFT = NLEFT - MAXCLD
         ISTART = ISTART + MAXCLD
      IF (NLEFT .GT. 0) GO TO 130
      RETURN
      END


