#ifndef _CEGOORDERCURSOR_H_INCLUDED_
#define _CEGOORDERCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderCursor.h
// ------------------
// Cego order cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoOrderCursor
// 
// Description: Traversing on a sorted AVL tuple tree
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/AVLTreeT.h>
// CEGO INCLUDES
#include "CegoTableManager.h"
#include "CegoDataPointer.h"
#include "CegoOrderNode.h"

class CegoOrderCursor {
    
public:
    
    CegoOrderCursor(AVLTreeT<CegoOrderNode>* pAVL, ListT<CegoField>& schema);
    ~CegoOrderCursor();
    
    bool getFirst(ListT<CegoField>& fl);
    bool getNext(ListT<CegoField>& fl);
    
    void abort();

 private:

    ListT<CegoField> _schema;
    AVLTreeT<CegoOrderNode>* _pAVL;
    
};

#endif
