#ifndef _CEGOEXPR_H_INCLUDED_
#define _CEGOEXPR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoExpr.h
// ----------
// Cego expression class definition
//
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoExpr
// 
// Description: Query expression container class 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>

// CEGO INCLUDES
#include "CegoTerm.h"
#include "CegoProcStmt.h"

class CegoDistManager;

class CegoExpr {

public:

    enum ExpType { ADD, SUB, TERM, CONCAT  };
    
    CegoExpr();
    CegoExpr(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoExpr(Element* pExpElement, CegoDistManager *pGTM);
    CegoExpr(CegoExpr *pExpr, CegoTerm *pTerm, ExpType expType, const Chain& alias = Chain());
    CegoExpr(CegoTerm *pTerm, const Chain& alias = Chain());

    ~CegoExpr();

    void cleanUp();

    void setTabSetId(int tabSetId);
    
    void setAlias(const Chain& alias);
    const Chain& getAlias() const;

    bool checkConst() const;
    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;

    bool checkLob(CegoFieldValue& fv);
    
    void getFunctionList(SetT<CegoObject>& funcList);
    
    void setBlock(CegoProcBlock *pBlock);
    void setFieldListArray(ListT<CegoField>* pFL);

    void setExternalFieldListArray(ListT<CegoField> **pFLA);
    void setFieldListArray(ListT<CegoField> **pFLA);

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    void getFieldList(ListT<CegoField>& fl) const;
    CegoField evalField(const ListT<CegoField>& fl) const;
    CegoFieldValue evalFieldValue() const;

    void clearAttrCache();

    void getSelectQueryList(ListT<CegoSelect*>& queryList);

    ExpType getType() const;
    CegoTerm *getTerm() const;
    CegoExpr *getExpr() const;
   
    ListT<CegoAggregation*>& getAggregationList();

    CegoExpr* clone(bool isAttrRef = false);

    CegoExpr& operator = ( const CegoExpr& e);

    Chain getId() const;
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;

    Element* toElement() const;
    void fromElement(Element *pExpElement, CegoDistManager *pGTM);

    friend ostream& operator << (ostream& s, const CegoExpr& e);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM, int tabSetId);
    int getEncodingLength() const;

    void getPlanList(ListT<Element*>& planList);

private:
    
    bool _isAgg;
    ListT<CegoAggregation*> _aggList;
    
    ExpType _expType;

    Chain _alias;
    CegoExpr *_pExpr;
    CegoTerm *_pTerm;

    bool _isExtern;
    
    ListT<CegoField>* _fla[2];

};

#endif
