# Use, modification, and distribution are
# subject to the Boost Software License, Version 1.0. (See accompanying
# file LICENSE.txt)
#
# Copyright Rene Rivera 2020.

# For Drone CI we use the Starlark scripting language to reduce duplication.
# As the yaml syntax for Drone CI is rather limited.
#
#
globalenv={}
linuxglobalimage="cppalliance/droneubuntu1604:1"
windowsglobalimage="cppalliance/dronevs2019"

def main(ctx):
  return [
  
  linux_cxx("Ubuntu g++-6 std=gnu++14 arithmetic_tests", "g++-6", packages="g++-6 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-6', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-6 std=gnu++14 cpp_int_tests", "g++-6", packages="g++-6 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-6', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-6 std=gnu++14 functions_and_limits", "g++-6", packages="g++-6 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-6', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-6 std=gnu++14 conversions performance", "g++-6", packages="g++-6 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++-6', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-6 std=gnu++14 misc", "g++-6", packages="g++-6 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-6', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-6 std=gnu++14 compile_fail examples", "g++-6", packages="g++-6 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-6', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-6 std=gnu++14 concepts", "g++-6", packages="g++-6 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-6', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-8 std=gnu++14 arithmetic_tests", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++14 cpp_int_tests", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++14 functions_and_limits", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++14 conversions performance", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++14 misc", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++14 compile_fail examples", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++14 concepts", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-8 std=gnu++17 arithmetic_tests", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++17 cpp_int_tests", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++17 functions_and_limits", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++17 conversions performance", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++17 misc", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++17 compile_fail examples", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-8 std=gnu++17 concepts", "g++-8", packages="g++-8 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-8', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-9 std=gnu++14 arithmetic_tests", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++14 cpp_int_tests", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++14 functions_and_limits", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++14 conversions performance", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++14 misc", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++14 compile_fail examples", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++14 concepts", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-9 std=gnu++17 arithmetic_tests", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++17 cpp_int_tests", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++17 functions_and_limits", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++17 conversions performance", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++17 misc", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++17 compile_fail examples", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-9 std=gnu++17 concepts", "g++-9", packages="g++-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-9', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-10 std=gnu++14 arithmetic_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++14 cpp_int_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++14 functions_and_limits", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++14 conversions performance", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++14 misc", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++14 compile_fail examples", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++14 concepts", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-10 std=gnu++17 arithmetic_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++17 cpp_int_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++17 functions_and_limits", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  # No test of performance here, the object files get too large :(
  linux_cxx("Ubuntu g++-10 std=gnu++17 conversions", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'conversions', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++17 misc", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++17 compile_fail examples", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++17 concepts", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-10 std=gnu++20 arithmetic_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 cpp_int_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 functions_and_limits", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  # No test of performance here, the object files get too large :(
  linux_cxx("Ubuntu g++-10 std=gnu++20 conversions", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'conversions', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 misc", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 compile_fail examples", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 concepts", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu clang++-9 std=c++14 arithmetic_tests", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++14 cpp_int_test", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++14 functions_and_limits", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++14 conversions performance", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++14 misc", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++14 compile_fail examples", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++14 concepts", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu clang++-9 std=c++17 arithmetic_tests", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++17 cpp_int_test", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++17 functions_and_limits", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++17 conversions performance", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++17 misc", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++17 compile_fail examples", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-9 std=c++17 concepts", "clang++-9", packages="clang-9 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="9", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-9', 'CXXSTD': 'c++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu clang++-10 std=c++14 arithmetic_tests", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++14 cpp_int_test", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++14 functions_and_limits", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++14 conversions performance", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++14 misc", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++14 compile_fail examples", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++14 concepts", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu clang++-10 std=c++17 arithmetic_tests", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++17 cpp_int_test", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++17 functions_and_limits", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++17 conversions performance", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++17 misc", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++17 compile_fail examples", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++17 concepts", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu clang++-10 std=c++20 arithmetic_tests", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++20 cpp_int_test", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++20 functions_and_limits", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++20 conversions performance", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++20 misc", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++20 compile_fail examples", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', }, globalenv=globalenv),
  linux_cxx("Ubuntu clang++-10 std=c++20 concepts", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image="cppalliance/droneubuntu1804:1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  # Sanitizers:
  #linux_cxx("Ubuntu clang++-10 std=c++20 ASAN arithmetic_tests", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image=linuxglobalimage, environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'cxxflags=-fsanitize=address linkflags=-fsanitize=address arithmetic_tests', }, globalenv=globalenv),
  #linux_cxx("Ubuntu clang++-10 std=c++20 ASAN cpp_int_test", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image=linuxglobalimage, environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'cxxflags=-fsanitize=address linkflags=-fsanitize=address cpp_int_tests', }, globalenv=globalenv),
  #linux_cxx("Ubuntu clang++-10 std=c++20 ASAN functions_and_limits", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image=linuxglobalimage, environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'cxxflags=-fsanitize=address linkflags=-fsanitize=address functions_and_limits', }, globalenv=globalenv),
  #linux_cxx("Ubuntu clang++-10 std=c++20 ASAN conversions", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image=linuxglobalimage, environment={'TEST_SUITE': 'cxxflags=-fsanitize=address linkflags=-fsanitize=address conversions', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', }, globalenv=globalenv),
  #linux_cxx("Ubuntu clang++-10 std=c++20 ASAN misc", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image=linuxglobalimage, environment={'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', 'TEST_SUITE': 'cxxflags=-fsanitize=address linkflags=-fsanitize=address misc', }, globalenv=globalenv),
  #linux_cxx("Ubuntu clang++-10 std=c++20 ASAN examples", "clang++-10", packages="clang-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", llvm_os="xenial", llvm_ver="10", buildtype="boost", image=linuxglobalimage, environment={'TEST_SUITE': 'cxxflags=-fsanitize=address linkflags=-fsanitize=address examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++-10', 'CXXSTD': 'c++20', }, globalenv=globalenv),

  linux_cxx("Ubuntu g++-10 std=gnu++20 USAN arithmetic_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'cxxflags=-fsanitize=undefined linkflags=-fsanitize=undefined arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 USAN cpp_int_tests", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'cxxflags=-fsanitize=undefined linkflags=-fsanitize=undefined cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 USAN functions_and_limits", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'cxxflags=-fsanitize=undefined linkflags=-fsanitize=undefined functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 USAN conversions", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'cxxflags=-fsanitize=undefined linkflags=-fsanitize=undefined define=BOOST_CI_USAN_BUID conversions', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 USAN misc", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', 'TEST_SUITE': 'cxxflags=-fsanitize=undefined linkflags=-fsanitize=undefined misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu g++-10 std=gnu++20 USAN examples", "g++-10", packages="g++-10 libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2004:1", environment={'TEST_SUITE': 'cxxflags=-fsanitize=undefined linkflags=-fsanitize=undefined examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++-10', 'CXXSTD': 'gnu++20', }, globalenv=globalenv),

  # OS X:
  osx_cxx("XCode 15.0.1, c++14 arithmetic_tests", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++14 cpp_int_tests", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++14 functions_and_limits", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++14 conversions performance", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++14 misc", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++14 compile_fail examples", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++14 concepts", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  osx_cxx("XCode 15.0.1, c++17 arithmetic_tests", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++17 cpp_int_tests", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++17 functions_and_limits", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++17 conversions performance", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++17 misc", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++17 compile_fail examples", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++17 concepts", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  osx_cxx("XCode 15.0.1, c++2a arithmetic_tests", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++2a', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++2a cpp_int_tests", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++2a', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++2a functions_and_limits", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++2a', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++2a conversions performance", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++2a', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++2a misc", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++2a', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++2a compile_fail examples", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++2a', }, globalenv=globalenv),
  osx_cxx("XCode 15.0.1, c++2a concepts", "clang++", packages="", buildtype="boost", xcode_version="15.0.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++2a', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  osx_cxx("XCode 14.3.1, c++17 arithmetic_tests", "clang++", packages="", buildtype="boost", xcode_version="14.3.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  osx_cxx("XCode 14.3.1, c++17 cpp_int_tests", "clang++", packages="", buildtype="boost", xcode_version="14.3.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  osx_cxx("XCode 14.3.1, c++17 functions_and_limits", "clang++", packages="", buildtype="boost", xcode_version="14.3.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  osx_cxx("XCode 14.3.1, c++17 conversions performance", "clang++", packages="", buildtype="boost", xcode_version="14.3.1", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  osx_cxx("XCode 14.3.1, c++17 misc", "clang++", packages="", buildtype="boost", xcode_version="14.3.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  osx_cxx("XCode 14.3.1, c++17 compile_fail examples", "clang++", packages="", buildtype="boost", xcode_version="14.3.1", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', }, globalenv=globalenv),
  osx_cxx("XCode 14.3.1, c++17 concepts", "clang++", packages="", buildtype="boost", xcode_version="14.3.1", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  osx_cxx("XCode 14.2.0, c++14 arithmetic_tests", "clang++", packages="", buildtype="boost", xcode_version="14.2.0", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  osx_cxx("XCode 14.2.0, c++14 cpp_int_tests", "clang++", packages="", buildtype="boost", xcode_version="14.2.0", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  osx_cxx("XCode 14.2.0, c++14 functions_and_limits", "clang++", packages="", buildtype="boost", xcode_version="14.2.0", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  osx_cxx("XCode 14.2.0, c++14 conversions performance", "clang++", packages="", buildtype="boost", xcode_version="14.2.0", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  osx_cxx("XCode 14.2.0, c++14 misc", "clang++", packages="", buildtype="boost", xcode_version="14.2.0", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  osx_cxx("XCode 14.2.0, c++14 compile_fail examples", "clang++", packages="", buildtype="boost", xcode_version="14.2.0", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', }, globalenv=globalenv),
  osx_cxx("XCode 14.2.0, c++14 concepts", "clang++", packages="", buildtype="boost", xcode_version="14.2.0", environment={'TOOLSET': 'clang', 'COMPILER': 'clang++', 'CXXSTD': 'c++14', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu ARM64 g++ std=gnu++17 arithmetic_tests", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="arm64", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu ARM64 g++ std=gnu++17 cpp_int_tests", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="arm64", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu ARM64 g++ std=gnu++17 functions_and_limits", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="arm64", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu ARM64 g++ std=gnu++17 conversions performance", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="arm64", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu ARM64 g++ std=gnu++17 misc", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="arm64", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu ARM64 g++ std=gnu++17 compile_fail examples", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="arm64", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu ARM64 g++ std=gnu++17 concepts", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="arm64", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  linux_cxx("Ubuntu s390x g++ std=gnu++17 arithmetic_tests", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="s390x", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'arithmetic_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu s390x g++ std=gnu++17 cpp_int_tests", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="s390x", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'cpp_int_tests', }, globalenv=globalenv),
  linux_cxx("Ubuntu s390x g++ std=gnu++17 functions_and_limits", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="s390x", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'functions_and_limits', }, globalenv=globalenv),
  linux_cxx("Ubuntu s390x g++ std=gnu++17 conversions performance", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="s390x", environment={'TEST_SUITE': 'conversions performance', 'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu s390x g++ std=gnu++17 misc", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="s390x", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'misc', }, globalenv=globalenv),
  linux_cxx("Ubuntu s390x g++ std=gnu++17 compile_fail examples", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="s390x", environment={'TEST_SUITE': 'compile_fail examples', 'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', }, globalenv=globalenv),
  linux_cxx("Ubuntu s390x g++ std=gnu++17 concepts", "g++", packages="libgmp-dev libmpfr-dev libmpc-dev libmpfi-dev libtommath-dev", buildtype="boost", image="cppalliance/droneubuntu2204:multiarch", arch="s390x", environment={'TOOLSET': 'gcc', 'COMPILER': 'g++', 'CXXSTD': 'gnu++17', 'TEST_SUITE': 'concepts', }, globalenv=globalenv),

  ]

# from https://github.com/boostorg/boost-ci
load("@boost_ci//ci/drone/:functions.star", "linux_cxx","windows_cxx","osx_cxx","freebsd_cxx")
