# SPDX-FileCopyrightText: 2017-2022 Blender Foundation
#
# SPDX-License-Identifier: GPL-2.0-or-later

import bpy

from mathutils import Color


def create(obj):  # noqa
    # generated by rigify.utils.write_metarig
    bpy.ops.object.mode_set(mode='EDIT')
    arm = obj.data

    for i in range(6):
        arm.rigify_colors.add()

    arm.rigify_colors[0].name = "Root"
    arm.rigify_colors[0].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[0].normal = Color((0.4353, 0.1843, 0.4157))
    arm.rigify_colors[0].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[0].standard_colors_lock = True
    arm.rigify_colors[1].name = "IK"
    arm.rigify_colors[1].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[1].normal = Color((0.6039, 0.0000, 0.0000))
    arm.rigify_colors[1].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[1].standard_colors_lock = True
    arm.rigify_colors[2].name = "Special"
    arm.rigify_colors[2].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[2].normal = Color((0.9569, 0.7882, 0.0471))
    arm.rigify_colors[2].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[2].standard_colors_lock = True
    arm.rigify_colors[3].name = "Tweak"
    arm.rigify_colors[3].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[3].normal = Color((0.0392, 0.2118, 0.5804))
    arm.rigify_colors[3].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[3].standard_colors_lock = True
    arm.rigify_colors[4].name = "FK"
    arm.rigify_colors[4].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[4].normal = Color((0.1176, 0.5686, 0.0353))
    arm.rigify_colors[4].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[4].standard_colors_lock = True
    arm.rigify_colors[5].name = "Extra"
    arm.rigify_colors[5].active = Color((0.5490, 1.0000, 1.0000))
    arm.rigify_colors[5].normal = Color((0.9686, 0.2510, 0.0941))
    arm.rigify_colors[5].select = Color((0.3137, 0.7843, 1.0000))
    arm.rigify_colors[5].standard_colors_lock = True

    bone_collections = {}

    for bcoll in list(arm.collections):
        arm.collections.remove(bcoll)

    def add_bone_collection(name, *, ui_row=0, ui_title='', sel_set=False, color_set_id=0):
        new_bcoll = arm.collections.new(name)
        new_bcoll.rigify_ui_row = ui_row
        new_bcoll.rigify_ui_title = ui_title
        new_bcoll.rigify_sel_set = sel_set
        new_bcoll.rigify_color_set_id = color_set_id
        bone_collections[name] = new_bcoll

    def assign_bone_collections(pose_bone, *coll_names):
        assert not len(pose_bone.bone.collections)
        for name in coll_names:
            bone_collections[name].assign(pose_bone)

    def assign_bone_collection_refs(params, attr_name, *coll_names):
        ref_list = getattr(params, attr_name + '_coll_refs', None)
        if ref_list is not None:
            for name in coll_names:
                ref_list.add().set_collection(bone_collections[name])

    add_bone_collection('Face', ui_row=1, color_set_id=6)
    add_bone_collection('Face (Tweak)', ui_row=2, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Spine', ui_row=4, color_set_id=3)
    add_bone_collection('Spine (Tweak)', ui_row=5, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Wing.L', ui_row=7, color_set_id=5)
    add_bone_collection('Wing.L (Tweak)', ui_row=8, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Wing.R', ui_row=7, color_set_id=5)
    add_bone_collection('Wing.R (Tweak)', ui_row=8, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Leg.L (IK)', ui_row=11, color_set_id=2)
    add_bone_collection('Leg.L (FK)', ui_row=12, ui_title='(FK)', color_set_id=5)
    add_bone_collection('Leg.L (Tweak)', ui_row=13, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Leg.R (IK)', ui_row=11, color_set_id=2)
    add_bone_collection('Leg.R (FK)', ui_row=12, ui_title='(FK)', color_set_id=5)
    add_bone_collection('Leg.R (Tweak)', ui_row=13, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Claws', ui_row=14, color_set_id=6)
    add_bone_collection('Claws (Tweak)', ui_row=15, ui_title='(Tweak)', color_set_id=4)
    add_bone_collection('Feathers', ui_row=9, color_set_id=6)
    add_bone_collection('Root', ui_row=18, color_set_id=1)

    bones = {}

    bone = arm.edit_bones.new('spine.003')
    bone.head = -0.0000, 0.0451, 0.0845
    bone.tail = -0.0000, 0.0192, 0.0888
    bone.roll = 0.0000
    bone.use_connect = False
    bones['spine.003'] = bone.name
    bone = arm.edit_bones.new('spine.002')
    bone.head = -0.0000, 0.0451, 0.0845
    bone.tail = -0.0000, 0.0757, 0.0880
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.003']]
    bones['spine.002'] = bone.name
    bone = arm.edit_bones.new('spine.004')
    bone.head = -0.0000, 0.0192, 0.0888
    bone.tail = -0.0000, -0.0106, 0.0979
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.003']]
    bones['spine.004'] = bone.name
    bone = arm.edit_bones.new('spine.001')
    bone.head = -0.0000, 0.0757, 0.0880
    bone.tail = -0.0000, 0.1039, 0.0907
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.002']]
    bones['spine.001'] = bone.name
    bone = arm.edit_bones.new('spine.005')
    bone.head = -0.0000, -0.0106, 0.0979
    bone.tail = -0.0000, -0.0298, 0.1158
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.004']]
    bones['spine.005'] = bone.name
    bone = arm.edit_bones.new('pelvis.L')
    bone.head = -0.0000, 0.0192, 0.0888
    bone.tail = 0.0250, 0.0070, 0.0782
    bone.roll = -0.0369
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.004']]
    bones['pelvis.L'] = bone.name
    bone = arm.edit_bones.new('pelvis.R')
    bone.head = 0.0000, 0.0192, 0.0888
    bone.tail = -0.0250, 0.0070, 0.0782
    bone.roll = 0.0369
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.004']]
    bones['pelvis.R'] = bone.name
    bone = arm.edit_bones.new('thigh.L')
    bone.head = 0.0149, 0.0063, 0.0739
    bone.tail = 0.0149, 0.0143, 0.0391
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.004']]
    bones['thigh.L'] = bone.name
    bone = arm.edit_bones.new('thigh.R')
    bone.head = -0.0149, 0.0063, 0.0739
    bone.tail = -0.0149, 0.0143, 0.0391
    bone.roll = -0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.004']]
    bones['thigh.R'] = bone.name
    bone = arm.edit_bones.new('spine')
    bone.head = -0.0000, 0.1039, 0.0907
    bone.tail = -0.0000, 0.1371, 0.0894
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.001']]
    bones['spine'] = bone.name
    bone = arm.edit_bones.new('shoulder.L')
    bone.head = 0.0014, -0.0217, 0.0893
    bone.tail = 0.0076, -0.0020, 0.1179
    bone.roll = 1.3977
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['shoulder.L'] = bone.name
    bone = arm.edit_bones.new('spine.006')
    bone.head = -0.0000, -0.0298, 0.1158
    bone.tail = -0.0000, -0.0417, 0.1348
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['spine.006'] = bone.name
    bone = arm.edit_bones.new('shoulder.R')
    bone.head = -0.0014, -0.0217, 0.0893
    bone.tail = -0.0076, -0.0020, 0.1179
    bone.roll = -1.3977
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.005']]
    bones['shoulder.R'] = bone.name
    bone = arm.edit_bones.new('shin.L')
    bone.head = 0.0149, 0.0143, 0.0391
    bone.tail = 0.0149, 0.0015, 0.0074
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thigh.L']]
    bones['shin.L'] = bone.name
    bone = arm.edit_bones.new('shin.R')
    bone.head = -0.0149, 0.0143, 0.0391
    bone.tail = -0.0149, 0.0015, 0.0074
    bone.roll = -0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['thigh.R']]
    bones['shin.R'] = bone.name
    bone = arm.edit_bones.new('t_feather.L')
    bone.head = 0.0112, 0.1017, 0.0907
    bone.tail = 0.0167, 0.1345, 0.0894
    bone.roll = 0.0032
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine']]
    bones['t_feather.L'] = bone.name
    bone = arm.edit_bones.new('t_feather.R')
    bone.head = -0.0112, 0.1017, 0.0907
    bone.tail = -0.0167, 0.1345, 0.0894
    bone.roll = -0.0032
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine']]
    bones['t_feather.R'] = bone.name
    bone = arm.edit_bones.new('Wing.L')
    bone.head = 0.0089, 0.0141, 0.1157
    bone.tail = 0.0485, 0.0107, 0.1163
    bone.roll = 2.8221
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['shoulder.L']]
    bones['Wing.L'] = bone.name
    bone = arm.edit_bones.new('neck.001')
    bone.head = -0.0000, -0.0417, 0.1348
    bone.tail = -0.0000, -0.0458, 0.1429
    bone.roll = 0.0001
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['spine.006']]
    bones['neck.001'] = bone.name
    bone = arm.edit_bones.new('Wing.R')
    bone.head = -0.0089, 0.0141, 0.1157
    bone.tail = -0.0485, 0.0107, 0.1163
    bone.roll = -2.8221
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['shoulder.R']]
    bones['Wing.R'] = bone.name
    bone = arm.edit_bones.new('foot.L')
    bone.head = 0.0149, 0.0015, 0.0074
    bone.tail = 0.0149, -0.0033, 0.0045
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.L']]
    bones['foot.L'] = bone.name
    bone = arm.edit_bones.new('foot.R')
    bone.head = -0.0149, 0.0015, 0.0074
    bone.tail = -0.0149, -0.0033, 0.0045
    bone.roll = -0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['shin.R']]
    bones['foot.R'] = bone.name
    bone = arm.edit_bones.new('Wing.001.L')
    bone.head = 0.0485, 0.0107, 0.1163
    bone.tail = 0.0919, 0.0021, 0.1191
    bone.roll = 2.7596
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['Wing.L']]
    bones['Wing.001.L'] = bone.name
    bone = arm.edit_bones.new('w_feather.004.L')
    bone.head = 0.0382, 0.0253, 0.1081
    bone.tail = 0.0553, 0.0878, 0.0901
    bone.roll = 3.0872
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.L']]
    bones['w_feather.004.L'] = bone.name
    bone = arm.edit_bones.new('neck.002')
    bone.head = -0.0000, -0.0458, 0.1429
    bone.tail = -0.0000, -0.0483, 0.1498
    bone.roll = 0.0001
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['neck.001']]
    bones['neck.002'] = bone.name
    bone = arm.edit_bones.new('Wing.001.R')
    bone.head = -0.0485, 0.0107, 0.1163
    bone.tail = -0.0919, 0.0021, 0.1191
    bone.roll = -2.7596
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['Wing.R']]
    bones['Wing.001.R'] = bone.name
    bone = arm.edit_bones.new('w_feather.004.R')
    bone.head = -0.0382, 0.0253, 0.1081
    bone.tail = -0.0553, 0.0878, 0.0901
    bone.roll = -3.0872
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.R']]
    bones['w_feather.004.R'] = bone.name
    bone = arm.edit_bones.new('toe.L')
    bone.head = 0.0149, -0.0033, 0.0045
    bone.tail = 0.0149, -0.0404, 0.0006
    bone.roll = 3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['foot.L']]
    bones['toe.L'] = bone.name
    bone = arm.edit_bones.new('toe.R')
    bone.head = -0.0149, -0.0033, 0.0045
    bone.tail = -0.0149, -0.0404, 0.0006
    bone.roll = -3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['foot.R']]
    bones['toe.R'] = bone.name
    bone = arm.edit_bones.new('Wing.002.L')
    bone.head = 0.0919, 0.0021, 0.1191
    bone.tail = 0.2128, 0.0178, 0.1159
    bone.roll = 2.8565
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['Wing.001.L']]
    bones['Wing.002.L'] = bone.name
    bone = arm.edit_bones.new('w_feather.003.L')
    bone.head = 0.0754, 0.0212, 0.1122
    bone.tail = 0.1342, 0.0830, 0.0901
    bone.roll = 3.0993
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.001.L']]
    bones['w_feather.003.L'] = bone.name
    bone = arm.edit_bones.new('head')
    bone.head = -0.0000, -0.0483, 0.1498
    bone.tail = -0.0000, -0.1026, 0.1815
    bone.roll = 0.0000
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['neck.002']]
    bones['head'] = bone.name
    bone = arm.edit_bones.new('Wing.002.R')
    bone.head = -0.0919, 0.0021, 0.1191
    bone.tail = -0.2128, 0.0178, 0.1159
    bone.roll = -2.8565
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['Wing.001.R']]
    bones['Wing.002.R'] = bone.name
    bone = arm.edit_bones.new('w_feather.003.R')
    bone.head = -0.0754, 0.0212, 0.1122
    bone.tail = -0.1342, 0.0830, 0.0901
    bone.roll = -3.0993
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.001.R']]
    bones['w_feather.003.R'] = bone.name
    bone = arm.edit_bones.new('toes_parent.L')
    bone.head = 0.0149, -0.0033, 0.0045
    bone.tail = 0.0149, -0.0096, 0.0037
    bone.roll = 3.1416
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.L']]
    bones['toes_parent.L'] = bone.name
    bone = arm.edit_bones.new('t_thumb.001.L')
    bone.head = 0.0136, 0.0051, 0.0022
    bone.tail = 0.0131, 0.0142, 0.0026
    bone.roll = 3.1406
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.L']]
    bones['t_thumb.001.L'] = bone.name
    bone = arm.edit_bones.new('toes_parent.R')
    bone.head = -0.0149, -0.0033, 0.0045
    bone.tail = -0.0149, -0.0096, 0.0037
    bone.roll = -3.1416
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.R']]
    bones['toes_parent.R'] = bone.name
    bone = arm.edit_bones.new('t_thumb.001.R')
    bone.head = -0.0136, 0.0051, 0.0022
    bone.tail = -0.0131, 0.0142, 0.0026
    bone.roll = -3.1406
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toe.R']]
    bones['t_thumb.001.R'] = bone.name
    bone = arm.edit_bones.new('w_feather.001.L')
    bone.head = 0.1595, -0.0062, 0.1163
    bone.tail = 0.2489, -0.0055, 0.1224
    bone.roll = 2.9290
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.002.L']]
    bones['w_feather.001.L'] = bone.name
    bone = arm.edit_bones.new('w_feather.002.L')
    bone.head = 0.1218, 0.0331, 0.1099
    bone.tail = 0.1812, 0.0495, 0.1068
    bone.roll = 2.8770
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.002.L']]
    bones['w_feather.002.L'] = bone.name
    bone = arm.edit_bones.new('beak.001.T')
    bone.head = -0.0000, -0.0703, 0.1580
    bone.tail = -0.0000, -0.0927, 0.1597
    bone.roll = 0.0001
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['beak.001.T'] = bone.name
    bone = arm.edit_bones.new('beak_001.B')
    bone.head = -0.0000, -0.0703, 0.1556
    bone.tail = -0.0000, -0.0914, 0.1555
    bone.roll = 0.0001
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['beak_001.B'] = bone.name
    bone = arm.edit_bones.new('eye.L')
    bone.head = 0.0055, -0.0647, 0.1615
    bone.tail = 0.0198, -0.0675, 0.1615
    bone.roll = 0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['eye.L'] = bone.name
    bone = arm.edit_bones.new('eye.R')
    bone.head = -0.0055, -0.0647, 0.1615
    bone.tail = -0.0198, -0.0675, 0.1615
    bone.roll = -0.0000
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['eye.R'] = bone.name
    bone = arm.edit_bones.new('n_feather.001.L')
    bone.head = 0.0098, -0.0390, 0.1566
    bone.tail = 0.0131, -0.0247, 0.1430
    bone.roll = -0.0380
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['n_feather.001.L'] = bone.name
    bone = arm.edit_bones.new('n_feather.001.R')
    bone.head = -0.0098, -0.0390, 0.1566
    bone.tail = -0.0131, -0.0247, 0.1430
    bone.roll = 0.0380
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['n_feather.001.R'] = bone.name
    bone = arm.edit_bones.new('skull.006.L')
    bone.head = 0.0033, -0.0587, 0.1538
    bone.tail = 0.0162, -0.0666, 0.1509
    bone.roll = 1.6532
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['skull.006.L'] = bone.name
    bone = arm.edit_bones.new('skull.006.R')
    bone.head = -0.0033, -0.0587, 0.1538
    bone.tail = -0.0162, -0.0666, 0.1509
    bone.roll = -1.6532
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['head']]
    bones['skull.006.R'] = bone.name
    bone = arm.edit_bones.new('w_feather.001.R')
    bone.head = -0.1595, -0.0062, 0.1163
    bone.tail = -0.2489, -0.0055, 0.1224
    bone.roll = -2.9290
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.002.R']]
    bones['w_feather.001.R'] = bone.name
    bone = arm.edit_bones.new('w_feather.002.R')
    bone.head = -0.1218, 0.0331, 0.1099
    bone.tail = -0.1812, 0.0495, 0.1068
    bone.roll = -2.8770
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['Wing.002.R']]
    bones['w_feather.002.R'] = bone.name
    bone = arm.edit_bones.new('t_ring.001.L')
    bone.head = 0.0183, -0.0026, 0.0034
    bone.tail = 0.0216, -0.0129, 0.0038
    bone.roll = 6.0340
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toes_parent.L']]
    bones['t_ring.001.L'] = bone.name
    bone = arm.edit_bones.new('t_index.001.L')
    bone.head = 0.0122, -0.0026, 0.0034
    bone.tail = 0.0093, -0.0130, 0.0038
    bone.roll = 6.5631
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toes_parent.L']]
    bones['t_index.001.L'] = bone.name
    bone = arm.edit_bones.new('t_middle.001.L')
    bone.head = 0.0149, -0.0050, 0.0034
    bone.tail = 0.0149, -0.0207, 0.0040
    bone.roll = 3.1416
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toes_parent.L']]
    bones['t_middle.001.L'] = bone.name
    bone = arm.edit_bones.new('t_thumb.002.L')
    bone.head = 0.0131, 0.0142, 0.0026
    bone.tail = 0.0126, 0.0241, 0.0003
    bone.roll = 3.1472
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_thumb.001.L']]
    bones['t_thumb.002.L'] = bone.name
    bone = arm.edit_bones.new('t_ring.001.R')
    bone.head = -0.0183, -0.0026, 0.0034
    bone.tail = -0.0216, -0.0129, 0.0038
    bone.roll = -6.0340
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toes_parent.R']]
    bones['t_ring.001.R'] = bone.name
    bone = arm.edit_bones.new('t_index.001.R')
    bone.head = -0.0122, -0.0026, 0.0034
    bone.tail = -0.0093, -0.0130, 0.0038
    bone.roll = -6.5631
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toes_parent.R']]
    bones['t_index.001.R'] = bone.name
    bone = arm.edit_bones.new('t_middle.001.R')
    bone.head = -0.0149, -0.0050, 0.0034
    bone.tail = -0.0149, -0.0207, 0.0040
    bone.roll = -3.1416
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['toes_parent.R']]
    bones['t_middle.001.R'] = bone.name
    bone = arm.edit_bones.new('t_thumb.002.R')
    bone.head = -0.0131, 0.0142, 0.0026
    bone.tail = -0.0126, 0.0241, 0.0003
    bone.roll = -3.1472
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_thumb.001.R']]
    bones['t_thumb.002.R'] = bone.name
    bone = arm.edit_bones.new('beak.002.T')
    bone.head = -0.0000, -0.0927, 0.1597
    bone.tail = -0.0000, -0.1131, 0.1533
    bone.roll = 0.0001
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['beak.001.T']]
    bones['beak.002.T'] = bone.name
    bone = arm.edit_bones.new('beak.002.B')
    bone.head = -0.0000, -0.0914, 0.1555
    bone.tail = -0.0000, -0.1084, 0.1519
    bone.roll = 0.0001
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['beak_001.B']]
    bones['beak.002.B'] = bone.name
    bone = arm.edit_bones.new('tongue.001.L')
    bone.head = -0.0000, -0.0792, 0.1536
    bone.tail = -0.0000, -0.0840, 0.1555
    bone.roll = 0.0001
    bone.use_connect = False
    bone.parent = arm.edit_bones[bones['beak_001.B']]
    bones['tongue.001.L'] = bone.name
    bone = arm.edit_bones.new('t_ring.002.L')
    bone.head = 0.0216, -0.0129, 0.0038
    bone.tail = 0.0237, -0.0195, 0.0032
    bone.roll = 0.5806
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_ring.001.L']]
    bones['t_ring.002.L'] = bone.name
    bone = arm.edit_bones.new('t_index.002.L')
    bone.head = 0.0093, -0.0130, 0.0038
    bone.tail = 0.0067, -0.0223, 0.0032
    bone.roll = -0.4957
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_index.001.L']]
    bones['t_index.002.L'] = bone.name
    bone = arm.edit_bones.new('t_middle.002.L')
    bone.head = 0.0149, -0.0207, 0.0040
    bone.tail = 0.0149, -0.0308, 0.0031
    bone.roll = 3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_middle.001.L']]
    bones['t_middle.002.L'] = bone.name
    bone = arm.edit_bones.new('t_ring.002.R')
    bone.head = -0.0216, -0.0129, 0.0038
    bone.tail = -0.0237, -0.0195, 0.0032
    bone.roll = -0.5806
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_ring.001.R']]
    bones['t_ring.002.R'] = bone.name
    bone = arm.edit_bones.new('t_index.002.R')
    bone.head = -0.0093, -0.0130, 0.0038
    bone.tail = -0.0067, -0.0223, 0.0032
    bone.roll = 0.4957
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_index.001.R']]
    bones['t_index.002.R'] = bone.name
    bone = arm.edit_bones.new('t_middle.002.R')
    bone.head = -0.0149, -0.0207, 0.0040
    bone.tail = -0.0149, -0.0308, 0.0031
    bone.roll = -3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_middle.001.R']]
    bones['t_middle.002.R'] = bone.name
    bone = arm.edit_bones.new('tongue.002.L')
    bone.head = -0.0000, -0.0840, 0.1555
    bone.tail = -0.0000, -0.0874, 0.1553
    bone.roll = 0.0001
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['tongue.001.L']]
    bones['tongue.002.L'] = bone.name
    bone = arm.edit_bones.new('t_ring.003.L')
    bone.head = 0.0237, -0.0195, 0.0032
    bone.tail = 0.0261, -0.0270, 0.0009
    bone.roll = 1.5954
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_ring.002.L']]
    bones['t_ring.003.L'] = bone.name
    bone = arm.edit_bones.new('t_index.003.L')
    bone.head = 0.0067, -0.0223, 0.0032
    bone.tail = 0.0038, -0.0327, 0.0009
    bone.roll = 4.8853
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_index.002.L']]
    bones['t_index.003.L'] = bone.name
    bone = arm.edit_bones.new('t_middle.003.L')
    bone.head = 0.0149, -0.0308, 0.0031
    bone.tail = 0.0149, -0.0421, -0.0003
    bone.roll = 3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_middle.002.L']]
    bones['t_middle.003.L'] = bone.name
    bone = arm.edit_bones.new('t_ring.003.R')
    bone.head = -0.0237, -0.0195, 0.0032
    bone.tail = -0.0261, -0.0270, 0.0009
    bone.roll = -1.5954
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_ring.002.R']]
    bones['t_ring.003.R'] = bone.name
    bone = arm.edit_bones.new('t_index.003.R')
    bone.head = -0.0067, -0.0223, 0.0032
    bone.tail = -0.0038, -0.0327, 0.0009
    bone.roll = -4.8853
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_index.002.R']]
    bones['t_index.003.R'] = bone.name
    bone = arm.edit_bones.new('t_middle.003.R')
    bone.head = -0.0149, -0.0308, 0.0031
    bone.tail = -0.0149, -0.0421, -0.0003
    bone.roll = -3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['t_middle.002.R']]
    bones['t_middle.003.R'] = bone.name
    bone = arm.edit_bones.new('tongue.003.L')
    bone.head = -0.0000, -0.0874, 0.1553
    bone.tail = -0.0000, -0.0898, 0.1553
    bone.roll = 3.1416
    bone.use_connect = True
    bone.parent = arm.edit_bones[bones['tongue.002.L']]
    bones['tongue.003.L'] = bone.name

    bpy.ops.object.mode_set(mode='OBJECT')
    pbone = obj.pose.bones[bones['spine.003']]
    pbone.rigify_type = 'spines.basic_spine'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.pivot_pos = 1
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Spine (Tweak)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['spine.002']]
    pbone.rigify_type = 'spines.basic_tail'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.copy_rotation_axes = (True, False, True)
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.connect_chain = True
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['spine.004']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['spine.001']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['spine.005']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['pelvis.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.make_control = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['pelvis.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.make_control = False
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['thigh.L']]
    pbone.rigify_type = 'limbs.paw'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.ik_local_location = False
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Leg.L (Tweak)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Leg.L (FK)')
    pbone = obj.pose.bones[bones['thigh.R']]
    pbone.rigify_type = 'limbs.paw'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    try:
        pbone.rigify_parameters.limb_type = 'paw'
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.ik_local_location = False
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Leg.R (Tweak)')
    assign_bone_collection_refs(pbone.rigify_parameters, 'fk', 'Leg.R (FK)')
    pbone = obj.pose.bones[bones['spine']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['shoulder.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['spine.006']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['shoulder.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['shin.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    pbone = obj.pose.bones[bones['shin.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    pbone = obj.pose.bones[bones['t_feather.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['t_feather.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['Wing.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Wing.L')
    try:
        pbone.rigify_parameters.copy_rotation_axes = (False, False, False)
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Wing.L (Tweak)')
    pbone = obj.pose.bones[bones['neck.001']]
    pbone.rigify_type = 'spines.super_head'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    try:
        pbone.rigify_parameters.connect_chain = True
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Spine (Tweak)')
    pbone = obj.pose.bones[bones['Wing.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Wing.R')
    try:
        pbone.rigify_parameters.copy_rotation_axes = (False, False, False)
    except AttributeError:
        pass
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Wing.R (Tweak)')
    pbone = obj.pose.bones[bones['foot.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    pbone = obj.pose.bones[bones['foot.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    pbone = obj.pose.bones[bones['Wing.001.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Wing.L')
    pbone = obj.pose.bones[bones['w_feather.004.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['neck.002']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['Wing.001.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Wing.R')
    pbone = obj.pose.bones[bones['w_feather.004.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['toe.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.L (IK)')
    pbone = obj.pose.bones[bones['toe.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Leg.R (IK)')
    pbone = obj.pose.bones[bones['Wing.002.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Wing.L')
    pbone = obj.pose.bones[bones['w_feather.003.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['head']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Spine')
    pbone = obj.pose.bones[bones['Wing.002.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Wing.R')
    pbone = obj.pose.bones[bones['w_feather.003.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['toes_parent.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_thumb.001.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['toes_parent.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_thumb.001.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['w_feather.001.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['w_feather.002.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['beak.001.T']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Face (Tweak)')
    pbone = obj.pose.bones[bones['beak_001.B']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Face (Tweak)')
    pbone = obj.pose.bones[bones['eye.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['eye.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['n_feather.001.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['n_feather.001.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['skull.006.L']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.make_control = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['skull.006.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    try:
        pbone.rigify_parameters.make_control = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['w_feather.001.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['w_feather.002.R']]
    pbone.rigify_type = 'basic.super_copy'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Feathers')
    try:
        pbone.rigify_parameters.make_widget = False
    except AttributeError:
        pass
    pbone = obj.pose.bones[bones['t_ring.001.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['t_index.001.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['t_middle.001.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['t_thumb.002.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_ring.001.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['t_index.001.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['t_middle.001.R']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Claws (Tweak)')
    pbone = obj.pose.bones[bones['t_thumb.002.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['beak.002.T']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['beak.002.B']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['tongue.001.L']]
    pbone.rigify_type = 'limbs.simple_tentacle'
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    assign_bone_collection_refs(pbone.rigify_parameters, 'tweak', 'Face (Tweak)')
    pbone = obj.pose.bones[bones['t_ring.002.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_index.002.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_middle.002.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_ring.002.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_index.002.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_middle.002.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['tongue.002.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')
    pbone = obj.pose.bones[bones['t_ring.003.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_index.003.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_middle.003.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_ring.003.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_index.003.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['t_middle.003.R']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Claws')
    pbone = obj.pose.bones[bones['tongue.003.L']]
    pbone.rigify_type = ''
    pbone.lock_location = (False, False, False)
    pbone.lock_rotation = (False, False, False)
    pbone.lock_rotation_w = False
    pbone.lock_scale = (False, False, False)
    pbone.rotation_mode = 'QUATERNION'
    assign_bone_collections(pbone, 'Face')

    bpy.ops.object.mode_set(mode='EDIT')
    for bone in arm.edit_bones:
        bone.select = False
        bone.select_head = False
        bone.select_tail = False
    for b in bones:
        bone = arm.edit_bones[bones[b]]
        bone.select = True
        bone.select_head = True
        bone.select_tail = True
        bone.bbone_x = bone.bbone_z = bone.length * 0.05
        arm.edit_bones.active = bone

    arm.collections.active_index = 0

    return bones


if __name__ == "__main__":
    create(bpy.context.active_object)
