# SPDX-FileCopyrightText: 2012 Manfred Moitzi (mozman)
#
# SPDX-License-Identifier: MIT

__author__ = 'manfred'


class TrueColor(int):
    def rgb(self):
        return (self >> 16) & 0xFF, (self >> 8) & 0xFF, self & 0xFF

    @property
    def r(self):
        return (self >> 16) & 0xFF

    @property
    def g(self):
        return (self >> 8) & 0xFF

    @property
    def b(self):
        return self & 0xFF

    def __getitem__(self, item):
        if item == 0:
            return self.r
        elif item == 1:
            return self.g
        elif item == 2:
            return self.b
        raise IndexError(item)

    @staticmethod
    def from_rgb(r, g, b):
        return TrueColor(((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff))

    @staticmethod
    def from_aci(index):
        if index < 1:
            raise IndexError(index)
        return dxf_default_colors[index]


def aci_to_true_color(index):
    return TrueColor.from_aci(index)


dxf_default_colors = [
    TrueColor(0x000000),
    TrueColor(0xff0000),
    TrueColor(0xffff00),
    TrueColor(0x00ff00),
    TrueColor(0x00ffff),
    TrueColor(0x0000ff),
    TrueColor(0xff00ff),
    TrueColor(0xffffff),
    TrueColor(0x414141),
    TrueColor(0x808080),
    TrueColor(0xff0000),
    TrueColor(0xffaaaa),
    TrueColor(0xbd0000),
    TrueColor(0xbd7e7e),
    TrueColor(0x810000),
    TrueColor(0x815656),
    TrueColor(0x680000),
    TrueColor(0x684545),
    TrueColor(0x4f0000),
    TrueColor(0x4f3535),
    TrueColor(0xff3f00),
    TrueColor(0xffbfaa),
    TrueColor(0xbd2e00),
    TrueColor(0xbd8d7e),
    TrueColor(0x811f00),
    TrueColor(0x816056),
    TrueColor(0x681900),
    TrueColor(0x684e45),
    TrueColor(0x4f1300),
    TrueColor(0x4f3b35),
    TrueColor(0xff7f00),
    TrueColor(0xffd4aa),
    TrueColor(0xbd5e00),
    TrueColor(0xbd9d7e),
    TrueColor(0x814000),
    TrueColor(0x816b56),
    TrueColor(0x683400),
    TrueColor(0x685645),
    TrueColor(0x4f2700),
    TrueColor(0x4f4235),
    TrueColor(0xffbf00),
    TrueColor(0xffeaaa),
    TrueColor(0xbd8d00),
    TrueColor(0xbdad7e),
    TrueColor(0x816000),
    TrueColor(0x817656),
    TrueColor(0x684e00),
    TrueColor(0x685f45),
    TrueColor(0x4f3b00),
    TrueColor(0x4f4935),
    TrueColor(0xffff00),
    TrueColor(0xffffaa),
    TrueColor(0xbdbd00),
    TrueColor(0xbdbd7e),
    TrueColor(0x818100),
    TrueColor(0x818156),
    TrueColor(0x686800),
    TrueColor(0x686845),
    TrueColor(0x4f4f00),
    TrueColor(0x4f4f35),
    TrueColor(0xbfff00),
    TrueColor(0xeaffaa),
    TrueColor(0x8dbd00),
    TrueColor(0xadbd7e),
    TrueColor(0x608100),
    TrueColor(0x768156),
    TrueColor(0x4e6800),
    TrueColor(0x5f6845),
    TrueColor(0x3b4f00),
    TrueColor(0x494f35),
    TrueColor(0x7fff00),
    TrueColor(0xd4ffaa),
    TrueColor(0x5ebd00),
    TrueColor(0x9dbd7e),
    TrueColor(0x408100),
    TrueColor(0x6b8156),
    TrueColor(0x346800),
    TrueColor(0x566845),
    TrueColor(0x274f00),
    TrueColor(0x424f35),
    TrueColor(0x3fff00),
    TrueColor(0xbfffaa),
    TrueColor(0x2ebd00),
    TrueColor(0x8dbd7e),
    TrueColor(0x1f8100),
    TrueColor(0x608156),
    TrueColor(0x196800),
    TrueColor(0x4e6845),
    TrueColor(0x134f00),
    TrueColor(0x3b4f35),
    TrueColor(0x00ff00),
    TrueColor(0xaaffaa),
    TrueColor(0x00bd00),
    TrueColor(0x7ebd7e),
    TrueColor(0x008100),
    TrueColor(0x568156),
    TrueColor(0x006800),
    TrueColor(0x456845),
    TrueColor(0x004f00),
    TrueColor(0x354f35),
    TrueColor(0x00ff3f),
    TrueColor(0xaaffbf),
    TrueColor(0x00bd2e),
    TrueColor(0x7ebd8d),
    TrueColor(0x00811f),
    TrueColor(0x568160),
    TrueColor(0x006819),
    TrueColor(0x45684e),
    TrueColor(0x004f13),
    TrueColor(0x354f3b),
    TrueColor(0x00ff7f),
    TrueColor(0xaaffd4),
    TrueColor(0x00bd5e),
    TrueColor(0x7ebd9d),
    TrueColor(0x008140),
    TrueColor(0x56816b),
    TrueColor(0x006834),
    TrueColor(0x456856),
    TrueColor(0x004f27),
    TrueColor(0x354f42),
    TrueColor(0x00ffbf),
    TrueColor(0xaaffea),
    TrueColor(0x00bd8d),
    TrueColor(0x7ebdad),
    TrueColor(0x008160),
    TrueColor(0x568176),
    TrueColor(0x00684e),
    TrueColor(0x45685f),
    TrueColor(0x004f3b),
    TrueColor(0x354f49),
    TrueColor(0x00ffff),
    TrueColor(0xaaffff),
    TrueColor(0x00bdbd),
    TrueColor(0x7ebdbd),
    TrueColor(0x008181),
    TrueColor(0x568181),
    TrueColor(0x006868),
    TrueColor(0x456868),
    TrueColor(0x004f4f),
    TrueColor(0x354f4f),
    TrueColor(0x00bfff),
    TrueColor(0xaaeaff),
    TrueColor(0x008dbd),
    TrueColor(0x7eadbd),
    TrueColor(0x006081),
    TrueColor(0x567681),
    TrueColor(0x004e68),
    TrueColor(0x455f68),
    TrueColor(0x003b4f),
    TrueColor(0x35494f),
    TrueColor(0x007fff),
    TrueColor(0xaad4ff),
    TrueColor(0x005ebd),
    TrueColor(0x7e9dbd),
    TrueColor(0x004081),
    TrueColor(0x566b81),
    TrueColor(0x003468),
    TrueColor(0x455668),
    TrueColor(0x00274f),
    TrueColor(0x35424f),
    TrueColor(0x003fff),
    TrueColor(0xaabfff),
    TrueColor(0x002ebd),
    TrueColor(0x7e8dbd),
    TrueColor(0x001f81),
    TrueColor(0x566081),
    TrueColor(0x001968),
    TrueColor(0x454e68),
    TrueColor(0x00134f),
    TrueColor(0x353b4f),
    TrueColor(0x0000ff),
    TrueColor(0xaaaaff),
    TrueColor(0x0000bd),
    TrueColor(0x7e7ebd),
    TrueColor(0x000081),
    TrueColor(0x565681),
    TrueColor(0x000068),
    TrueColor(0x454568),
    TrueColor(0x00004f),
    TrueColor(0x35354f),
    TrueColor(0x3f00ff),
    TrueColor(0xbfaaff),
    TrueColor(0x2e00bd),
    TrueColor(0x8d7ebd),
    TrueColor(0x1f0081),
    TrueColor(0x605681),
    TrueColor(0x190068),
    TrueColor(0x4e4568),
    TrueColor(0x13004f),
    TrueColor(0x3b354f),
    TrueColor(0x7f00ff),
    TrueColor(0xd4aaff),
    TrueColor(0x5e00bd),
    TrueColor(0x9d7ebd),
    TrueColor(0x400081),
    TrueColor(0x6b5681),
    TrueColor(0x340068),
    TrueColor(0x564568),
    TrueColor(0x27004f),
    TrueColor(0x42354f),
    TrueColor(0xbf00ff),
    TrueColor(0xeaaaff),
    TrueColor(0x8d00bd),
    TrueColor(0xad7ebd),
    TrueColor(0x600081),
    TrueColor(0x765681),
    TrueColor(0x4e0068),
    TrueColor(0x5f4568),
    TrueColor(0x3b004f),
    TrueColor(0x49354f),
    TrueColor(0xff00ff),
    TrueColor(0xffaaff),
    TrueColor(0xbd00bd),
    TrueColor(0xbd7ebd),
    TrueColor(0x810081),
    TrueColor(0x815681),
    TrueColor(0x680068),
    TrueColor(0x684568),
    TrueColor(0x4f004f),
    TrueColor(0x4f354f),
    TrueColor(0xff00bf),
    TrueColor(0xffaaea),
    TrueColor(0xbd008d),
    TrueColor(0xbd7ead),
    TrueColor(0x810060),
    TrueColor(0x815676),
    TrueColor(0x68004e),
    TrueColor(0x68455f),
    TrueColor(0x4f003b),
    TrueColor(0x4f3549),
    TrueColor(0xff007f),
    TrueColor(0xffaad4),
    TrueColor(0xbd005e),
    TrueColor(0xbd7e9d),
    TrueColor(0x810040),
    TrueColor(0x81566b),
    TrueColor(0x680034),
    TrueColor(0x684556),
    TrueColor(0x4f0027),
    TrueColor(0x4f3542),
    TrueColor(0xff003f),
    TrueColor(0xffaabf),
    TrueColor(0xbd002e),
    TrueColor(0xbd7e8d),
    TrueColor(0x81001f),
    TrueColor(0x815660),
    TrueColor(0x680019),
    TrueColor(0x68454e),
    TrueColor(0x4f0013),
    TrueColor(0x4f353b),
    TrueColor(0x333333),
    TrueColor(0x505050),
    TrueColor(0x696969),
    TrueColor(0x828282),
    TrueColor(0xbebebe),
    TrueColor(0xffffff),
]
