;; NOTE: Assertions have been generated by update_lit_checks.py --output=fuzz-exec and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --fuzz-exec-before -q -o /dev/null 2>&1 | filecheck %s

;; Three exports, one which throws from a resume, and two that do unhandled
;; suspends. This is a regression test for a bug where the global state of
;; continuations got into a confused state at the last export, and asserted.

(module
  (type $none (func))
  (type $cont (cont $none))

  (tag $tag (type $none))

  (func $empty
  )

  ;; CHECK:      [fuzz-exec] calling a
  ;; CHECK-NEXT: [exception thrown: tag ()]
  (func $a (export "a")
    (resume_throw $cont $tag
      (cont.new $cont
        (ref.func $empty)
      )
    )
  )

  ;; CHECK:      [fuzz-exec] calling b
  ;; CHECK-NEXT: [exception thrown: unhandled suspend]
  (func $b (export "b")
    (suspend $tag)
  )

  ;; CHECK:      [fuzz-exec] calling c
  ;; CHECK-NEXT: [exception thrown: unhandled suspend]
  (func $c (export "c")
    (suspend $tag)
  )
)

