;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Check that extern conversion instructions are emitted properly in the binary format.
;; Also check that the optimizer does not break on this code.

;; RUN: wasm-opt %s -all -O1 --roundtrip -S -o - | filecheck %s


(module
 ;; CHECK:      (type $0 (func (param (ref any)) (result (ref extern))))

 ;; CHECK:      (type $1 (func (param externref) (result anyref)))

 ;; CHECK:      (type $2 (func (param externref) (result externref)))

 ;; CHECK:      (export "ext" (func $extern.convert_any))

 ;; CHECK:      (export "int" (func $any.convert_extern))

 ;; CHECK:      (export "legacy" (func $legacy_notation))

 ;; CHECK:      (func $extern.convert_any (type $0) (param $0 (ref any)) (result (ref extern))
 ;; CHECK-NEXT:  (extern.convert_any
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $extern.convert_any (export "ext") (param $x (ref any)) (result (ref extern))
  (extern.convert_any
   (local.get $x)
  )
 )

 ;; CHECK:      (func $any.convert_extern (type $1) (param $0 externref) (result anyref)
 ;; CHECK-NEXT:  (any.convert_extern
 ;; CHECK-NEXT:   (local.get $0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $any.convert_extern (export "int") (param $x (ref null extern)) (result (ref null any))
  (any.convert_extern
   (local.get $x)
  )
 )

 ;; CHECK:      (func $legacy_notation (type $2) (param $0 externref) (result externref)
 ;; CHECK-NEXT:  (extern.convert_any
 ;; CHECK-NEXT:   (any.convert_extern
 ;; CHECK-NEXT:    (local.get $0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $legacy_notation (export "legacy") (param $x (ref null extern)) (result (ref null extern))
  (extern.externalize
   (extern.internalize
    (local.get $x)
   )
  )
 )
)
