from collections.abc import Callable
from typing import TextIO
from typing_extensions import Self

CONTROL_SEQUENCES: dict[str, str] = ...

def format_text(text: str, f: str) -> str: ...

class MultilinePrinterBase:
    def __init__(self, stream: TextIO | None = None, lines: int = ...) -> None: ...
    def __enter__(self) -> Self: ...
    def __exit__(self, *args: object) -> None: ...
    def print_at_line(self, text: str, pos: int) -> None: ...
    def end(self) -> None: ...
    def write(self, *text: str) -> None: ...

class QuietMultilinePrinter(MultilinePrinterBase): ...
class MultilineLogger(MultilinePrinterBase): ...
class BreaklineStatusPrinter(MultilinePrinterBase): ...

class MultilinePrinter(MultilinePrinterBase):
    def __init__(self, stream: TextIO | None = None, lines: int = ..., preserve_output: bool = ...) -> None: ...
    def lock(func: Callable[..., object]) -> Callable[..., object]: ...  # type: ignore[misc] # pyright: ignore[reportGeneralTypeIssues]
