#include <cstddef>
#include <cstdio>
#include "aztecgen.h"


int main()
{
	enum {success, error};

	const char data[] = "Hello world :)";
	enum {symbol_format = AG_FULL_FORMAT};

	// Barcode creation
	ag_settings settings;
	settings.mask = AG_SF_SYMBOL_FORMAT;
	settings.symbol_format = symbol_format;

	ag_matrix *barcode;
	const int gen_result = ag_generate(
		&barcode, data, sizeof(data) - 1, &settings);
	if (gen_result != AG_SUCCESS)
	{
		printf("Can't create a barcode (error code: %i)\n",
			gen_result);
		return error;
	}

	// Barcode printout
	printf("Data:\n");
	printf("\t%s\n", data);

	printf("Barcode:\n");
	for (size_t y = 0; y < barcode->height; ++y)
	{
		printf("\t");
		for (size_t x = 0; x < barcode->width; ++x)
		{
			const unsigned char t =
				barcode->data[y * barcode->width + x];
			printf("%c", (t == 0) ? ' ': '#');
		}
		printf("\n");
	}
	printf("\n");

	// Barcode destruction
	ag_release_matrix(barcode);

	return success;
}
