#pragma once
#include <aztecgen.h>


class CPictureWnd: public CScrollWindowImpl<CPictureWnd>
{
public:
	void SetBarcode(const ag_matrix *pBarcode,
		UINT pointSizeInPixels, double pointSizeInMillimetres);
	void ResetContent();

	void DoPaint(CDCHandle dc);

private:
	CDC m_dc;
	CBitmap m_bmp;
	CBitmapHandle m_bmpOld;

	BEGIN_MSG_MAP(CPictureWnd)
		MSG_WM_CREATE(OnCreate)
		MSG_WM_DESTROY(OnDestroy)
		CHAIN_MSG_MAP(CScrollWindowImpl<CPictureWnd>)
	END_MSG_MAP()

	int OnCreate(LPCREATESTRUCT lpCreateStruct);
	void OnDestroy();

	void CreateBitmap(int width, int height);
	void RecreateBitmap(int width, int height);
	void DestroyBitmap();
	void GetBitmapSize(SIZE *size) const;

	void UpdateScrolls();
};
