#pragma once
#include <ag_matrix_ptr.h>
#include "PictureWnd.h"


class CMainDlg:
	public CDialogImpl<CMainDlg>,
	public CWinDataExchange<CMainDlg>,
	public CDialogResize<CMainDlg>
{
public:
	enum {IDD = IDD_MAINDLG};

private:
	CString m_appName;
	CWindow m_wndPictureHomePosition;
	CPictureWnd m_wndPicture;
	CHyperLink m_wndLogo;
	CComboBox m_wndSymbolFormat;
	UINT m_redundancyForErrorCorrection;
	UINT m_pointSizeInPixels;
	double m_pointSizeInMillimetres;
	CString m_inputData;
	CButton m_wndCopy;
	CButton m_wndSave;
	CButton m_wndPrint;

	ag_matrix_ptr m_barcode;
	UINT m_pointSizeInPixelsActual;
	double m_pointSizeInMillimetresActual;

	BEGIN_MSG_MAP(CMainDlg)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_ID_HANDLER_EX(IDCANCEL, OnCancel)
		COMMAND_ID_HANDLER_EX(IDC_COPY, OnCopy)
		COMMAND_ID_HANDLER_EX(IDC_SAVE, OnSave)
		COMMAND_ID_HANDLER_EX(IDC_PRINT, OnPrint)
		COMMAND_ID_HANDLER_EX(IDC_GENERATE, OnGenerate)
		CHAIN_MSG_MAP(CDialogResize<CMainDlg>)
	END_MSG_MAP()

	BEGIN_DDX_MAP(CMainDlg)
		DDX_CONTROL_HANDLE(IDC_PICTURE_HOME_POSITION, m_wndPictureHomePosition)
		DDX_CONTROL(IDC_LOGO, m_wndLogo)
		DDX_CONTROL_HANDLE(IDC_SYMBOL_FORMAT, m_wndSymbolFormat)
		DDX_UINT_RANGE(IDC_REDUNDANCY_FOR_ERROR_CORRECTION,
			m_redundancyForErrorCorrection, 0u, 99u)
		DDX_UINT_RANGE(IDC_POINT_SIZE_IN_PIXELS,
			m_pointSizeInPixels, 1u, 20u)
		DDX_FLOAT_RANGE(IDC_POINT_SIZE_IN_MILLIMETRES,
			m_pointSizeInMillimetres, 0.1, 5.0)
		DDX_TEXT(IDC_INPUT_DATA, m_inputData)
		DDX_CONTROL_HANDLE(IDC_COPY, m_wndCopy)
		DDX_CONTROL_HANDLE(IDC_SAVE, m_wndSave)
		DDX_CONTROL_HANDLE(IDC_PRINT, m_wndPrint)
	END_DDX_MAP()

	BEGIN_DLGRESIZE_MAP(CMainDlg)
		DLGRESIZE_CONTROL(IDC_PICTURE, DLSZ_SIZE_X | DLSZ_SIZE_Y)
		DLGRESIZE_CONTROL(IDC_LOGO, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_STATIC_0, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_STATIC_1, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_STATIC_2, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_STATIC_3, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_STATIC_4, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_STATIC_5, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_STATIC_6, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_SYMBOL_FORMAT, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_REDUNDANCY_FOR_ERROR_CORRECTION, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_POINT_SIZE_IN_PIXELS, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_POINT_SIZE_IN_MILLIMETRES, DLSZ_MOVE_X)
		DLGRESIZE_CONTROL(IDC_INPUT_DATA, DLSZ_MOVE_X | DLSZ_SIZE_Y)
		DLGRESIZE_CONTROL(IDC_COPY, DLSZ_MOVE_X | DLSZ_MOVE_Y)
		DLGRESIZE_CONTROL(IDC_SAVE, DLSZ_MOVE_X | DLSZ_MOVE_Y)
		DLGRESIZE_CONTROL(IDC_PRINT, DLSZ_MOVE_X | DLSZ_MOVE_Y)
		DLGRESIZE_CONTROL(IDC_GENERATE, DLSZ_MOVE_X | DLSZ_MOVE_Y)
	END_DLGRESIZE_MAP()

	BOOL OnInitDialog(CWindow wndFocus, LPARAM lInitParam);
	void OnCancel(UINT uNotifyCode, int nID, CWindow wndCtl);
	void OnCopy(UINT uNotifyCode, int nID, CWindow wndCtl);
	void OnSave(UINT uNotifyCode, int nID, CWindow wndCtl);
	void OnPrint(UINT uNotifyCode, int nID, CWindow wndCtl);
	void OnGenerate(UINT uNotifyCode, int nID, CWindow wndCtl);

	void OnDataExchangeError(UINT nCtrlID, BOOL /*bSave*/);
	void OnDataValidateError(UINT nCtrlID, BOOL /*bSave*/, _XData &data);

	void UpdateToolbarState();
};
