﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/customer-profiles/model/RangeUnit.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace CustomerProfiles
  {
    namespace Model
    {
      namespace RangeUnitMapper
      {

        static const int DAYS_HASH = HashingUtils::HashString("DAYS");


        RangeUnit GetRangeUnitForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == DAYS_HASH)
          {
            return RangeUnit::DAYS;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<RangeUnit>(hashCode);
          }

          return RangeUnit::NOT_SET;
        }

        Aws::String GetNameForRangeUnit(RangeUnit enumValue)
        {
          switch(enumValue)
          {
          case RangeUnit::NOT_SET:
            return {};
          case RangeUnit::DAYS:
            return "DAYS";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace RangeUnitMapper
    } // namespace Model
  } // namespace CustomerProfiles
} // namespace Aws
