﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/comprehend/model/DatasetEntityRecognizerEntityList.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Comprehend
{
namespace Model
{

DatasetEntityRecognizerEntityList::DatasetEntityRecognizerEntityList() : 
    m_s3UriHasBeenSet(false)
{
}

DatasetEntityRecognizerEntityList::DatasetEntityRecognizerEntityList(JsonView jsonValue)
  : DatasetEntityRecognizerEntityList()
{
  *this = jsonValue;
}

DatasetEntityRecognizerEntityList& DatasetEntityRecognizerEntityList::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("S3Uri"))
  {
    m_s3Uri = jsonValue.GetString("S3Uri");

    m_s3UriHasBeenSet = true;
  }

  return *this;
}

JsonValue DatasetEntityRecognizerEntityList::Jsonize() const
{
  JsonValue payload;

  if(m_s3UriHasBeenSet)
  {
   payload.WithString("S3Uri", m_s3Uri);

  }

  return payload;
}

} // namespace Model
} // namespace Comprehend
} // namespace Aws
