﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock/model/UpdateMarketplaceModelEndpointRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Bedrock::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

UpdateMarketplaceModelEndpointRequest::UpdateMarketplaceModelEndpointRequest() : 
    m_endpointArnHasBeenSet(false),
    m_endpointConfigHasBeenSet(false),
    m_clientRequestToken(Aws::Utils::UUID::PseudoRandomUUID()),
    m_clientRequestTokenHasBeenSet(true)
{
}

Aws::String UpdateMarketplaceModelEndpointRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_endpointConfigHasBeenSet)
  {
   payload.WithObject("endpointConfig", m_endpointConfig.Jsonize());

  }

  if(m_clientRequestTokenHasBeenSet)
  {
   payload.WithString("clientRequestToken", m_clientRequestToken);

  }

  return payload.View().WriteReadable();
}




