﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/accessanalyzer/model/AnalysisRule.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace AccessAnalyzer
{
namespace Model
{

AnalysisRule::AnalysisRule() : 
    m_exclusionsHasBeenSet(false)
{
}

AnalysisRule::AnalysisRule(JsonView jsonValue)
  : AnalysisRule()
{
  *this = jsonValue;
}

AnalysisRule& AnalysisRule::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("exclusions"))
  {
    Aws::Utils::Array<JsonView> exclusionsJsonList = jsonValue.GetArray("exclusions");
    for(unsigned exclusionsIndex = 0; exclusionsIndex < exclusionsJsonList.GetLength(); ++exclusionsIndex)
    {
      m_exclusions.push_back(exclusionsJsonList[exclusionsIndex].AsObject());
    }
    m_exclusionsHasBeenSet = true;
  }

  return *this;
}

JsonValue AnalysisRule::Jsonize() const
{
  JsonValue payload;

  if(m_exclusionsHasBeenSet)
  {
   Aws::Utils::Array<JsonValue> exclusionsJsonList(m_exclusions.size());
   for(unsigned exclusionsIndex = 0; exclusionsIndex < exclusionsJsonList.GetLength(); ++exclusionsIndex)
   {
     exclusionsJsonList[exclusionsIndex].AsObject(m_exclusions[exclusionsIndex].Jsonize());
   }
   payload.WithArray("exclusions", std::move(exclusionsJsonList));

  }

  return payload;
}

} // namespace Model
} // namespace AccessAnalyzer
} // namespace Aws
