﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/MeshData.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace AppMesh
{
namespace Model
{
  /**
   * <zonbook></zonbook><xhtml></xhtml><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMeshOutput">AWS
   * API Reference</a></p>
   */
  class DeleteMeshResult
  {
  public:
    AWS_APPMESH_API DeleteMeshResult();
    AWS_APPMESH_API DeleteMeshResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPMESH_API DeleteMeshResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The service mesh that was deleted.</p>
     */
    inline const MeshData& GetMesh() const{ return m_mesh; }
    inline void SetMesh(const MeshData& value) { m_mesh = value; }
    inline void SetMesh(MeshData&& value) { m_mesh = std::move(value); }
    inline DeleteMeshResult& WithMesh(const MeshData& value) { SetMesh(value); return *this;}
    inline DeleteMeshResult& WithMesh(MeshData&& value) { SetMesh(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DeleteMeshResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DeleteMeshResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DeleteMeshResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    MeshData m_mesh;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace AppMesh
} // namespace Aws
