﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/discovery/ApplicationDiscoveryService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/discovery/model/NeighborConnectionDetail.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ApplicationDiscoveryService
{
namespace Model
{
  class ListServerNeighborsResult
  {
  public:
    AWS_APPLICATIONDISCOVERYSERVICE_API ListServerNeighborsResult();
    AWS_APPLICATIONDISCOVERYSERVICE_API ListServerNeighborsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPLICATIONDISCOVERYSERVICE_API ListServerNeighborsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>List of distinct servers that are one hop away from the given server.</p>
     */
    inline const Aws::Vector<NeighborConnectionDetail>& GetNeighbors() const{ return m_neighbors; }
    inline void SetNeighbors(const Aws::Vector<NeighborConnectionDetail>& value) { m_neighbors = value; }
    inline void SetNeighbors(Aws::Vector<NeighborConnectionDetail>&& value) { m_neighbors = std::move(value); }
    inline ListServerNeighborsResult& WithNeighbors(const Aws::Vector<NeighborConnectionDetail>& value) { SetNeighbors(value); return *this;}
    inline ListServerNeighborsResult& WithNeighbors(Aws::Vector<NeighborConnectionDetail>&& value) { SetNeighbors(std::move(value)); return *this;}
    inline ListServerNeighborsResult& AddNeighbors(const NeighborConnectionDetail& value) { m_neighbors.push_back(value); return *this; }
    inline ListServerNeighborsResult& AddNeighbors(NeighborConnectionDetail&& value) { m_neighbors.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Token to retrieve the next set of results. For example, if you specified 100
     * IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
     * <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of
     * 10 results along with this token. Use this token in the next query to retrieve
     * the next set of 10.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListServerNeighborsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListServerNeighborsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListServerNeighborsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Count of distinct servers that are one hop away from the given server.</p>
     */
    inline long long GetKnownDependencyCount() const{ return m_knownDependencyCount; }
    inline void SetKnownDependencyCount(long long value) { m_knownDependencyCount = value; }
    inline ListServerNeighborsResult& WithKnownDependencyCount(long long value) { SetKnownDependencyCount(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListServerNeighborsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListServerNeighborsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListServerNeighborsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<NeighborConnectionDetail> m_neighbors;

    Aws::String m_nextToken;

    long long m_knownDependencyCount;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace ApplicationDiscoveryService
} // namespace Aws
