﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codedeploy/CodeDeploy_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/codedeploy/model/RevisionLocation.h>
#include <aws/codedeploy/model/DeploymentStatus.h>
#include <aws/codedeploy/model/ErrorInformation.h>
#include <aws/core/utils/DateTime.h>
#include <aws/codedeploy/model/DeploymentOverview.h>
#include <aws/codedeploy/model/DeploymentCreator.h>
#include <aws/codedeploy/model/AutoRollbackConfiguration.h>
#include <aws/codedeploy/model/RollbackInfo.h>
#include <aws/codedeploy/model/DeploymentStyle.h>
#include <aws/codedeploy/model/TargetInstances.h>
#include <aws/codedeploy/model/BlueGreenDeploymentConfiguration.h>
#include <aws/codedeploy/model/LoadBalancerInfo.h>
#include <aws/codedeploy/model/FileExistsBehavior.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/codedeploy/model/ComputePlatform.h>
#include <aws/codedeploy/model/RelatedDeployments.h>
#include <aws/codedeploy/model/AlarmConfiguration.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CodeDeploy
{
namespace Model
{

  /**
   * <p>Information about a deployment.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeploymentInfo">AWS
   * API Reference</a></p>
   */
  class DeploymentInfo
  {
  public:
    AWS_CODEDEPLOY_API DeploymentInfo();
    AWS_CODEDEPLOY_API DeploymentInfo(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEDEPLOY_API DeploymentInfo& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEDEPLOY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The application name.</p>
     */
    inline const Aws::String& GetApplicationName() const{ return m_applicationName; }
    inline bool ApplicationNameHasBeenSet() const { return m_applicationNameHasBeenSet; }
    inline void SetApplicationName(const Aws::String& value) { m_applicationNameHasBeenSet = true; m_applicationName = value; }
    inline void SetApplicationName(Aws::String&& value) { m_applicationNameHasBeenSet = true; m_applicationName = std::move(value); }
    inline void SetApplicationName(const char* value) { m_applicationNameHasBeenSet = true; m_applicationName.assign(value); }
    inline DeploymentInfo& WithApplicationName(const Aws::String& value) { SetApplicationName(value); return *this;}
    inline DeploymentInfo& WithApplicationName(Aws::String&& value) { SetApplicationName(std::move(value)); return *this;}
    inline DeploymentInfo& WithApplicationName(const char* value) { SetApplicationName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p> The deployment group name. </p>
     */
    inline const Aws::String& GetDeploymentGroupName() const{ return m_deploymentGroupName; }
    inline bool DeploymentGroupNameHasBeenSet() const { return m_deploymentGroupNameHasBeenSet; }
    inline void SetDeploymentGroupName(const Aws::String& value) { m_deploymentGroupNameHasBeenSet = true; m_deploymentGroupName = value; }
    inline void SetDeploymentGroupName(Aws::String&& value) { m_deploymentGroupNameHasBeenSet = true; m_deploymentGroupName = std::move(value); }
    inline void SetDeploymentGroupName(const char* value) { m_deploymentGroupNameHasBeenSet = true; m_deploymentGroupName.assign(value); }
    inline DeploymentInfo& WithDeploymentGroupName(const Aws::String& value) { SetDeploymentGroupName(value); return *this;}
    inline DeploymentInfo& WithDeploymentGroupName(Aws::String&& value) { SetDeploymentGroupName(std::move(value)); return *this;}
    inline DeploymentInfo& WithDeploymentGroupName(const char* value) { SetDeploymentGroupName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p> The deployment configuration name. </p>
     */
    inline const Aws::String& GetDeploymentConfigName() const{ return m_deploymentConfigName; }
    inline bool DeploymentConfigNameHasBeenSet() const { return m_deploymentConfigNameHasBeenSet; }
    inline void SetDeploymentConfigName(const Aws::String& value) { m_deploymentConfigNameHasBeenSet = true; m_deploymentConfigName = value; }
    inline void SetDeploymentConfigName(Aws::String&& value) { m_deploymentConfigNameHasBeenSet = true; m_deploymentConfigName = std::move(value); }
    inline void SetDeploymentConfigName(const char* value) { m_deploymentConfigNameHasBeenSet = true; m_deploymentConfigName.assign(value); }
    inline DeploymentInfo& WithDeploymentConfigName(const Aws::String& value) { SetDeploymentConfigName(value); return *this;}
    inline DeploymentInfo& WithDeploymentConfigName(Aws::String&& value) { SetDeploymentConfigName(std::move(value)); return *this;}
    inline DeploymentInfo& WithDeploymentConfigName(const char* value) { SetDeploymentConfigName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p> The unique ID of a deployment. </p>
     */
    inline const Aws::String& GetDeploymentId() const{ return m_deploymentId; }
    inline bool DeploymentIdHasBeenSet() const { return m_deploymentIdHasBeenSet; }
    inline void SetDeploymentId(const Aws::String& value) { m_deploymentIdHasBeenSet = true; m_deploymentId = value; }
    inline void SetDeploymentId(Aws::String&& value) { m_deploymentIdHasBeenSet = true; m_deploymentId = std::move(value); }
    inline void SetDeploymentId(const char* value) { m_deploymentIdHasBeenSet = true; m_deploymentId.assign(value); }
    inline DeploymentInfo& WithDeploymentId(const Aws::String& value) { SetDeploymentId(value); return *this;}
    inline DeploymentInfo& WithDeploymentId(Aws::String&& value) { SetDeploymentId(std::move(value)); return *this;}
    inline DeploymentInfo& WithDeploymentId(const char* value) { SetDeploymentId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the application revision that was deployed to the
     * deployment group before the most recent successful deployment.</p>
     */
    inline const RevisionLocation& GetPreviousRevision() const{ return m_previousRevision; }
    inline bool PreviousRevisionHasBeenSet() const { return m_previousRevisionHasBeenSet; }
    inline void SetPreviousRevision(const RevisionLocation& value) { m_previousRevisionHasBeenSet = true; m_previousRevision = value; }
    inline void SetPreviousRevision(RevisionLocation&& value) { m_previousRevisionHasBeenSet = true; m_previousRevision = std::move(value); }
    inline DeploymentInfo& WithPreviousRevision(const RevisionLocation& value) { SetPreviousRevision(value); return *this;}
    inline DeploymentInfo& WithPreviousRevision(RevisionLocation&& value) { SetPreviousRevision(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the location of stored application artifacts and the
     * service from which to retrieve them.</p>
     */
    inline const RevisionLocation& GetRevision() const{ return m_revision; }
    inline bool RevisionHasBeenSet() const { return m_revisionHasBeenSet; }
    inline void SetRevision(const RevisionLocation& value) { m_revisionHasBeenSet = true; m_revision = value; }
    inline void SetRevision(RevisionLocation&& value) { m_revisionHasBeenSet = true; m_revision = std::move(value); }
    inline DeploymentInfo& WithRevision(const RevisionLocation& value) { SetRevision(value); return *this;}
    inline DeploymentInfo& WithRevision(RevisionLocation&& value) { SetRevision(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The current state of the deployment as a whole.</p>
     */
    inline const DeploymentStatus& GetStatus() const{ return m_status; }
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
    inline void SetStatus(const DeploymentStatus& value) { m_statusHasBeenSet = true; m_status = value; }
    inline void SetStatus(DeploymentStatus&& value) { m_statusHasBeenSet = true; m_status = std::move(value); }
    inline DeploymentInfo& WithStatus(const DeploymentStatus& value) { SetStatus(value); return *this;}
    inline DeploymentInfo& WithStatus(DeploymentStatus&& value) { SetStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about any error associated with this deployment.</p>
     */
    inline const ErrorInformation& GetErrorInformation() const{ return m_errorInformation; }
    inline bool ErrorInformationHasBeenSet() const { return m_errorInformationHasBeenSet; }
    inline void SetErrorInformation(const ErrorInformation& value) { m_errorInformationHasBeenSet = true; m_errorInformation = value; }
    inline void SetErrorInformation(ErrorInformation&& value) { m_errorInformationHasBeenSet = true; m_errorInformation = std::move(value); }
    inline DeploymentInfo& WithErrorInformation(const ErrorInformation& value) { SetErrorInformation(value); return *this;}
    inline DeploymentInfo& WithErrorInformation(ErrorInformation&& value) { SetErrorInformation(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A timestamp that indicates when the deployment was created.</p>
     */
    inline const Aws::Utils::DateTime& GetCreateTime() const{ return m_createTime; }
    inline bool CreateTimeHasBeenSet() const { return m_createTimeHasBeenSet; }
    inline void SetCreateTime(const Aws::Utils::DateTime& value) { m_createTimeHasBeenSet = true; m_createTime = value; }
    inline void SetCreateTime(Aws::Utils::DateTime&& value) { m_createTimeHasBeenSet = true; m_createTime = std::move(value); }
    inline DeploymentInfo& WithCreateTime(const Aws::Utils::DateTime& value) { SetCreateTime(value); return *this;}
    inline DeploymentInfo& WithCreateTime(Aws::Utils::DateTime&& value) { SetCreateTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A timestamp that indicates when the deployment was deployed to the deployment
     * group.</p> <p>In some cases, the reported value of the start time might be later
     * than the complete time. This is due to differences in the clock settings of
     * backend servers that participate in the deployment process.</p>
     */
    inline const Aws::Utils::DateTime& GetStartTime() const{ return m_startTime; }
    inline bool StartTimeHasBeenSet() const { return m_startTimeHasBeenSet; }
    inline void SetStartTime(const Aws::Utils::DateTime& value) { m_startTimeHasBeenSet = true; m_startTime = value; }
    inline void SetStartTime(Aws::Utils::DateTime&& value) { m_startTimeHasBeenSet = true; m_startTime = std::move(value); }
    inline DeploymentInfo& WithStartTime(const Aws::Utils::DateTime& value) { SetStartTime(value); return *this;}
    inline DeploymentInfo& WithStartTime(Aws::Utils::DateTime&& value) { SetStartTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A timestamp that indicates when the deployment was complete.</p>
     */
    inline const Aws::Utils::DateTime& GetCompleteTime() const{ return m_completeTime; }
    inline bool CompleteTimeHasBeenSet() const { return m_completeTimeHasBeenSet; }
    inline void SetCompleteTime(const Aws::Utils::DateTime& value) { m_completeTimeHasBeenSet = true; m_completeTime = value; }
    inline void SetCompleteTime(Aws::Utils::DateTime&& value) { m_completeTimeHasBeenSet = true; m_completeTime = std::move(value); }
    inline DeploymentInfo& WithCompleteTime(const Aws::Utils::DateTime& value) { SetCompleteTime(value); return *this;}
    inline DeploymentInfo& WithCompleteTime(Aws::Utils::DateTime&& value) { SetCompleteTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A summary of the deployment status of the instances in the deployment.</p>
     */
    inline const DeploymentOverview& GetDeploymentOverview() const{ return m_deploymentOverview; }
    inline bool DeploymentOverviewHasBeenSet() const { return m_deploymentOverviewHasBeenSet; }
    inline void SetDeploymentOverview(const DeploymentOverview& value) { m_deploymentOverviewHasBeenSet = true; m_deploymentOverview = value; }
    inline void SetDeploymentOverview(DeploymentOverview&& value) { m_deploymentOverviewHasBeenSet = true; m_deploymentOverview = std::move(value); }
    inline DeploymentInfo& WithDeploymentOverview(const DeploymentOverview& value) { SetDeploymentOverview(value); return *this;}
    inline DeploymentInfo& WithDeploymentOverview(DeploymentOverview&& value) { SetDeploymentOverview(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A comment about the deployment.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }
    inline DeploymentInfo& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}
    inline DeploymentInfo& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}
    inline DeploymentInfo& WithDescription(const char* value) { SetDescription(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The means by which the deployment was created:</p> <ul> <li> <p>
     * <code>user</code>: A user created the deployment.</p> </li> <li> <p>
     * <code>autoscaling</code>: Amazon EC2 Auto Scaling created the deployment.</p>
     * </li> <li> <p> <code>codeDeployRollback</code>: A rollback process created the
     * deployment.</p> </li> <li> <p> <code>CodeDeployAutoUpdate</code>: An auto-update
     * process created the deployment when it detected outdated Amazon EC2
     * instances.</p> </li> </ul>
     */
    inline const DeploymentCreator& GetCreator() const{ return m_creator; }
    inline bool CreatorHasBeenSet() const { return m_creatorHasBeenSet; }
    inline void SetCreator(const DeploymentCreator& value) { m_creatorHasBeenSet = true; m_creator = value; }
    inline void SetCreator(DeploymentCreator&& value) { m_creatorHasBeenSet = true; m_creator = std::move(value); }
    inline DeploymentInfo& WithCreator(const DeploymentCreator& value) { SetCreator(value); return *this;}
    inline DeploymentInfo& WithCreator(DeploymentCreator&& value) { SetCreator(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p> If true, then if an <code>ApplicationStop</code>,
     * <code>BeforeBlockTraffic</code>, or <code>AfterBlockTraffic</code> deployment
     * lifecycle event to an instance fails, then the deployment continues to the next
     * deployment lifecycle event. For example, if <code>ApplicationStop</code> fails,
     * the deployment continues with DownloadBundle. If <code>BeforeBlockTraffic</code>
     * fails, the deployment continues with <code>BlockTraffic</code>. If
     * <code>AfterBlockTraffic</code> fails, the deployment continues with
     * <code>ApplicationStop</code>. </p> <p> If false or not specified, then if a
     * lifecycle event fails during a deployment to an instance, that deployment fails.
     * If deployment to that instance is part of an overall deployment and the number
     * of healthy hosts is not less than the minimum number of healthy hosts, then a
     * deployment to the next instance is attempted. </p> <p> During a deployment, the
     * CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>,
     * <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the
     * AppSpec file from the previous successful deployment. (All other scripts are run
     * from the AppSpec file in the current deployment.) If one of these scripts
     * contains an error and does not run successfully, the deployment can fail. </p>
     * <p> If the cause of the failure is a script from the last successful deployment
     * that will never run successfully, create a new deployment and use
     * <code>ignoreApplicationStopFailures</code> to specify that the
     * <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and
     * <code>AfterBlockTraffic</code> failures should be ignored. </p>
     */
    inline bool GetIgnoreApplicationStopFailures() const{ return m_ignoreApplicationStopFailures; }
    inline bool IgnoreApplicationStopFailuresHasBeenSet() const { return m_ignoreApplicationStopFailuresHasBeenSet; }
    inline void SetIgnoreApplicationStopFailures(bool value) { m_ignoreApplicationStopFailuresHasBeenSet = true; m_ignoreApplicationStopFailures = value; }
    inline DeploymentInfo& WithIgnoreApplicationStopFailures(bool value) { SetIgnoreApplicationStopFailures(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the automatic rollback configuration associated with the
     * deployment.</p>
     */
    inline const AutoRollbackConfiguration& GetAutoRollbackConfiguration() const{ return m_autoRollbackConfiguration; }
    inline bool AutoRollbackConfigurationHasBeenSet() const { return m_autoRollbackConfigurationHasBeenSet; }
    inline void SetAutoRollbackConfiguration(const AutoRollbackConfiguration& value) { m_autoRollbackConfigurationHasBeenSet = true; m_autoRollbackConfiguration = value; }
    inline void SetAutoRollbackConfiguration(AutoRollbackConfiguration&& value) { m_autoRollbackConfigurationHasBeenSet = true; m_autoRollbackConfiguration = std::move(value); }
    inline DeploymentInfo& WithAutoRollbackConfiguration(const AutoRollbackConfiguration& value) { SetAutoRollbackConfiguration(value); return *this;}
    inline DeploymentInfo& WithAutoRollbackConfiguration(AutoRollbackConfiguration&& value) { SetAutoRollbackConfiguration(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates whether only instances that are not running the latest application
     * revision are to be deployed to.</p>
     */
    inline bool GetUpdateOutdatedInstancesOnly() const{ return m_updateOutdatedInstancesOnly; }
    inline bool UpdateOutdatedInstancesOnlyHasBeenSet() const { return m_updateOutdatedInstancesOnlyHasBeenSet; }
    inline void SetUpdateOutdatedInstancesOnly(bool value) { m_updateOutdatedInstancesOnlyHasBeenSet = true; m_updateOutdatedInstancesOnly = value; }
    inline DeploymentInfo& WithUpdateOutdatedInstancesOnly(bool value) { SetUpdateOutdatedInstancesOnly(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about a deployment rollback.</p>
     */
    inline const RollbackInfo& GetRollbackInfo() const{ return m_rollbackInfo; }
    inline bool RollbackInfoHasBeenSet() const { return m_rollbackInfoHasBeenSet; }
    inline void SetRollbackInfo(const RollbackInfo& value) { m_rollbackInfoHasBeenSet = true; m_rollbackInfo = value; }
    inline void SetRollbackInfo(RollbackInfo&& value) { m_rollbackInfoHasBeenSet = true; m_rollbackInfo = std::move(value); }
    inline DeploymentInfo& WithRollbackInfo(const RollbackInfo& value) { SetRollbackInfo(value); return *this;}
    inline DeploymentInfo& WithRollbackInfo(RollbackInfo&& value) { SetRollbackInfo(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the type of deployment, either in-place or blue/green, you
     * want to run and whether to route deployment traffic behind a load balancer.</p>
     */
    inline const DeploymentStyle& GetDeploymentStyle() const{ return m_deploymentStyle; }
    inline bool DeploymentStyleHasBeenSet() const { return m_deploymentStyleHasBeenSet; }
    inline void SetDeploymentStyle(const DeploymentStyle& value) { m_deploymentStyleHasBeenSet = true; m_deploymentStyle = value; }
    inline void SetDeploymentStyle(DeploymentStyle&& value) { m_deploymentStyleHasBeenSet = true; m_deploymentStyle = std::move(value); }
    inline DeploymentInfo& WithDeploymentStyle(const DeploymentStyle& value) { SetDeploymentStyle(value); return *this;}
    inline DeploymentInfo& WithDeploymentStyle(DeploymentStyle&& value) { SetDeploymentStyle(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the instances that belong to the replacement environment in
     * a blue/green deployment.</p>
     */
    inline const TargetInstances& GetTargetInstances() const{ return m_targetInstances; }
    inline bool TargetInstancesHasBeenSet() const { return m_targetInstancesHasBeenSet; }
    inline void SetTargetInstances(const TargetInstances& value) { m_targetInstancesHasBeenSet = true; m_targetInstances = value; }
    inline void SetTargetInstances(TargetInstances&& value) { m_targetInstancesHasBeenSet = true; m_targetInstances = std::move(value); }
    inline DeploymentInfo& WithTargetInstances(const TargetInstances& value) { SetTargetInstances(value); return *this;}
    inline DeploymentInfo& WithTargetInstances(TargetInstances&& value) { SetTargetInstances(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates whether the wait period set for the termination of instances in the
     * original environment has started. Status is 'false' if the KEEP_ALIVE option is
     * specified. Otherwise, 'true' as soon as the termination wait period starts.</p>
     */
    inline bool GetInstanceTerminationWaitTimeStarted() const{ return m_instanceTerminationWaitTimeStarted; }
    inline bool InstanceTerminationWaitTimeStartedHasBeenSet() const { return m_instanceTerminationWaitTimeStartedHasBeenSet; }
    inline void SetInstanceTerminationWaitTimeStarted(bool value) { m_instanceTerminationWaitTimeStartedHasBeenSet = true; m_instanceTerminationWaitTimeStarted = value; }
    inline DeploymentInfo& WithInstanceTerminationWaitTimeStarted(bool value) { SetInstanceTerminationWaitTimeStarted(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about blue/green deployment options for this deployment.</p>
     */
    inline const BlueGreenDeploymentConfiguration& GetBlueGreenDeploymentConfiguration() const{ return m_blueGreenDeploymentConfiguration; }
    inline bool BlueGreenDeploymentConfigurationHasBeenSet() const { return m_blueGreenDeploymentConfigurationHasBeenSet; }
    inline void SetBlueGreenDeploymentConfiguration(const BlueGreenDeploymentConfiguration& value) { m_blueGreenDeploymentConfigurationHasBeenSet = true; m_blueGreenDeploymentConfiguration = value; }
    inline void SetBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration&& value) { m_blueGreenDeploymentConfigurationHasBeenSet = true; m_blueGreenDeploymentConfiguration = std::move(value); }
    inline DeploymentInfo& WithBlueGreenDeploymentConfiguration(const BlueGreenDeploymentConfiguration& value) { SetBlueGreenDeploymentConfiguration(value); return *this;}
    inline DeploymentInfo& WithBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration&& value) { SetBlueGreenDeploymentConfiguration(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the load balancer used in the deployment.</p>
     */
    inline const LoadBalancerInfo& GetLoadBalancerInfo() const{ return m_loadBalancerInfo; }
    inline bool LoadBalancerInfoHasBeenSet() const { return m_loadBalancerInfoHasBeenSet; }
    inline void SetLoadBalancerInfo(const LoadBalancerInfo& value) { m_loadBalancerInfoHasBeenSet = true; m_loadBalancerInfo = value; }
    inline void SetLoadBalancerInfo(LoadBalancerInfo&& value) { m_loadBalancerInfoHasBeenSet = true; m_loadBalancerInfo = std::move(value); }
    inline DeploymentInfo& WithLoadBalancerInfo(const LoadBalancerInfo& value) { SetLoadBalancerInfo(value); return *this;}
    inline DeploymentInfo& WithLoadBalancerInfo(LoadBalancerInfo&& value) { SetLoadBalancerInfo(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Provides information about the results of a deployment, such as whether
     * instances in the original environment in a blue/green deployment were not
     * terminated.</p>
     */
    inline const Aws::String& GetAdditionalDeploymentStatusInfo() const{ return m_additionalDeploymentStatusInfo; }
    inline bool AdditionalDeploymentStatusInfoHasBeenSet() const { return m_additionalDeploymentStatusInfoHasBeenSet; }
    inline void SetAdditionalDeploymentStatusInfo(const Aws::String& value) { m_additionalDeploymentStatusInfoHasBeenSet = true; m_additionalDeploymentStatusInfo = value; }
    inline void SetAdditionalDeploymentStatusInfo(Aws::String&& value) { m_additionalDeploymentStatusInfoHasBeenSet = true; m_additionalDeploymentStatusInfo = std::move(value); }
    inline void SetAdditionalDeploymentStatusInfo(const char* value) { m_additionalDeploymentStatusInfoHasBeenSet = true; m_additionalDeploymentStatusInfo.assign(value); }
    inline DeploymentInfo& WithAdditionalDeploymentStatusInfo(const Aws::String& value) { SetAdditionalDeploymentStatusInfo(value); return *this;}
    inline DeploymentInfo& WithAdditionalDeploymentStatusInfo(Aws::String&& value) { SetAdditionalDeploymentStatusInfo(std::move(value)); return *this;}
    inline DeploymentInfo& WithAdditionalDeploymentStatusInfo(const char* value) { SetAdditionalDeploymentStatusInfo(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about how CodeDeploy handles files that already exist in a
     * deployment target location but weren't part of the previous successful
     * deployment.</p> <ul> <li> <p> <code>DISALLOW</code>: The deployment fails. This
     * is also the default behavior if no option is specified.</p> </li> <li> <p>
     * <code>OVERWRITE</code>: The version of the file from the application revision
     * currently being deployed replaces the version already on the instance.</p> </li>
     * <li> <p> <code>RETAIN</code>: The version of the file already on the instance is
     * kept and used as part of the new deployment.</p> </li> </ul>
     */
    inline const FileExistsBehavior& GetFileExistsBehavior() const{ return m_fileExistsBehavior; }
    inline bool FileExistsBehaviorHasBeenSet() const { return m_fileExistsBehaviorHasBeenSet; }
    inline void SetFileExistsBehavior(const FileExistsBehavior& value) { m_fileExistsBehaviorHasBeenSet = true; m_fileExistsBehavior = value; }
    inline void SetFileExistsBehavior(FileExistsBehavior&& value) { m_fileExistsBehaviorHasBeenSet = true; m_fileExistsBehavior = std::move(value); }
    inline DeploymentInfo& WithFileExistsBehavior(const FileExistsBehavior& value) { SetFileExistsBehavior(value); return *this;}
    inline DeploymentInfo& WithFileExistsBehavior(FileExistsBehavior&& value) { SetFileExistsBehavior(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Messages that contain information about the status of a deployment.</p>
     */
    inline const Aws::Vector<Aws::String>& GetDeploymentStatusMessages() const{ return m_deploymentStatusMessages; }
    inline bool DeploymentStatusMessagesHasBeenSet() const { return m_deploymentStatusMessagesHasBeenSet; }
    inline void SetDeploymentStatusMessages(const Aws::Vector<Aws::String>& value) { m_deploymentStatusMessagesHasBeenSet = true; m_deploymentStatusMessages = value; }
    inline void SetDeploymentStatusMessages(Aws::Vector<Aws::String>&& value) { m_deploymentStatusMessagesHasBeenSet = true; m_deploymentStatusMessages = std::move(value); }
    inline DeploymentInfo& WithDeploymentStatusMessages(const Aws::Vector<Aws::String>& value) { SetDeploymentStatusMessages(value); return *this;}
    inline DeploymentInfo& WithDeploymentStatusMessages(Aws::Vector<Aws::String>&& value) { SetDeploymentStatusMessages(std::move(value)); return *this;}
    inline DeploymentInfo& AddDeploymentStatusMessages(const Aws::String& value) { m_deploymentStatusMessagesHasBeenSet = true; m_deploymentStatusMessages.push_back(value); return *this; }
    inline DeploymentInfo& AddDeploymentStatusMessages(Aws::String&& value) { m_deploymentStatusMessagesHasBeenSet = true; m_deploymentStatusMessages.push_back(std::move(value)); return *this; }
    inline DeploymentInfo& AddDeploymentStatusMessages(const char* value) { m_deploymentStatusMessagesHasBeenSet = true; m_deploymentStatusMessages.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The destination platform type for the deployment (<code>Lambda</code>,
     * <code>Server</code>, or <code>ECS</code>).</p>
     */
    inline const ComputePlatform& GetComputePlatform() const{ return m_computePlatform; }
    inline bool ComputePlatformHasBeenSet() const { return m_computePlatformHasBeenSet; }
    inline void SetComputePlatform(const ComputePlatform& value) { m_computePlatformHasBeenSet = true; m_computePlatform = value; }
    inline void SetComputePlatform(ComputePlatform&& value) { m_computePlatformHasBeenSet = true; m_computePlatform = std::move(value); }
    inline DeploymentInfo& WithComputePlatform(const ComputePlatform& value) { SetComputePlatform(value); return *this;}
    inline DeploymentInfo& WithComputePlatform(ComputePlatform&& value) { SetComputePlatform(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The unique ID for an external resource (for example, a CloudFormation stack
     * ID) that is linked to this deployment.</p>
     */
    inline const Aws::String& GetExternalId() const{ return m_externalId; }
    inline bool ExternalIdHasBeenSet() const { return m_externalIdHasBeenSet; }
    inline void SetExternalId(const Aws::String& value) { m_externalIdHasBeenSet = true; m_externalId = value; }
    inline void SetExternalId(Aws::String&& value) { m_externalIdHasBeenSet = true; m_externalId = std::move(value); }
    inline void SetExternalId(const char* value) { m_externalIdHasBeenSet = true; m_externalId.assign(value); }
    inline DeploymentInfo& WithExternalId(const Aws::String& value) { SetExternalId(value); return *this;}
    inline DeploymentInfo& WithExternalId(Aws::String&& value) { SetExternalId(std::move(value)); return *this;}
    inline DeploymentInfo& WithExternalId(const char* value) { SetExternalId(value); return *this;}
    ///@}

    ///@{
    
    inline const RelatedDeployments& GetRelatedDeployments() const{ return m_relatedDeployments; }
    inline bool RelatedDeploymentsHasBeenSet() const { return m_relatedDeploymentsHasBeenSet; }
    inline void SetRelatedDeployments(const RelatedDeployments& value) { m_relatedDeploymentsHasBeenSet = true; m_relatedDeployments = value; }
    inline void SetRelatedDeployments(RelatedDeployments&& value) { m_relatedDeploymentsHasBeenSet = true; m_relatedDeployments = std::move(value); }
    inline DeploymentInfo& WithRelatedDeployments(const RelatedDeployments& value) { SetRelatedDeployments(value); return *this;}
    inline DeploymentInfo& WithRelatedDeployments(RelatedDeployments&& value) { SetRelatedDeployments(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const AlarmConfiguration& GetOverrideAlarmConfiguration() const{ return m_overrideAlarmConfiguration; }
    inline bool OverrideAlarmConfigurationHasBeenSet() const { return m_overrideAlarmConfigurationHasBeenSet; }
    inline void SetOverrideAlarmConfiguration(const AlarmConfiguration& value) { m_overrideAlarmConfigurationHasBeenSet = true; m_overrideAlarmConfiguration = value; }
    inline void SetOverrideAlarmConfiguration(AlarmConfiguration&& value) { m_overrideAlarmConfigurationHasBeenSet = true; m_overrideAlarmConfiguration = std::move(value); }
    inline DeploymentInfo& WithOverrideAlarmConfiguration(const AlarmConfiguration& value) { SetOverrideAlarmConfiguration(value); return *this;}
    inline DeploymentInfo& WithOverrideAlarmConfiguration(AlarmConfiguration&& value) { SetOverrideAlarmConfiguration(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_applicationName;
    bool m_applicationNameHasBeenSet = false;

    Aws::String m_deploymentGroupName;
    bool m_deploymentGroupNameHasBeenSet = false;

    Aws::String m_deploymentConfigName;
    bool m_deploymentConfigNameHasBeenSet = false;

    Aws::String m_deploymentId;
    bool m_deploymentIdHasBeenSet = false;

    RevisionLocation m_previousRevision;
    bool m_previousRevisionHasBeenSet = false;

    RevisionLocation m_revision;
    bool m_revisionHasBeenSet = false;

    DeploymentStatus m_status;
    bool m_statusHasBeenSet = false;

    ErrorInformation m_errorInformation;
    bool m_errorInformationHasBeenSet = false;

    Aws::Utils::DateTime m_createTime;
    bool m_createTimeHasBeenSet = false;

    Aws::Utils::DateTime m_startTime;
    bool m_startTimeHasBeenSet = false;

    Aws::Utils::DateTime m_completeTime;
    bool m_completeTimeHasBeenSet = false;

    DeploymentOverview m_deploymentOverview;
    bool m_deploymentOverviewHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    DeploymentCreator m_creator;
    bool m_creatorHasBeenSet = false;

    bool m_ignoreApplicationStopFailures;
    bool m_ignoreApplicationStopFailuresHasBeenSet = false;

    AutoRollbackConfiguration m_autoRollbackConfiguration;
    bool m_autoRollbackConfigurationHasBeenSet = false;

    bool m_updateOutdatedInstancesOnly;
    bool m_updateOutdatedInstancesOnlyHasBeenSet = false;

    RollbackInfo m_rollbackInfo;
    bool m_rollbackInfoHasBeenSet = false;

    DeploymentStyle m_deploymentStyle;
    bool m_deploymentStyleHasBeenSet = false;

    TargetInstances m_targetInstances;
    bool m_targetInstancesHasBeenSet = false;

    bool m_instanceTerminationWaitTimeStarted;
    bool m_instanceTerminationWaitTimeStartedHasBeenSet = false;

    BlueGreenDeploymentConfiguration m_blueGreenDeploymentConfiguration;
    bool m_blueGreenDeploymentConfigurationHasBeenSet = false;

    LoadBalancerInfo m_loadBalancerInfo;
    bool m_loadBalancerInfoHasBeenSet = false;

    Aws::String m_additionalDeploymentStatusInfo;
    bool m_additionalDeploymentStatusInfoHasBeenSet = false;

    FileExistsBehavior m_fileExistsBehavior;
    bool m_fileExistsBehaviorHasBeenSet = false;

    Aws::Vector<Aws::String> m_deploymentStatusMessages;
    bool m_deploymentStatusMessagesHasBeenSet = false;

    ComputePlatform m_computePlatform;
    bool m_computePlatformHasBeenSet = false;

    Aws::String m_externalId;
    bool m_externalIdHasBeenSet = false;

    RelatedDeployments m_relatedDeployments;
    bool m_relatedDeploymentsHasBeenSet = false;

    AlarmConfiguration m_overrideAlarmConfiguration;
    bool m_overrideAlarmConfigurationHasBeenSet = false;
  };

} // namespace Model
} // namespace CodeDeploy
} // namespace Aws
