﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apprunner/AppRunner_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/apprunner/model/VpcIngressConnectionSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace AppRunner
{
namespace Model
{
  class ListVpcIngressConnectionsResult
  {
  public:
    AWS_APPRUNNER_API ListVpcIngressConnectionsResult();
    AWS_APPRUNNER_API ListVpcIngressConnectionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_APPRUNNER_API ListVpcIngressConnectionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of summary information records for VPC Ingress Connections. In a
     * paginated request, the request returns up to <code>MaxResults</code> records for
     * each call.</p>
     */
    inline const Aws::Vector<VpcIngressConnectionSummary>& GetVpcIngressConnectionSummaryList() const{ return m_vpcIngressConnectionSummaryList; }
    inline void SetVpcIngressConnectionSummaryList(const Aws::Vector<VpcIngressConnectionSummary>& value) { m_vpcIngressConnectionSummaryList = value; }
    inline void SetVpcIngressConnectionSummaryList(Aws::Vector<VpcIngressConnectionSummary>&& value) { m_vpcIngressConnectionSummaryList = std::move(value); }
    inline ListVpcIngressConnectionsResult& WithVpcIngressConnectionSummaryList(const Aws::Vector<VpcIngressConnectionSummary>& value) { SetVpcIngressConnectionSummaryList(value); return *this;}
    inline ListVpcIngressConnectionsResult& WithVpcIngressConnectionSummaryList(Aws::Vector<VpcIngressConnectionSummary>&& value) { SetVpcIngressConnectionSummaryList(std::move(value)); return *this;}
    inline ListVpcIngressConnectionsResult& AddVpcIngressConnectionSummaryList(const VpcIngressConnectionSummary& value) { m_vpcIngressConnectionSummaryList.push_back(value); return *this; }
    inline ListVpcIngressConnectionsResult& AddVpcIngressConnectionSummaryList(VpcIngressConnectionSummary&& value) { m_vpcIngressConnectionSummaryList.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token that you can pass in a subsequent request to get the next result
     * page. It's returned in a paginated request.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListVpcIngressConnectionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListVpcIngressConnectionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListVpcIngressConnectionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListVpcIngressConnectionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListVpcIngressConnectionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListVpcIngressConnectionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<VpcIngressConnectionSummary> m_vpcIngressConnectionSummaryList;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace AppRunner
} // namespace Aws
