// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#pragma once

#include "arrow/chunked_array.h"

#include "libmexclass/proxy/Proxy.h"

namespace arrow::matlab::array::proxy {

class ChunkedArray : public libmexclass::proxy::Proxy {
 public:
  ChunkedArray(std::shared_ptr<arrow::ChunkedArray> chunked_array);

  ~ChunkedArray() {}

  std::shared_ptr<arrow::ChunkedArray> unwrap();

  static libmexclass::proxy::MakeResult make(
      const libmexclass::proxy::FunctionArguments& constructor_arguments);

 protected:
  void getNumElements(libmexclass::proxy::method::Context& context);

  void getNumChunks(libmexclass::proxy::method::Context& context);

  void getChunk(libmexclass::proxy::method::Context& context);

  void getType(libmexclass::proxy::method::Context& context);

  void isEqual(libmexclass::proxy::method::Context& context);

  std::shared_ptr<arrow::ChunkedArray> chunked_array;
};

}  // namespace arrow::matlab::array::proxy
