// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//
// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the protocol buffer compiler.
// Source: Flight.proto
//
import GRPC
import NIO
import NIOConcurrencyHelpers
import SwiftProtobuf


///
/// A flight service is an endpoint for retrieving or storing Arrow data. A
/// flight service can expose one or more predefined endpoints that can be
/// accessed using the Arrow Flight Protocol. Additionally, a flight service
/// can expose a set of actions that are available.
///
/// Usage: instantiate `Arrow_Flight_Protocol_FlightServiceClient`, then call methods of this protocol to make API calls.
internal protocol Arrow_Flight_Protocol_FlightServiceClientProtocol: GRPCClient {
  var serviceName: String { get }
  var interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol? { get }

  func handshake(
    callOptions: CallOptions?,
    handler: @escaping (Arrow_Flight_Protocol_HandshakeResponse) -> Void
  ) -> BidirectionalStreamingCall<Arrow_Flight_Protocol_HandshakeRequest, Arrow_Flight_Protocol_HandshakeResponse>

  func listFlights(
    _ request: Arrow_Flight_Protocol_Criteria,
    callOptions: CallOptions?,
    handler: @escaping (Arrow_Flight_Protocol_FlightInfo) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Criteria, Arrow_Flight_Protocol_FlightInfo>

  func getFlightInfo(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions?
  ) -> UnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_FlightInfo>

  func getSchema(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions?
  ) -> UnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_SchemaResult>

  func doGet(
    _ request: Arrow_Flight_Protocol_Ticket,
    callOptions: CallOptions?,
    handler: @escaping (Arrow_Flight_Protocol_FlightData) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Ticket, Arrow_Flight_Protocol_FlightData>

  func doPut(
    callOptions: CallOptions?,
    handler: @escaping (Arrow_Flight_Protocol_PutResult) -> Void
  ) -> BidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_PutResult>

  func doExchange(
    callOptions: CallOptions?,
    handler: @escaping (Arrow_Flight_Protocol_FlightData) -> Void
  ) -> BidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_FlightData>

  func doAction(
    _ request: Arrow_Flight_Protocol_Action,
    callOptions: CallOptions?,
    handler: @escaping (Arrow_Flight_Protocol_Result) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Action, Arrow_Flight_Protocol_Result>

  func listActions(
    _ request: Arrow_Flight_Protocol_Empty,
    callOptions: CallOptions?,
    handler: @escaping (Arrow_Flight_Protocol_ActionType) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Empty, Arrow_Flight_Protocol_ActionType>
}

extension Arrow_Flight_Protocol_FlightServiceClientProtocol {
  internal var serviceName: String {
    return "arrow.flight.protocol.FlightService"
  }

  ///
  /// Handshake between client and server. Depending on the server, the
  /// handshake may be required to determine the token that should be used for
  /// future operations. Both request and response are streams to allow multiple
  /// round-trips depending on auth mechanism.
  ///
  /// Callers should use the `send` method on the returned object to send messages
  /// to the server. The caller should send an `.end` after the final message has been sent.
  ///
  /// - Parameters:
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ClientStreamingCall` with futures for the metadata and status.
  internal func handshake(
    callOptions: CallOptions? = nil,
    handler: @escaping (Arrow_Flight_Protocol_HandshakeResponse) -> Void
  ) -> BidirectionalStreamingCall<Arrow_Flight_Protocol_HandshakeRequest, Arrow_Flight_Protocol_HandshakeResponse> {
    return self.makeBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.handshake.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeHandshakeInterceptors() ?? [],
      handler: handler
    )
  }

  ///
  /// Get a list of available streams given a particular criteria. Most flight
  /// services will expose one or more streams that are readily available for
  /// retrieval. This api allows listing the streams available for
  /// consumption. A user can also provide a criteria. The criteria can limit
  /// the subset of streams that can be listed via this interface. Each flight
  /// service allows its own definition of how to consume criteria.
  ///
  /// - Parameters:
  ///   - request: Request to send to ListFlights.
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ServerStreamingCall` with futures for the metadata and status.
  internal func listFlights(
    _ request: Arrow_Flight_Protocol_Criteria,
    callOptions: CallOptions? = nil,
    handler: @escaping (Arrow_Flight_Protocol_FlightInfo) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Criteria, Arrow_Flight_Protocol_FlightInfo> {
    return self.makeServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listFlights.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeListFlightsInterceptors() ?? [],
      handler: handler
    )
  }

  ///
  /// For a given FlightDescriptor, get information about how the flight can be
  /// consumed. This is a useful interface if the consumer of the interface
  /// already can identify the specific flight to consume. This interface can
  /// also allow a consumer to generate a flight stream through a specified
  /// descriptor. For example, a flight descriptor might be something that
  /// includes a SQL statement or a Pickled Python operation that will be
  /// executed. In those cases, the descriptor will not be previously available
  /// within the list of available streams provided by ListFlights but will be
  /// available for consumption for the duration defined by the specific flight
  /// service.
  ///
  /// - Parameters:
  ///   - request: Request to send to GetFlightInfo.
  ///   - callOptions: Call options.
  /// - Returns: A `UnaryCall` with futures for the metadata, status and response.
  internal func getFlightInfo(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions? = nil
  ) -> UnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_FlightInfo> {
    return self.makeUnaryCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getFlightInfo.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeGetFlightInfoInterceptors() ?? []
    )
  }

  ///
  /// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
  /// This is used when a consumer needs the Schema of flight stream. Similar to
  /// GetFlightInfo this interface may generate a new flight that was not previously
  /// available in ListFlights.
  ///
  /// - Parameters:
  ///   - request: Request to send to GetSchema.
  ///   - callOptions: Call options.
  /// - Returns: A `UnaryCall` with futures for the metadata, status and response.
  internal func getSchema(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions? = nil
  ) -> UnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_SchemaResult> {
    return self.makeUnaryCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getSchema.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeGetSchemaInterceptors() ?? []
    )
  }

  ///
  /// Retrieve a single stream associated with a particular descriptor
  /// associated with the referenced ticket. A Flight can be composed of one or
  /// more streams where each stream can be retrieved using a separate opaque
  /// ticket that the flight service uses for managing a collection of streams.
  ///
  /// - Parameters:
  ///   - request: Request to send to DoGet.
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ServerStreamingCall` with futures for the metadata and status.
  internal func doGet(
    _ request: Arrow_Flight_Protocol_Ticket,
    callOptions: CallOptions? = nil,
    handler: @escaping (Arrow_Flight_Protocol_FlightData) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Ticket, Arrow_Flight_Protocol_FlightData> {
    return self.makeServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doGet.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoGetInterceptors() ?? [],
      handler: handler
    )
  }

  ///
  /// Push a stream to the flight service associated with a particular
  /// flight stream. This allows a client of a flight service to upload a stream
  /// of data. Depending on the particular flight service, a client consumer
  /// could be allowed to upload a single stream per descriptor or an unlimited
  /// number. In the latter, the service might implement a 'seal' action that
  /// can be applied to a descriptor once all streams are uploaded.
  ///
  /// Callers should use the `send` method on the returned object to send messages
  /// to the server. The caller should send an `.end` after the final message has been sent.
  ///
  /// - Parameters:
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ClientStreamingCall` with futures for the metadata and status.
  internal func doPut(
    callOptions: CallOptions? = nil,
    handler: @escaping (Arrow_Flight_Protocol_PutResult) -> Void
  ) -> BidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_PutResult> {
    return self.makeBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doPut.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoPutInterceptors() ?? [],
      handler: handler
    )
  }

  ///
  /// Open a bidirectional data channel for a given descriptor. This
  /// allows clients to send and receive arbitrary Arrow data and
  /// application-specific metadata in a single logical stream. In
  /// contrast to DoGet/DoPut, this is more suited for clients
  /// offloading computation (rather than storage) to a Flight service.
  ///
  /// Callers should use the `send` method on the returned object to send messages
  /// to the server. The caller should send an `.end` after the final message has been sent.
  ///
  /// - Parameters:
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ClientStreamingCall` with futures for the metadata and status.
  internal func doExchange(
    callOptions: CallOptions? = nil,
    handler: @escaping (Arrow_Flight_Protocol_FlightData) -> Void
  ) -> BidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_FlightData> {
    return self.makeBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doExchange.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoExchangeInterceptors() ?? [],
      handler: handler
    )
  }

  ///
  /// Flight services can support an arbitrary number of simple actions in
  /// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
  /// operations that are potentially available. DoAction allows a flight client
  /// to do a specific action against a flight service. An action includes
  /// opaque request and response objects that are specific to the type action
  /// being undertaken.
  ///
  /// - Parameters:
  ///   - request: Request to send to DoAction.
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ServerStreamingCall` with futures for the metadata and status.
  internal func doAction(
    _ request: Arrow_Flight_Protocol_Action,
    callOptions: CallOptions? = nil,
    handler: @escaping (Arrow_Flight_Protocol_Result) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Action, Arrow_Flight_Protocol_Result> {
    return self.makeServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doAction.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoActionInterceptors() ?? [],
      handler: handler
    )
  }

  ///
  /// A flight service exposes all of the available action types that it has
  /// along with descriptions. This allows different flight consumers to
  /// understand the capabilities of the flight service.
  ///
  /// - Parameters:
  ///   - request: Request to send to ListActions.
  ///   - callOptions: Call options.
  ///   - handler: A closure called when each response is received from the server.
  /// - Returns: A `ServerStreamingCall` with futures for the metadata and status.
  internal func listActions(
    _ request: Arrow_Flight_Protocol_Empty,
    callOptions: CallOptions? = nil,
    handler: @escaping (Arrow_Flight_Protocol_ActionType) -> Void
  ) -> ServerStreamingCall<Arrow_Flight_Protocol_Empty, Arrow_Flight_Protocol_ActionType> {
    return self.makeServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listActions.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeListActionsInterceptors() ?? [],
      handler: handler
    )
  }
}

@available(*, deprecated)
extension Arrow_Flight_Protocol_FlightServiceClient: @unchecked Sendable {}

@available(*, deprecated, renamed: "Arrow_Flight_Protocol_FlightServiceNIOClient")
internal final class Arrow_Flight_Protocol_FlightServiceClient: Arrow_Flight_Protocol_FlightServiceClientProtocol {
  private let lock = Lock()
  private var _defaultCallOptions: CallOptions
  private var _interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol?
  internal let channel: GRPCChannel
  internal var defaultCallOptions: CallOptions {
    get { self.lock.withLock { return self._defaultCallOptions } }
    set { self.lock.withLockVoid { self._defaultCallOptions = newValue } }
  }
  internal var interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol? {
    get { self.lock.withLock { return self._interceptors } }
    set { self.lock.withLockVoid { self._interceptors = newValue } }
  }

  /// Creates a client for the arrow.flight.protocol.FlightService service.
  ///
  /// - Parameters:
  ///   - channel: `GRPCChannel` to the service host.
  ///   - defaultCallOptions: Options to use for each service call if the user doesn't provide them.
  ///   - interceptors: A factory providing interceptors for each RPC.
  internal init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self._defaultCallOptions = defaultCallOptions
    self._interceptors = interceptors
  }
}

internal struct Arrow_Flight_Protocol_FlightServiceNIOClient: Arrow_Flight_Protocol_FlightServiceClientProtocol {
  internal var channel: GRPCChannel
  internal var defaultCallOptions: CallOptions
  internal var interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol?

  /// Creates a client for the arrow.flight.protocol.FlightService service.
  ///
  /// - Parameters:
  ///   - channel: `GRPCChannel` to the service host.
  ///   - defaultCallOptions: Options to use for each service call if the user doesn't provide them.
  ///   - interceptors: A factory providing interceptors for each RPC.
  internal init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self.defaultCallOptions = defaultCallOptions
    self.interceptors = interceptors
  }
}

///
/// A flight service is an endpoint for retrieving or storing Arrow data. A
/// flight service can expose one or more predefined endpoints that can be
/// accessed using the Arrow Flight Protocol. Additionally, a flight service
/// can expose a set of actions that are available.
@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
internal protocol Arrow_Flight_Protocol_FlightServiceAsyncClientProtocol: GRPCClient {
  static var serviceDescriptor: GRPCServiceDescriptor { get }
  var interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol? { get }

  func makeHandshakeCall(
    callOptions: CallOptions?
  ) -> GRPCAsyncBidirectionalStreamingCall<Arrow_Flight_Protocol_HandshakeRequest, Arrow_Flight_Protocol_HandshakeResponse>

  func makeListFlightsCall(
    _ request: Arrow_Flight_Protocol_Criteria,
    callOptions: CallOptions?
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Criteria, Arrow_Flight_Protocol_FlightInfo>

  func makeGetFlightInfoCall(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions?
  ) -> GRPCAsyncUnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_FlightInfo>

  func makeGetSchemaCall(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions?
  ) -> GRPCAsyncUnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_SchemaResult>

  func makeDoGetCall(
    _ request: Arrow_Flight_Protocol_Ticket,
    callOptions: CallOptions?
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Ticket, Arrow_Flight_Protocol_FlightData>

  func makeDoPutCall(
    callOptions: CallOptions?
  ) -> GRPCAsyncBidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_PutResult>

  func makeDoExchangeCall(
    callOptions: CallOptions?
  ) -> GRPCAsyncBidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_FlightData>

  func makeDoActionCall(
    _ request: Arrow_Flight_Protocol_Action,
    callOptions: CallOptions?
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Action, Arrow_Flight_Protocol_Result>

  func makeListActionsCall(
    _ request: Arrow_Flight_Protocol_Empty,
    callOptions: CallOptions?
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Empty, Arrow_Flight_Protocol_ActionType>
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension Arrow_Flight_Protocol_FlightServiceAsyncClientProtocol {
  internal static var serviceDescriptor: GRPCServiceDescriptor {
    return Arrow_Flight_Protocol_FlightServiceClientMetadata.serviceDescriptor
  }

  internal var interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol? {
    return nil
  }

  internal func makeHandshakeCall(
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncBidirectionalStreamingCall<Arrow_Flight_Protocol_HandshakeRequest, Arrow_Flight_Protocol_HandshakeResponse> {
    return self.makeAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.handshake.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeHandshakeInterceptors() ?? []
    )
  }

  internal func makeListFlightsCall(
    _ request: Arrow_Flight_Protocol_Criteria,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Criteria, Arrow_Flight_Protocol_FlightInfo> {
    return self.makeAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listFlights.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeListFlightsInterceptors() ?? []
    )
  }

  internal func makeGetFlightInfoCall(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncUnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_FlightInfo> {
    return self.makeAsyncUnaryCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getFlightInfo.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeGetFlightInfoInterceptors() ?? []
    )
  }

  internal func makeGetSchemaCall(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncUnaryCall<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_SchemaResult> {
    return self.makeAsyncUnaryCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getSchema.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeGetSchemaInterceptors() ?? []
    )
  }

  internal func makeDoGetCall(
    _ request: Arrow_Flight_Protocol_Ticket,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Ticket, Arrow_Flight_Protocol_FlightData> {
    return self.makeAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doGet.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoGetInterceptors() ?? []
    )
  }

  internal func makeDoPutCall(
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncBidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_PutResult> {
    return self.makeAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doPut.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoPutInterceptors() ?? []
    )
  }

  internal func makeDoExchangeCall(
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncBidirectionalStreamingCall<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_FlightData> {
    return self.makeAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doExchange.path,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoExchangeInterceptors() ?? []
    )
  }

  internal func makeDoActionCall(
    _ request: Arrow_Flight_Protocol_Action,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Action, Arrow_Flight_Protocol_Result> {
    return self.makeAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doAction.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoActionInterceptors() ?? []
    )
  }

  internal func makeListActionsCall(
    _ request: Arrow_Flight_Protocol_Empty,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncServerStreamingCall<Arrow_Flight_Protocol_Empty, Arrow_Flight_Protocol_ActionType> {
    return self.makeAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listActions.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeListActionsInterceptors() ?? []
    )
  }
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension Arrow_Flight_Protocol_FlightServiceAsyncClientProtocol {
  internal func handshake<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_HandshakeResponse> where RequestStream: Sequence, RequestStream.Element == Arrow_Flight_Protocol_HandshakeRequest {
    return self.performAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.handshake.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeHandshakeInterceptors() ?? []
    )
  }

  internal func handshake<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_HandshakeResponse> where RequestStream: AsyncSequence & Sendable, RequestStream.Element == Arrow_Flight_Protocol_HandshakeRequest {
    return self.performAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.handshake.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeHandshakeInterceptors() ?? []
    )
  }

  internal func listFlights(
    _ request: Arrow_Flight_Protocol_Criteria,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_FlightInfo> {
    return self.performAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listFlights.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeListFlightsInterceptors() ?? []
    )
  }

  internal func getFlightInfo(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions? = nil
  ) async throws -> Arrow_Flight_Protocol_FlightInfo {
    return try await self.performAsyncUnaryCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getFlightInfo.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeGetFlightInfoInterceptors() ?? []
    )
  }

  internal func getSchema(
    _ request: Arrow_Flight_Protocol_FlightDescriptor,
    callOptions: CallOptions? = nil
  ) async throws -> Arrow_Flight_Protocol_SchemaResult {
    return try await self.performAsyncUnaryCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getSchema.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeGetSchemaInterceptors() ?? []
    )
  }

  internal func doGet(
    _ request: Arrow_Flight_Protocol_Ticket,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_FlightData> {
    return self.performAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doGet.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoGetInterceptors() ?? []
    )
  }

  internal func doPut<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_PutResult> where RequestStream: Sequence, RequestStream.Element == Arrow_Flight_Protocol_FlightData {
    return self.performAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doPut.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoPutInterceptors() ?? []
    )
  }

  internal func doPut<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_PutResult> where RequestStream: AsyncSequence & Sendable, RequestStream.Element == Arrow_Flight_Protocol_FlightData {
    return self.performAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doPut.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoPutInterceptors() ?? []
    )
  }

  internal func doExchange<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_FlightData> where RequestStream: Sequence, RequestStream.Element == Arrow_Flight_Protocol_FlightData {
    return self.performAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doExchange.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoExchangeInterceptors() ?? []
    )
  }

  internal func doExchange<RequestStream>(
    _ requests: RequestStream,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_FlightData> where RequestStream: AsyncSequence & Sendable, RequestStream.Element == Arrow_Flight_Protocol_FlightData {
    return self.performAsyncBidirectionalStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doExchange.path,
      requests: requests,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoExchangeInterceptors() ?? []
    )
  }

  internal func doAction(
    _ request: Arrow_Flight_Protocol_Action,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_Result> {
    return self.performAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doAction.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeDoActionInterceptors() ?? []
    )
  }

  internal func listActions(
    _ request: Arrow_Flight_Protocol_Empty,
    callOptions: CallOptions? = nil
  ) -> GRPCAsyncResponseStream<Arrow_Flight_Protocol_ActionType> {
    return self.performAsyncServerStreamingCall(
      path: Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listActions.path,
      request: request,
      callOptions: callOptions ?? self.defaultCallOptions,
      interceptors: self.interceptors?.makeListActionsInterceptors() ?? []
    )
  }
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
internal struct Arrow_Flight_Protocol_FlightServiceAsyncClient: Arrow_Flight_Protocol_FlightServiceAsyncClientProtocol {
  internal var channel: GRPCChannel
  internal var defaultCallOptions: CallOptions
  internal var interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol?

  internal init(
    channel: GRPCChannel,
    defaultCallOptions: CallOptions = CallOptions(),
    interceptors: Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol? = nil
  ) {
    self.channel = channel
    self.defaultCallOptions = defaultCallOptions
    self.interceptors = interceptors
  }
}

internal protocol Arrow_Flight_Protocol_FlightServiceClientInterceptorFactoryProtocol: Sendable {

  /// - Returns: Interceptors to use when invoking 'handshake'.
  func makeHandshakeInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_HandshakeRequest, Arrow_Flight_Protocol_HandshakeResponse>]

  /// - Returns: Interceptors to use when invoking 'listFlights'.
  func makeListFlightsInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_Criteria, Arrow_Flight_Protocol_FlightInfo>]

  /// - Returns: Interceptors to use when invoking 'getFlightInfo'.
  func makeGetFlightInfoInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_FlightInfo>]

  /// - Returns: Interceptors to use when invoking 'getSchema'.
  func makeGetSchemaInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_SchemaResult>]

  /// - Returns: Interceptors to use when invoking 'doGet'.
  func makeDoGetInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_Ticket, Arrow_Flight_Protocol_FlightData>]

  /// - Returns: Interceptors to use when invoking 'doPut'.
  func makeDoPutInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_PutResult>]

  /// - Returns: Interceptors to use when invoking 'doExchange'.
  func makeDoExchangeInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_FlightData>]

  /// - Returns: Interceptors to use when invoking 'doAction'.
  func makeDoActionInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_Action, Arrow_Flight_Protocol_Result>]

  /// - Returns: Interceptors to use when invoking 'listActions'.
  func makeListActionsInterceptors() -> [ClientInterceptor<Arrow_Flight_Protocol_Empty, Arrow_Flight_Protocol_ActionType>]
}

internal enum Arrow_Flight_Protocol_FlightServiceClientMetadata {
  internal static let serviceDescriptor = GRPCServiceDescriptor(
    name: "FlightService",
    fullName: "arrow.flight.protocol.FlightService",
    methods: [
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.handshake,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listFlights,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getFlightInfo,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.getSchema,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doGet,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doPut,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doExchange,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.doAction,
      Arrow_Flight_Protocol_FlightServiceClientMetadata.Methods.listActions,
    ]
  )

  internal enum Methods {
    internal static let handshake = GRPCMethodDescriptor(
      name: "Handshake",
      path: "/arrow.flight.protocol.FlightService/Handshake",
      type: GRPCCallType.bidirectionalStreaming
    )

    internal static let listFlights = GRPCMethodDescriptor(
      name: "ListFlights",
      path: "/arrow.flight.protocol.FlightService/ListFlights",
      type: GRPCCallType.serverStreaming
    )

    internal static let getFlightInfo = GRPCMethodDescriptor(
      name: "GetFlightInfo",
      path: "/arrow.flight.protocol.FlightService/GetFlightInfo",
      type: GRPCCallType.unary
    )

    internal static let getSchema = GRPCMethodDescriptor(
      name: "GetSchema",
      path: "/arrow.flight.protocol.FlightService/GetSchema",
      type: GRPCCallType.unary
    )

    internal static let doGet = GRPCMethodDescriptor(
      name: "DoGet",
      path: "/arrow.flight.protocol.FlightService/DoGet",
      type: GRPCCallType.serverStreaming
    )

    internal static let doPut = GRPCMethodDescriptor(
      name: "DoPut",
      path: "/arrow.flight.protocol.FlightService/DoPut",
      type: GRPCCallType.bidirectionalStreaming
    )

    internal static let doExchange = GRPCMethodDescriptor(
      name: "DoExchange",
      path: "/arrow.flight.protocol.FlightService/DoExchange",
      type: GRPCCallType.bidirectionalStreaming
    )

    internal static let doAction = GRPCMethodDescriptor(
      name: "DoAction",
      path: "/arrow.flight.protocol.FlightService/DoAction",
      type: GRPCCallType.serverStreaming
    )

    internal static let listActions = GRPCMethodDescriptor(
      name: "ListActions",
      path: "/arrow.flight.protocol.FlightService/ListActions",
      type: GRPCCallType.serverStreaming
    )
  }
}

///
/// A flight service is an endpoint for retrieving or storing Arrow data. A
/// flight service can expose one or more predefined endpoints that can be
/// accessed using the Arrow Flight Protocol. Additionally, a flight service
/// can expose a set of actions that are available.
///
/// To build a server, implement a class that conforms to this protocol.
internal protocol Arrow_Flight_Protocol_FlightServiceProvider: CallHandlerProvider {
  var interceptors: Arrow_Flight_Protocol_FlightServiceServerInterceptorFactoryProtocol? { get }

  ///
  /// Handshake between client and server. Depending on the server, the
  /// handshake may be required to determine the token that should be used for
  /// future operations. Both request and response are streams to allow multiple
  /// round-trips depending on auth mechanism.
  func handshake(context: StreamingResponseCallContext<Arrow_Flight_Protocol_HandshakeResponse>) -> EventLoopFuture<(StreamEvent<Arrow_Flight_Protocol_HandshakeRequest>) -> Void>

  ///
  /// Get a list of available streams given a particular criteria. Most flight
  /// services will expose one or more streams that are readily available for
  /// retrieval. This api allows listing the streams available for
  /// consumption. A user can also provide a criteria. The criteria can limit
  /// the subset of streams that can be listed via this interface. Each flight
  /// service allows its own definition of how to consume criteria.
  func listFlights(request: Arrow_Flight_Protocol_Criteria, context: StreamingResponseCallContext<Arrow_Flight_Protocol_FlightInfo>) -> EventLoopFuture<GRPCStatus>

  ///
  /// For a given FlightDescriptor, get information about how the flight can be
  /// consumed. This is a useful interface if the consumer of the interface
  /// already can identify the specific flight to consume. This interface can
  /// also allow a consumer to generate a flight stream through a specified
  /// descriptor. For example, a flight descriptor might be something that
  /// includes a SQL statement or a Pickled Python operation that will be
  /// executed. In those cases, the descriptor will not be previously available
  /// within the list of available streams provided by ListFlights but will be
  /// available for consumption for the duration defined by the specific flight
  /// service.
  func getFlightInfo(request: Arrow_Flight_Protocol_FlightDescriptor, context: StatusOnlyCallContext) -> EventLoopFuture<Arrow_Flight_Protocol_FlightInfo>

  ///
  /// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
  /// This is used when a consumer needs the Schema of flight stream. Similar to
  /// GetFlightInfo this interface may generate a new flight that was not previously
  /// available in ListFlights.
  func getSchema(request: Arrow_Flight_Protocol_FlightDescriptor, context: StatusOnlyCallContext) -> EventLoopFuture<Arrow_Flight_Protocol_SchemaResult>

  ///
  /// Retrieve a single stream associated with a particular descriptor
  /// associated with the referenced ticket. A Flight can be composed of one or
  /// more streams where each stream can be retrieved using a separate opaque
  /// ticket that the flight service uses for managing a collection of streams.
  func doGet(request: Arrow_Flight_Protocol_Ticket, context: StreamingResponseCallContext<Arrow_Flight_Protocol_FlightData>) -> EventLoopFuture<GRPCStatus>

  ///
  /// Push a stream to the flight service associated with a particular
  /// flight stream. This allows a client of a flight service to upload a stream
  /// of data. Depending on the particular flight service, a client consumer
  /// could be allowed to upload a single stream per descriptor or an unlimited
  /// number. In the latter, the service might implement a 'seal' action that
  /// can be applied to a descriptor once all streams are uploaded.
  func doPut(context: StreamingResponseCallContext<Arrow_Flight_Protocol_PutResult>) -> EventLoopFuture<(StreamEvent<Arrow_Flight_Protocol_FlightData>) -> Void>

  ///
  /// Open a bidirectional data channel for a given descriptor. This
  /// allows clients to send and receive arbitrary Arrow data and
  /// application-specific metadata in a single logical stream. In
  /// contrast to DoGet/DoPut, this is more suited for clients
  /// offloading computation (rather than storage) to a Flight service.
  func doExchange(context: StreamingResponseCallContext<Arrow_Flight_Protocol_FlightData>) -> EventLoopFuture<(StreamEvent<Arrow_Flight_Protocol_FlightData>) -> Void>

  ///
  /// Flight services can support an arbitrary number of simple actions in
  /// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
  /// operations that are potentially available. DoAction allows a flight client
  /// to do a specific action against a flight service. An action includes
  /// opaque request and response objects that are specific to the type action
  /// being undertaken.
  func doAction(request: Arrow_Flight_Protocol_Action, context: StreamingResponseCallContext<Arrow_Flight_Protocol_Result>) -> EventLoopFuture<GRPCStatus>

  ///
  /// A flight service exposes all of the available action types that it has
  /// along with descriptions. This allows different flight consumers to
  /// understand the capabilities of the flight service.
  func listActions(request: Arrow_Flight_Protocol_Empty, context: StreamingResponseCallContext<Arrow_Flight_Protocol_ActionType>) -> EventLoopFuture<GRPCStatus>
}

extension Arrow_Flight_Protocol_FlightServiceProvider {
  internal var serviceName: Substring {
    return Arrow_Flight_Protocol_FlightServiceServerMetadata.serviceDescriptor.fullName[...]
  }

  /// Determines, calls and returns the appropriate request handler, depending on the request's method.
  /// Returns nil for methods not handled by this service.
  internal func handle(
    method name: Substring,
    context: CallHandlerContext
  ) -> GRPCServerHandlerProtocol? {
    switch name {
    case "Handshake":
      return BidirectionalStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_HandshakeRequest>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_HandshakeResponse>(),
        interceptors: self.interceptors?.makeHandshakeInterceptors() ?? [],
        observerFactory: self.handshake(context:)
      )

    case "ListFlights":
      return ServerStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Criteria>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightInfo>(),
        interceptors: self.interceptors?.makeListFlightsInterceptors() ?? [],
        userFunction: self.listFlights(request:context:)
      )

    case "GetFlightInfo":
      return UnaryServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightDescriptor>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightInfo>(),
        interceptors: self.interceptors?.makeGetFlightInfoInterceptors() ?? [],
        userFunction: self.getFlightInfo(request:context:)
      )

    case "GetSchema":
      return UnaryServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightDescriptor>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_SchemaResult>(),
        interceptors: self.interceptors?.makeGetSchemaInterceptors() ?? [],
        userFunction: self.getSchema(request:context:)
      )

    case "DoGet":
      return ServerStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Ticket>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightData>(),
        interceptors: self.interceptors?.makeDoGetInterceptors() ?? [],
        userFunction: self.doGet(request:context:)
      )

    case "DoPut":
      return BidirectionalStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightData>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_PutResult>(),
        interceptors: self.interceptors?.makeDoPutInterceptors() ?? [],
        observerFactory: self.doPut(context:)
      )

    case "DoExchange":
      return BidirectionalStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightData>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightData>(),
        interceptors: self.interceptors?.makeDoExchangeInterceptors() ?? [],
        observerFactory: self.doExchange(context:)
      )

    case "DoAction":
      return ServerStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Action>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_Result>(),
        interceptors: self.interceptors?.makeDoActionInterceptors() ?? [],
        userFunction: self.doAction(request:context:)
      )

    case "ListActions":
      return ServerStreamingServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Empty>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_ActionType>(),
        interceptors: self.interceptors?.makeListActionsInterceptors() ?? [],
        userFunction: self.listActions(request:context:)
      )

    default:
      return nil
    }
  }
}

///
/// A flight service is an endpoint for retrieving or storing Arrow data. A
/// flight service can expose one or more predefined endpoints that can be
/// accessed using the Arrow Flight Protocol. Additionally, a flight service
/// can expose a set of actions that are available.
///
/// To implement a server, implement an object which conforms to this protocol.
@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
internal protocol Arrow_Flight_Protocol_FlightServiceAsyncProvider: CallHandlerProvider, Sendable {
  static var serviceDescriptor: GRPCServiceDescriptor { get }
  var interceptors: Arrow_Flight_Protocol_FlightServiceServerInterceptorFactoryProtocol? { get }

  ///
  /// Handshake between client and server. Depending on the server, the
  /// handshake may be required to determine the token that should be used for
  /// future operations. Both request and response are streams to allow multiple
  /// round-trips depending on auth mechanism.
  func handshake(
    requestStream: GRPCAsyncRequestStream<Arrow_Flight_Protocol_HandshakeRequest>,
    responseStream: GRPCAsyncResponseStreamWriter<Arrow_Flight_Protocol_HandshakeResponse>,
    context: GRPCAsyncServerCallContext
  ) async throws

  ///
  /// Get a list of available streams given a particular criteria. Most flight
  /// services will expose one or more streams that are readily available for
  /// retrieval. This api allows listing the streams available for
  /// consumption. A user can also provide a criteria. The criteria can limit
  /// the subset of streams that can be listed via this interface. Each flight
  /// service allows its own definition of how to consume criteria.
  func listFlights(
    request: Arrow_Flight_Protocol_Criteria,
    responseStream: GRPCAsyncResponseStreamWriter<Arrow_Flight_Protocol_FlightInfo>,
    context: GRPCAsyncServerCallContext
  ) async throws

  ///
  /// For a given FlightDescriptor, get information about how the flight can be
  /// consumed. This is a useful interface if the consumer of the interface
  /// already can identify the specific flight to consume. This interface can
  /// also allow a consumer to generate a flight stream through a specified
  /// descriptor. For example, a flight descriptor might be something that
  /// includes a SQL statement or a Pickled Python operation that will be
  /// executed. In those cases, the descriptor will not be previously available
  /// within the list of available streams provided by ListFlights but will be
  /// available for consumption for the duration defined by the specific flight
  /// service.
  func getFlightInfo(
    request: Arrow_Flight_Protocol_FlightDescriptor,
    context: GRPCAsyncServerCallContext
  ) async throws -> Arrow_Flight_Protocol_FlightInfo

  ///
  /// For a given FlightDescriptor, get the Schema as described in Schema.fbs::Schema
  /// This is used when a consumer needs the Schema of flight stream. Similar to
  /// GetFlightInfo this interface may generate a new flight that was not previously
  /// available in ListFlights.
  func getSchema(
    request: Arrow_Flight_Protocol_FlightDescriptor,
    context: GRPCAsyncServerCallContext
  ) async throws -> Arrow_Flight_Protocol_SchemaResult

  ///
  /// Retrieve a single stream associated with a particular descriptor
  /// associated with the referenced ticket. A Flight can be composed of one or
  /// more streams where each stream can be retrieved using a separate opaque
  /// ticket that the flight service uses for managing a collection of streams.
  func doGet(
    request: Arrow_Flight_Protocol_Ticket,
    responseStream: GRPCAsyncResponseStreamWriter<Arrow_Flight_Protocol_FlightData>,
    context: GRPCAsyncServerCallContext
  ) async throws

  ///
  /// Push a stream to the flight service associated with a particular
  /// flight stream. This allows a client of a flight service to upload a stream
  /// of data. Depending on the particular flight service, a client consumer
  /// could be allowed to upload a single stream per descriptor or an unlimited
  /// number. In the latter, the service might implement a 'seal' action that
  /// can be applied to a descriptor once all streams are uploaded.
  func doPut(
    requestStream: GRPCAsyncRequestStream<Arrow_Flight_Protocol_FlightData>,
    responseStream: GRPCAsyncResponseStreamWriter<Arrow_Flight_Protocol_PutResult>,
    context: GRPCAsyncServerCallContext
  ) async throws

  ///
  /// Open a bidirectional data channel for a given descriptor. This
  /// allows clients to send and receive arbitrary Arrow data and
  /// application-specific metadata in a single logical stream. In
  /// contrast to DoGet/DoPut, this is more suited for clients
  /// offloading computation (rather than storage) to a Flight service.
  func doExchange(
    requestStream: GRPCAsyncRequestStream<Arrow_Flight_Protocol_FlightData>,
    responseStream: GRPCAsyncResponseStreamWriter<Arrow_Flight_Protocol_FlightData>,
    context: GRPCAsyncServerCallContext
  ) async throws

  ///
  /// Flight services can support an arbitrary number of simple actions in
  /// addition to the possible ListFlights, GetFlightInfo, DoGet, DoPut
  /// operations that are potentially available. DoAction allows a flight client
  /// to do a specific action against a flight service. An action includes
  /// opaque request and response objects that are specific to the type action
  /// being undertaken.
  func doAction(
    request: Arrow_Flight_Protocol_Action,
    responseStream: GRPCAsyncResponseStreamWriter<Arrow_Flight_Protocol_Result>,
    context: GRPCAsyncServerCallContext
  ) async throws

  ///
  /// A flight service exposes all of the available action types that it has
  /// along with descriptions. This allows different flight consumers to
  /// understand the capabilities of the flight service.
  func listActions(
    request: Arrow_Flight_Protocol_Empty,
    responseStream: GRPCAsyncResponseStreamWriter<Arrow_Flight_Protocol_ActionType>,
    context: GRPCAsyncServerCallContext
  ) async throws
}

@available(macOS 10.15, iOS 13, tvOS 13, watchOS 6, *)
extension Arrow_Flight_Protocol_FlightServiceAsyncProvider {
  internal static var serviceDescriptor: GRPCServiceDescriptor {
    return Arrow_Flight_Protocol_FlightServiceServerMetadata.serviceDescriptor
  }

  internal var serviceName: Substring {
    return Arrow_Flight_Protocol_FlightServiceServerMetadata.serviceDescriptor.fullName[...]
  }

  internal var interceptors: Arrow_Flight_Protocol_FlightServiceServerInterceptorFactoryProtocol? {
    return nil
  }

  internal func handle(
    method name: Substring,
    context: CallHandlerContext
  ) -> GRPCServerHandlerProtocol? {
    switch name {
    case "Handshake":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_HandshakeRequest>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_HandshakeResponse>(),
        interceptors: self.interceptors?.makeHandshakeInterceptors() ?? [],
        wrapping: { try await self.handshake(requestStream: $0, responseStream: $1, context: $2) }
      )

    case "ListFlights":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Criteria>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightInfo>(),
        interceptors: self.interceptors?.makeListFlightsInterceptors() ?? [],
        wrapping: { try await self.listFlights(request: $0, responseStream: $1, context: $2) }
      )

    case "GetFlightInfo":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightDescriptor>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightInfo>(),
        interceptors: self.interceptors?.makeGetFlightInfoInterceptors() ?? [],
        wrapping: { try await self.getFlightInfo(request: $0, context: $1) }
      )

    case "GetSchema":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightDescriptor>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_SchemaResult>(),
        interceptors: self.interceptors?.makeGetSchemaInterceptors() ?? [],
        wrapping: { try await self.getSchema(request: $0, context: $1) }
      )

    case "DoGet":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Ticket>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightData>(),
        interceptors: self.interceptors?.makeDoGetInterceptors() ?? [],
        wrapping: { try await self.doGet(request: $0, responseStream: $1, context: $2) }
      )

    case "DoPut":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightData>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_PutResult>(),
        interceptors: self.interceptors?.makeDoPutInterceptors() ?? [],
        wrapping: { try await self.doPut(requestStream: $0, responseStream: $1, context: $2) }
      )

    case "DoExchange":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_FlightData>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_FlightData>(),
        interceptors: self.interceptors?.makeDoExchangeInterceptors() ?? [],
        wrapping: { try await self.doExchange(requestStream: $0, responseStream: $1, context: $2) }
      )

    case "DoAction":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Action>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_Result>(),
        interceptors: self.interceptors?.makeDoActionInterceptors() ?? [],
        wrapping: { try await self.doAction(request: $0, responseStream: $1, context: $2) }
      )

    case "ListActions":
      return GRPCAsyncServerHandler(
        context: context,
        requestDeserializer: ProtobufDeserializer<Arrow_Flight_Protocol_Empty>(),
        responseSerializer: ProtobufSerializer<Arrow_Flight_Protocol_ActionType>(),
        interceptors: self.interceptors?.makeListActionsInterceptors() ?? [],
        wrapping: { try await self.listActions(request: $0, responseStream: $1, context: $2) }
      )

    default:
      return nil
    }
  }
}

internal protocol Arrow_Flight_Protocol_FlightServiceServerInterceptorFactoryProtocol: Sendable {

  /// - Returns: Interceptors to use when handling 'handshake'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeHandshakeInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_HandshakeRequest, Arrow_Flight_Protocol_HandshakeResponse>]

  /// - Returns: Interceptors to use when handling 'listFlights'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeListFlightsInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_Criteria, Arrow_Flight_Protocol_FlightInfo>]

  /// - Returns: Interceptors to use when handling 'getFlightInfo'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeGetFlightInfoInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_FlightInfo>]

  /// - Returns: Interceptors to use when handling 'getSchema'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeGetSchemaInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_FlightDescriptor, Arrow_Flight_Protocol_SchemaResult>]

  /// - Returns: Interceptors to use when handling 'doGet'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeDoGetInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_Ticket, Arrow_Flight_Protocol_FlightData>]

  /// - Returns: Interceptors to use when handling 'doPut'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeDoPutInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_PutResult>]

  /// - Returns: Interceptors to use when handling 'doExchange'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeDoExchangeInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_FlightData, Arrow_Flight_Protocol_FlightData>]

  /// - Returns: Interceptors to use when handling 'doAction'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeDoActionInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_Action, Arrow_Flight_Protocol_Result>]

  /// - Returns: Interceptors to use when handling 'listActions'.
  ///   Defaults to calling `self.makeInterceptors()`.
  func makeListActionsInterceptors() -> [ServerInterceptor<Arrow_Flight_Protocol_Empty, Arrow_Flight_Protocol_ActionType>]
}

internal enum Arrow_Flight_Protocol_FlightServiceServerMetadata {
  internal static let serviceDescriptor = GRPCServiceDescriptor(
    name: "FlightService",
    fullName: "arrow.flight.protocol.FlightService",
    methods: [
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.handshake,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.listFlights,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.getFlightInfo,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.getSchema,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.doGet,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.doPut,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.doExchange,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.doAction,
      Arrow_Flight_Protocol_FlightServiceServerMetadata.Methods.listActions,
    ]
  )

  internal enum Methods {
    internal static let handshake = GRPCMethodDescriptor(
      name: "Handshake",
      path: "/arrow.flight.protocol.FlightService/Handshake",
      type: GRPCCallType.bidirectionalStreaming
    )

    internal static let listFlights = GRPCMethodDescriptor(
      name: "ListFlights",
      path: "/arrow.flight.protocol.FlightService/ListFlights",
      type: GRPCCallType.serverStreaming
    )

    internal static let getFlightInfo = GRPCMethodDescriptor(
      name: "GetFlightInfo",
      path: "/arrow.flight.protocol.FlightService/GetFlightInfo",
      type: GRPCCallType.unary
    )

    internal static let getSchema = GRPCMethodDescriptor(
      name: "GetSchema",
      path: "/arrow.flight.protocol.FlightService/GetSchema",
      type: GRPCCallType.unary
    )

    internal static let doGet = GRPCMethodDescriptor(
      name: "DoGet",
      path: "/arrow.flight.protocol.FlightService/DoGet",
      type: GRPCCallType.serverStreaming
    )

    internal static let doPut = GRPCMethodDescriptor(
      name: "DoPut",
      path: "/arrow.flight.protocol.FlightService/DoPut",
      type: GRPCCallType.bidirectionalStreaming
    )

    internal static let doExchange = GRPCMethodDescriptor(
      name: "DoExchange",
      path: "/arrow.flight.protocol.FlightService/DoExchange",
      type: GRPCCallType.bidirectionalStreaming
    )

    internal static let doAction = GRPCMethodDescriptor(
      name: "DoAction",
      path: "/arrow.flight.protocol.FlightService/DoAction",
      type: GRPCCallType.serverStreaming
    )

    internal static let listActions = GRPCMethodDescriptor(
      name: "ListActions",
      path: "/arrow.flight.protocol.FlightService/ListActions",
      type: GRPCCallType.serverStreaming
    )
  }
}
