# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": "ld.bfd",
                "version": "13.2.0",
                "commands": "gcc",
                "args": "-march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -D__USE_MINGW_ANSI_STDIO=1",
                "linker args": "-pipe, -march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -D__USE_MINGW_ANSI_STDIO=1",
            },
            "cython": {
                "name": "cython",
                "linker": "cython",
                "version": "3.0.8",
                "commands": "cython",
                "args": "",
                "linker args": "",
            },
            "c++": {
                "name": "gcc",
                "linker": "ld.bfd",
                "version": "13.2.0",
                "commands": "g++",
                "args": "-march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -D__USE_MINGW_ANSI_STDIO=1",
                "linker args": "-pipe, -march=nocona, -msahf, -mtune=generic, -O2, -pipe, -Wp,-D_FORTIFY_SOURCE=2, -fstack-protector-strong, -D__USE_MINGW_ANSI_STDIO=1",
            },
            "fortran": {
                "name": "gcc",
                "linker": "ld.bfd",
                "version": "13.2.0",
                "commands": "gfortran",
                "args": "",
                "linker args": "-pipe",
            },
            "pythran": {
                "version": "0.15.0",
                "include directory": r"D:/a/msys64/mingw64/lib/python3.11/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "windows",
            },
            "build": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "windows",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.26",
                "detection method": "pkgconfig",
                "include directory": r"D:/a/msys64/mingw64/include/openblas",
                "lib directory": r"D:/a/msys64/mingw64/lib",
                "openblas configuration": "USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=ON DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP=ON CORE2 MAX_THREADS=64",
                "pc file directory": r"D:/a/msys64/mingw64/lib/pkgconfig",
            },
            "lapack": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.26",
                "detection method": "pkgconfig",
                "include directory": r"D:/a/msys64/mingw64/include/openblas",
                "lib directory": r"D:/a/msys64/mingw64/lib",
                "openblas configuration": "USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=ON DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP=ON CORE2 MAX_THREADS=64",
                "pc file directory": r"D:/a/msys64/mingw64/lib/pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.11.1",
                "detection method": "pkgconfig",
                "include directory": r"D:/a/msys64/mingw64/include",
            },
        },
        "Python Information": {
            "path": r"D:/a/msys64/mingw64/bin/python.exe",
            "version": "3.11",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
