// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_UI_Input_Inking_Analysis_H
#define WINRT_Windows_UI_Input_Inking_Analysis_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.UI.Input.Inking.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.UI.Input.Inking.2.h"
#include "winrt/impl/Windows.UI.Input.Inking.Analysis.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisInkBullet<D>::RecognizedText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkBullet>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkBullet, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkBullet>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkBullet>**)this;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisInkDrawing<D>::DrawingKind() const
    {
        winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisDrawingKind value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DrawingKind(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>**)this;
            check_hresult(_winrt_abi_type->get_DrawingKind(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisInkDrawing<D>::Center() const
    {
        winrt::Windows::Foundation::Point value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Center(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>**)this;
            check_hresult(_winrt_abi_type->get_Center(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisInkDrawing<D>::Points() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Points(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>**)this;
            check_hresult(_winrt_abi_type->get_Points(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Foundation::Point>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisInkWord<D>::RecognizedText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord>**)this;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisInkWord<D>::TextAlternates() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TextAlternates(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord>**)this;
            check_hresult(_winrt_abi_type->get_TextAlternates(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisLine<D>::RecognizedText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine>**)this;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisLine<D>::IndentLevel() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IndentLevel(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine>**)this;
            check_hresult(_winrt_abi_type->get_IndentLevel(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisListItem<D>::RecognizedText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisListItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisListItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisListItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisListItem>**)this;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode<D>::Id() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode<D>::Kind() const
    {
        winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisNodeKind value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)this;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode<D>::BoundingRect() const
    {
        winrt::Windows::Foundation::Rect value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_BoundingRect(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)this;
            check_hresult(_winrt_abi_type->get_BoundingRect(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode<D>::RotatedBoundingRect() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RotatedBoundingRect(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)this;
            check_hresult(_winrt_abi_type->get_RotatedBoundingRect(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Foundation::Point>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode<D>::Children() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Children(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)this;
            check_hresult(_winrt_abi_type->get_Children(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode<D>::Parent() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)this;
            check_hresult(_winrt_abi_type->get_Parent(&value));
        }
        return winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisNode<D>::GetStrokeIds() const
    {
        void* strokeIds{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStrokeIds(&strokeIds));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>**)this;
            check_hresult(_winrt_abi_type->GetStrokeIds(&strokeIds));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<uint32_t>{ strokeIds, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisParagraph<D>::RecognizedText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisParagraph>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisParagraph, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisParagraph>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisParagraph>**)this;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisResult<D>::Status() const
    {
        winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisResult>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisRoot<D>::RecognizedText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot>**)this;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisRoot<D>::FindNodes(winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisNodeKind const& nodeKind) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FindNodes(static_cast<int32_t>(nodeKind), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot>**)this;
            check_hresult(_winrt_abi_type->FindNodes(static_cast<int32_t>(nodeKind), &result));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalysisWritingRegion<D>::RecognizedText() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisWritingRegion>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisWritingRegion, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisWritingRegion>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisWritingRegion>**)this;
            check_hresult(_winrt_abi_type->get_RecognizedText(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::AnalysisRoot() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AnalysisRoot(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->get_AnalysisRoot(&value));
        }
        return winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisRoot{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::IsAnalyzing() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAnalyzing(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->get_IsAnalyzing(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::AddDataForStroke(winrt::Windows::UI::Input::Inking::InkStroke const& stroke) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AddDataForStroke(*(void**)(&stroke)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->AddDataForStroke(*(void**)(&stroke)));
        }
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::AddDataForStrokes(param::iterable<winrt::Windows::UI::Input::Inking::InkStroke> const& strokes) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AddDataForStrokes(*(void**)(&strokes)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->AddDataForStrokes(*(void**)(&strokes)));
        }
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::ClearDataForAllStrokes() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ClearDataForAllStrokes());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->ClearDataForAllStrokes());
        }
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::RemoveDataForStroke(uint32_t strokeId) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveDataForStroke(strokeId));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->RemoveDataForStroke(strokeId));
        }
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::RemoveDataForStrokes(param::iterable<uint32_t> const& strokeIds) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveDataForStrokes(*(void**)(&strokeIds)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->RemoveDataForStrokes(*(void**)(&strokeIds)));
        }
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::ReplaceDataForStroke(winrt::Windows::UI::Input::Inking::InkStroke const& stroke) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReplaceDataForStroke(*(void**)(&stroke)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->ReplaceDataForStroke(*(void**)(&stroke)));
        }
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::SetStrokeDataKind(uint32_t strokeId, winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisStrokeKind const& strokeKind) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetStrokeDataKind(strokeId, static_cast<int32_t>(strokeKind)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->SetStrokeDataKind(strokeId, static_cast<int32_t>(strokeKind)));
        }
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzer<D>::AnalyzeAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AnalyzeAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>**)this;
            check_hresult(_winrt_abi_type->AnalyzeAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisResult>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_UI_Input_Inking_Analysis_IInkAnalyzerFactory<D>::CreateAnalyzer() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzerFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzerFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzerFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateAnalyzer(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzerFactory>**)this;
            check_hresult(_winrt_abi_type->CreateAnalyzer(&result));
        }
        return winrt::Windows::UI::Input::Inking::Analysis::InkAnalyzer{ result, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkBullet> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkBullet>
    {
        int32_t __stdcall get_RecognizedText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RecognizedText());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing>
    {
        int32_t __stdcall get_DrawingKind(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisDrawingKind>(this->shim().DrawingKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Center(winrt::Windows::Foundation::Point* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Point>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Point>(this->shim().Center());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Points(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Foundation::Point>>(this->shim().Points());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord>
    {
        int32_t __stdcall get_RecognizedText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RecognizedText());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TextAlternates(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<hstring>>(this->shim().TextAlternates());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine>
    {
        int32_t __stdcall get_RecognizedText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RecognizedText());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IndentLevel(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().IndentLevel());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisListItem> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisListItem>
    {
        int32_t __stdcall get_RecognizedText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RecognizedText());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>
    {
        int32_t __stdcall get_Id(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Kind(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisNodeKind>(this->shim().Kind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_BoundingRect(winrt::Windows::Foundation::Rect* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Rect>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Rect>(this->shim().BoundingRect());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RotatedBoundingRect(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Foundation::Point>>(this->shim().RotatedBoundingRect());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Children(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>>(this->shim().Children());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Parent(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>(this->shim().Parent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetStrokeIds(void** strokeIds) noexcept final try
        {
            clear_abi(strokeIds);
            typename D::abi_guard guard(this->shim());
            *strokeIds = detach_from<winrt::Windows::Foundation::Collections::IVectorView<uint32_t>>(this->shim().GetStrokeIds());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisParagraph> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisParagraph>
    {
        int32_t __stdcall get_RecognizedText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RecognizedText());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisResult> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisResult>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot>
    {
        int32_t __stdcall get_RecognizedText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RecognizedText());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FindNodes(int32_t nodeKind, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode>>(this->shim().FindNodes(*reinterpret_cast<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisNodeKind const*>(&nodeKind)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisWritingRegion> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisWritingRegion>
    {
        int32_t __stdcall get_RecognizedText(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RecognizedText());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer>
    {
        int32_t __stdcall get_AnalysisRoot(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisRoot>(this->shim().AnalysisRoot());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsAnalyzing(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAnalyzing());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AddDataForStroke(void* stroke) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AddDataForStroke(*reinterpret_cast<winrt::Windows::UI::Input::Inking::InkStroke const*>(&stroke));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AddDataForStrokes(void* strokes) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AddDataForStrokes(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::UI::Input::Inking::InkStroke> const*>(&strokes));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ClearDataForAllStrokes() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ClearDataForAllStrokes();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveDataForStroke(uint32_t strokeId) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveDataForStroke(strokeId);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveDataForStrokes(void* strokeIds) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveDataForStrokes(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<uint32_t> const*>(&strokeIds));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReplaceDataForStroke(void* stroke) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReplaceDataForStroke(*reinterpret_cast<winrt::Windows::UI::Input::Inking::InkStroke const*>(&stroke));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetStrokeDataKind(uint32_t strokeId, int32_t strokeKind) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetStrokeDataKind(strokeId, *reinterpret_cast<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisStrokeKind const*>(&strokeKind));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AnalyzeAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisResult>>(this->shim().AnalyzeAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzerFactory> : produce_base<D, winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzerFactory>
    {
        int32_t __stdcall CreateAnalyzer(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::UI::Input::Inking::Analysis::InkAnalyzer>(this->shim().CreateAnalyzer());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
}
WINRT_EXPORT namespace winrt::Windows::UI::Input::Inking::Analysis
{
    inline InkAnalyzer::InkAnalyzer() :
        InkAnalyzer(impl::call_factory_cast<InkAnalyzer(*)(winrt::Windows::Foundation::IActivationFactory const&), InkAnalyzer>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<InkAnalyzer>(); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkBullet> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkDrawing> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisInkWord> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisLine> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisListItem> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisNode> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisParagraph> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisRoot> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalysisWritingRegion> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzer> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::IInkAnalyzerFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisInkBullet> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisInkDrawing> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisInkWord> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisLine> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisListItem> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisNode> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisParagraph> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisRoot> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalysisWritingRegion> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::UI::Input::Inking::Analysis::InkAnalyzer> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
