// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Perception_Spatial_Surfaces_H
#define WINRT_Windows_Perception_Spatial_Surfaces_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Perception.Spatial.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Foundation.Numerics.2.h"
#include "winrt/impl/Windows.Graphics.DirectX.2.h"
#include "winrt/impl/Windows.Perception.Spatial.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.Perception.Spatial.Surfaces.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceInfo<D>::Id() const
    {
        winrt::guid value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)this;
            check_hresult(_winrt_abi_type->get_Id(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceInfo<D>::UpdateTime() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UpdateTime(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)this;
            check_hresult(_winrt_abi_type->get_UpdateTime(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceInfo<D>::TryGetBounds(winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const& coordinateSystem) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetBounds(*(void**)(&coordinateSystem), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)this;
            check_hresult(_winrt_abi_type->TryGetBounds(*(void**)(&coordinateSystem), &value));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Perception::Spatial::SpatialBoundingOrientedBox>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceInfo<D>::TryComputeLatestMeshAsync(double maxTrianglesPerCubicMeter) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryComputeLatestMeshAsync(maxTrianglesPerCubicMeter, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)this;
            check_hresult(_winrt_abi_type->TryComputeLatestMeshAsync(maxTrianglesPerCubicMeter, &value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMesh>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceInfo<D>::TryComputeLatestMeshAsync(double maxTrianglesPerCubicMeter, winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshOptions const& options) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryComputeLatestMeshWithOptionsAsync(maxTrianglesPerCubicMeter, *(void**)(&options), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>**)this;
            check_hresult(_winrt_abi_type->TryComputeLatestMeshWithOptionsAsync(maxTrianglesPerCubicMeter, *(void**)(&options), &value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMesh>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMesh<D>::SurfaceInfo() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SurfaceInfo(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)this;
            check_hresult(_winrt_abi_type->get_SurfaceInfo(&value));
        }
        return winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceInfo{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMesh<D>::CoordinateSystem() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CoordinateSystem(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)this;
            check_hresult(_winrt_abi_type->get_CoordinateSystem(&value));
        }
        return winrt::Windows::Perception::Spatial::SpatialCoordinateSystem{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMesh<D>::TriangleIndices() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TriangleIndices(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)this;
            check_hresult(_winrt_abi_type->get_TriangleIndices(&value));
        }
        return winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMesh<D>::VertexPositions() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VertexPositions(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)this;
            check_hresult(_winrt_abi_type->get_VertexPositions(&value));
        }
        return winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMesh<D>::VertexPositionScale() const
    {
        winrt::Windows::Foundation::Numerics::float3 value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VertexPositionScale(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)this;
            check_hresult(_winrt_abi_type->get_VertexPositionScale(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMesh<D>::VertexNormals() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VertexNormals(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>**)this;
            check_hresult(_winrt_abi_type->get_VertexNormals(&value));
        }
        return winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshBuffer<D>::Format() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Format(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)this;
            check_hresult(_winrt_abi_type->get_Format(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshBuffer<D>::Stride() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Stride(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)this;
            check_hresult(_winrt_abi_type->get_Stride(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshBuffer<D>::ElementCount() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ElementCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)this;
            check_hresult(_winrt_abi_type->get_ElementCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshBuffer<D>::Data() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>**)this;
            check_hresult(_winrt_abi_type->get_Data(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::VertexPositionFormat() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VertexPositionFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->get_VertexPositionFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::VertexPositionFormat(winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VertexPositionFormat(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->put_VertexPositionFormat(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::TriangleIndexFormat() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TriangleIndexFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->get_TriangleIndexFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::TriangleIndexFormat(winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TriangleIndexFormat(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->put_TriangleIndexFormat(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::VertexNormalFormat() const
    {
        winrt::Windows::Graphics::DirectX::DirectXPixelFormat value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_VertexNormalFormat(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->get_VertexNormalFormat(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::VertexNormalFormat(winrt::Windows::Graphics::DirectX::DirectXPixelFormat const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_VertexNormalFormat(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->put_VertexNormalFormat(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::IncludeVertexNormals() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IncludeVertexNormals(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->get_IncludeVertexNormals(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptions<D>::IncludeVertexNormals(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IncludeVertexNormals(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>**)this;
            check_hresult(_winrt_abi_type->put_IncludeVertexNormals(value));
        }
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptionsStatics<D>::SupportedVertexPositionFormats() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedVertexPositionFormats(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>**)this;
            check_hresult(_winrt_abi_type->get_SupportedVertexPositionFormats(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptionsStatics<D>::SupportedTriangleIndexFormats() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedTriangleIndexFormats(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>**)this;
            check_hresult(_winrt_abi_type->get_SupportedTriangleIndexFormats(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceMeshOptionsStatics<D>::SupportedVertexNormalFormats() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedVertexNormalFormats(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>**)this;
            check_hresult(_winrt_abi_type->get_SupportedVertexNormalFormats(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserver<D>::GetObservedSurfaces() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetObservedSurfaces(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)this;
            check_hresult(_winrt_abi_type->GetObservedSurfaces(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<winrt::guid, winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceInfo>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserver<D>::SetBoundingVolume(winrt::Windows::Perception::Spatial::SpatialBoundingVolume const& bounds) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBoundingVolume(*(void**)(&bounds)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)this;
            check_hresult(_winrt_abi_type->SetBoundingVolume(*(void**)(&bounds)));
        }
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserver<D>::SetBoundingVolumes(param::iterable<winrt::Windows::Perception::Spatial::SpatialBoundingVolume> const& bounds) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetBoundingVolumes(*(void**)(&bounds)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)this;
            check_hresult(_winrt_abi_type->SetBoundingVolumes(*(void**)(&bounds)));
        }
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserver<D>::ObservedSurfacesChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceObserver, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ObservedSurfacesChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)this;
            check_hresult(_winrt_abi_type->add_ObservedSurfacesChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserver<D>::ObservedSurfacesChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceObserver, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, ObservedSurfacesChanged_revoker>(this, ObservedSurfacesChanged(handler));
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserver<D>::ObservedSurfacesChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ObservedSurfacesChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>**)this;
            _winrt_abi_type->remove_ObservedSurfacesChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserverStatics<D>::RequestAccessAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestAccessAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics>**)this;
            check_hresult(_winrt_abi_type->RequestAccessAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Perception::Spatial::SpatialPerceptionAccessStatus>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Perception_Spatial_Surfaces_ISpatialSurfaceObserverStatics2<D>::IsSupported() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsSupported(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics2>**)this;
            check_hresult(_winrt_abi_type->IsSupported(&value));
        }
        return value;
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo>
    {
        int32_t __stdcall get_Id(winrt::guid* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::guid>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UpdateTime(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().UpdateTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetBounds(void* coordinateSystem, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Perception::Spatial::SpatialBoundingOrientedBox>>(this->shim().TryGetBounds(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem const*>(&coordinateSystem)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryComputeLatestMeshAsync(double maxTrianglesPerCubicMeter, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMesh>>(this->shim().TryComputeLatestMeshAsync(maxTrianglesPerCubicMeter));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryComputeLatestMeshWithOptionsAsync(double maxTrianglesPerCubicMeter, void* options, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMesh>>(this->shim().TryComputeLatestMeshAsync(maxTrianglesPerCubicMeter, *reinterpret_cast<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshOptions const*>(&options)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh>
    {
        int32_t __stdcall get_SurfaceInfo(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceInfo>(this->shim().SurfaceInfo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_CoordinateSystem(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Perception::Spatial::SpatialCoordinateSystem>(this->shim().CoordinateSystem());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TriangleIndices(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshBuffer>(this->shim().TriangleIndices());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VertexPositions(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshBuffer>(this->shim().VertexPositions());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VertexPositionScale(winrt::Windows::Foundation::Numerics::float3* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::Numerics::float3>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Numerics::float3>(this->shim().VertexPositionScale());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VertexNormals(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshBuffer>(this->shim().VertexNormals());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer>
    {
        int32_t __stdcall get_Format(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().Format());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Stride(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().Stride());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ElementCount(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().ElementCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Data(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().Data());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions>
    {
        int32_t __stdcall get_VertexPositionFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().VertexPositionFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VertexPositionFormat(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VertexPositionFormat(*reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TriangleIndexFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().TriangleIndexFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TriangleIndexFormat(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TriangleIndexFormat(*reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_VertexNormalFormat(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(this->shim().VertexNormalFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_VertexNormalFormat(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().VertexNormalFormat(*reinterpret_cast<winrt::Windows::Graphics::DirectX::DirectXPixelFormat const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IncludeVertexNormals(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IncludeVertexNormals());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IncludeVertexNormals(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IncludeVertexNormals(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics>
    {
        int32_t __stdcall get_SupportedVertexPositionFormats(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>>(this->shim().SupportedVertexPositionFormats());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedTriangleIndexFormats(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>>(this->shim().SupportedTriangleIndexFormats());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedVertexNormalFormats(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>>(this->shim().SupportedVertexNormalFormats());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver>
    {
        int32_t __stdcall GetObservedSurfaces(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<winrt::guid, winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceInfo>>(this->shim().GetObservedSurfaces());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetBoundingVolume(void* bounds) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetBoundingVolume(*reinterpret_cast<winrt::Windows::Perception::Spatial::SpatialBoundingVolume const*>(&bounds));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetBoundingVolumes(void* bounds) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetBoundingVolumes(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<winrt::Windows::Perception::Spatial::SpatialBoundingVolume> const*>(&bounds));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ObservedSurfacesChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ObservedSurfacesChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceObserver, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ObservedSurfacesChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ObservedSurfacesChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics>
    {
        int32_t __stdcall RequestAccessAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Perception::Spatial::SpatialPerceptionAccessStatus>>(this->shim().RequestAccessAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics2> : produce_base<D, winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics2>
    {
        int32_t __stdcall IsSupported(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsSupported());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Perception::Spatial::Surfaces
{
    inline SpatialSurfaceMeshOptions::SpatialSurfaceMeshOptions() :
        SpatialSurfaceMeshOptions(impl::call_factory_cast<SpatialSurfaceMeshOptions(*)(winrt::Windows::Foundation::IActivationFactory const&), SpatialSurfaceMeshOptions>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<SpatialSurfaceMeshOptions>(); }))
    {
    }
    inline auto SpatialSurfaceMeshOptions::SupportedVertexPositionFormats()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(*)(ISpatialSurfaceMeshOptionsStatics const&), SpatialSurfaceMeshOptions, ISpatialSurfaceMeshOptionsStatics>([](ISpatialSurfaceMeshOptionsStatics const& f) { return f.SupportedVertexPositionFormats(); });
    }
    inline auto SpatialSurfaceMeshOptions::SupportedTriangleIndexFormats()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(*)(ISpatialSurfaceMeshOptionsStatics const&), SpatialSurfaceMeshOptions, ISpatialSurfaceMeshOptionsStatics>([](ISpatialSurfaceMeshOptionsStatics const& f) { return f.SupportedTriangleIndexFormats(); });
    }
    inline auto SpatialSurfaceMeshOptions::SupportedVertexNormalFormats()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Graphics::DirectX::DirectXPixelFormat>(*)(ISpatialSurfaceMeshOptionsStatics const&), SpatialSurfaceMeshOptions, ISpatialSurfaceMeshOptionsStatics>([](ISpatialSurfaceMeshOptionsStatics const& f) { return f.SupportedVertexNormalFormats(); });
    }
    inline SpatialSurfaceObserver::SpatialSurfaceObserver() :
        SpatialSurfaceObserver(impl::call_factory_cast<SpatialSurfaceObserver(*)(winrt::Windows::Foundation::IActivationFactory const&), SpatialSurfaceObserver>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<SpatialSurfaceObserver>(); }))
    {
    }
    inline auto SpatialSurfaceObserver::RequestAccessAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Perception::Spatial::SpatialPerceptionAccessStatus>(*)(ISpatialSurfaceObserverStatics const&), SpatialSurfaceObserver, ISpatialSurfaceObserverStatics>([](ISpatialSurfaceObserverStatics const& f) { return f.RequestAccessAsync(); });
    }
    inline auto SpatialSurfaceObserver::IsSupported()
    {
        return impl::call_factory_cast<bool(*)(ISpatialSurfaceObserverStatics2 const&), SpatialSurfaceObserver, ISpatialSurfaceObserverStatics2>([](ISpatialSurfaceObserverStatics2 const& f) { return f.IsSupported(); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMesh> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshBuffer> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceMeshOptionsStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserver> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::ISpatialSurfaceObserverStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMesh> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshBuffer> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceMeshOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Perception::Spatial::Surfaces::SpatialSurfaceObserver> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
