# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm and other development tools to provide
# more information, such as PEP 484 type hints, than it is able to glean from
# introspection of extension types and methods.  They are not intended to be
# imported, executed or used for any other purpose other than providing info
# to the tools. If you don't use use a tool that makes use of .pyi files then
# you can safely ignore this file.
#
# See: https://www.python.org/dev/peps/pep-0484/
#      https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2018 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------


"""
The classes in this module provide views and data models for viewing tabular
or hierarchical data in a more advanced way than what is provided by classes
such as :ref:`wx.ListCtrl`, :ref:`wx.TreeCtrl`, etc.
"""
#-- begin-_dataview --#

import wx
#-- end-_dataview --#
#-- begin-dataview --#
DVC_DEFAULT_RENDERER_SIZE = 0
DVC_DEFAULT_WIDTH = 0
DVC_TOGGLE_DEFAULT_WIDTH = 0
DVC_DEFAULT_MINWIDTH = 0
DVR_DEFAULT_ALIGNMENT = 0
DV_SINGLE = 0
DV_MULTIPLE = 0
DV_NO_HEADER = 0
DV_HORIZ_RULES = 0
DV_VERT_RULES = 0
DV_ROW_LINES = 0
DV_VARIABLE_LINE_HEIGHT = 0
DATAVIEW_CELL_INERT = 0
DATAVIEW_CELL_ACTIVATABLE = 0
DATAVIEW_CELL_EDITABLE = 0
DATAVIEW_CELL_SELECTED = 0
DATAVIEW_CELL_PRELIT = 0
DATAVIEW_CELL_INSENSITIVE = 0
DATAVIEW_CELL_FOCUSED = 0
DATAVIEW_COL_RESIZABLE = 0
DATAVIEW_COL_SORTABLE = 0
DATAVIEW_COL_REORDERABLE = 0
DATAVIEW_COL_HIDDEN = 0
wxEVT_DATAVIEW_SELECTION_CHANGED = 0
wxEVT_DATAVIEW_ITEM_ACTIVATED = 0
wxEVT_DATAVIEW_ITEM_COLLAPSING = 0
wxEVT_DATAVIEW_ITEM_COLLAPSED = 0
wxEVT_DATAVIEW_ITEM_EXPANDING = 0
wxEVT_DATAVIEW_ITEM_EXPANDED = 0
wxEVT_DATAVIEW_ITEM_START_EDITING = 0
wxEVT_DATAVIEW_ITEM_EDITING_STARTED = 0
wxEVT_DATAVIEW_ITEM_EDITING_DONE = 0
wxEVT_DATAVIEW_ITEM_VALUE_CHANGED = 0
wxEVT_DATAVIEW_ITEM_CONTEXT_MENU = 0
wxEVT_DATAVIEW_COLUMN_HEADER_CLICK = 0
wxEVT_DATAVIEW_COLUMN_HEADER_RIGHT_CLICK = 0
wxEVT_DATAVIEW_COLUMN_SORTED = 0
wxEVT_DATAVIEW_COLUMN_REORDERED = 0
wxEVT_DATAVIEW_CACHE_HINT = 0
wxEVT_DATAVIEW_ITEM_BEGIN_DRAG = 0
wxEVT_DATAVIEW_ITEM_DROP_POSSIBLE = 0
wxEVT_DATAVIEW_ITEM_DROP = 0

class DataViewItem(object):
    """
    DataViewItem()
    DataViewItem(item)
    DataViewItem(id)
    
    wxDataViewItem is a small opaque class that represents an item in a
    wxDataViewCtrl in a persistent way, i.e.
    """

    def __init__(self, *args, **kw):
        """
        DataViewItem()
        DataViewItem(item)
        DataViewItem(id)
        
        wxDataViewItem is a small opaque class that represents an item in a
        wxDataViewCtrl in a persistent way, i.e.
        """

    def GetID(self):
        """
        GetID() -> void
        
        Returns the ID.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the ID is not NULL.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def __bool__(self):
        """
        __bool__() -> int
        """

    def __hash__(self):
        """
        __hash__() -> long
        """

    def __eq__(self, other):
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other):
        """
        __ne__(other) -> bool
        """
    ID = property(None, None)
# end of class DataViewItem


class DataViewItemAttr(object):
    """
    DataViewItemAttr()
    
    This class is used to indicate to a wxDataViewCtrl that a certain item
    (see wxDataViewItem) has extra font attributes for its renderer.
    """

    def __init__(self):
        """
        DataViewItemAttr()
        
        This class is used to indicate to a wxDataViewCtrl that a certain item
        (see wxDataViewItem) has extra font attributes for its renderer.
        """

    def SetBold(self, set):
        """
        SetBold(set)
        
        Call this to indicate that the item shall be displayed in bold text.
        """

    def SetColour(self, colour):
        """
        SetColour(colour)
        
        Call this to indicate that the item shall be displayed with that
        colour.
        """

    def SetBackgroundColour(self, colour):
        """
        SetBackgroundColour(colour)
        
        Call this to set the background colour to use.
        """

    def SetItalic(self, set):
        """
        SetItalic(set)
        
        Call this to indicate that the item shall be displayed in italic text.
        """

    def HasColour(self):
        """
        HasColour() -> bool
        
        Returns true if the colour property has been set.
        """

    def GetColour(self):
        """
        GetColour() -> wx.Colour
        
        Returns this attribute's colour.
        """

    def HasFont(self):
        """
        HasFont() -> bool
        
        Returns true if any property affecting the font has been set.
        """

    def GetBold(self):
        """
        GetBold() -> bool
        
        Returns value of the bold property.
        """

    def GetItalic(self):
        """
        GetItalic() -> bool
        
        Returns value of the italics property.
        """

    def HasBackgroundColour(self):
        """
        HasBackgroundColour() -> bool
        
        Returns true if the background colour property has been set.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> wx.Colour
        
        Returns the colour to be used for the background.
        """

    def IsDefault(self):
        """
        IsDefault() -> bool
        
        Returns true if none of the properties have been set.
        """

    def GetEffectiveFont(self, font):
        """
        GetEffectiveFont(font) -> wx.Font
        
        Return the font based on the given one with this attribute applied to
        it.
        """
    BackgroundColour = property(None, None)
    Bold = property(None, None)
    Colour = property(None, None)
    Italic = property(None, None)
# end of class DataViewItemAttr


class DataViewIconText(wx.Object):
    """
    DataViewIconText(text=wx.EmptyString, icon=wx.NullIcon)
    DataViewIconText(other)
    
    wxDataViewIconText is used by wxDataViewIconTextRenderer for data
    transfer.
    """

    def __init__(self, *args, **kw):
        """
        DataViewIconText(text=wx.EmptyString, icon=wx.NullIcon)
        DataViewIconText(other)
        
        wxDataViewIconText is used by wxDataViewIconTextRenderer for data
        transfer.
        """

    def GetIcon(self):
        """
        GetIcon() -> wx.Icon
        
        Gets the icon.
        """

    def GetText(self):
        """
        GetText() -> String
        
        Gets the text.
        """

    def SetIcon(self, icon):
        """
        SetIcon(icon)
        
        Set the icon.
        """

    def SetText(self, text):
        """
        SetText(text)
        
        Set the text.
        """
    Icon = property(None, None)
    Text = property(None, None)
# end of class DataViewIconText


class DataViewModelNotifier(object):
    """
    DataViewModelNotifier()
    
    A wxDataViewModelNotifier instance is owned by a wxDataViewModel and
    mirrors its notification interface.
    """

    def __init__(self):
        """
        DataViewModelNotifier()
        
        A wxDataViewModelNotifier instance is owned by a wxDataViewModel and
        mirrors its notification interface.
        """

    def Cleared(self):
        """
        Cleared() -> bool
        
        Called by owning model.
        """

    def GetOwner(self):
        """
        GetOwner() -> DataViewModel
        
        Get owning wxDataViewModel.
        """

    def ItemAdded(self, parent, item):
        """
        ItemAdded(parent, item) -> bool
        
        Called by owning model.
        """

    def ItemChanged(self, item):
        """
        ItemChanged(item) -> bool
        
        Called by owning model.
        """

    def ItemDeleted(self, parent, item):
        """
        ItemDeleted(parent, item) -> bool
        
        Called by owning model.
        """

    def ItemsAdded(self, parent, items):
        """
        ItemsAdded(parent, items) -> bool
        
        Called by owning model.
        """

    def ItemsChanged(self, items):
        """
        ItemsChanged(items) -> bool
        
        Called by owning model.
        """

    def ItemsDeleted(self, parent, items):
        """
        ItemsDeleted(parent, items) -> bool
        
        Called by owning model.
        """

    def Resort(self):
        """
        Resort()
        
        Called by owning model.
        """

    def SetOwner(self, owner):
        """
        SetOwner(owner)
        
        Set owner of this notifier.
        """

    def ValueChanged(self, item, col):
        """
        ValueChanged(item, col) -> bool
        
        Called by owning model.
        """
    Owner = property(None, None)
# end of class DataViewModelNotifier


class DataViewModel(wx.RefCounter):
    """
    DataViewModel()
    
    wxDataViewModel is the base class for all data model to be displayed
    by a wxDataViewCtrl.
    """

    def __init__(self):
        """
        DataViewModel()
        
        wxDataViewModel is the base class for all data model to be displayed
        by a wxDataViewCtrl.
        """

    def AddNotifier(self, notifier):
        """
        AddNotifier(notifier)
        
        Adds a wxDataViewModelNotifier to the model.
        """

    def ChangeValue(self, variant, item, col):
        """
        ChangeValue(variant, item, col) -> bool
        
        Change the value of the given item and update the control to reflect
        it.
        """

    def Cleared(self):
        """
        Cleared() -> bool
        
        Called to inform the model that all data has been cleared.
        """

    def Compare(self, item1, item2, column, ascending):
        """
        Compare(item1, item2, column, ascending) -> int
        
        The compare function to be used by control.
        """

    def GetAttr(self, item, col, attr):
        """
        GetAttr(item, col, attr) -> bool
        
        Override this to indicate that the item has special font attributes.
        """

    def IsEnabled(self, item, col):
        """
        IsEnabled(item, col) -> bool
        
        Override this to indicate that the item should be disabled.
        """

    def GetChildren(self, item, children):
        """
        GetChildren(item, children) -> unsignedint
        
        Override this so the control can query the child items of an item.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> unsignedint
        
        Override this to indicate the number of columns in the model.
        """

    def GetColumnType(self, col):
        """
        GetColumnType(col) -> String
        
        Override this to indicate what type of data is stored in the column
        specified by col.
        """

    def GetParent(self, item):
        """
        GetParent(item) -> DataViewItem
        
        Override this to indicate which wxDataViewItem representing the parent
        of item or an invalid wxDataViewItem if the root item is the parent
        item.
        """

    def GetValue(self, item, col):
        """
        GetValue(item, col) -> variant
        
        Override this to indicate the value of item.
        """

    def HasContainerColumns(self, item):
        """
        HasContainerColumns(item) -> bool
        
        Override this method to indicate if a container item merely acts as a
        headline (or for categorisation) or if it also acts a normal item with
        entries for further columns.
        """

    def HasDefaultCompare(self):
        """
        HasDefaultCompare() -> bool
        
        Override this to indicate that the model provides a default compare
        function that the control should use if no wxDataViewColumn has been
        chosen for sorting.
        """

    def HasValue(self, item, col):
        """
        HasValue(item, col) -> bool
        
        Return true if there is a value in the given column of this item.
        """

    def IsContainer(self, item):
        """
        IsContainer(item) -> bool
        
        Override this to indicate of item is a container, i.e. if it can have
        child items.
        """

    def ItemAdded(self, parent, item):
        """
        ItemAdded(parent, item) -> bool
        
        Call this to inform the model that an item has been added to the data.
        """

    def ItemChanged(self, item):
        """
        ItemChanged(item) -> bool
        
        Call this to inform the model that an item has changed.
        """

    def ItemDeleted(self, parent, item):
        """
        ItemDeleted(parent, item) -> bool
        
        Call this to inform the model that an item has been deleted from the
        data.
        """

    def ItemsAdded(self, parent, items):
        """
        ItemsAdded(parent, items) -> bool
        
        Call this to inform the model that several items have been added to
        the data.
        """

    def ItemsChanged(self, items):
        """
        ItemsChanged(items) -> bool
        
        Call this to inform the model that several items have changed.
        """

    def ItemsDeleted(self, parent, items):
        """
        ItemsDeleted(parent, items) -> bool
        
        Call this to inform the model that several items have been deleted.
        """

    def RemoveNotifier(self, notifier):
        """
        RemoveNotifier(notifier)
        
        Remove the notifier from the list of notifiers.
        """

    def Resort(self):
        """
        Resort()
        
        Call this to initiate a resort after the sort function has been
        changed.
        """

    def SetValue(self, variant, item, col):
        """
        SetValue(variant, item, col) -> bool
        
        This gets called in order to set a value in the data model.
        """

    def ValueChanged(self, item, col):
        """
        ValueChanged(item, col) -> bool
        
        Call this to inform this model that a value in the model has been
        changed.
        """

    def IsListModel(self):
        """
        IsListModel() -> bool
        """

    def IsVirtualListModel(self):
        """
        IsVirtualListModel() -> bool
        """
    ColumnCount = property(None, None)
# end of class DataViewModel


class DataViewListModel(DataViewModel):
    """
    Base class with abstract API for wxDataViewIndexListModel and
    wxDataViewVirtualListModel.
    """

    def Compare(self, item1, item2, column, ascending):
        """
        Compare(item1, item2, column, ascending) -> int
        
        Compare method that sorts the items by their index.
        """

    def GetAttrByRow(self, row, col, attr):
        """
        GetAttrByRow(row, col, attr) -> bool
        
        Override this to indicate that the row has special font attributes.
        """

    def IsEnabledByRow(self, row, col):
        """
        IsEnabledByRow(row, col) -> bool
        
        Override this if you want to disable specific items.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items (or rows) in the list.
        """

    def GetRow(self, item):
        """
        GetRow(item) -> unsignedint
        
        Returns the position of given item.
        """

    def GetValueByRow(self, row, col):
        """
        GetValueByRow(row, col) -> variant
        
        Override this to allow getting values from the model.
        """

    def SetValueByRow(self, variant, row, col):
        """
        SetValueByRow(variant, row, col) -> bool
        
        Called in order to set a value in the model.
        """
    Count = property(None, None)
# end of class DataViewListModel


class DataViewIndexListModel(DataViewListModel):
    """
    DataViewIndexListModel(initial_size=0)
    
    wxDataViewIndexListModel is a specialized data model which lets you
    address an item by its position (row) rather than its wxDataViewItem
    (which you can obtain from this class).
    """

    def __init__(self, initial_size=0):
        """
        DataViewIndexListModel(initial_size=0)
        
        wxDataViewIndexListModel is a specialized data model which lets you
        address an item by its position (row) rather than its wxDataViewItem
        (which you can obtain from this class).
        """

    def GetItem(self, row):
        """
        GetItem(row) -> DataViewItem
        
        Returns the wxDataViewItem at the given row.
        """

    def Reset(self, new_size):
        """
        Reset(new_size)
        
        Call this after if the data has to be read again from the model.
        """

    def RowAppended(self):
        """
        RowAppended()
        
        Call this after a row has been appended to the model.
        """

    def RowChanged(self, row):
        """
        RowChanged(row)
        
        Call this after a row has been changed.
        """

    def RowDeleted(self, row):
        """
        RowDeleted(row)
        
        Call this after a row has been deleted.
        """

    def RowInserted(self, before):
        """
        RowInserted(before)
        
        Call this after a row has been inserted at the given position.
        """

    def RowPrepended(self):
        """
        RowPrepended()
        
        Call this after a row has been prepended to the model.
        """

    def RowValueChanged(self, row, col):
        """
        RowValueChanged(row, col)
        
        Call this after a value has been changed.
        """

    def RowsDeleted(self, rows):
        """
        RowsDeleted(rows)
        
        Call this after rows have been deleted.
        """
# end of class DataViewIndexListModel


class DataViewVirtualListModel(DataViewListModel):
    """
    DataViewVirtualListModel(initial_size=0)
    
    wxDataViewVirtualListModel is a specialized data model which lets you
    address an item by its position (row) rather than its wxDataViewItem
    and as such offers the exact same interface as
    wxDataViewIndexListModel.
    """

    def __init__(self, initial_size=0):
        """
        DataViewVirtualListModel(initial_size=0)
        
        wxDataViewVirtualListModel is a specialized data model which lets you
        address an item by its position (row) rather than its wxDataViewItem
        and as such offers the exact same interface as
        wxDataViewIndexListModel.
        """

    def GetItem(self, row):
        """
        GetItem(row) -> DataViewItem
        
        Returns the wxDataViewItem at the given row.
        """

    def Reset(self, new_size):
        """
        Reset(new_size)
        
        Call this after if the data has to be read again from the model.
        """

    def RowAppended(self):
        """
        RowAppended()
        
        Call this after a row has been appended to the model.
        """

    def RowChanged(self, row):
        """
        RowChanged(row)
        
        Call this after a row has been changed.
        """

    def RowDeleted(self, row):
        """
        RowDeleted(row)
        
        Call this after a row has been deleted.
        """

    def RowInserted(self, before):
        """
        RowInserted(before)
        
        Call this after a row has been inserted at the given position.
        """

    def RowPrepended(self):
        """
        RowPrepended()
        
        Call this after a row has been prepended to the model.
        """

    def RowValueChanged(self, row, col):
        """
        RowValueChanged(row, col)
        
        Call this after a value has been changed.
        """

    def RowsDeleted(self, rows):
        """
        RowsDeleted(rows)
        
        Call this after rows have been deleted.
        """
# end of class DataViewVirtualListModel


class DataViewRenderer(wx.Object):
    """
    DataViewRenderer(varianttype, mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
    
    This class is used by wxDataViewCtrl to render the individual cells.
    """

    def __init__(self, varianttype, mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewRenderer(varianttype, mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
        
        This class is used by wxDataViewCtrl to render the individual cells.
        """

    def EnableEllipsize(self, mode=wx.ELLIPSIZE_MIDDLE):
        """
        EnableEllipsize(mode=wx.ELLIPSIZE_MIDDLE)
        
        Enable or disable replacing parts of the item text with ellipsis to
        make it fit the column width.
        """

    def DisableEllipsize(self):
        """
        DisableEllipsize()
        
        Disable replacing parts of the item text with ellipsis.
        """

    def GetAlignment(self):
        """
        GetAlignment() -> int
        
        Returns the alignment.
        """

    def GetEllipsizeMode(self):
        """
        GetEllipsizeMode() -> EllipsizeMode
        
        Returns the ellipsize mode used by the renderer.
        """

    def GetMode(self):
        """
        GetMode() -> DataViewCellMode
        
        Returns the cell mode.
        """

    def GetOwner(self):
        """
        GetOwner() -> DataViewColumn
        
        Returns pointer to the owning wxDataViewColumn.
        """

    def GetValue(self):
        """
        GetValue() -> value
        
        This methods retrieves the value from the renderer in order to
        transfer the value back to the data model.
        """

    def GetVariantType(self):
        """
        GetVariantType() -> String
        
        Returns a string with the type of the wxVariant supported by this
        renderer.
        """

    def SetAlignment(self, align):
        """
        SetAlignment(align)
        
        Sets the alignment of the renderer's content.
        """

    def SetOwner(self, owner):
        """
        SetOwner(owner)
        
        Sets the owning wxDataViewColumn.
        """

    def SetValue(self, value):
        """
        SetValue(value) -> bool
        
        Set the value of the renderer (and thus its cell) to value.
        """

    def Validate(self, value):
        """
        Validate(value) -> bool
        
        Before data is committed to the data model, it is passed to this
        method where it can be checked for validity.
        """

    def HasEditorCtrl(self):
        """
        HasEditorCtrl() -> bool
        """

    def CreateEditorCtrl(self, parent, labelRect, value):
        """
        CreateEditorCtrl(parent, labelRect, value) -> wx.Window
        """

    def GetValueFromEditorCtrl(self, editor):
        """
        GetValueFromEditorCtrl(editor) -> value
        """

    def StartEditing(self, item, labelRect):
        """
        StartEditing(item, labelRect) -> bool
        """

    def CancelEditing(self):
        """
        CancelEditing()
        """

    def FinishEditing(self):
        """
        FinishEditing() -> bool
        """

    def GetEditorCtrl(self):
        """
        GetEditorCtrl() -> wx.Window
        """
    Alignment = property(None, None)
    EditorCtrl = property(None, None)
    EllipsizeMode = property(None, None)
    Mode = property(None, None)
    Owner = property(None, None)
    VariantType = property(None, None)

    def GetView(self):
        """
        GetView() -> DataViewCtrl
        """
# end of class DataViewRenderer


class DataViewCustomRenderer(DataViewRenderer):
    """
    DataViewCustomRenderer(varianttype="string", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
    
    You need to derive a new class from wxDataViewCustomRenderer in order
    to write a new renderer.
    """

    def __init__(self, varianttype="string", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewCustomRenderer(varianttype="string", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
        
        You need to derive a new class from wxDataViewCustomRenderer in order
        to write a new renderer.
        """

    def ActivateCell(self, cell, model, item, col, mouseEvent):
        """
        ActivateCell(cell, model, item, col, mouseEvent) -> bool
        
        Override this to react to cell activation.
        """

    def CreateEditorCtrl(self, parent, labelRect, value):
        """
        CreateEditorCtrl(parent, labelRect, value) -> wx.Window
        
        Override this to create the actual editor control once editing is
        about to start.
        """

    def GetAttr(self):
        """
        GetAttr() -> DataViewItemAttr
        
        Return the attribute to be used for rendering.
        """

    def GetSize(self):
        """
        GetSize() -> wx.Size
        
        Return size required to show content.
        """

    def GetValueFromEditorCtrl(self, editor):
        """
        GetValueFromEditorCtrl(editor) -> value
        
        Override this so that the renderer can get the value from the editor
        control (pointed to by editor):
        """

    def HasEditorCtrl(self):
        """
        HasEditorCtrl() -> bool
        
        Override this and make it return true in order to indicate that this
        renderer supports in-place editing.
        """

    def LeftClick(self, cursor, cell, model, item, col):
        """
        LeftClick(cursor, cell, model, item, col) -> bool
        
        Override this to react to a left click.
        """

    def Activate(self, cell, model, item, col):
        """
        Activate(cell, model, item, col) -> bool
        
        Override this to react to the activation of a cell.
        """

    def Render(self, cell, dc, state):
        """
        Render(cell, dc, state) -> bool
        
        Override this to render the cell.
        """

    def RenderText(self, text, xoffset, cell, dc, state):
        """
        RenderText(text, xoffset, cell, dc, state)
        
        This method should be called from within Render() whenever you need to
        render simple text.
        """

    def StartDrag(self, cursor, cell, model, item, col):
        """
        StartDrag(cursor, cell, model, item, col) -> bool
        
        Override this to start a drag operation.
        """
    Attr = property(None, None)
    Size = property(None, None)

    def GetTextExtent(self, str):
        """
        GetTextExtent(str) -> wx.Size
        
        Helper for GetSize() implementations, respects attributes.
        """
# end of class DataViewCustomRenderer


class DataViewTextRenderer(DataViewRenderer):
    """
    DataViewTextRenderer(varianttype="string", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
    
    wxDataViewTextRenderer is used for rendering text.
    """

    def __init__(self, varianttype="string", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewTextRenderer(varianttype="string", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
        
        wxDataViewTextRenderer is used for rendering text.
        """
# end of class DataViewTextRenderer


class DataViewIconTextRenderer(DataViewRenderer):
    """
    DataViewIconTextRenderer(varianttype="wxDataViewIconText", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
    
    The wxDataViewIconTextRenderer class is used to display text with a
    small icon next to it as it is typically done in a file manager.
    """

    def __init__(self, varianttype="wxDataViewIconText", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewIconTextRenderer(varianttype="wxDataViewIconText", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
        
        The wxDataViewIconTextRenderer class is used to display text with a
        small icon next to it as it is typically done in a file manager.
        """
# end of class DataViewIconTextRenderer


class DataViewProgressRenderer(DataViewRenderer):
    """
    DataViewProgressRenderer(label=wx.EmptyString, varianttype="long", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
    
    This class is used by wxDataViewCtrl to render progress bars.
    """

    def __init__(self, label=wx.EmptyString, varianttype="long", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewProgressRenderer(label=wx.EmptyString, varianttype="long", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
        
        This class is used by wxDataViewCtrl to render progress bars.
        """
# end of class DataViewProgressRenderer


class DataViewSpinRenderer(DataViewCustomRenderer):
    """
    DataViewSpinRenderer(min, max, mode=DATAVIEW_CELL_EDITABLE, align=DVR_DEFAULT_ALIGNMENT)
    
    This is a specialized renderer for rendering integer values.
    """

    def __init__(self, min, max, mode=DATAVIEW_CELL_EDITABLE, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewSpinRenderer(min, max, mode=DATAVIEW_CELL_EDITABLE, align=DVR_DEFAULT_ALIGNMENT)
        
        This is a specialized renderer for rendering integer values.
        """
# end of class DataViewSpinRenderer


class DataViewToggleRenderer(DataViewRenderer):
    """
    DataViewToggleRenderer(varianttype="bool", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
    
    This class is used by wxDataViewCtrl to render toggle controls.
    """

    def __init__(self, varianttype="bool", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewToggleRenderer(varianttype="bool", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
        
        This class is used by wxDataViewCtrl to render toggle controls.
        """
# end of class DataViewToggleRenderer


class DataViewChoiceRenderer(DataViewRenderer):
    """
    DataViewChoiceRenderer(choices, mode=DATAVIEW_CELL_EDITABLE, alignment=DVR_DEFAULT_ALIGNMENT)
    
    A wxDataViewCtrl renderer using wxChoice control and values of strings
    in it.
    """

    def __init__(self, choices, mode=DATAVIEW_CELL_EDITABLE, alignment=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewChoiceRenderer(choices, mode=DATAVIEW_CELL_EDITABLE, alignment=DVR_DEFAULT_ALIGNMENT)
        
        A wxDataViewCtrl renderer using wxChoice control and values of strings
        in it.
        """

    def GetChoice(self, index):
        """
        GetChoice(index) -> String
        
        Returns the choice referred to by index.
        """

    def GetChoices(self):
        """
        GetChoices() -> ArrayString
        
        Returns all choices.
        """
    Choices = property(None, None)
# end of class DataViewChoiceRenderer


class DataViewDateRenderer(DataViewRenderer):
    """
    DataViewDateRenderer(varianttype="datetime", mode=DATAVIEW_CELL_ACTIVATABLE, align=DVR_DEFAULT_ALIGNMENT)
    
    This class is used by wxDataViewCtrl to render calendar controls.
    """

    def __init__(self, varianttype="datetime", mode=DATAVIEW_CELL_ACTIVATABLE, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewDateRenderer(varianttype="datetime", mode=DATAVIEW_CELL_ACTIVATABLE, align=DVR_DEFAULT_ALIGNMENT)
        
        This class is used by wxDataViewCtrl to render calendar controls.
        """
# end of class DataViewDateRenderer


class DataViewBitmapRenderer(DataViewRenderer):
    """
    DataViewBitmapRenderer(varianttype="wxBitmap", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
    
    This class is used by wxDataViewCtrl to render bitmap controls.
    """

    def __init__(self, varianttype="wxBitmap", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT):
        """
        DataViewBitmapRenderer(varianttype="wxBitmap", mode=DATAVIEW_CELL_INERT, align=DVR_DEFAULT_ALIGNMENT)
        
        This class is used by wxDataViewCtrl to render bitmap controls.
        """
# end of class DataViewBitmapRenderer


class DataViewColumn(wx.SettableHeaderColumn):
    """
    DataViewColumn(title, renderer, model_column, width=DVC_DEFAULT_WIDTH, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE)
    DataViewColumn(bitmap, renderer, model_column, width=DVC_DEFAULT_WIDTH, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE)
    
    This class represents a column in a wxDataViewCtrl.
    """

    def __init__(self, *args, **kw):
        """
        DataViewColumn(title, renderer, model_column, width=DVC_DEFAULT_WIDTH, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE)
        DataViewColumn(bitmap, renderer, model_column, width=DVC_DEFAULT_WIDTH, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE)
        
        This class represents a column in a wxDataViewCtrl.
        """

    def GetModelColumn(self):
        """
        GetModelColumn() -> unsignedint
        
        Returns the index of the column of the model, which this
        wxDataViewColumn is displaying.
        """

    def GetOwner(self):
        """
        GetOwner() -> DataViewCtrl
        
        Returns the owning wxDataViewCtrl.
        """

    def GetRenderer(self):
        """
        GetRenderer() -> DataViewRenderer
        
        Returns the renderer of this wxDataViewColumn.
        """
    ModelColumn = property(None, None)
    Owner = property(None, None)
    Renderer = property(None, None)
    Title = property(None, None)
    Bitmap = property(None, None)
    Width = property(None, None)
    MinWidth = property(None, None)
    Alignment = property(None, None)
    Flags = property(None, None)
    SortOrder = property(None, None)
# end of class DataViewColumn

DataViewCtrlNameStr = ""

class DataViewCtrl(wx.Control):
    """
    DataViewCtrl()
    DataViewCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=DataViewCtrlNameStr)
    
    wxDataViewCtrl is a control to display data either in a tree like
    fashion or in a tabular form or both.
    """

    def __init__(self, *args, **kw):
        """
        DataViewCtrl()
        DataViewCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=DataViewCtrlNameStr)
        
        wxDataViewCtrl is a control to display data either in a tree like
        fashion or in a tabular form or both.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=DataViewCtrlNameStr):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=DataViewCtrlNameStr) -> bool
        
        Create the control.
        """

    def AppendColumn(self, col):
        """
        AppendColumn(col) -> bool
        
        Appends a wxDataViewColumn to the control.
        """

    def PrependColumn(self, col):
        """
        PrependColumn(col) -> bool
        
        Prepends a wxDataViewColumn to the control.
        """

    def InsertColumn(self, pos, col):
        """
        InsertColumn(pos, col) -> bool
        
        Inserts a wxDataViewColumn to the control.
        """

    def AppendBitmapColumn(self, *args, **kw):
        """
        AppendBitmapColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        AppendBitmapColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a column for rendering a bitmap.
        """

    def PrependBitmapColumn(self, *args, **kw):
        """
        PrependBitmapColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        PrependBitmapColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Prepends a column for rendering a bitmap.
        """

    def AppendDateColumn(self, *args, **kw):
        """
        AppendDateColumn(label, model_column, mode=DATAVIEW_CELL_ACTIVATABLE, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        AppendDateColumn(label, model_column, mode=DATAVIEW_CELL_ACTIVATABLE, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a column for rendering a date.
        """

    def PrependDateColumn(self, *args, **kw):
        """
        PrependDateColumn(label, model_column, mode=DATAVIEW_CELL_ACTIVATABLE, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        PrependDateColumn(label, model_column, mode=DATAVIEW_CELL_ACTIVATABLE, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Prepends a column for rendering a date.
        """

    def AppendIconTextColumn(self, *args, **kw):
        """
        AppendIconTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        AppendIconTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a column for rendering text with an icon.
        """

    def PrependIconTextColumn(self, *args, **kw):
        """
        PrependIconTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        PrependIconTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Prepends a column for rendering text with an icon.
        """

    def AppendProgressColumn(self, *args, **kw):
        """
        AppendProgressColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=80, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        AppendProgressColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=80, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a column for rendering a progress indicator.
        """

    def PrependProgressColumn(self, *args, **kw):
        """
        PrependProgressColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=80, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        PrependProgressColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=80, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Prepends a column for rendering a progress indicator.
        """

    def AppendTextColumn(self, *args, **kw):
        """
        AppendTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        AppendTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a column for rendering text.
        """

    def PrependTextColumn(self, *args, **kw):
        """
        PrependTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        PrependTextColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_NOT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Prepends a column for rendering text.
        """

    def AppendToggleColumn(self, *args, **kw):
        """
        AppendToggleColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=30, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        AppendToggleColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=30, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a column for rendering a toggle.
        """

    def PrependToggleColumn(self, *args, **kw):
        """
        PrependToggleColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=30, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        PrependToggleColumn(label, model_column, mode=DATAVIEW_CELL_INERT, width=30, align=wx.ALIGN_CENTER, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Prepends a column for rendering a toggle.
        """

    def _AssociateModel(self, model):
        """
        _AssociateModel(model) -> bool
        
        Associates a wxDataViewModel with the control.
        """

    def ClearColumns(self):
        """
        ClearColumns() -> bool
        
        Removes all columns.
        """

    def Collapse(self, item):
        """
        Collapse(item)
        
        Collapses the item.
        """

    def DeleteColumn(self, column):
        """
        DeleteColumn(column) -> bool
        
        Deletes given column.
        """

    def EditItem(self, item, column):
        """
        EditItem(item, column)
        
        Programmatically starts editing given cell of item.
        """

    def EnableDragSource(self, format):
        """
        EnableDragSource(format) -> bool
        
        Enable drag operations using the given format.
        """

    def EnableDropTarget(self, format):
        """
        EnableDropTarget(format) -> bool
        
        Enable drop operations using the given format.
        """

    def EnsureVisible(self, item, column=None):
        """
        EnsureVisible(item, column=None)
        
        Call this to ensure that the given item is visible.
        """

    def Expand(self, item):
        """
        Expand(item)
        
        Expands the item.
        """

    def ExpandAncestors(self, item):
        """
        ExpandAncestors(item)
        
        Expands all ancestors of the item.
        """

    def GetColumn(self, pos):
        """
        GetColumn(pos) -> DataViewColumn
        
        Returns pointer to the column.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> unsignedint
        
        Returns the number of columns.
        """

    def GetColumnPosition(self, column):
        """
        GetColumnPosition(column) -> int
        
        Returns the position of the column or -1 if not found in the control.
        """

    def GetExpanderColumn(self):
        """
        GetExpanderColumn() -> DataViewColumn
        
        Returns column containing the expanders.
        """

    def GetCurrentItem(self):
        """
        GetCurrentItem() -> DataViewItem
        
        Returns the currently focused item.
        """

    def GetCurrentColumn(self):
        """
        GetCurrentColumn() -> DataViewColumn
        
        Returns the column that currently has focus.
        """

    def GetIndent(self):
        """
        GetIndent() -> int
        
        Returns indentation.
        """

    def GetItemRect(self, item, col=None):
        """
        GetItemRect(item, col=None) -> wx.Rect
        
        Returns item rectangle.
        """

    def GetModel(self):
        """
        GetModel() -> DataViewModel
        
        Returns pointer to the data model associated with the control (if
        any).
        """

    def GetSelectedItemsCount(self):
        """
        GetSelectedItemsCount() -> int
        
        Returns the number of currently selected items.
        """

    def GetSelection(self):
        """
        GetSelection() -> DataViewItem
        
        Returns first selected item or an invalid item if none is selected.
        """

    def GetSelections(self):
        """
        GetSelections() -> DataViewItemArray
        
        Returns a list of the currently selected items.
        """

    def GetSortingColumn(self):
        """
        GetSortingColumn() -> DataViewColumn
        
        Returns the wxDataViewColumn currently responsible for sorting or NULL
        if none has been selected.
        """

    def HasSelection(self):
        """
        HasSelection() -> bool
        
        Returns true if any items are currently selected.
        """

    def HitTest(self, point):
        """
        HitTest(point) -> PyObject
        
        HitTest(point) -> (item, col)
        
        Returns the item and column located at point, as a 2 element tuple.
        """

    def IsExpanded(self, item):
        """
        IsExpanded(item) -> bool
        
        Return true if the item is expanded.
        """

    def IsSelected(self, item):
        """
        IsSelected(item) -> bool
        
        Return true if the item is selected.
        """

    def Select(self, item):
        """
        Select(item)
        
        Select the given item.
        """

    def SelectAll(self):
        """
        SelectAll()
        
        Select all items.
        """

    def SetExpanderColumn(self, col):
        """
        SetExpanderColumn(col)
        
        Set which column shall contain the tree-like expanders.
        """

    def SetCurrentItem(self, item):
        """
        SetCurrentItem(item)
        
        Changes the currently focused item.
        """

    def SetIndent(self, indent):
        """
        SetIndent(indent)
        
        Sets the indentation.
        """

    def SetSelections(self, sel):
        """
        SetSelections(sel)
        
        Sets the selection to the array of wxDataViewItems.
        """

    def Unselect(self, item):
        """
        Unselect(item)
        
        Unselect the given item.
        """

    def UnselectAll(self):
        """
        UnselectAll()
        
        Unselect all item.
        """

    def SetRowHeight(self, rowHeight):
        """
        SetRowHeight(rowHeight) -> bool
        
        Sets the row height.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def AssociateModel(self, model):
        """
        Associates a :class:`DataViewModel` with the control.
        Ownership of the model object is passed to C++, however it
        is reference counted so it can be shared with other views.
        """

    def GetColumns(self):
        """
        Returns a list of column objects.
        """
    ColumnCount = property(None, None)
    Columns = property(None, None)
    CurrentColumn = property(None, None)
    CurrentItem = property(None, None)
    ExpanderColumn = property(None, None)
    Indent = property(None, None)
    Model = property(None, None)
    SelectedItemsCount = property(None, None)
    Selection = property(None, None)
    Selections = property(None, None)
    SortingColumn = property(None, None)
# end of class DataViewCtrl


class DataViewEvent(wx.NotifyEvent):
    """
    DataViewEvent(commandType=wx.wxEVT_NULL, winid=0)
    
    This is the event class for the wxDataViewCtrl notifications.
    """

    def __init__(self, commandType=wx.wxEVT_NULL, winid=0):
        """
        DataViewEvent(commandType=wx.wxEVT_NULL, winid=0)
        
        This is the event class for the wxDataViewCtrl notifications.
        """

    def GetColumn(self):
        """
        GetColumn() -> int
        
        Returns the position of the column in the control or -1 if no column
        field was set by the event emitter.
        """

    def GetDataViewColumn(self):
        """
        GetDataViewColumn() -> DataViewColumn
        
        Returns a pointer to the wxDataViewColumn from which the event was
        emitted or NULL.
        """

    def GetModel(self):
        """
        GetModel() -> DataViewModel
        
        Returns the wxDataViewModel associated with the event.
        """

    def GetPosition(self):
        """
        GetPosition() -> wx.Point
        
        Returns the position of a context menu event in screen coordinates.
        """

    def GetValue(self):
        """
        GetValue() -> DVCVariant
        
        Returns a reference to a value.
        """

    def IsEditCancelled(self):
        """
        IsEditCancelled() -> bool
        
        Can be used to determine whether the new value is going to be accepted
        in wxEVT_DATAVIEW_ITEM_EDITING_DONE handler.
        """

    def SetColumn(self, col):
        """
        SetColumn(col)
        
        Sets the column index associated with this event.
        """

    def SetDataViewColumn(self, col):
        """
        SetDataViewColumn(col)
        
        For wxEVT_DATAVIEW_COLUMN_HEADER_CLICK only.
        """

    def SetModel(self, model):
        """
        SetModel(model)
        
        Sets the dataview model associated with this event.
        """

    def SetValue(self, value):
        """
        SetValue(value)
        
        Sets the value associated with this event.
        """

    def SetDataObject(self, obj):
        """
        SetDataObject(obj)
        
        Set wxDataObject for data transfer within a drag operation.
        """

    def GetDataFormat(self):
        """
        GetDataFormat() -> wx.DataFormat
        
        Gets the wxDataFormat during a drop operation.
        """

    def GetDataSize(self):
        """
        GetDataSize() -> size_t
        
        Gets the data size for a drop data transfer.
        """

    def GetDataBuffer(self):
        """
        GetDataBuffer() -> PyObject
        
        Gets the data buffer for a drop data transfer
        """

    def SetDragFlags(self, flags):
        """
        SetDragFlags(flags)
        
        Specify the kind of the drag operation to perform.
        """

    def GetDropEffect(self):
        """
        GetDropEffect() -> DragResult
        
        Returns the effect the user requested to happen to the dropped data.
        """

    def GetCacheFrom(self):
        """
        GetCacheFrom() -> int
        
        Return the first row that will be displayed.
        """

    def GetCacheTo(self):
        """
        GetCacheTo() -> int
        
        Return the last row that will be displayed.
        """

    def GetItem(self):
        """
        GetItem() -> DataViewItem
        """

    def SetItem(self, item):
        """
        SetItem(item)
        """

    def SetEditCanceled(self, editCancelled):
        """
        SetEditCanceled(editCancelled)
        """

    def SetPosition(self, x, y):
        """
        SetPosition(x, y)
        """

    def SetCache(self, from_, to_):
        """
        SetCache(from_, to_)
        """

    def GetDataObject(self):
        """
        GetDataObject() -> wx.DataObject
        """

    def SetDataFormat(self, format):
        """
        SetDataFormat(format)
        """

    def SetDataSize(self, size):
        """
        SetDataSize(size)
        """

    def SetDataBuffer(self, buf):
        """
        SetDataBuffer(buf)
        """

    def GetDragFlags(self):
        """
        GetDragFlags() -> int
        """

    def SetDropEffect(self, effect):
        """
        SetDropEffect(effect)
        """
    EditCancelled = property(None, None)
# end of class DataViewEvent


class DataViewListCtrl(DataViewCtrl):
    """
    DataViewListCtrl()
    DataViewListCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_ROW_LINES, validator=wx.DefaultValidator)
    
    This class is a wxDataViewCtrl which internally uses a
    wxDataViewListStore and forwards most of its API to that class.
    """

    def __init__(self, *args, **kw):
        """
        DataViewListCtrl()
        DataViewListCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_ROW_LINES, validator=wx.DefaultValidator)
        
        This class is a wxDataViewCtrl which internally uses a
        wxDataViewListStore and forwards most of its API to that class.
        """

    def GetSelectedRow(self):
        """
        GetSelectedRow() -> int
        
        Returns index of the selected row or wxNOT_FOUND.
        """

    def SelectRow(self, row):
        """
        SelectRow(row)
        
        Selects given row.
        """

    def UnselectRow(self, row):
        """
        UnselectRow(row)
        
        Unselects given row.
        """

    def IsRowSelected(self, row):
        """
        IsRowSelected(row) -> bool
        
        Returns true if row is selected.
        """

    def AppendColumn(self, *args, **kw):
        """
        AppendColumn(column) -> bool
        AppendColumn(column, varianttype)
        
        Appends a column to the control and additionally appends a column to
        the store with the type string.
        """

    def AppendTextColumn(self, label, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE):
        """
        AppendTextColumn(label, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a text column to the control and the store.
        """

    def AppendToggleColumn(self, label, mode=DATAVIEW_CELL_ACTIVATABLE, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE):
        """
        AppendToggleColumn(label, mode=DATAVIEW_CELL_ACTIVATABLE, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a toggle column to the control and the store.
        """

    def AppendProgressColumn(self, label, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE):
        """
        AppendProgressColumn(label, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends a progress column to the control and the store.
        """

    def AppendIconTextColumn(self, label, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE):
        """
        AppendIconTextColumn(label, mode=DATAVIEW_CELL_INERT, width=-1, align=wx.ALIGN_LEFT, flags=DATAVIEW_COL_RESIZABLE) -> DataViewColumn
        
        Appends an icon-and-text column to the control and the store.
        """

    def InsertColumn(self, *args, **kw):
        """
        InsertColumn(pos, column) -> bool
        InsertColumn(pos, column, varianttype)
        
        Inserts a column to the control and additionally inserts a column to
        the store with the type string.
        """

    def PrependColumn(self, *args, **kw):
        """
        PrependColumn(column) -> bool
        PrependColumn(column, varianttype)
        
        Prepends a column to the control and additionally prepends a column to
        the store with the type string.
        """

    def AppendItem(self, values, data=None):
        """
        AppendItem(values, data=None)
        
        Appends an item (=row) to the control and store.
        """

    def PrependItem(self, values, data=None):
        """
        PrependItem(values, data=None)
        
        Prepends an item (=row) to the control and store.
        """

    def InsertItem(self, row, values, data=None):
        """
        InsertItem(row, values, data=None)
        
        Inserts an item (=row) to the control and store.
        """

    def DeleteItem(self, row):
        """
        DeleteItem(row)
        
        Delete the row at position row.
        """

    def DeleteAllItems(self):
        """
        DeleteAllItems()
        
        Delete all items (= all rows).
        """

    def GetItemCount(self):
        """
        GetItemCount() -> unsignedint
        
        Returns the number of items (=rows) in the control.
        """

    def GetItemData(self, item):
        """
        GetItemData(item) -> UIntPtr
        
        Returns the client data associated with the item.
        """

    def SetValue(self, value, row, col):
        """
        SetValue(value, row, col)
        
        Sets the value in the store and update the control.
        """

    def GetValue(self, row, col):
        """
        GetValue(row, col) -> value
        
        Returns the value from the store.
        """

    def SetTextValue(self, value, row, col):
        """
        SetTextValue(value, row, col)
        
        Sets the value in the store and update the control.
        """

    def GetTextValue(self, row, col):
        """
        GetTextValue(row, col) -> String
        
        Returns the value from the store.
        """

    def SetToggleValue(self, value, row, col):
        """
        SetToggleValue(value, row, col)
        
        Sets the value in the store and update the control.
        """

    def GetToggleValue(self, row, col):
        """
        GetToggleValue(row, col) -> bool
        
        Returns the value from the store.
        """

    def SetItemData(self, item, data):
        """
        SetItemData(item, data)
        
        Associates a client data pointer with the given item.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_ROW_LINES, validator=wx.DefaultValidator):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_ROW_LINES, validator=wx.DefaultValidator) -> bool
        
        Creates the control and a wxDataViewListStore as its internal model.
        """

    def GetStore(self):
        """
        GetStore() -> DataViewListStore
        
        Returns the store.
        """

    def ItemToRow(self, item):
        """
        ItemToRow(item) -> int
        
        Returns the position of given item or wxNOT_FOUND if it's not a valid
        item.
        """

    def RowToItem(self, row):
        """
        RowToItem(row) -> DataViewItem
        
        Returns the wxDataViewItem at the given row.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ItemCount = property(None, None)
    SelectedRow = property(None, None)
    Store = property(None, None)
# end of class DataViewListCtrl


class DataViewListStore(DataViewIndexListModel):
    """
    DataViewListStore()
    
    wxDataViewListStore is a specialised wxDataViewModel for storing a
    simple table of data.
    """

    def __init__(self):
        """
        DataViewListStore()
        
        wxDataViewListStore is a specialised wxDataViewModel for storing a
        simple table of data.
        """

    def PrependColumn(self, varianttype):
        """
        PrependColumn(varianttype)
        
        Prepends a data column.
        """

    def InsertColumn(self, pos, varianttype):
        """
        InsertColumn(pos, varianttype)
        
        Inserts a data column before pos.
        """

    def AppendColumn(self, varianttype):
        """
        AppendColumn(varianttype)
        
        Appends a data column.
        """

    def AppendItem(self, values, data=None):
        """
        AppendItem(values, data=None)
        
        Appends an item (=row) and fills it with values.
        """

    def PrependItem(self, values, data=None):
        """
        PrependItem(values, data=None)
        
        Prepends an item (=row) and fills it with values.
        """

    def InsertItem(self, row, values, data=None):
        """
        InsertItem(row, values, data=None)
        
        Inserts an item (=row) and fills it with values.
        """

    def DeleteItem(self, pos):
        """
        DeleteItem(pos)
        
        Delete the item (=row) at position pos.
        """

    def DeleteAllItems(self):
        """
        DeleteAllItems()
        
        Delete all item (=all rows) in the store.
        """

    def GetItemCount(self):
        """
        GetItemCount() -> unsignedint
        
        Returns the number of items (=rows) in the control.
        """

    def GetItemData(self, item):
        """
        GetItemData(item) -> UIntPtr
        
        Returns the client data associated with the item.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> unsignedint
        
        Overridden from wxDataViewModel.
        """

    def GetColumnType(self, col):
        """
        GetColumnType(col) -> String
        
        Overridden from wxDataViewModel.
        """

    def SetItemData(self, item, data):
        """
        SetItemData(item, data)
        
        Sets the client data associated with the item.
        """

    def GetValueByRow(self, row, col):
        """
        GetValueByRow(row, col) -> value
        
        Overridden from wxDataViewIndexListModel.
        """

    def SetValueByRow(self, value, row, col):
        """
        SetValueByRow(value, row, col) -> bool
        
        Overridden from wxDataViewIndexListModel.
        """
    ColumnCount = property(None, None)
    ItemCount = property(None, None)
# end of class DataViewListStore


class DataViewTreeCtrl(DataViewCtrl):
    """
    DataViewTreeCtrl()
    DataViewTreeCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_NO_HEADER|DV_ROW_LINES, validator=wx.DefaultValidator)
    
    This class is a wxDataViewCtrl which internally uses a
    wxDataViewTreeStore and forwards most of its API to that class.
    """

    def __init__(self, *args, **kw):
        """
        DataViewTreeCtrl()
        DataViewTreeCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_NO_HEADER|DV_ROW_LINES, validator=wx.DefaultValidator)
        
        This class is a wxDataViewCtrl which internally uses a
        wxDataViewTreeStore and forwards most of its API to that class.
        """

    def AppendContainer(self, parent, text, icon=-1, expanded=-1, data=None):
        """
        AppendContainer(parent, text, icon=-1, expanded=-1, data=None) -> DataViewItem
        
        Appends a container to the given parent.
        """

    def AppendItem(self, parent, text, icon=-1, data=None):
        """
        AppendItem(parent, text, icon=-1, data=None) -> DataViewItem
        
        Appends an item to the given parent.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_NO_HEADER|DV_ROW_LINES, validator=wx.DefaultValidator):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DV_NO_HEADER|DV_ROW_LINES, validator=wx.DefaultValidator) -> bool
        
        Creates the control and a wxDataViewTreeStore as its internal model.
        """

    def DeleteAllItems(self):
        """
        DeleteAllItems()
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def DeleteChildren(self, item):
        """
        DeleteChildren(item)
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def DeleteItem(self, item):
        """
        DeleteItem(item)
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def GetChildCount(self, parent):
        """
        GetChildCount(parent) -> int
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def GetImageList(self):
        """
        GetImageList() -> wx.ImageList
        
        Returns the image list.
        """

    def GetItemData(self, item):
        """
        GetItemData(item) -> ClientData
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def GetItemExpandedIcon(self, item):
        """
        GetItemExpandedIcon(item) -> wx.Icon
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def GetItemIcon(self, item):
        """
        GetItemIcon(item) -> wx.Icon
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def GetItemText(self, item):
        """
        GetItemText(item) -> String
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def GetNthChild(self, parent, pos):
        """
        GetNthChild(parent, pos) -> DataViewItem
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def GetStore(self):
        """
        GetStore() -> DataViewTreeStore
        
        Returns the store.
        """

    def InsertContainer(self, parent, previous, text, icon=-1, expanded=-1, data=None):
        """
        InsertContainer(parent, previous, text, icon=-1, expanded=-1, data=None) -> DataViewItem
        
        Calls the same method from wxDataViewTreeStore but uses an index
        position in the image list instead of a wxIcon.
        """

    def InsertItem(self, parent, previous, text, icon=-1, data=None):
        """
        InsertItem(parent, previous, text, icon=-1, data=None) -> DataViewItem
        
        Calls the same method from wxDataViewTreeStore but uses an index
        position in the image list instead of a wxIcon.
        """

    def IsContainer(self, item):
        """
        IsContainer(item) -> bool
        
        Returns true if item is a container.
        """

    def PrependContainer(self, parent, text, icon=-1, expanded=-1, data=None):
        """
        PrependContainer(parent, text, icon=-1, expanded=-1, data=None) -> DataViewItem
        
        Calls the same method from wxDataViewTreeStore but uses an index
        position in the image list instead of a wxIcon.
        """

    def PrependItem(self, parent, text, icon=-1, data=None):
        """
        PrependItem(parent, text, icon=-1, data=None) -> DataViewItem
        
        Calls the same method from wxDataViewTreeStore but uses an index
        position in the image list instead of a wxIcon.
        """

    def SetImageList(self, imagelist):
        """
        SetImageList(imagelist)
        
        Sets the image list.
        """

    def SetItemData(self, item, data):
        """
        SetItemData(item, data)
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def SetItemExpandedIcon(self, item, icon):
        """
        SetItemExpandedIcon(item, icon)
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def SetItemIcon(self, item, icon):
        """
        SetItemIcon(item, icon)
        
        Calls the identical method from wxDataViewTreeStore.
        """

    def SetItemText(self, item, text):
        """
        SetItemText(item, text)
        
        Calls the identical method from wxDataViewTreeStore.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ImageList = property(None, None)
    Store = property(None, None)
# end of class DataViewTreeCtrl


class DataViewTreeStore(DataViewModel):
    """
    DataViewTreeStore()
    
    wxDataViewTreeStore is a specialised wxDataViewModel for storing
    simple trees very much like wxTreeCtrl does and it offers a similar
    API.
    """

    def __init__(self):
        """
        DataViewTreeStore()
        
        wxDataViewTreeStore is a specialised wxDataViewModel for storing
        simple trees very much like wxTreeCtrl does and it offers a similar
        API.
        """

    def AppendContainer(self, parent, text, icon=wx.NullIcon, expanded=wx.NullIcon, data=None):
        """
        AppendContainer(parent, text, icon=wx.NullIcon, expanded=wx.NullIcon, data=None) -> DataViewItem
        
        Append a container.
        """

    def AppendItem(self, parent, text, icon=wx.NullIcon, data=None):
        """
        AppendItem(parent, text, icon=wx.NullIcon, data=None) -> DataViewItem
        
        Append an item.
        """

    def DeleteAllItems(self):
        """
        DeleteAllItems()
        
        Delete all item in the model.
        """

    def DeleteChildren(self, item):
        """
        DeleteChildren(item)
        
        Delete all children of the item, but not the item itself.
        """

    def DeleteItem(self, item):
        """
        DeleteItem(item)
        
        Delete this item.
        """

    def GetChildCount(self, parent):
        """
        GetChildCount(parent) -> int
        
        Return the number of children of item.
        """

    def GetItemData(self, item):
        """
        GetItemData(item) -> ClientData
        
        Returns the client data associated with the item.
        """

    def GetItemExpandedIcon(self, item):
        """
        GetItemExpandedIcon(item) -> wx.Icon
        
        Returns the icon to display in expanded containers.
        """

    def GetItemIcon(self, item):
        """
        GetItemIcon(item) -> wx.Icon
        
        Returns the icon of the item.
        """

    def GetItemText(self, item):
        """
        GetItemText(item) -> String
        
        Returns the text of the item.
        """

    def GetNthChild(self, parent, pos):
        """
        GetNthChild(parent, pos) -> DataViewItem
        
        Returns the nth child item of item.
        """

    def InsertContainer(self, parent, previous, text, icon=wx.NullIcon, expanded=wx.NullIcon, data=None):
        """
        InsertContainer(parent, previous, text, icon=wx.NullIcon, expanded=wx.NullIcon, data=None) -> DataViewItem
        
        Inserts a container after previous.
        """

    def InsertItem(self, parent, previous, text, icon=wx.NullIcon, data=None):
        """
        InsertItem(parent, previous, text, icon=wx.NullIcon, data=None) -> DataViewItem
        
        Inserts an item after previous.
        """

    def PrependContainer(self, parent, text, icon=wx.NullIcon, expanded=wx.NullIcon, data=None):
        """
        PrependContainer(parent, text, icon=wx.NullIcon, expanded=wx.NullIcon, data=None) -> DataViewItem
        
        Inserts a container before the first child item or parent.
        """

    def PrependItem(self, parent, text, icon=wx.NullIcon, data=None):
        """
        PrependItem(parent, text, icon=wx.NullIcon, data=None) -> DataViewItem
        
        Inserts an item before the first child item or parent.
        """

    def SetItemData(self, item, data):
        """
        SetItemData(item, data)
        
        Sets the client data associated with the item.
        """

    def SetItemExpandedIcon(self, item, icon):
        """
        SetItemExpandedIcon(item, icon)
        
        Sets the expanded icon for the item.
        """

    def SetItemIcon(self, item, icon):
        """
        SetItemIcon(item, icon)
        
        Sets the icon for the item.
        """
# end of class DataViewTreeStore


NullDataViewItem = DataViewItem()
class DataViewItemObjectMapper(object):
    """
    This class provides a mechanism for mapping between Python objects and the
    :class:`DataViewItem` objects used by the :class:`DataViewModel` for tracking the items in
    the view. The ID used for the item is the id() of the Python object. Use
    :meth:`ObjectToItem` to create a :class:`DataViewItem` using a Python object as its ID,
    and use :meth:`ItemToObject` to fetch that Python object again later for a given
    :class:`DataViewItem`.
    
    By default a regular dictionary is used to implement the ID to object
    mapping. Optionally a WeakValueDictionary can be useful when there will be
    a high turnover of objects and mantaining an extra reference to the
    objects would be unwise.  If weak references are used then the objects
    associated with data items must be weak-referenceable.  (Things like
    stock lists and dictionaries are not.)  See :meth:`UseWeakRefs`.
    
    This class is used in :class:`PyDataViewModel` as a mixin for convenience.
    """

    def __init__(self):
        pass

    def ObjectToItem(self, obj):
        """
        Create a :class:`DataViewItem` for the object, and remember the ID-->obj mapping.
        """
        pass

    def ItemToObject(self, item):
        """
        Retrieve the object that was used to create an item.
        """
        pass

    def UseWeakRefs(self, flag):
        """
        Switch to or from using a weak value dictionary for keeping the ID to
        object map.
        """
        pass
class PyDataViewModel(DataViewModel, DataViewItemObjectMapper):
    """
    A convenience class that is a :class:`DataViewModel` combined with an object mapper.
    """

    def __init__(self):
        pass

PyDataViewIndexListModel = wx.deprecated(DataViewIndexListModel)
PyDataViewVirtualListModel = wx.deprecated(DataViewVirtualListModel)

PyDataViewCustomRenderer = wx.deprecated(DataViewCustomRenderer,
                                         "Use DataViewCustomRenderer instead")

EVT_DATAVIEW_SELECTION_CHANGED         = wx.PyEventBinder( wxEVT_DATAVIEW_SELECTION_CHANGED, 1)
EVT_DATAVIEW_ITEM_ACTIVATED            = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_ACTIVATED, 1)
EVT_DATAVIEW_ITEM_COLLAPSED            = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_COLLAPSED, 1)
EVT_DATAVIEW_ITEM_EXPANDED             = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_EXPANDED, 1)
EVT_DATAVIEW_ITEM_COLLAPSING           = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_COLLAPSING, 1)
EVT_DATAVIEW_ITEM_EXPANDING            = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_EXPANDING, 1)
EVT_DATAVIEW_ITEM_START_EDITING        = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_START_EDITING, 1)
EVT_DATAVIEW_ITEM_EDITING_STARTED      = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_EDITING_STARTED, 1)
EVT_DATAVIEW_ITEM_EDITING_DONE         = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_EDITING_DONE, 1)
EVT_DATAVIEW_ITEM_VALUE_CHANGED        = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_VALUE_CHANGED, 1)
EVT_DATAVIEW_ITEM_CONTEXT_MENU         = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_CONTEXT_MENU, 1)
EVT_DATAVIEW_COLUMN_HEADER_CLICK       = wx.PyEventBinder( wxEVT_DATAVIEW_COLUMN_HEADER_CLICK, 1)
EVT_DATAVIEW_COLUMN_HEADER_RIGHT_CLICK = wx.PyEventBinder( wxEVT_DATAVIEW_COLUMN_HEADER_RIGHT_CLICK, 1)
EVT_DATAVIEW_COLUMN_SORTED             = wx.PyEventBinder( wxEVT_DATAVIEW_COLUMN_SORTED, 1)
EVT_DATAVIEW_COLUMN_REORDERED          = wx.PyEventBinder( wxEVT_DATAVIEW_COLUMN_REORDERED, 1)
EVT_DATAVIEW_ITEM_BEGIN_DRAG           = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_BEGIN_DRAG, 1)
EVT_DATAVIEW_ITEM_DROP_POSSIBLE        = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_DROP_POSSIBLE, 1)
EVT_DATAVIEW_ITEM_DROP                 = wx.PyEventBinder( wxEVT_DATAVIEW_ITEM_DROP, 1)
EVT_DATAVIEW_CACHE_HINT                = wx.PyEventBinder( wxEVT_DATAVIEW_CACHE_HINT, 1 )

# deprecated wxEVT aliases
wxEVT_COMMAND_DATAVIEW_SELECTION_CHANGED          = wxEVT_DATAVIEW_SELECTION_CHANGED
wxEVT_COMMAND_DATAVIEW_ITEM_ACTIVATED             = wxEVT_DATAVIEW_ITEM_ACTIVATED
wxEVT_COMMAND_DATAVIEW_ITEM_COLLAPSED             = wxEVT_DATAVIEW_ITEM_COLLAPSED
wxEVT_COMMAND_DATAVIEW_ITEM_EXPANDED              = wxEVT_DATAVIEW_ITEM_EXPANDED
wxEVT_COMMAND_DATAVIEW_ITEM_COLLAPSING            = wxEVT_DATAVIEW_ITEM_COLLAPSING
wxEVT_COMMAND_DATAVIEW_ITEM_EXPANDING             = wxEVT_DATAVIEW_ITEM_EXPANDING
wxEVT_COMMAND_DATAVIEW_ITEM_START_EDITING         = wxEVT_DATAVIEW_ITEM_START_EDITING
wxEVT_COMMAND_DATAVIEW_ITEM_EDITING_STARTED       = wxEVT_DATAVIEW_ITEM_EDITING_STARTED
wxEVT_COMMAND_DATAVIEW_ITEM_EDITING_DONE          = wxEVT_DATAVIEW_ITEM_EDITING_DONE
wxEVT_COMMAND_DATAVIEW_ITEM_VALUE_CHANGED         = wxEVT_DATAVIEW_ITEM_VALUE_CHANGED
wxEVT_COMMAND_DATAVIEW_ITEM_CONTEXT_MENU          = wxEVT_DATAVIEW_ITEM_CONTEXT_MENU
wxEVT_COMMAND_DATAVIEW_COLUMN_HEADER_CLICK        = wxEVT_DATAVIEW_COLUMN_HEADER_CLICK
wxEVT_COMMAND_DATAVIEW_COLUMN_HEADER_RIGHT_CLICK  = wxEVT_DATAVIEW_COLUMN_HEADER_RIGHT_CLICK
wxEVT_COMMAND_DATAVIEW_COLUMN_SORTED              = wxEVT_DATAVIEW_COLUMN_SORTED
wxEVT_COMMAND_DATAVIEW_COLUMN_REORDERED           = wxEVT_DATAVIEW_COLUMN_REORDERED
wxEVT_COMMAND_DATAVIEW_CACHE_HINT                 = wxEVT_DATAVIEW_CACHE_HINT
wxEVT_COMMAND_DATAVIEW_ITEM_BEGIN_DRAG            = wxEVT_DATAVIEW_ITEM_BEGIN_DRAG
wxEVT_COMMAND_DATAVIEW_ITEM_DROP_POSSIBLE         = wxEVT_DATAVIEW_ITEM_DROP_POSSIBLE
wxEVT_COMMAND_DATAVIEW_ITEM_DROP                  = wxEVT_DATAVIEW_ITEM_DROP
#-- end-dataview --#
#-- begin-treelist --#
TL_SINGLE = 0
TL_MULTIPLE = 0
TL_CHECKBOX = 0
TL_3STATE = 0
TL_USER_3STATE = 0
TL_NO_HEADER = 0
TL_DEFAULT_STYLE = 0
TL_STYLE_MASK = 0
wxEVT_TREELIST_SELECTION_CHANGED = 0
wxEVT_TREELIST_ITEM_EXPANDING = 0
wxEVT_TREELIST_ITEM_EXPANDED = 0
wxEVT_TREELIST_ITEM_CHECKED = 0
wxEVT_TREELIST_ITEM_ACTIVATED = 0
wxEVT_TREELIST_ITEM_CONTEXT_MENU = 0
wxEVT_TREELIST_COLUMN_SORTED = 0

class TreeListItem(object):
    """
    TreeListItem()
    
    Unique identifier of an item in wxTreeListCtrl.
    """

    def __init__(self):
        """
        TreeListItem()
        
        Unique identifier of an item in wxTreeListCtrl.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Return true if the item is valid.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def __bool__(self):
        """
        __bool__() -> int
        """

    def __hash__(self):
        """
        __hash__() -> long
        """

    def __eq__(self, other):
        """
        __eq__(other) -> bool
        """

    def __ne__(self, other):
        """
        __ne__(other) -> bool
        """
# end of class TreeListItem


class TreeListItemComparator(object):
    """
    TreeListItemComparator()
    
    Class defining sort order for the items in wxTreeListCtrl.
    """

    def __init__(self):
        """
        TreeListItemComparator()
        
        Class defining sort order for the items in wxTreeListCtrl.
        """

    def Compare(self, treelist, column, first, second):
        """
        Compare(treelist, column, first, second) -> int
        
        Pure virtual function which must be overridden to define sort order.
        """
# end of class TreeListItemComparator

TreeListCtrlNameStr = ""

class TreeListCtrl(wx.Window):
    """
    TreeListCtrl()
    TreeListCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TL_DEFAULT_STYLE, name=TreeListCtrlNameStr)
    
    A control combining wxTreeCtrl and wxListCtrl features.
    """

    def __init__(self, *args, **kw):
        """
        TreeListCtrl()
        TreeListCtrl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TL_DEFAULT_STYLE, name=TreeListCtrlNameStr)
        
        A control combining wxTreeCtrl and wxListCtrl features.
        """
    NO_IMAGE = property(None, None)

    def AssignImageList(self, imageList):
        """
        AssignImageList(imageList)
        
        Sets the image list and gives its ownership to the control.
        """

    def SetImageList(self, imageList):
        """
        SetImageList(imageList)
        
        Sets the image list.
        """

    def AppendColumn(self, title, width=wx.COL_WIDTH_AUTOSIZE, align=wx.ALIGN_LEFT, flags=wx.COL_RESIZABLE):
        """
        AppendColumn(title, width=wx.COL_WIDTH_AUTOSIZE, align=wx.ALIGN_LEFT, flags=wx.COL_RESIZABLE) -> int
        
        Add a column with the given title and attributes.
        """

    def GetColumnCount(self):
        """
        GetColumnCount() -> unsigned
        
        Return the total number of columns.
        """

    def DeleteColumn(self, col):
        """
        DeleteColumn(col) -> bool
        
        Delete the column with the given index.
        """

    def ClearColumns(self):
        """
        ClearColumns()
        
        Delete all columns.
        """

    def SetColumnWidth(self, col, width):
        """
        SetColumnWidth(col, width)
        
        Change the width of the given column.
        """

    def GetColumnWidth(self, col):
        """
        GetColumnWidth(col) -> int
        
        Get the current width of the given column in pixels.
        """

    def WidthFor(self, text):
        """
        WidthFor(text) -> int
        
        Get the width appropriate for showing the given text.
        """

    def AppendItem(self, parent, text, imageClosed=-1, imageOpened=-1, data=None):
        """
        AppendItem(parent, text, imageClosed=-1, imageOpened=-1, data=None) -> TreeListItem
        
        Same as InsertItem() with wxTLI_LAST.
        """

    def InsertItem(self, parent, previous, text, imageClosed=-1, imageOpened=-1, data=None):
        """
        InsertItem(parent, previous, text, imageClosed=-1, imageOpened=-1, data=None) -> TreeListItem
        
        Insert a new item into the tree.
        """

    def PrependItem(self, parent, text, imageClosed=-1, imageOpened=-1, data=None):
        """
        PrependItem(parent, text, imageClosed=-1, imageOpened=-1, data=None) -> TreeListItem
        
        Same as InsertItem() with wxTLI_FIRST.
        """

    def DeleteItem(self, item):
        """
        DeleteItem(item)
        
        Delete the specified item.
        """

    def DeleteAllItems(self):
        """
        DeleteAllItems()
        
        Delete all tree items.
        """

    def GetRootItem(self):
        """
        GetRootItem() -> TreeListItem
        
        Return the (never shown) root item.
        """

    def GetItemParent(self, item):
        """
        GetItemParent(item) -> TreeListItem
        
        Return the parent of the given item.
        """

    def GetFirstChild(self, item):
        """
        GetFirstChild(item) -> TreeListItem
        
        Return the first child of the given item.
        """

    def GetNextSibling(self, item):
        """
        GetNextSibling(item) -> TreeListItem
        
        Return the next sibling of the given item.
        """

    def GetFirstItem(self):
        """
        GetFirstItem() -> TreeListItem
        
        Return the first item in the tree.
        """

    def GetNextItem(self, item):
        """
        GetNextItem(item) -> TreeListItem
        
        Get item after the given one in the depth-first tree-traversal order.
        """

    def GetItemText(self, item, col=0):
        """
        GetItemText(item, col=0) -> String
        
        Return the text of the given item.
        """

    def SetItemText(self, *args, **kw):
        """
        SetItemText(item, col, text)
        SetItemText(item, text)
        
        Set the text of the specified column of the given item.
        """

    def SetItemImage(self, item, closed, opened=-1):
        """
        SetItemImage(item, closed, opened=-1)
        
        Set the images for the given item.
        """

    def GetItemData(self, item):
        """
        GetItemData(item) -> ClientData
        
        Get the data associated with the given item.
        """

    def SetItemData(self, item, data):
        """
        SetItemData(item, data)
        
        Set the data associated with the given item.
        """

    def Expand(self, item):
        """
        Expand(item)
        
        Expand the given tree branch.
        """

    def Collapse(self, item):
        """
        Collapse(item)
        
        Collapse the given tree branch.
        """

    def IsExpanded(self, item):
        """
        IsExpanded(item) -> bool
        
        Return whether the given item is expanded.
        """

    def GetSelection(self):
        """
        GetSelection() -> TreeListItem
        
        Return the currently selected item.
        """

    def GetSelections(self):
        """
        GetSelections() -> PyObject
        
        Returns a list of all selected items. This method can be used in
        both single and multi-selection case.
        """

    def Select(self, item):
        """
        Select(item)
        
        Select the given item.
        """

    def Unselect(self, item):
        """
        Unselect(item)
        
        Deselect the given item.
        """

    def IsSelected(self, item):
        """
        IsSelected(item) -> bool
        
        Return true if the item is selected.
        """

    def SelectAll(self):
        """
        SelectAll()
        
        Select all the control items.
        """

    def UnselectAll(self):
        """
        UnselectAll()
        
        Deselect all the control items.
        """

    def CheckItem(self, item, state=wx.CHK_CHECKED):
        """
        CheckItem(item, state=wx.CHK_CHECKED)
        
        Change the item checked state.
        """

    def CheckItemRecursively(self, item, state=wx.CHK_CHECKED):
        """
        CheckItemRecursively(item, state=wx.CHK_CHECKED)
        
        Change the checked state of the given item and all its children.
        """

    def UncheckItem(self, item):
        """
        UncheckItem(item)
        
        Uncheck the given item.
        """

    def UpdateItemParentStateRecursively(self, item):
        """
        UpdateItemParentStateRecursively(item)
        
        Update the state of the parent item to reflect the checked state of
        its children.
        """

    def GetCheckedState(self, item):
        """
        GetCheckedState(item) -> CheckBoxState
        
        Return the checked state of the item.
        """

    def AreAllChildrenInState(self, item, state):
        """
        AreAllChildrenInState(item, state) -> bool
        
        Return true if all children of the given item are in the specified
        state.
        """

    def SetSortColumn(self, col, ascendingOrder=True):
        """
        SetSortColumn(col, ascendingOrder=True)
        
        Set the column to use for sorting and the order in which to sort.
        """

    def GetSortColumn(self):
        """
        GetSortColumn() -> (bool, col, ascendingOrder)
        
        Return the column currently used for sorting, if any.
        """

    def SetItemComparator(self, comparator):
        """
        SetItemComparator(comparator)
        
        Set the object to use for comparing the items.
        """

    def GetView(self):
        """
        GetView() -> wx.Window
        
        Return the view part of this control as a wxWindow.
        """

    def GetDataView(self):
        """
        GetDataView() -> DataViewCtrl
        
        Return the view part of this control as wxDataViewCtrl.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TL_DEFAULT_STYLE, name=TreeListCtrlNameStr):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TL_DEFAULT_STYLE, name=TreeListCtrlNameStr) -> bool
        
        Create the control window.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ColumnCount = property(None, None)
    DataView = property(None, None)
    FirstItem = property(None, None)
    RootItem = property(None, None)
    Selection = property(None, None)
    Selections = property(None, None)
    SortColumn = property(None, None)
    View = property(None, None)
# end of class TreeListCtrl


class TreeListEvent(wx.NotifyEvent):
    """
    TreeListEvent()
    
    Event generated by wxTreeListCtrl.
    """

    def __init__(self):
        """
        TreeListEvent()
        
        Event generated by wxTreeListCtrl.
        """

    def GetItem(self):
        """
        GetItem() -> TreeListItem
        
        Return the item affected by the event.
        """

    def GetOldCheckedState(self):
        """
        GetOldCheckedState() -> CheckBoxState
        
        Return the previous state of the item checkbox.
        """

    def GetColumn(self):
        """
        GetColumn() -> unsigned
        
        Return the column affected by the event.
        """
    Column = property(None, None)
    Item = property(None, None)
    OldCheckedState = property(None, None)
# end of class TreeListEvent

TLI_FIRST = TreeListItem()
TLI_LAST = TreeListItem()

EVT_TREELIST_SELECTION_CHANGED = wx.PyEventBinder( wxEVT_TREELIST_SELECTION_CHANGED )
EVT_TREELIST_ITEM_EXPANDING =    wx.PyEventBinder( wxEVT_TREELIST_ITEM_EXPANDING )
EVT_TREELIST_ITEM_EXPANDED =     wx.PyEventBinder( wxEVT_TREELIST_ITEM_EXPANDED )
EVT_TREELIST_ITEM_CHECKED =      wx.PyEventBinder( wxEVT_TREELIST_ITEM_CHECKED )
EVT_TREELIST_ITEM_ACTIVATED =    wx.PyEventBinder( wxEVT_TREELIST_ITEM_ACTIVATED )
EVT_TREELIST_ITEM_CONTEXT_MENU = wx.PyEventBinder( wxEVT_TREELIST_ITEM_CONTEXT_MENU )
EVT_TREELIST_COLUMN_SORTED =     wx.PyEventBinder( wxEVT_TREELIST_COLUMN_SORTED )

# deprecated wxEVT aliases
wxEVT_COMMAND_TREELIST_SELECTION_CHANGED  = wxEVT_TREELIST_SELECTION_CHANGED
wxEVT_COMMAND_TREELIST_ITEM_EXPANDING     = wxEVT_TREELIST_ITEM_EXPANDING
wxEVT_COMMAND_TREELIST_ITEM_EXPANDED      = wxEVT_TREELIST_ITEM_EXPANDED
wxEVT_COMMAND_TREELIST_ITEM_CHECKED       = wxEVT_TREELIST_ITEM_CHECKED
wxEVT_COMMAND_TREELIST_ITEM_ACTIVATED     = wxEVT_TREELIST_ITEM_ACTIVATED
wxEVT_COMMAND_TREELIST_ITEM_CONTEXT_MENU  = wxEVT_TREELIST_ITEM_CONTEXT_MENU
wxEVT_COMMAND_TREELIST_COLUMN_SORTED      = wxEVT_TREELIST_COLUMN_SORTED
#-- end-treelist --#
