/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.IdentityParseException;
import com.zeroc.IceGrid.AdaptiveLoadBalancingPolicy;
import com.zeroc.IceGrid.ObjectDescriptor;
import com.zeroc.IceGrid.OrderedLoadBalancingPolicy;
import com.zeroc.IceGrid.RandomLoadBalancingPolicy;
import com.zeroc.IceGrid.ReplicaGroupDescriptor;
import com.zeroc.IceGrid.RoundRobinLoadBalancingPolicy;
import com.zeroc.IceGridGUI.Application.ArrayMapField;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ReplicaGroup;
import com.zeroc.IceGridGUI.Application.ReplicaGroups;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ReplicaGroupEditor
extends Editor {
    private static String ORDERED = "Ordered";
    private static String RANDOM = "Random";
    private static String ROUND_ROBIN = "Round-robin";
    private static String ADAPTIVE = "Adaptive";
    private JTextField _id = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private JTextField _proxyOptions = new JTextField(20);
    private JTextField _filter = new JTextField(20);
    private JComboBox _loadBalancing = new JComboBox<String>(new String[]{ADAPTIVE, ORDERED, RANDOM, ROUND_ROBIN});
    private JTextField _nReplicas = new JTextField(20);
    private JLabel _loadSampleLabel;
    private JComboBox _loadSample = new JComboBox<String>(new String[]{"1", "5", "15"});
    private ArrayMapField _objects = new ArrayMapField(this, true, "Identity", "Type", "Proxy Options");
    private LinkedList<ObjectDescriptor> _objectList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean applyUpdate(boolean refresh) {
        ReplicaGroup replicaGroup = (ReplicaGroup)this._target;
        Root root = replicaGroup.getRoot();
        root.disableSelectionListener();
        try {
            if (replicaGroup.isEphemeral()) {
                ReplicaGroups replicaGroups = (ReplicaGroups)replicaGroup.getParent();
                this.writeDescriptor();
                ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)replicaGroup.getDescriptor();
                replicaGroup.destroy();
                try {
                    replicaGroups.tryAdd(descriptor, true);
                }
                catch (UpdateFailedException e) {
                    block19: {
                        try {
                            replicaGroups.insertChild(replicaGroup, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block19;
                            throw new AssertionError();
                        }
                    }
                    root.setSelectedNode(replicaGroup);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean die = false;
                    root.enableSelectionListener();
                    return die;
                }
                this._target = replicaGroups.findChildWithDescriptor(descriptor);
                root.updated();
            } else if (this.isSimpleUpdate()) {
                this.writeDescriptor();
                root.updated();
                replicaGroup.getEditable().markModified();
            } else {
                Object savedDescriptor = replicaGroup.saveDescriptor();
                ReplicaGroups replicaGroups = (ReplicaGroups)replicaGroup.getParent();
                this.writeDescriptor();
                ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)replicaGroup.getDescriptor();
                replicaGroups.removeChild(replicaGroup);
                try {
                    replicaGroups.tryAdd(descriptor, false);
                }
                catch (UpdateFailedException e) {
                    block20: {
                        try {
                            replicaGroups.insertChild(replicaGroup, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block20;
                            throw new AssertionError();
                        }
                    }
                    replicaGroup.restoreDescriptor(savedDescriptor);
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                replicaGroups.getEditable().removeElement(replicaGroup.getId(), replicaGroup.getEditable(), ReplicaGroup.class);
                this._target = replicaGroups.findChildWithDescriptor(descriptor);
                root.updated();
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            }
            if (refresh) {
                root.getCoordinator().getCurrentTab().showNode(this._target);
            }
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }

    @Override
    Utils.Resolver getDetailResolver() {
        Root root = this._target.getRoot();
        if (root.getCoordinator().substitute()) {
            return root.getResolver();
        }
        return null;
    }

    ReplicaGroupEditor() {
        this._loadBalancing.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReplicaGroupEditor.this.updated();
                    Object item = e.getItem();
                    ReplicaGroupEditor.this._loadSampleLabel.setVisible(item == ADAPTIVE);
                    ReplicaGroupEditor.this._loadSample.setVisible(item == ADAPTIVE);
                }
            }
        });
        this._loadBalancing.setToolTipText("<html>Specifies how IceGrid selects adapters and return<br>their endpoints when resolving a replica group ID</html>");
        this._id.getDocument().addDocumentListener(this._updateListener);
        this._id.setToolTipText("Must be unique within this IceGrid deployment");
        this._description.getDocument().addDocumentListener(this._updateListener);
        this._description.setToolTipText("An optional description for this replica group");
        this._nReplicas.getDocument().addDocumentListener(this._updateListener);
        this._nReplicas.setToolTipText("<html>IceGrid returns the endpoints of up to <i>number</i> adapters<br>when resolving a replica group ID.<br>Enter 0 to returns the endpoints of all adapters.</html>");
        this._loadSample.setEditable(true);
        JTextField loadSampleTextField = (JTextField)this._loadSample.getEditor().getEditorComponent();
        loadSampleTextField.getDocument().addDocumentListener(this._updateListener);
        this._loadSample.setToolTipText("Use the load average or CPU usage over the last 1, 5 or 15 minutes?");
        this._proxyOptions.getDocument().addDocumentListener(this._updateListener);
        this._proxyOptions.setToolTipText("The proxy options used for proxies created by IceGrid for the replica group");
        this._filter.getDocument().addDocumentListener(this._updateListener);
        this._filter.setToolTipText("An optional filter for this replica group. Filters are installed by registryplugin to provide custom load balancing for replica groups.");
    }

    void writeDescriptor() {
        ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)this.getReplicaGroup().getDescriptor();
        descriptor.id = this._id.getText().trim();
        descriptor.description = this._description.getText();
        descriptor.objects = this._objectList;
        descriptor.proxyOptions = this._proxyOptions.getText().trim();
        descriptor.filter = this._filter.getText();
        Object loadBalancing = this._loadBalancing.getSelectedItem();
        if (loadBalancing == ORDERED) {
            descriptor.loadBalancing = new OrderedLoadBalancingPolicy(this._nReplicas.getText().trim());
        } else if (loadBalancing == RANDOM) {
            descriptor.loadBalancing = new RandomLoadBalancingPolicy(this._nReplicas.getText().trim());
        } else if (loadBalancing == ROUND_ROBIN) {
            descriptor.loadBalancing = new RoundRobinLoadBalancingPolicy(this._nReplicas.getText().trim());
        } else if (loadBalancing == ADAPTIVE) {
            descriptor.loadBalancing = new AdaptiveLoadBalancingPolicy(this._nReplicas.getText().trim(), this._loadSample.getSelectedItem().toString().trim());
        } else assert (false);
    }

    boolean isSimpleUpdate() {
        ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)this.getReplicaGroup().getDescriptor();
        return descriptor.id.equals(this._id.getText().trim());
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Replica Group ID");
        builder.append((Component)this._id, 3);
        builder.nextLine();
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Proxy Options");
        builder.append((Component)this._proxyOptions, 3);
        builder.nextLine();
        builder.append("Filter");
        builder.append((Component)this._filter, 3);
        builder.nextLine();
        builder.append("Well-known Objects");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._objects);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Load Balancing Policy");
        builder.append((Component)this._loadBalancing, 3);
        builder.nextLine();
        builder.append("How many Adapters? (0 = all)");
        builder.append((Component)this._nReplicas, 3);
        builder.nextLine();
        this._loadSampleLabel = builder.append("Load Sample");
        builder.append((Component)this._loadSample, 3);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Replica Group Properties");
    }

    @Override
    protected boolean validate() {
        this._objectList = this.mapToObjectDescriptorSeq(this._objects.get());
        if (this._objectList == null) {
            return false;
        }
        return this.check(new String[]{"Replica Group ID", this._id.getText().trim()});
    }

    void show(ReplicaGroup replicaGroup) {
        this.getProperties();
        this.detectUpdates(false);
        this._target = replicaGroup;
        Utils.Resolver resolver = this.getDetailResolver();
        boolean isEditable = resolver == null;
        ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)replicaGroup.getDescriptor();
        this._id.setText(descriptor.id);
        this._id.setEditable(isEditable);
        this._description.setText(Utils.substitute(descriptor.description, resolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
        this._proxyOptions.setText(descriptor.proxyOptions);
        this._proxyOptions.setEditable(isEditable);
        this._filter.setText(descriptor.filter);
        this._filter.setEditable(isEditable);
        this._objects.set(this.objectDescriptorSeqToMap(descriptor.objects), resolver, isEditable);
        this._loadBalancing.setEnabled(true);
        if (descriptor.loadBalancing == null) {
            this._loadBalancing.setSelectedItem(RANDOM);
            this._nReplicas.setText("0");
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof RandomLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(RANDOM);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof OrderedLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(ORDERED);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof RoundRobinLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(ROUND_ROBIN);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof AdaptiveLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(ADAPTIVE);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem(Utils.substitute(((AdaptiveLoadBalancingPolicy)descriptor.loadBalancing).loadSample, resolver));
        } else assert (false);
        this._nReplicas.setEditable(isEditable);
        this._loadSample.setEditable(isEditable);
        this._loadBalancing.setEnabled(isEditable);
        this._applyButton.setEnabled(replicaGroup.isEphemeral());
        this._discardButton.setEnabled(replicaGroup.isEphemeral());
        this.detectUpdates(true);
        if (replicaGroup.isEphemeral()) {
            this.updated();
        }
    }

    private ReplicaGroup getReplicaGroup() {
        return (ReplicaGroup)this._target;
    }

    private Map<String, String[]> objectDescriptorSeqToMap(List<ObjectDescriptor> objects) {
        TreeMap<String, String[]> result = new TreeMap<String, String[]>();
        Communicator communicator = this._target.getCoordinator().getCommunicator();
        for (ObjectDescriptor p : objects) {
            result.put(communicator.identityToString(p.id), new String[]{p.type, p.proxyOptions});
        }
        return result;
    }

    private LinkedList<ObjectDescriptor> mapToObjectDescriptorSeq(Map<String, String[]> map) {
        String badIdentities = "";
        LinkedList<ObjectDescriptor> result = new LinkedList<ObjectDescriptor>();
        Communicator communicator = this._target.getCoordinator().getCommunicator();
        for (Map.Entry<String, String[]> p : map.entrySet()) {
            try {
                Identity id = communicator.stringToIdentity(p.getKey());
                String[] val = p.getValue();
                result.add(new ObjectDescriptor(id, val[0], val[1]));
            }
            catch (IdentityParseException ex) {
                badIdentities = badIdentities + "- " + p.getKey() + "\n";
            }
        }
        if (!badIdentities.equals("")) {
            JOptionPane.showMessageDialog(this._target.getCoordinator().getMainFrame(), "The following identities could not be parsed properly:\n" + badIdentities, "Validation failed", 0);
            return null;
        }
        return result;
    }
}

