/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.juife.EnhancedDialog;
import net.sf.juife.JuifeUtils;
import org.jsampler.view.fantasia.ChannelsPropsPane;
import org.jsampler.view.fantasia.ConsolePane;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.GeneralPane;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.ViewPane;
import org.jsampler.view.std.JSConnectionPropsPane;
import org.jsampler.view.std.JSDefaultsPropsPane;

public class PrefsDlg
extends EnhancedDialog {
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final GeneralPane genPane = new GeneralPane(this);
    private final ViewPane viewPane = new ViewPane();
    private final ChannelsPropsPane channelsPane = new ChannelsPropsPane();
    private final ConsolePane consolePane = new ConsolePane();
    private final JSConnectionPropsPane connectionPane = new JSConnectionPropsPane();
    private final JSDefaultsPropsPane defaultsPane;
    private final JButton btnApply = new JButton(FantasiaI18n.i18n.getButtonLabel("apply"));
    private final JButton btnClose = new JButton(FantasiaI18n.i18n.getButtonLabel("close"));

    public PrefsDlg(Frame frame) {
        super(frame, FantasiaI18n.i18n.getLabel("PrefsDlg.title"), true);
        this.defaultsPane = new JSDefaultsPropsPane(this, Res.iconEdit16, true);
        JTabbedPane jTabbedPane = this.tabbedPane;
        jTabbedPane.setTabLayoutPolicy(1);
        jTabbedPane.addTab(FantasiaI18n.i18n.getLabel("PrefsDlg.tabGeneral"), this.genPane);
        jTabbedPane.addTab(FantasiaI18n.i18n.getLabel("PrefsDlg.tabView"), this.viewPane);
        jTabbedPane.addTab(FantasiaI18n.i18n.getLabel("PrefsDlg.tabChannels"), this.channelsPane);
        jTabbedPane.addTab(FantasiaI18n.i18n.getLabel("PrefsDlg.tabConsole"), this.consolePane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add(this.connectionPane);
        jTabbedPane.addTab(FantasiaI18n.i18n.getLabel("PrefsDlg.tabBackend"), jPanel);
        jTabbedPane.addTab(FantasiaI18n.i18n.getLabel("PrefsDlg.tabDefaults"), this.defaultsPane);
        jTabbedPane.setAlignmentX(1.0f);
        Dimension dimension = JuifeUtils.getUnionSize((Component)this.btnApply, this.btnClose);
        this.btnApply.setPreferredSize(dimension);
        this.btnClose.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.btnApply);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.btnClose);
        jPanel2.setAlignmentX(1.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jTabbedPane);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 12)));
        jPanel3.add(jPanel2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(11, 12, 12, 12));
        this.getContentPane().add(jPanel3);
        this.pack();
        this.setResizable(false);
        this.setLocation(JuifeUtils.centerLocation(this, frame));
        this.installListeners();
        int n = FantasiaPrefs.preferences().getIntProperty("PrefsDlg.tabIndex");
        if (n >= 0 && n < jTabbedPane.getTabCount()) {
            jTabbedPane.setSelectedIndex(n);
        }
    }

    private void installListeners() {
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDlg.this.onApply();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDlg.this.onExit();
            }
        });
    }

    @Override
    protected void onOk() {
        this.onApply();
    }

    @Override
    protected void onCancel() {
        this.onExit();
    }

    private void onApply() {
        this.genPane.apply();
        this.viewPane.apply();
        this.channelsPane.apply();
        this.consolePane.apply();
        this.connectionPane.apply();
        this.defaultsPane.apply();
        FantasiaPrefs.preferences().setIntProperty("PrefsDlg.tabIndex", this.tabbedPane.getSelectedIndex());
        this.setVisible(false);
    }

    private void onExit() {
        this.setVisible(false);
    }
}

